/* ix/MBox (mb-daemon.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #RF reflector()        reflecting device - yes, it's yet built in
   #PS pdsize()           for PD groups - find out the size of a file
   #SC scan()             scanning news articles
   #MX mix()              updating AGROUPS
   #MA main()             mb-daemon main function

   Contact <volkers@unnet.wupper.de> for help! */

  




#ifndef _ESTDIO
#include <stdio.h>
#else
#include <estdio.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <dirent.h>

#include <errno.h>

#include "mbox.h"



#define ADDRESSES "/local/address/addresses"
#define ADDRESSXX "/local/address/addressxx"

int FASTMODE;
int KILLMODE;

long killtime;

int mb_gruppen;
int mb_new;
long mb_bytes;
long mb_new_bytes;
long mb_artikel;

long lastrun;

#ifdef _UNNET
FILE *ad;
#endif





/* #RF - Replies to a news article by sending a mail to the author.

   [arg] is a dummy (as far as I know), [msg] names the article to
   reflect on.

   This function returns 0 for OK, -1 on any errors. */


int FLAG;

int reflector(arg, msg)
UNSIGNED char arg[];
UNSIGNED char msg[];
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char s[LONGSTRING];
  UNSIGNED char t[STRING];
  UNSIGNED char tmp[STRING];
  UNSIGNED char receiver[STRING];
  UNSIGNED char path[LONGSTRING];
  UNSIGNED char reply_to[LONGSTRING];
  UNSIGNED char from[LONGSTRING];
  UNSIGNED char sender[LONGSTRING];
  UNSIGNED char subject[LONGSTRING];
  UNSIGNED char summary[LONGSTRING];
  UNSIGNED char keywords[LONGSTRING];
  UNSIGNED char newsgroups[LONGSTRING];
  UNSIGNED char followup_to[LONGSTRING];
  UNSIGNED char distribution[LONGSTRING];
  UNSIGNED char date[LONGSTRING];
  UNSIGNED char lines[LONGSTRING];
  UNSIGNED char message_id[LONGSTRING];
  UNSIGNED char organization[LONGSTRING];
  UNSIGNED char posted[LONGSTRING];
  UNSIGNED char article_id[LONGSTRING];
  UNSIGNED char nntp_post[LONGSTRING];
  UNSIGNED char references[LONGSTRING];

  int id_err = 0;
  int i, a, b;
  int inlines;

  int reply = 0;
  int noreply = 0;
  int dirlist = 0;
  int logfile = 0;
  int info = 0;
  int minimal = 0;
  long timer;

  int ok = 0;

  fp = fopen(msg, "r");
  if (fp == NULL) return -1;
  sprintf(tmp, "%s/%d", TMP, getpid());
  ff = fopen(tmp, "w");
  if(ff == NULL){
	printf("\nMB-DAEMON: Can't open [%s]!\n", tmp);
	exit(0);
  }
  i = 1;
  inlines = -1;

  reply_to[0] = '\0';

  while (fgets(s, LONGSTRING, fp) != NULL) {
	ok = 0;
	if (strcomp("Path:", s) == 0) {
		sprintf(path, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Reply-To:", s) == 0) {
		sprintf(reply_to, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		reply--;
		ok++;
	}
	if (strcomp("From:", s) == 0) {
		sprintf(from, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Sender:", s) == 0) {
		sprintf(sender, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Subject:", s) == 0) {
		sprintf(subject, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Summary:", s) == 0) {
		sprintf(summary, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Keywords:", s) == 0) {
		sprintf(keywords, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Newsgroups:", s) == 0) {
		sprintf(newsgroups, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Followup-To:", s) == 0) {
		sprintf(followup_to, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Distribution:", s) == 0) {
		sprintf(distribution, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Date:", s) == 0) {
		sprintf(date, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Lines:", s) == 0) {
		sprintf(lines, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Message-I", s) == 0) {
		sprintf(message_id, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Organization:", s) == 0) {
		sprintf(organization, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Posted:", s) == 0) {
		sprintf(posted, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Article-I.D.:", s) == 0) {
		sprintf(article_id, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("Nntp-Posting-Host:", s) == 0) {
		sprintf(nntp_post, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}
	if (strcomp("References:", s) == 0) {
		sprintf(references, "%02d>> %s <<\n", i, (UNSIGNED char *) stripped(s));
		ok++;
	}



	if (strcomp("NO REPLY", s)        == 0 ||
	    strcomp("NOT REPLY", s)       == 0 ||
	    strcomp("KEIN REPLY", s)      == 0 ||
	    strcomp("NO REPLIES", s)      == 0 ||
	    strcomp("KEINE REPLIES", s)   == 0 ||
	    strcomp("NO REPLYS", s)       == 0 ||
	    strcomp("KEINE REPLYS", s)    == 0 ||
	    strcomp("KEINE ANTWORTEN", s) == 0 ||
	    strcomp("NICHT ANTWORTEN", s) == 0 ||
	    strcomp("NO REFLECT", s)      == 0 ||
	    strcomp("NOT REFLECT", s)     == 0 ||
	    strcomp("NO ANSWER", s)       == 0 ||
	    strcomp("NOT ANSWER", s)      == 0 ||
	    strcomp("IGNORE", s)          == 0)
		noreply++;

	if (strcomp("PLEASE REPLY", s)    == 0 ||
	    strcomp("BITTE REPLY", s)     == 0 ||
	    strcomp("PLEASE REFLECT", s)  == 0 ||
	    strcomp("BITTE REFLECT", s)   == 0 ||
	    strcomp("BITTE ANTWORT", s)   == 0 ||
	    strcomp("REPLY", s)           == 0 ||
	    strcomp("REFLECT", s)         == 0 ||
	    strcomp("ANTWORT", s)         == 0)
		reply++;

	if (strcomp("DIRLIST", s) == 0) dirlist++;

	if (strcomp("LOGFILE", s) == 0) logfile++;

	if (strcomp("INFO", s) == 0 ||
	    strcomp("HELP", s) == 0)
		info++;

	if (strcomp("SHORT", s) == 0) minimal++;

	if (ok == 0) {
		inlines++;
	}
	i++;
  }
  fclose(fp);

  strcpy(s, (UNSIGNED char *) strcopy(organization, 19, STRING));
  if ((FLAG == 1) && (strcomp(ORGANIZATION, s) != 0)) return -1;

  if (reply_to[0] != '\0') {
	strcpy(receiver, (UNSIGNED char *) strcopy(reply_to, 15, STRING));
  } else {
	strcpy(receiver, (UNSIGNED char *) strcopy(from, 11, STRING));
  }

  receiver[strlen(receiver) -3] = '\0';
  i = 0; a = 0; b = 0;
  while (receiver[i] != '\0') {
	if(receiver[i] == '(') a = i;
	if(receiver[i] == '<') a = i + 1;
        if(receiver[i] == '>') b = i - 1;
	i++;
  }
  if((a == 0) && (b == 0)){
	strcpy(t, (UNSIGNED char *) receiver);
  }
  else{
	if(b == 0){
		strcpy(t, (UNSIGNED char *) strcopy(receiver, 0, (a - 1)));
	}
	else{
		strcpy(t, (UNSIGNED char *) strcopy(receiver, a, b));
	}
  }
  time(&timer);

  fprintf(ff, "From: reflector@%s (Reflecting Device)\n", UUCPID2); 
  fprintf(ff, "Reply-To: postmaster@%s (Reflector's Boss)\n", UUCPID2);
  fprintf(ff, "Organization: %s\n", ORGANIZATION);
  if(message_id[0] != '\0'){
	fprintf(fp, "References: %s", message_id);
  }
  fprintf(ff, "To: %s\n", t);
  fprintf(ff, "Subject: *Reflexion*\n");
  fprintf(ff, "X-Mailer: %s %s %s\n", VERSION, PATCHLEVEL, AUTOR);	
  fprintf(ff, "Message-Id: <%x.reflector@%s>\n", timer, UUCPID2);
  fputs("\n", ff);

  fp = fopen(REFLECT_LOG, "a");
  if (fp == NULL) {
	while (1) printf("%c", 7);
  }
  fprintf(fp, "%s - %s", (UNSIGNED char *) mydate(1), from);
  fprintf(fp, "         - %s", message_id);
  fprintf(fp, "         - %s", subject);
  if (dirlist != 0) {
	fprintf(fp, "         - DIRLIST-Request\n");
  }
  if (logfile != 0) {
	fprintf(fp, "         - LOGFILE-Request\n");
  }
  if (info != 0) {
	fprintf(fp, "         - INFO-Request\n");
  }
  fprintf(fp, "         - Reflected to %s\n\n", receiver);
  fclose(fp);

  fprintf(ff, "+++ Reflecting Device - Version %s %s / MB-DAEMON +++\n\n", VERSION, PATCHLEVEL);

  if ((dirlist == 0) && (logfile == 0) && (info == 0) && (minimal == 0)) {
	fprintf(ff, "That's what we've received in NG \"%s\" ...\n\n", arg);

	fputs(path, ff);
	fputs(from, ff);
	fputs(reply_to, ff);
	fputs(sender, ff);
	fputs(newsgroups, ff);
	fputs(subject, ff);
	fputs(article_id, ff);
	fputs(posted, ff);
	fputs(nntp_post, ff);
	fputs(summary, ff);
	fputs(keywords, ff);
	fputs(followup_to, ff);
	fputs(distribution, ff);
	fputs(references, ff);
	fputs(message_id, ff);
	fputs(organization, ff);
	fputs(date, ff);
	fputs(lines, ff);

	fputs("\n\nDiagnostics ...\n\n", ff);

	ok = 0;

	if (id_err != 0) {
		fprintf(ff, "- \"Message-ID\" may cause trouble ... use \"Message-Id\".\n\n");
		ok++;
	}
	if (reply_to[0] == '\0') {
		fprintf(ff, "- No \"Reply-To\"-Path ... not a problem.\n\n");
		ok++;
	}
	i = atoi((UNSIGNED char *) strcopy(lines, 12, STRING));
	inlines--;
	if (inlines != i) {
		fprintf(ff, "- Your Header reports %d lines ... we've counted %d ... who cares?\n\n", i, inlines);
		ok++;
	}
	if ((reply != 0) || (noreply != 0)) {
		fprintf(ff, "- Found %d Reply-Requests and %d No-Replies.\n\n", reply, noreply);
		ok++;
	}

	if (ok == 0) {
		fprintf(ff, "- Everything seems to be correct!\n\n");
	}
  }

  if (dirlist != 0) {
	fp = fopen(DIRLIST, "r");
	if (fp != NULL) {
		fputs("DIRLIST:\n\n", ff);
		while (fgets(s, LONGSTRING, fp) != NULL) fputs(s, ff);
		fclose(fp);
	} else {
		fputs("Sorry, no DIRLIST-Entry found ...\n\n", ff);
	}
	printf("\n\n");
  }
  if (logfile != 0) {
	fp = fopen(REFLECT_LOG, "r");
	if (fp != NULL) {
		fputs("LOGFILE:\n\n", ff);
		while (fgets(s, LONGSTRING, fp) != NULL) fputs(s, ff);
		fclose(fp);
	} else {
		fputs("Sorry, no LOGFILE-Entry found ...\n\n", ff);
	}
	printf("\n\n");
  }
  if (info != 0) {
	fputs("INFO (weitere Schluesselwoerter):\n\n", ff);
	fputs("LOGFILE - Wenn der Reflektor nicht reflektiert, kann man sich\n", ff);
	fputs("          das LOGFILE senden lassen, um zu ueberpruefen ob der\n", ff);
	fputs("          Artikel jemals erfasst worden ist.\n\n", ff);

	fputs("DIRLIST - Eine Liste des lokalen MINIX-Archivs. Da der Reflektor\n", ff);
	fputs("          (noch) kein PD-Server ist, kann man diese Liste nur zu\n", ff);
	fputs("          Testzwecken anfordern.\n\n", ff);

	fputs("SHORT   - Quittiert nur den Empfang des Artikels.\n\n", ff);
  }
  if (minimal != 0) {
	fprintf(ff, "Received your article %s", message_id);
  }
  fclose(ff);

  sprintf(s, "/bin/sh ./etc/rmail.sh %s %s postmaster", tmp, t);
  system(s);

  unlink(tmp);

  return 0;
}






/* #PS - Find out the size of a file.

   [arg] delivers the path to a news article of a PD group. This article
   includes a filename (including the PD stuff). The size of this file
   is found out.

   This function returns the size of that file. */

int pdsize( arg )
UNSIGNED char arg[];
{
  FILE *fp;
  UNSIGNED char s[STRING];
  int ok = 0, i;
  struct stat fstat;

  fp = fopen( arg, "r" );
  if(fp == NULL){
	return (int) 0;
  }
  while((ok == 0) && (fgets(s, STRING, fp) != NULL)){
	if(strcomp("BINFILE", s) == 0) ok++;
  }
  fgets(s, STRING, fp);
  fclose(fp);

  if(ok == 0) strcpy(s, (UNSIGNED char *) arg);

  if(stat((UNSIGNED char *) stripped(s), &fstat) != NULL){
	return (int) 0;
  }
  i = (int) (fstat.st_size / 1024);
  if(i < 1) i = 1;
  return (int) i;
}




/* #SC - Scans news articles to build up lines for the index files. 

   [arg] is the name of the newsgroup. 

   This functions returns the date of the latest article. */

UNSIGNED char *scan(arg)
UNSIGNED char arg[];
{
  FILE *th;
  FILE *fp;
  FILE *ff;
  FILE *ft;
  FILE *fg;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char f[STRING];
  UNSIGNED char v[STRING];
  UNSIGNED char from[STRING];
  UNSIGNED char subj[STRING];
  UNSIGNED char date[STRING];
  UNSIGNED char line[STRING];
  UNSIGNED char orga[STRING];
  UNSIGNED char keyw[STRING];
  UNSIGNED char Ndir[STRING];
  UNSIGNED char Ldir[STRING];
  UNSIGNED char Tdir[STRING];
  UNSIGNED char ex[1024];
  UNSIGNED char et[355];

  UNSIGNED char xgate[STRING];
  UNSIGNED char xnews[STRING];

  int dirarray[MAX_PER_NG];
  int idp = 0, iii = 0;

  DIR *dp;
  struct dirent *actdir;

  static UNSIGNED char sdate[STRING];

  UNSIGNED char today[STRING];
  UNSIGNED char thatday[STRING];
  UNSIGNED char arti[STRING];

  long nowtime, checktime;

  int i, j;
  int ok = 0;
  int a, b;
  int BINFILE = 0;
  int PDGROUP = 0;
  int fsi = 0;
  int seq = 0;
  int OLDENTRY = 0;
  int OLDn = 0;
  int OLDo = 0;
  int got_org = 0;
  int approved = 0;

  int u, z, w; 
  int informer = 0;
 

  struct stat fstat;
  struct tm *tp;

  i = 0;
  while (arg[i] != '\0') {
	t[i] = arg[i];
	if (t[i] == '.') t[i] = '/';
	i++;
  }
  t[i] = '\0';

  sprintf(Ndir, "%s/%s", NEWS, t);

  if(strlen(arg) > 14){
#ifndef _LONGNAMES
	strcpy(s, (UNSIGNED char *) shortname(arg));
#else
	strcpy(s, (UNSIGNED char *) arg);
#endif
	sprintf(Ldir, "%s/%s", LIB, s);
  } 
  else{
	sprintf(Ldir, "%s/%s", LIB, arg);
  }
  strcpy(Ldir, (UNSIGNED char *) stripped(Ldir));

  sprintf(Tdir, "%s/TD.%d", TMP, getpid());

  if (FLAG == 0) printf("\n%s...\n", Ndir);

  sprintf(f, "%s/%dA", TMP, getpid());

  informer = 0;

  dp = opendir( Ndir );
  if(dp == NULL){
	printf("::No such directory!\n\n");
	return (UNSIGNED char *) "\0";
  }
  while((actdir = readdir(dp)) != NULL){
	 dirarray[idp] = atoi(actdir->d_name);
	 if(dirarray[idp] != 0) idp++;
	 if(idp == LIM_RE_INFO){
		informer++;
		/*
		ft = fopen(MBD_ERROR, "a");
		fprintf(ft, "At least %d articles in [%s]\n", (int) LIM_RE_INFO, Ndir);
		fclose(ft);	
		*/	
	 }
	 if(idp >= MAX_PER_NG){
		ft = fopen(MBD_ERROR, "a");
		fprintf(ft, "Limit overrun by %d articles in [%s]\n", (int) MAX_PER_NG, Ndir);
		fclose(ft);		
	        /*	
		nerror("mb-daemon.c", 506, "scan", "Directory too huge", Ndir );		
	        */
		return (UNSIGNED char *) "19000000"; 
	 }
  }
  closedir(dp);

  if(informer != 0){
	ft = fopen(MBD_ERROR, "a");
	fprintf(ft, "There are actually %5d articles in [%s]\n", idp, Ndir);
	fclose(ft);	
  }

  for(i = 0; i < idp; i++){
	for(j = 0; j < idp; j++){
		if(dirarray[i] > dirarray[j]){
			a = dirarray[j];
			dirarray[j] = dirarray[i];
			dirarray[i] = a;
		}
        }
  } 

  if(idp == 0){
	if (FLAG == 0) printf("::Directory is empty!\n\n");
	ft = fopen(Ldir, "w");
	fputs(" ", ft);
	fclose(ft);
	return (UNSIGNED char *) "\0";
  }

  strcpy(sdate, (UNSIGNED char *) ":-)");

  strcpy(today, (UNSIGNED char *) mydate(1));

  ft = fopen(Ldir, "r");
  if(ft == NULL){
	ft = fopen(Ldir, "w");
	if(ft == NULL){
		nerror("mb-daemon.c", 575, "scan", "Can't write to", Ldir );		
		return;
	}
	fputs("\n\n0\n", ft);
	fclose(ft);
	ft = fopen(Ldir, "r");
	OLDo = -2;
  }
  fgets(s, STRING, ft);
  fgets(s, STRING, ft);
  fgets(s, STRING, ft);
  OLDENTRY = atoi(s); 

  mblock(Ldir);

  ff = fopen(Tdir, "w");

  seq = 0;

  mb_gruppen++;

  if(FASTMODE == 0){
	sprintf(s, "%s/threads.%d", TMP, getpid());
	th = fopen( s, "w"); /* Threads */
	if(th == NULL){
		printf("\nMB-DAEMON: Can't open [%s]!\n", s);
		exit(0);
	}
  }


  if((strcomp(PDNG, arg) == 0) || (strcomp(ADULTNG, arg) == 0)){
	PDGROUP++;	
	fprintf(ff, "%s\n", GBL08_MSG); 
  }
  else{
	fprintf(ff, "%s\n", GBL05_MSG);
  }
  fputs("===============================================================================\n", ff);

  while (iii < idp) {

	if((dirarray[iii] < OLDENTRY) && (FASTMODE == 1)) goto YET_SCANNED;

	OLDn++;

	seq++;
	BINFILE = 0;
	fsi++;

	sprintf(arti, "%s/%d", Ndir, dirarray[iii]);  
	strcpy(t, (UNSIGNED char *) arti);

	if (FLAG == 0) printf("~%s: ", (UNSIGNED char *) strcopy(t, strlen(NEWS), 80));
	

	fp = fopen(t, "r");
	if (fp != NULL) {
		stat(t, &fstat);
		checktime = fstat.st_mtime;

		if (KILLMODE == 1) {
			printf("%s", t);
			if (checktime <= killtime) {
				printf(" has to be erased.\n");
				fclose(fp);
				unlink( t );
				continue;
			}
			printf("\n");
		}

		tp = localtime(&fstat.st_mtime);
		nowtime = fstat.st_mtime;

		if(fstat.st_mode & S_IFDIR) goto OFF_HERE;

		mb_bytes += (long) fstat.st_size;
		sprintf(thatday, "%02.2d.%02.2d.%02.2d", tp->tm_mday, tp->tm_mon + TZS, tp->tm_year);
		if(strcomp(thatday, today) == 0) mb_new_bytes += (long) fstat.st_size;

		if (sdate[0] == ':') {
			sprintf(sdate, "%4.4d%02.2d%02.2d",
				1900 + tp->tm_year, tp->tm_mon + TZS, tp->tm_mday);
			sprintf(s, "%02.2d:%02.2d",
				tp->tm_hour, tp->tm_min);
			LASTTIME = timeconv(s);
			if (FLAG == 0) printf(" (%s) ", sdate);
			if(strcomp(thatday, today) == 0) mb_new++;
		}

		if ((strcomp(arg, REFLECT_NG) == 0) || (strcomp(arg, "local.test") == 0)) {
			if (strcomp(thatday, today) == 0) {
				/*
				if (nowtime > lastrun) reflector(arg, t);
				*/
				reflector(arg, t);
			}
		}
		from[0] = '\0';
		subj[0] = '\0';
		date[0] = '\0';
		line[0] = '\0';
		orga[0] = '\0';
		
		strcpy(keyw, (UNSIGNED char *) "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
		got_org = 0;
		i = 0;

		approved = 0;

		while((got_org == 0) && (i < 20)){
			fgets(ex, 1024, fp);
			ex[STRING] = '\0'; strcpy(s, ex);
			if (strcomp("From:", s) == 0) {
				strcpy(from, s);
			}
			if ((strcomp("Reply-To:", s) == 0) && (from[0] == '\0')) {
				strcpy(from, s);
			}
			if (strcomp("Subject:", s)      == 0){
				strcpy(subj, s);
#ifdef _UNNET
			/*
				if((strcomp(STOCK_DJ,	s) == 0) ||
				   (strcomp(STOCK_DAX,	s) == 0) ||
				   (strcomp(WPKN_DJ,	s) == 0) ||
				   (strcomp(WPKN_DAX,	s) == 0)){
					stock_exchange( t, subj );
				}
			*/
#endif
			}
			if (strcomp("Keywords:", s)     == 0) strcpy(keyw, s);
			if (strcomp("Date:", s)         == 0) strcpy(date, s);
			if (strcomp("Lines:", s)        == 0){
				strcpy(line, s);
				if(from[0] != '\0'){
					/*
					i = 20;
					*/
					/* No more header lines! */
				}
			}
			if (strcomp("BINFILE", s)       == 0) BINFILE++;
			if (strcomp("Organization:", s) == 0) strcpy(orga, s);
		
#ifdef _UNNET
			if(strcomp("X-GATE", s)         == 0) strcpy(xgate, s);
			if(strcomp("X-NEWS", s)	        == 0) strcpy(xnews, s);
			if(strcomp("Approved:", s)	== 0) approved++;
#endif			

			if (strlen(s) < 3) got_org++;
			i++;
		}

		if(FASTMODE == 0){			/* Threads */
			if(strcomp("Subject: Re:", subj) == 0){
				strcpy(s, (UNSIGNED char *) strcopy(subj, 13, 83));
				fprintf(th, "%-70s  %5d-\n", (UNSIGNED char *) stripped(s), dirarray[iii] );
			}
			else{
				if(strcomp("Subject: Re^", subj) == 0){
					strcpy(s, (UNSIGNED char *) strcopy(subj, 15, 85));
					fprintf(th, "%-70s  %5d-\n", (UNSIGNED char *) stripped(s), dirarray[iii] );
				}
				else{
					strcpy(s, (UNSIGNED char *) strcopy(subj, 9, 79));
					fprintf(th, "%-70s  %5d+\n", (UNSIGNED char *) stripped(s), dirarray[iii] );
				}
			}
		}

#ifdef _UNNET		

		/*		
		if ((strcomp("de.", arg) == 0) && (FASTMODE != 0) && (from[0] != '\0')) {
		if ((strcomp("de.", arg) == 0) && (from[0] != '\0')) {
		*/		
		
		if (((strcomp("rec.arts.movies.local.indian", arg) == 0) ||
		     (strcomp("rec.music.indian.misc",        arg) == 0) ||
		     (strcomp("local.rmim",                   arg) == 0) ||
                     (strcomp("alt.movies.indian",            arg) == 0)) && 
 			(from[0] != '\0') && (approved == 0) && (FASTMODE != 0)) {
			u = 0; z = 0; w = 0;

			while(from[u] != '\0'){
				if((from[u] == '(') && (z == 0)) z = u;
				if(from[u] == ')') w = u;
				if((from[u] == '<') && (z == 0)) z = u;
				if(from[u] == '>') w = u;
				u++;
			}
			if((z != 0) && (w != 0)){
				if(from[z] == '('){
					if(from[z+1] != '"'){
						fprintf(ad, "%s; ", (UNSIGNED char *) stripped(strcopy(from, (z+1), (w-1))));
					}
					else{
						fprintf(ad, "%s; ", (UNSIGNED char *) stripped(strcopy(from, (z+2), (w-2))));
					}	
					fprintf(ad, "%s; ",
						(UNSIGNED char *) stripped(strcopy(from, 6, (z-2))));	
				}
				else{
					if(from[6] != '"'){
						fprintf(ad, "%s; ", (UNSIGNED char *) stripped(strcopy(from, 6, (z-2))));
					}
					else{
						fprintf(ad, "%s; ", (UNSIGNED char *) stripped(strcopy(from, 7, (z-3))));
					}
					fprintf(ad, "%s; ",
						(UNSIGNED char *) stripped(strcopy(from, (z+1), (w-1))));
				}
				u = 0;
				while(orga[u] != '\0'){
					if(orga[u] == ';') orga[u] = ',';
					u++;
				}
				fprintf(ad, "%s; %s\n", (UNSIGNED char *) strcopy(orga, 14, strlen(orga)-2), (UNSIGNED char *) mydate( 0 ));
			}
			
			fg = fopen( ADDRESSXX, "a" );
			if(fg != NULL){
				if(xgate[0] != '\0') fprintf(fg, "%s", xgate);
				if(xnews[0] != '\0') fprintf(fg, "%s", xnews);
				fclose(fg);
				xgate[0] = '\0';
				xnews[0] = '\0';
			}
		}
#endif

		if (FLAG == 0) printf("%s", (UNSIGNED char *) strcopy(subj, 9, 80));

		if ((from[0] == 'F') || (from[0] == 'R')) {
			
			if(PDGROUP == 0){
				sprintf(s, "%d        ", dirarray[iii]);
				s[6] = '\0';
				if (BINFILE != 0) s[5] = '*';

				subj[79] = '\0';
				strcpy(ex, (UNSIGNED char *) strcopy(subj, 8, 79));
				strcpy(et, (UNSIGNED char *) stripped(ex));
				strcpy(ex, et);
				strcat(ex, "                           ");
				ex[25] = '\0';
				strcat(s, ex);
				strcat(s, "   ");

				i = 5; /* 8 */
				if (from[0] == 'R') i = 10;
	
				from[79] = '\0';
				strcpy(ex, (UNSIGNED char *) strcopy(from, i, STRING));
				strcpy(et, (UNSIGNED char *) stripped(ex));
				strcpy(ex, et);
	
				a = 0;
				b = 0;
				i = 0;
				while (ex[i] != '\0') {
					if ((ex[i] == '(') && (a == 0)) a = i + 1;
					if (ex[i] == ')') b = i - 1;
					i++;
				}
				if (a < b) {
					strcpy(et, (UNSIGNED char *) strcopy(ex, a, b));
					strcpy(ex, et);
				}
				strcat(ex, "                           ");
				ex[19] = '\0';
				strcat(s, ex);
				strcat(s, "   ");
	

				i = 0;
				j = 0;
				while (date[i] != '\0') {
					if (j == 0) {
						if ((date[i] >= '1') && (date[i] <= '9'))
							j = i;
					}
					i++;
				}

				sprintf(ex, "%02.2d.%02.2d.%02.2d  %02.2d:%02.2d",
				 tp->tm_mday, tp->tm_mon + TZS, tp->tm_year,
					tp->tm_hour, tp->tm_min);
				strcat(ex, "                         ");
				ex[15] = '\0';
				strcat(s, ex);
				strcat(s, "  ");

				strcpy(ex, (UNSIGNED char *) strcopy(line, 7, 20));
				strcpy(t, (UNSIGNED char *) stripped(ex));
				i = atoi(t);
				sprintf(ex, "%-06d", i);
			}
			else{	/* PDGROUP ! */
				sprintf(s, "%d        ", dirarray[iii]);
				s[6] = '\0';
				if (BINFILE != 0) s[5] = '*';

				subj[79] = '\0';
				strcpy(ex, (UNSIGNED char *) strcopy(subj, 8, 79));
				strcpy(et, (UNSIGNED char *) stripped(ex));
				strcpy(ex, et);
				strcat(ex, "                           ");
				ex[19] = '\0';
				strcat(s, ex);
				strcat(s, "   ");

				strcpy(ex, (UNSIGNED char *) strcopy(keyw, 10, STRING));
				strcpy(t, (UNSIGNED char *) stripped(ex));
				strcpy(ex, t);
				strcat(ex, "                                                      ");
				ex[43] = '\0';
				strcat(s, ex);				
				strcat(s, "  ");
			}	
	
			if(PDGROUP != 0){
				i = pdsize(arti);
				sprintf(ex, "%-06d", i);
				if(i == 0){
					fg = fopen( CPRN, "a" );
				        if(fg != NULL){
						fprintf(fg, "\n#MB-DAEMON -> %23.23s | %s\n", s, arti);
						fprintf(fg, "rm %s\n", arti); 
						fclose(fg);
					}
				}
			}

			strcat(s, ex);
			fputs(s, ff);
			fputs("\n", ff);

			mb_artikel++;

			ok = 1;
		} else {
			if (FLAG == 0) printf("invalid header!\n");
		}

		OFF_HERE:

		if (fp != 0) fclose(fp);
	} else {
		if (FLAG == 0) printf("can't open! (%d)\n", errno);
	}
	iii++;
  }

  YET_SCANNED:

  if(OLDn != 0) OLDn -= 1;

  while(iii < idp){
	fgets(s, STRING, ft); 
	sprintf(t, "%s/%d", Ndir, dirarray[iii]);
	if(stat(t, &fstat) > -1){
		mb_bytes += (long) fstat.st_size;
		fputs(s, ff);
	}

	mb_artikel++;
	OLDo++;
	iii++;
  }
  fclose(ff);
  fclose(ft);
  mbrename( Tdir, Ldir );

  unlink(f);
  unlink(Tdir);


  if (sdate[0] == ':') {
	strcpy(sdate, (UNSIGNED char *) "19700101");
	LASTTIME = 0;
  }


/* This EXPIREing stuff caused trouble very often so I disabled it. If
   you like to use it set the following few lines free and check the
   defines in [mbox.h] ... */

  mbunlock(Ldir);

  if((FASTMODE == 1) && (FLAG == 0)){
	OLDo += 2;
	printf("\n==> %s %d. %s %d.\n\n", MBD01_MSG, OLDn, MBD02_MSG, OLDo);
  }

  if(FASTMODE == 0){
	fclose(th); /* Threads */

	sprintf(s, "%s/threads.%d", TMP, getpid());
	sprintf(t, "%s/thsrt.%d",   TMP, getpid());

	sprintf(f, "sort %s > %s", s, t);
	system(f);

	unlink(s);

	th = fopen( s, "w" );
	if(th == NULL){
		nerror("mb-daemon.c", 921, "scan", "Can't write to", s );		
		return;
	}
	fp = fopen( t, "r" );

	a = 0; b = 0;
	strcpy(subj, "Lisa Aziz");

	/* LISA AZIZ, newscaster in british television. Former member
           of the "Live at Five" team of SKY NEWS. Mostly responsible
           for my interests in british and later american news shows.
           Watching those was/is my way of learning english ... */

	s[77] = ' ';

	while(fgets(s, STRING, fp) != 0){
		if(strcomp(subj, s) != 0){
			if(strcomp("Lisa Aziz", subj) != 0){
				i = atoi( (UNSIGNED char *) v );
			
				if(b != 0) 
					j = GBL06_MSG;
				else
					j = GBL07_MSG;

				if(a == 0)
					fprintf(th, "%-5d %56s  %c         -\n", i, subj, j);		
				else
					fprintf(th, "%-5d %56s  %c       %3d\n", i, subj, j, a);				
			}
			strcpy(subj, s);
			subj[56] = '\0';
			strcpy(v, (UNSIGNED char *) strcopy(s, 72, STRING));			
			a = 0; b = 0;
		}
		if(s[77] == '-')
			a++;
		else
			b++;
		s[77] = ' ';
	}

	fclose(fp);
	fclose(th);

	sprintf(s, "%s/threads.%d", TMP, getpid());
	strcpy(f, (UNSIGNED char *) arg);
	if(strlen(f) > 14)
		strcpy(f, (UNSIGNED char *) shortname(f));
	sprintf(t, "%s/.thread/%s", LIB, f);
	sprintf(f, "sort -rn %s > %s", s, t);
	system(f);

	sprintf(t, "%s/thsrt.%d", TMP, getpid());

	unlink(t);
	unlink(s);

  }

  return (UNSIGNED char *) sdate;
}





/* #MX - Updates the AGROUPS file.

   The entry for the newsgroup [s] is substituted by the new entry [t]. */

void mix( s, t )
UNSIGNED char s[], t[];
{
  FILE *ff, *fp;
  UNSIGNED char tmp[STRING];
  UNSIGNED char f[STRING];

  sprintf(tmp, "%s/ff%d", TMP, getpid());


  maybe_locked( AGROUPS, "r" );
  fp = fopen( AGROUPS, "r" );
  if(fp == NULL){
	printf("\nMB-DAEMON: Can't open [%s]!\n", AGROUPS);
	exit(0);
  }

  ff = fopen( tmp, "w" );
  if(ff == NULL){
	printf("\nMB-DAEMON: Can't open [%s]!\n", tmp);
	exit(0);
  }

  while(fgets(f, STRING, fp) != NULL){
	if(strcomp(s, f) == 0){
		fputs(t, ff);
	}
	else{
		fputs(f, ff);
	}
  }
  fclose(fp);
  fclose(ff);

  mbrename( tmp, AGROUPS );
}






/* #MA - MB-DAEMONs main function.

   [argc] contains the number of given arguments (if you haven't known
   that, you should leave this at the moment!).

   If [argv] doesn't contain anything, all groups are scanned and 
   updated the fast way (FASTMODE).

   [argv] with "all -x" will lead to a scan of the entire newsgroups
   the long way (i.e. all indexes are rebuild completely).

   [argv] naming a single newsgroup or a hierachy will start a fast
   update of the belonging index files. 

   [argv] containing a newsgroups or a hierachy and the flag "-x" will
   rebuild the specified index files totally.

   [argv] delivering the name of a newsgroup and also the "kill" keyword
   will DELETE (!) all files which are older than timestamp [MMDDhhmm]!

   
   EXAMPLES: mb-daemon 
             mb-daemon all -x
  	     mb-daemon comp.sources
             mb-daemon comp.sources -x
	     mb-daemon comp.sources kill MMDDhhmm */


main(argc, argv)
int argc;
UNSIGNED char *argv[];
{
  FILE *fp;
  FILE *fa;
  FILE *fc;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char d[STRING];
  UNSIGNED char TMP_AGROUPS[STRING];

  int a, b;

  struct stat fstat;


  chdir(HOME);

  setuid(0);
  setgid(0);
  umask(0000);

  FLAG = 0;
  FASTMODE = 1;
  KILLMODE = 0;

  
  strcpy(ORGANIZATION, _ORGANIZATION);
  strcpy(SYSTEM,       _SYSTEM);
  strcpy(UUCPSITE,     _UUCPSITE);
  strcpy(UUCPID2,      _UUCPID2);
  strcpy(UUCPID1,      _UUCPID1);
  strcpy(NAT_DOMAIN1,  _NAT_DOMAIN1);
  strcpy(NAT_DOMAIN2,  _NAT_DOMAIN2);
  strcpy(NAT_DOMAIN3,  _NAT_DOMAIN3);
  strcpy(UUCPBANG,     _UUCPBANG);
  strcpy(PHONE,        _PHONE);
  strcpy(LOCATION,     _LOCATION);
  strcpy(SMARTHOST,    _SMARTHOST);
  strcpy(NEWS_MINIMUM, _NEWS_MINIMUM);
  strcpy(PMS_TTY,      _PMS_TTY);
  strcpy(GREP,         _GREP);
  strcpy(UUX,          _UUX); 
  strcpy(TAR,          _TAR);
  strcpy(SORTEDCUT,    _SORTEDCUT);
  strcpy(SECONDCUT,    _SECONDCUT);
  strcpy(THIRDCUT,     _THIRDCUT);
  TARIF = (int) _TARIF;
  NZNT  = (int) _NZNT;
  NZBT  = (int) _NZBT;
  RZNT  = (int) _RZNT;
  RZBT  = (int) _RZBT;
  WZNT  = (int) _WZNT;
  WZBT  = (int) _WZBT;
  strcpy(REFLECT_NG,   _REFLECT_NG);

  if(get_cfg() == -1)
	write_cfg();

  sprintf(s, "%s/mbd-limit", TMP);
  unlink( s );

  sprintf(TMP_AGROUPS, "%s/ACTIVE.%d", TMP, getpid() );

  if(argc > 1){
	FLAG++;
  }
  if(argc > 2){			/* MB-Daemon calls MB-Daemon !!! */
	FLAG++; 
	FASTMODE = 0; 
	if(strcomp("kill", argv[2]) == 0){
		KILLMODE = 1;
		printf("\nNOTE: MB-DAEMON has been ordered to DELETE all files which are older than\n");
		printf("timestamp %s - if that is not what you want press CTRL-C really soon!!\n", argv[3]);

		if(argc < 4){
			printf("\nArgument No.4 has to be the timestamp: MMDDhhmm!!\n");
			exit( 0 );
		}

		sprintf(s, "touch -t %s /tmp/timestamp", argv[3] );
		system( s );

		sleep( 15 );
	
		stat("/tmp/timestamp", &fstat);
		killtime = fstat.st_mtime;
	}
  }

  if(argc > 1){
	if(strcomp("all", argv[1]) == 0) FLAG = 0;
  }

  if(argc > 2){
	if(argv[2][0] == '-'){	/* Completly rebuild index !!! */
		FASTMODE = 0;
	}
  }

  if(FLAG == 0){
	fa = fopen( TMP_AGROUPS, "w" );
	if(fa == NULL){
		printf("\nMB-DAEMON: Can't open [%s]!\n", TMP_AGROUPS);
		exit( 0 );
	}
  }

  strcpy(s, (UNSIGNED char *) "./etc/mb-daemon.lastrun");
  lastrun = 0L;
  if(stat( s, &fstat ) == 0){
	lastrun = fstat.st_mtime;
  }
  fp = fopen( s, "w" );
  fprintf(fp, "Hands off! THIS is important!\n");
  fclose(fp); 

#ifdef _UNNET
    ad = fopen( ADDRESSES, "a" );
    if(ad == NULL){
	printf("\nMB-DAEMON: Can't open [%s]!\n", ADDRESSES);
	exit( 0 );	
    }
#endif

  mb_gruppen = 0;
  mb_new = 0;
  mb_bytes = 0L;
  mb_new_bytes = 0L;
  mb_artikel = 0L;


  fp = fopen(NGROUPS, "r");
  if(fp == NULL){
	printf("\nMB-DAEMON: Can't open [%s]!\n", NGROUPS);
	exit(0);
  }

  while (fscanf(fp, "%s %d %d %s", s, &a, &b, t) > 0) {
#ifdef _CNEWS
	if(t[0] == '=')
		continue;
#endif
	if(FLAG > 0){
		if(strcomp(argv[1], s) == 0){
	
#ifdef _SYS7
			strcpy(d, (UNSIGNED char *) scan(s));
#else
			strcpy(d, (UNSIGNED char *) scan(&s));
#endif
			sprintf(t, "%s  %s  %ld\n", s, d, LASTTIME);
			if(FLAG < 2) mix( s, t );
		}
	}
	else{
#ifdef _SYS7	
		strcpy(d, (UNSIGNED char *) scan(s));
#else	
		strcpy(d, (UNSIGNED char *) scan(&s));
#endif
		if((strcomp(CDROMNG, s) != 0) && (CDROMNG[0] != '\0'))
			fprintf(fa, "%s  %s  %ld\n", s, d, LASTTIME);
		else
			fprintf(fa, "%s  %s  %ld\n", s, "30003000", (long) 221);
	}
  }
  if(fp != 0) fclose(fp);

  if(FLAG > 0){
  }
  else{
     mb_bytes = (long)(mb_bytes / 1024);
     mb_new_bytes = (long)(mb_new_bytes /1024);
   
     sprintf(d, "%s/%d.mbd", TMP, getpid());
     fp = fopen( d, "w" );
     fprintf(fp, "%s  %s    %6d   %6ld",
                  mydate(1), mytime(1), mb_new, mb_new_bytes);
     fprintf(fp, "%16.16s", " ");
     fprintf(fp, "%6d   %6ld   %6ld\n", mb_gruppen, mb_artikel, mb_bytes);

     b = PRO_ENTRIES / 2; a = 0;

     fc = fopen( MB_DLOG, "r" );
     if(fc != 0){
	while((fgets(s, STRING, fc) != 0) && (a < b)){
		fputs(s, fp);
		a++;
	}
	fclose(fc);
     }
     if(fp != 0) fclose(fp);

     mbrename( d, MB_DLOG);
  } 

  if((FASTMODE == 1) && (FLAG == 0)){
	printf("%s %d %s %ld %s.\n", MBD03_MSG, mb_new, MBD04_MSG, 
		mb_new_bytes, MBD05_MSG);
	printf("%s %d %s %ld %s %ld %s.\n\n", 
		MBD06_MSG, mb_gruppen, MBD07_MSG, mb_artikel, MBD08_MSG, 
		mb_bytes, MBD09_MSG);
  }


#ifdef _UNNET
  if(ad != 0) fclose(ad);
#endif

  if(FLAG == 0){
	fflush(fa);
	fclose(fa);
	fp = fopen( TMP_AGROUPS, "r" );
	if(fp == NULL){
		printf("\nMB-DAEMON: Can't open [%s]!\n", TMP_AGROUPS);
		exit(0);
	}
	fa = fopen( AGROUPS, "w" );
	if(fa == NULL){
		printf("\nMB-DAEMON: Can't open [%s]!\n", AGROUPS);
		exit(0);
	}
	while(fgets(s, STRING, fp) != 0){
		fputs(s, fa);
	}
	fflush(fa);
	fclose(fa);
	fclose(fp);
	unlink( TMP_AGROUPS );
  }

  if((FASTMODE == 0) && (FLAG == 0)){
	
	strcpy(s, (UNSIGNED char *) "1:???");

	fp = fopen( MB_READY, "r" );
	if(fp != NULL){
		fgets(s, STRING, fp);
		fclose(fp);
	}
	fp = fopen( MB_READY, "w" );
	if(fp == NULL){
		printf("\nMB-DAEMON: Can't write to [%s]!\n", MB_READY);		
	}
	if(s[0] == '1')
		fprintf(fp, "2:MB-DAEMON INDEX BUILD UP %s", (UNSIGNED char *) mytime(1));
	else
		fprintf(fp, "1:MB-DAEMON READY %s", (UNSIGNED char *) mytime(1));
	
	fclose(fp);
  }

  return;
}
