/* ix/MBox (mail.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #BF brief()           mailing to local and foreign users

   Contact <volkers@unnet.wupper.de> for help! */








#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>

#include "mbox.h"




/* #BF - The internal mailer.

   This one is able to mail to BBS users, to shell users and users
   abroad.

   If [arg] contains the text "~REPLY~", the mailer looks for a mail
   to replay on. If not, [arg] must be some kind of address. The mailer
   itself finds out wheter the receiver is a BBS user, shell user or
   even a user on another site.

   The function returns a -1 to announce a break or an error. */

int brief(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  FILE *ff;
  FILE *ft;
  int fd;
  int i, j, a;
  int ok;
  struct userdaten LOOSER;

  int endless;

  time_t timer;
  struct tm *timeptr;

  int receiver;
  int mail_id;
  int EX_PM = 0;
  int REPLY = 0;
  int lines = 0;
  int WEITERLEITEN = 0;
  int HOLD = 0;
  int UMLEITUNG = 0;
  int KOPIE = 0;
  int robinround = 0;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char TEP[STRING];
  UNSIGNED char REP[STRING];
  UNSIGNED char f[STRING];
  UNSIGNED char subject[STRING];
  UNSIGNED char from[STRING];
  UNSIGNED char rec_char[STRING];
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char user[STRING];
  UNSIGNED char mesg_id[STRING];
  UNSIGNED char refs[STRING];
  UNSIGNED char date[STRING];
  UNSIGNED char c;
  UNSIGNED char protokoll;
  UNSIGNED char lf;
  UNSIGNED char pubdir[STRING];
  UNSIGNED char dummy[STRING];
  UNSIGNED char username[STRING];
  UNSIGNED char reply[STRING];
  UNSIGNED char priority[STRING];
  UNSIGNED char action[STRING];
  UNSIGNED char cc[STRING];
  UNSIGNED char bcc[STRING];
  UNSIGNED char encrypted[STRING];
  UNSIGNED char comments[STRING];
  UNSIGNED char keywords[STRING];
  UNSIGNED char fortune[STRING];
  UNSIGNED char content[STRING];
  UNSIGNED char receipt[STRING];
  UNSIGNED char delivery[STRING];

  long cont_length = 0;

  int BINFILE;
  int news_reply = 0;

  struct stat fst;


  i = 0;
  ok = 0;

  mesg_id[0] = '\0';

  if (arg[0] == '\0') {
	ansi2("md", 0, 0);
	printf(" %s\n", MAL03_MSG);
	ansi2("me", 0, 0);
	intuition( 160 );
	return -1;
  }
  EX_PM = 0;

  i = 0;
  strcpy(t, USER.name);
  while (t[i] != '\0') {
	if (t[i] == ' ') t[i] = '.';
	i++;
  }
  strcpy(username, t);
  action[0] 	= '\0';
  priority[0]	= '\0';
  encrypted[0]	= '\0';
  keywords[0] 	= '\0';
  comments[0]	= '\0';
  cc[0] 	= '\0';
  bcc[0]	= '\0';
  fortune[0] 	= '\0';
  content[0]	= '\0';
  receipt[0] 	= '\0';
  reply[0]   	= '\0';
  delivery[0]	= '\0';

#ifdef _UMLAUT
  if(UMLAUT_MODUS < 3) strcpy(content, (UNSIGNED char *) "text/plain; charset=iso-8859-1");
#endif

  if(ROT13_MODUS) strcpy(encrypted, (UNSIGNED char *) "rot13");

  i = 0;
  while (arg[i] != '\0') {
	if ((arg[i] == '!') || (arg[i] == '@') || (arg[i] == '%')) EX_PM++;
	i++;
  }

  if ((EX_PM > 0) && (USER.level < MAILOUT_LEV)) {
	ansi2("md", 0, 0);
	printf("\n\n%s (%d) %s\n", MAL04_MSG, MAILOUT_LEV, MAL05_MSG);
	ansi2("me", 0, 0);
	return -1;
  }

  if(arg[strlen(arg) -1] == '?'){
	arg[strlen(arg) -1] = '$';
	HOLD++;
	KOPIE++;
  }

  if(arg[strlen(arg) -1] == '$'){
	WEITERLEITEN++;
	arg[strlen(arg) -1] = '\0';
	sprintf(TEP, "%s/usr/%c/%d/.lastletter", HOME, USER.name[0], USER.id);
	sprintf(t, "%s/usr/%c/%d/.lastsubject", HOME, USER.name[0], USER.id);
	fp = fopen( t, "r" );
	if(fp == NULL) {
		return -1; 
	}
	fgets(s, STRING, fp);
	fclose(fp);
	if(HOLD == 0){
		sprintf(subject, "%s %s", MAL06_MSG, s);
		UMLEITUNG++;
	}else
		sprintf(subject, "%s", s);
  }


  strcpy(user, (UNSIGNED char *) arg);
 
  if(WEITERLEITEN != 0) goto TRY_AGAIN;

  if (strcomp("~REPLY~", arg) == 0) {
	REPLY++;
	sprintf(REP, "%s/%dRep", TMP, getpid());
	sprintf(TEP, "%s/%dTep", TMP, getpid());
	fp = fopen(REP, "r");
	if (fp == NULL) {
		nerror("mail.c", 278, "brief", "Can't read", REP);
	}
	fgets(s, STRING, fp	);			/* HEADER: Autor */

	sprintf(dummy, "%s %s", GBL01_MSG, X_MAIL_DEMON);

	if ((strcomp(dummy, s) != 0) && 
	   ((strcomp(GBL01_MSG, s) == 0) ||
	    (strcomp("Autor:",  s) == 0) ||
     	    (strcomp("Author:", s) == 0) ||
            (strcomp("Auteur:", s) == 0))){

		i = 0; j = 0;
		while(s[i] != '\0'){
			if(s[i] == ':') j = i + 2;
			i++;
		}
		strcpy(user, (UNSIGNED char *) strcopy(s, j, 80)); 

		fgets(s, STRING, fp);		/* HEADER: Datum */
		fgets(s, STRING, fp);		/* HEADER: Betreff */

		strcpy(t, (UNSIGNED char *) strcopy(s, (1+strlen(GBL03_MSG)), STRING));
		subject[0]= '\0';
		if (strcomp("Re: ", t) != 0) {
			strcpy(subject, "Re: ");
		}
		strcat(subject, (UNSIGNED char *) stripped(t));

		fgets(s, STRING, fp);	/* HEADER: empty */
		fgets(s, STRING, fp);	/* HEADER: empty */
	}
	else {		/* UUCP-Header (!MBox) */

		sprintf(subject, MAL07_MSG);
		refs[0] = '\0';
		mesg_id[0] = '\0';

		ok = -1;

		while ((ok < 1) && (fgets(s, STRING, fp) != NULL)) {
			/*
			if (strcomp("Lines: ", s)      == 0) ok = 1;
			*/
			if (strcomp("Date: ",  s)      == 0) {
				strcpy(date, (UNSIGNED char *) strcopy(s, 6, STRING));
			}
			if (strcomp("Newsgroups: ", s) == 0) news_reply++;
			if (strcomp("Subject: ", s)    == 0) {
				subject[0] = '\0';
				strcpy(t, (UNSIGNED char *) strcopy(s, 9, STRING));
				if (strcomp("Re: ", t) != 0) {
					sprintf(subject, "%s", "Re: ");
				}
				strcat(subject, (UNSIGNED char *) stripped(t));
			}
			if (strcomp("Message-Id: ", s) == 0) {
				strcpy(mesg_id, (UNSIGNED char *) strcopy(s, 12, STRING));
			}
			if (strcomp("From: ", s) == 0) {
				strcpy(from, (UNSIGNED char *) strcopy(s, 6, STRING));
				ok = 0;
			}
			/*
			if (strcomp("From ", s) == 0) {
				strcpy(from, (UNSIGNED char *) strcopy(s, 5, STRING));
				ok = 0;
			}
			*/
			if (strcomp("References: ", s) == 0) {
				strcpy(refs, (UNSIGNED char *) strcopy(s, 12, STRING));
			}
			if (strcomp("Comments: ", s) == 0) {
				strcpy(comments, (UNSIGNED char *) strcopy(s, 10, STRING));
				strcpy(comments, (UNSIGNED char *) stripped(comments));	
			}
			if (strcomp("Keywords: ", s) == 0) {
				strcpy(keywords, (UNSIGNED char *) strcopy(s, 10, STRING));
				strcpy(keywords, (UNSIGNED char *) stripped(keywords));
			}
			if (strcomp("Content-Type: ", s) == 0) {
				strcpy(content, (UNSIGNED char *) strcopy(s, 14, STRING));
				strcpy(content, (UNSIGNED char *) stripped(content));
			}
			if (strcomp("X-Delivering-Time: ", s) == 0) {
				strcpy(delivery, (UNSIGNED char *) strcopy(s, 19, STRING));
				strcpy(delivery, (UNSIGNED char *) stripped(delivery));
			}

			if ((strlen(s) < 5) && (ok == 0)) ok = 1;

			/* THE FOLLOWING IS A LOUSY TRICK, EATING HEADER INFORMATION! */

			while(strlen(s) == (STRING - 1)){ 
				fgets(s, STRING, fp);
			}

		}
	}

	i = 0; a = 0; printf(" %-4.4d", a );

	ff = fopen(TEP, "w");

	if(news_reply > 0){
		fprintf(ff, "In \"%s\" you wrote the other day:\n\n", NG);
	}


	while (fgets(s, STRING, fp) != NULL) {

		a++; 
		printf("%c%c%c%c%-4.4d", BS, BS, BS, BS, a );
	
		if((s[0] != '\n') && (i == 0)){

			if(s[0] != '>'){
				if(s[2] != '>')
					fputs(">     ", ff);
			}
			else{
				if(strcomp(">  ", s) == 0){
					s[1] = '>';
				}
				else fputs(">", ff);
			}
		}

		if((s[0] != '>') && (s[2] != '>')){

			if(i >= 65){	
				fputs("\n>     ", ff);
				i = 0;
			}

			endless = 0;

			BETTER_TWICE:

			if((strlen(s) + i) > 65){
				j = 65 - i;
				i = 0;
				ok = 0;
				while((ok == 0) && (j > 0)){
					if(s[j] == ' '){
						fputs((UNSIGNED char *) iso_line( (UNSIGNED char *) strcopy(s, 0, (j-1))), ff);
						fputs("\n>     ", ff);
						strcpy(f, (UNSIGNED char *) stripped( strcopy(s, (j+1), strlen(s))));
						strcpy(s, (UNSIGNED char *) f);
						i = strlen(s) -1;
						if((s[i] == ' ') || (s[i] == '-'))
							s[i] = '\0';
						else
							strcat(s, (UNSIGNED char *) " ");
						i = strlen(s);
						ok++;
					}
					j--;
				}
				if((j == 0) && (ok == 0)){
					fputs("\n>     ", ff);
					endless++;
					if(endless == 1) goto BETTER_TWICE;
				}
			}
			else{
				i = 0;
			}
		}

		fputs((UNSIGNED char *) iso_line(s), ff);
	}
	fputs("", ff);
	fclose(ff);
	fclose(fp);
  }


  TRY_AGAIN:


  if((WEITERLEITEN != 0) && (EX_PM != 0)){
	sprintf(rec_char, "%s", user);
	if(checkdomaintype( rec_char ) != 0) return -1;
	goto ONCE_MORE;
  }

  receiver = 0;

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("mail.c", 216, "brief", "Can't read", UDBASE);
  }
  lseek(fd, 0L, SEEK_SET);
  while ((receiver == 0) && (read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER))) {
	if ((strcomp(user, LOOSER.name) == 0) ||
	    (strcomp(LOOSER.name, user) == 0) ||
	    (strcomp(user, LOOSER.nick) == 0) ||
	    (strcomp(user, LOOSER.sh_name) == 0)) {
		receiver = LOOSER.id;
		strcpy(rec_char, LOOSER.name);
	}
  }
  close(fd);
  mbunlock(UDBASE);

  if ((receiver == 0) && (EX_PM == 0)) {

	if (REPLY != 0) {
		strcpy(user, fetch_reciepy(REP));
		if (fetch_local == 1){
			robinround++;
			if(robinround < 2) goto TRY_AGAIN;

			sprintf(s, "%s!%s", _UUCPSITE, user);
			strcpy(user, (UNSIGNED char *) s);
			printf("[%s]\n", user);
		}
		strcpy(rec_char, (UNSIGNED char *) stripped(user));
		if (strcomp(user, "OOPS") == 0) {
			ansi2("md", 0, 0);
			printf("\n\n%s\n", MAL08_MSG);
			ansi2("me", 0, 0);
			unlink(TEP);
			unlink(REP); /* ??? */
			return -1;
		}
		EX_PM = 1;
		c = MAL13_MSG;
		goto REPLY_MARK;
	}
	else {
		ansi2("md", 0, 0);
		strcpy(rec_char, (UNSIGNED char *) stripped(user));
		printf("\n\n%s \"%s\" %s\n", MAL09_MSG, user, MAL10_MSG);
		ansi2("me", 0, 0);
		if(WEITERLEITEN == 0) unlink(TEP);
		unlink(REP);
		return -1;
	}
  }

  if(WEITERLEITEN != 0) goto ONCE_MORE;

  unlink(REP);

  if (EX_PM == 0) {
	ansi2("md", 0, 0);
	sprintf(s, "%s/usr/%c/%d/.hello", HOME, rec_char[0], receiver);
	printf("\n\n");
	show(s, 22, 0);
	ansi2("me", 0, 0);
  }
  else {
	strcpy(rec_char, arg);
  }

  if(checkdomaintype( rec_char ) != 0) return -1;

  if (REPLY != 0) {
	c = MAL13_MSG;
	goto REPLY_MARK;
  }
  printf("\n\n%c", CR);

  if(ROT13_MODUS){
	printf("%s ", MAL11aMSG);
	ansi2("md", 0, 0);
	printf("ROT13");
	ansi2("me", 0, 0);
	printf(" %s\n\n", MAL11bMSG);
  }
  ansi2("mr", 0, 0);
  printf("[%s \"%s\"] %s, ? > ", MAL11_MSG, rec_char, MAL12_MSG);
  ansi2("me", 0, 0);
  printf("%c%c", MAL13_MSG, BS);


  do {
	c = getint();
	if (c >= 97) c -= 32;
	if (c == '?') {
		clearline();
		ansi2("mr", 0, 0);
		printf("%c%s > ", CR, MAL16_MSG);
		ansi2("me", 0, 0);
	}
	if (c == ENTER) c = MAL13_MSG;
	if ((c != MAL13_MSG) && (c != MAL14_MSG) && (c != MAL15_MSG)) c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == MAL15_MSG) {		/* REJECT / VERWERFEN */
	unlink(REP);
	unlink(TEP);
	printf("\n");
	return -1;
  }
  sprintf(TEP, "%s/M%d", TMP, getpid());
  sprintf(pubdir, "%s/dir%d", TMP, getpid());

  if (c == MAL14_MSG) {		/* UPLOAD */
	clearline();
	ansi2("mr", 0, 0);
	printf("%c%s, ? > ", CR, MAL17_MSG);
	ansi2("me", 0, 0);

	do {
		protokoll = getint();
		if (protokoll >= 97) protokoll -= 32;
		if (protokoll == '?') {
			clearline();
			ansi2("mr", 0, 0);
			printf("%c%s > ", CR, MAL17aMSG);
			ansi2("me", 0, 0);
		}
		if ((protokoll != MAL18_MSG) && (protokoll != MAL18_MSG) &&
		    (protokoll != MAL20_MSG) && (protokoll != MAL21_MSG))
			protokoll = 0;
	} while (protokoll == 0);

	printf("%c", protokoll);

  }
  printf("\n\n%c", CR);
  ansi2("mr", 0, 0);
  printf("%s ", MAL22_MSG);
  ansi2("me", 0, 0);
  printf(" %s (%s)\n%c", USER.name, USER.nick, CR);
  ansi2("mr", 0, 0);
  printf("%s ", MAL23_MSG);
  ansi2("me", 0, 0);
  printf(" %s\n%c", rec_char, CR);
  ansi2("mr", 0, 0);
  printf("%s ", MAL24_MSG);
  ansi2("me", 0, 0);
  printf(" ");
  strcpy(subject, (UNSIGNED char *) getline(50, -11, '.', ""));
  if(subject[0] == '\0'){
	strcpy(subject, (UNSIGNED char *) "Just another letter ...");
	printf("%s                           ", subject);
  }
  printf("\n");
  ansi2("mr", 0, 0);
  printf("%s ", MAL23aMSG);
  ansi2("me", 0, 0);
  printf(" ");
  strcpy(cc, (UNSIGNED char *) getline(50, -11, '.', ""));

  REPLY_MARK:

  if(checkdomaintype( rec_char ) != 0) return -1;

  if (c == MAL13_MSG) {
        if(G94ACTIVE == 0){
    	  	security_ed( TEP );
	}
	else{
		g94_xfer();
	}
	protokoll = '*';
  }
  else {			/* UPLOAD */

	noctrlx();

	printf("%c", 7);
	ansi2("mb", 0, 0 );
	printf("\n\n%s\n\n", MAL25_MSG); 
	ansi2("me", 0, 0 );
	ansi2("md", 0, 0);
	printf("%s", MAL26_MSG);
	ansi2("me", 0, 0);
          
	unlink( TEP );
	
	switch (protokoll) {
	    case MAL18_MSG:
			fp = fopen(TEP, "w");
			if (fp == NULL) {
				nerror("mail.c", 268, "brief", "Can't write to", TEP);
			}
			c = 0;
			lf = CR;

			fputc(LF, fp);

			/*
			while ((c != CTRL_X) && (c != CTRL_D)) {
			*/
			while ((c != CTRL_E) && (c != CTRL_D)) {
				c = getint();
				if ((c == CR) && (lf == CR)) fputc(LF, fp);
				if (c == CR) lf = CR;
				if (c == LF) lf = LF;
				/*
				if ((c != CTRL_X) && (c != CTRL_D) && (c != CR)) {
					fputc(c, fp);
				}
				*/
				if ((c != CTRL_E) && (c != CTRL_D) && (c != CR)) {
					fputc(c, fp);
				}
			}
			fclose(fp);
			break;

	    case MAL19_MSG:
			printf("\n");
			sprintf(s, "exec %s -c TimeTravelAgency", RX);
			break;
	    case MAL20_MSG:
			printf("\n");
			sprintf(s, "exec %s", RB);
			break;
	    case MAL21_MSG:
			printf("\n");
			sprintf(s, "exec %s", RZ);
			break;
	}
	if (protokoll != MAL18_MSG){
		mkdir( pubdir, 0777 );
		chdir( pubdir );

		system( s );

		chdir( HOME );
		sprintf(s, "mv %s/* %s", pubdir, TEP);
		system( s );
		sprintf(s, "rm -r %s", pubdir);
		system( s );
		/*
		do{
			c = getch();
		}while((c < 32) && (c != 0));
		*/
	}
	sync();
	ctrlx();
	stat(TEP, &fst);
	if (fst.st_size < 3L) {
		printf("\n\n%s\n", MAL27_MSG);
		control(MAL28_MSG, 3);
		unlink(REP);	
		unlink(TEP);
		return -1;
	}	
	if (prf(TEP) == 1) {
		printf("\n\n");
		ansi2( "md", 0, 0 );
		printf("%s", MAL25_MSG);		
		ansi2( "me", 0, 0 );
		unlink(REP); 	
		unlink(TEP);
		BINFILE++;
		return -1;
	}
	else{
		mkix(TEP);
	}
  }

  sprintf(reply, "%s <%s@%s>", USER.name, username, UUCPID);

  ONCE_MORE:


  if(G94ACTIVE != 0) goto HOLD_MARK;

  if((HOLD != 0) || ((WEITERLEITEN != 0) && (IS_BUFFERED != 0))) goto HOLD_MARK;

  printf("\n\n");
  ansi2("mr", 0, 0);
  printf("[%s \"%s\"] %s, ? > ", MAL11_MSG, rec_char, MAL28aMSG);
  ansi2("me", 0, 0);
  printf("%c%c", MAL29_MSG, BS);

  do {
	c = getint();
	if (c >= 97) c -= 32;
	if (c == '?') {
		clearline();
		ansi2("mr", 0, 0);
		printf("%c%s > ", CR, MAL32_MSG);
		ansi2("me", 0, 0);
	}
	if (c == ENTER) c = MAL29_MSG;
	if ((c != MAL29_MSG) && (c != MAL30_MSG) && (c != MAL30aMSG) &&  (c != MAL31_MSG) && (c != MAL31aMSG)) c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == MAL31_MSG) {		/* CONTINUE / WEITERSCHREIBEN */
	security_ed( TEP );
	goto ONCE_MORE;
  }
  if (c == MAL30_MSG) {		/* REJECT / VERWERFEN */
	printf("\n");
	unlink(TEP);
	unlink(REP);
	return -1;
  }
  if (c == MAL31aMSG) {		/* HEADER */
	headline( MAL32aMSG );
	printf("\n");

	time(&timer);

	ansi2( "md", 0, 0 );
	printf("From: ");
	ansi2( "me", 0, 0 );
	printf("%s <%s@%s>\n", USER.name, username, UUCPID);

	ansi2( "md", 0, 0 );
	printf("Reply-To: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(reply, (UNSIGNED char *) getline(STRING, -1001, 32, reply));
		printf("\n");
	}
	else printf("%s\n", reply);

	ansi2( "md", 0, 0 );
	printf("Return-Receipt-To: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(receipt, (UNSIGNED char *) getline(STRING, -1001, 32, receipt));
		printf("\n");
	}

	i = 0; j = 0;			/* Receiver: Realname */
	while(from[i] != '\0'){
		if(from[i] == '<'){
			strcpy(s, (UNSIGNED char *) strcopy(from, 0, (i-1)));
			j = i;
		}
		if(from[i] == '(') j = i+1;
		if(from[i] == ')') strcpy(s, (UNSIGNED char *) strcopy(from, j, (i-1)));
		i++;
	}
	if(j == 0) strcpy(s, from);
		
	if(mesg_id[0] != '\0'){
		ansi2( "md", 0, 0 );
		printf("In-Reply-To: ");
		ansi2( "me", 0, 0 );
		printf("%s; ", (UNSIGNED char *) stripped(mesg_id)); 
		printf("from \"%s\" at %s", (UNSIGNED char *) stripped(s), date);

		if(refs[0] != '\0') 
			sprintf(s, "%s ", stripped(refs));
		else
			s[0] = '\0';
		strcat(s, mesg_id);
		ansi2( "md", 0, 0 );
		printf("References: ");
		ansi2( "me", 0, 0 );
		printf("%s\n", s);
	}

	ansi2( "md", 0, 0 );
	printf("To: ");
	ansi2( "me", 0, 0 );
	if(USER.level > 99999){
		strcpy(rec_char, (UNSIGNED char *) getline(STRING, -1001, 32, rec_char));
		printf("\n");
	}
	else printf("%s\n", rec_char);

	ansi2( "md", 0, 0 );
	printf("Cc: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(cc, (UNSIGNED char *) getline(STRING, -1001, 32, cc));
		printf("\n");
	}
	else printf("%s\n", cc);

	ansi2( "md", 0, 0 );
	printf("Bcc: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(bcc, (UNSIGNED char *) getline(STRING, -1001, 32, bcc));
		printf("\n");
	}
	else printf("%s\n", bcc);


	ansi2( "md", 0, 0 );
	printf("Subject: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(subject, (UNSIGNED char *) getline(STRING, -1001, 32, subject));
		printf("\n");
	}
	else printf("%s\n", subject);

	ansi2( "md", 0, 0 );
	printf("Keywords: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(keywords, (UNSIGNED char *) getline(STRING, -1001, 32, keywords));
		printf("\n");
	}
	else printf("%s\n", keywords);

	ansi2( "md", 0, 0 );
	printf("Comments: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(comments, (UNSIGNED char *) getline(STRING, -1001, 32, comments));
		printf("\n");
	}
	else printf("%s\n", comments);

	ansi2( "md", 0, 0 );
	printf("Encrypted: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(encrypted, (UNSIGNED char *) getline(STRING, -1001, 32, encrypted));
		printf("\n");
	}
	else printf("%s\n", encrypted);

#ifdef _MULTIMEDIA
	ansi2( "md", 0, 0 );
	printf("MIME-Version: ");
	ansi2( "me", 0, 0 );
	printf("%s\n", MIME_VERSION);

	if(USER.level >= WRITE_INTERNAT){
		if(content[0] == '\0')
			strcpy(content, (UNSIGNED char *) "text/plain; charset=us-ascii");
		ansi2( "md", 0, 0 ); 
		printf("Content-Type: ");
		ansi2( "me", 0, 0 );
		strcpy(content, (UNSIGNED char *) getline(STRING, -1001, 32, content));
		printf("\n");
	}
#endif

	ansi2( "md", 0, 0 );
	printf("X-Mailer: ");
	ansi2( "me", 0, 0 );
	printf("%s %s %s\n", VERSION, PATCHLEVEL, AUTOR);	

	ansi2( "md", 0, 0 );
	printf("Priority: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(priority, (UNSIGNED char *) getline(STRING, -1001, 32, priority));
		printf("\n");
	}
	else printf("%s\n", priority);

	ansi2( "md", 0, 0 );
	printf("Action: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(action, (UNSIGNED char *) getline(STRING, -1001, 32, action));
		printf("\n");
	}
	else printf("%s\n", action);

	ansi2( "md", 0, 0 );
	printf("X-Fortune: ");
	ansi2( "me", 0, 0 );
	if(USER.level > GUEST_LEV){
		strcpy(fortune, (UNSIGNED char *) getline(STRING, -1001, 32, fortune));
		printf("\n");
	}
	else printf("%s\n", fortune);


	ansi2( "md", 0, 0 );
	printf("Message-Id: ");
	ansi2( "me", 0, 0 );
   	printf("<%x.%d@%s>\n", timer, USER.id, UUCPID);

	goto ONCE_MORE;
  }


  HOLD_MARK: 

  if(subject[0] != '\0')
	if(indecent( "", subject ) != 0){
		strcpy(subject, (UNSIGNED char *) "We have joy, we have fun ... we have Pacman for the SUN ;-)");
	}
  if(keywords[0] != '\0')
  	if(indecent( "", keywords ) != 0){
		keywords[0] = '\0';
  	}
  if(comments[0] != '\0')
  	if(indecent( "", comments ) != 0){
		comments[0] = '\0';
  	}

  if((UMLEITUNG == 0) && (WEITERLEITEN == 0) && (strcomp(TMP, TEP) == 0)){
	sprintf(s, "cp %s %s/usr/%c/%d/.lastletter > /dev/null", TEP, HOME, USER.name[0], USER.id);
	system( s );     
	sprintf(s, "%s/usr/%c/%d/.lastsubject", HOME, USER.name[0], USER.id);
	fp = fopen( s, "w" );
	if(fp == NULL){
		nerror("mail.c", 500, "brief", "Can't write to", s);
	}
	fprintf(fp, "%s", subject);
	fclose(fp);
  }


  if (EX_PM == 0) {

 	if(rec_char[0] >= 'a') rec_char[0] -= 32;

	sprintf(s, "%s/usr/%c/%d/seq", HOME, rec_char[0], receiver);
	maybe_locked(s, "r"); mblock(s);
	fp = fopen(s, "r");
	if (fp == NULL) {
		nerror("mail.c", 431, "brief", "Can't read", s);
	}
	fscanf(fp, "%d", &mail_id);
	fclose(fp);
	fp = fopen(s, "w");
	fprintf(fp, "%d\n", (mail_id + 1));
	fclose(fp);
	mbunlock(s);
	sprintf(s, "%s/usr/%c/%d/%d", HOME, rec_char[0], receiver, mail_id);
  }
  else {
	umask(0000);
	sprintf(s, "%s/%d.expm", TMP, getpid());
  }


  fp = fopen(s, "w");

  if (EX_PM == 0) {
	sprintf(s, "%s %s (%s)\n", GBL01_MSG, USER.name, USER.nick);
	fputs(s, fp);

	time(&timer);
	timeptr = localtime(&timer);
	strcpy(t, asctime(timeptr));

	sprintf(s, "%s %s", GBL02_MSG, t);
	fputs(s, fp);

	sprintf(s, "%s %s\n\n", GBL03_MSG, subject);
	fputs(s, fp);

	fputs("Content-Type: text/plain;\n", fp);

	lines = 5;
   }
   else {
	lines = 4;
  }

  if((EX_PM == 0) && (HOLD != 0)){
	/* No use in checking ... yet done anyway ;-) */
  }
  else{
	if(indecent( TEP, "" ) != 0){
		goto ONCE_MORE;
	}
  }


  ff = fopen(TEP, "r");
  if (ff == 0) {
	printf("\n\n");
	ansi2("md", 0, 0);
	printf("%s\n", MAL33_MSG);
	ansi2("me", 0, 0);
	control(MAL34_MSG, 3);
	return;
  }
  stat(TEP, &fst);
  cont_length = fst.st_size;

  if(EX_PM != 0){

	time(&timer);

	i = 0; j = 0;			/* Receiver: Realname */
	while(from[i] != '\0'){
		if(from[i] == '<'){
			strcpy(s, (UNSIGNED char *) strcopy(from, 0, (i-1)));
			j = i;
		}
		if(from[i] == '(') j = i+1;
		if(from[i] == ')') strcpy(s, (UNSIGNED char *) strcopy(from, j, (i-1)));
		i++;
	}
	if(j == 0) strcpy(s, from);

	fprintf(fp, "From: %s@%s (%s)\n", username, UUCPID, USER.name); 
	if(reply[0] != '\0')
		fprintf(fp, "Reply-To: %s\n", reply);
	if(receipt[0] != '\0')
		fprintf(fp, "Return-Receipt-To: %s\n", receipt);
	fprintf(fp, "Organization: %s\n", ORGANIZATION);
	if(mesg_id[0] != '\0'){
		fprintf(fp, "In-Reply-To: %s; ", (UNSIGNED char *) stripped(mesg_id)); 
		fprintf(fp, "from \"%s\" at %s", (UNSIGNED char *) stripped(s), date);
		if(refs[0] != '\0') 
			sprintf(s, "%s ", stripped(refs));
		else
			s[0] = '\0';
		strcat(s, mesg_id);
		fprintf(fp, "References: %s\n", s);
	}
        fprintf(fp, "To: %s\n", rec_char);
	if(cc[0] != '\0')
		fprintf(fp, "Cc: %s\n", cc);

	sprintf(s, "%s/usr/%c/%d/.face", HOME, USER.name[0], USER.id); /* X-Face ??? */
	ft = fopen( s, "r" );
	if(ft != NULL){
		while(fgets(s, 70, ft) != NULL){
			fprintf(fp, "X-Face: %s\n", (UNSIGNED char *) stripped(s));
		}
		fclose(ft);
	}

	if(subject[0] != '\0')
		fprintf(fp, "Subject: %s\n", subject);
	if(keywords[0] != '\0')
		fprintf(fp, "Keywords: %s\n", keywords);
	if(comments[0] != '\0')
		fprintf(fp, "Comments: %s\n", comments);
	if(encrypted[0] != '\0')
		fprintf(fp, "Encrypted: %s\n", encrypted);

#ifdef _MULTIMEDIA
	fprintf(fp, "MIME-Version: %s\n", MIME_VERSION);
	if(content[0] != '\0'){
		fprintf(fp, "Content-Type: %s\n", content);
		if(UMLAUT_MODUS < 3) fprintf(fp, "Content-Transfer-Encoding: 8bit\n");
		fprintf(fp, "Content-Length: %ld\n", cont_length);
	}
	else{
		fprintf(fp, "Content-Type: text/plain; charset=us-ascii\n");
	}
#endif
	fprintf(fp, "X-Mailer: %s %s %s\n", VERSION, PATCHLEVEL, AUTOR);	
	if(priority[0] != '\0')
		fprintf(fp, "Priority: %s\n", priority);
	if(action[0] != '\0')
		fprintf(fp, "Action: %s\n", action);
	if(fortune[0] != '\0')
		fprintf(fp, "X-Fortune: %s\n", fortune);
   	fprintf(fp, "Message-Id: <%x.%d@%s>\n", timer, USER.id, UUCPID);
	if(delivery[0] != '\0')
		fprintf(fp, "X-Delivered-After: %s\n", delivery);
 	fputs("\n", fp);

  }

  UMLAUT_MODUS = 1;
  if(WEITERLEITEN == 0) printf(" %-4.4d", lines);
  while (fgets(s, STRING, ff) != 0) {
	if(ROT13_MODUS) strcpy(s, (UNSIGNED char *) rot13( s ));
	fputs((UNSIGNED char *) iso_line(s), fp);
	lines++;
	if(WEITERLEITEN == 0) printf("%c%c%c%c%-4.4d", BS, BS, BS, BS, lines);
  }
  fclose(ff);

  if(UMLEITUNG == 0){
	  sprintf(s, "%s/usr/%c/%d/.signature", HOME, USER.name[0], USER.id);
	  ff = fopen(s, "r");
	  if (ff != NULL) {
		while (fgets(s, STRING, ff) != 0) {
			if(ROT13_MODUS) strcpy(s, (UNSIGNED char *) rot13( s ));
			fputs((UNSIGNED char *) iso_line(s), fp);
			lines++;
			if(KOPIE == 0) printf("%c%c%c%c%-4.4d", BS, BS, BS, BS, lines);
		}
		fclose(ff);
	  }

#ifdef _WEATHER
	
	ff = fopen( WEATHER_REPORT, "r" );
	if (ff != NULL) {
		/*
		fprintf(fp, "\n"); lines++;
		*/
		while (fgets(s, STRING, ff) != 0) {
			fputs((UNSIGNED char *) iso_line(s), fp);
			lines++;
			if(KOPIE == 0) printf("%c%c%c%c%-4.4d", BS, BS, BS, BS, lines);
		}
		fclose( ff );
     	}
	else{
		nerror("mail.c", 1021, "brief", "Can't read", WEATHER_REPORT);
	}
	
#endif

  }

  UMLAUT_MODUS = USER.schluessel[2];

  if(WEITERLEITEN == 0) unlink(TEP);
  fclose(fp);

  if((EX_PM == 0) && (HOLD != 0)){
	/* Nope, don't do it! */
  }
  else{
	sprintf(s, "Mail to: %s", rec_char);
	charge( USER.id, s, (long) cont_length );
  }

  if (EX_PM == 0) {
	sprintf(s, "%s/usr/%c/%d/INDEX", HOME, rec_char[0], receiver);
	maybe_locked(s, "r"); 
	fp = fopen(s, "a");
	if (fp == NULL) {
		nerror("mail.c", 527, "brief", "Can't append to", s);
	}
	sprintf(s, "%d              ", mail_id);
	s[6] = '\0';
	if(HOLD != 0){
		s[5] = '>';
	}
	fputs(s, fp);

	sprintf(ex, "%s                                ", subject);
	ex[26] = '\0';
	fputs(ex, fp);

	sprintf(ex, "  %s                                        ", USER.name);
	ex[22] = '\0';
	fputs(ex, fp);

	strcpy(s, (UNSIGNED char *) mydate(1));
	strcpy(t, (UNSIGNED char *) mytime(1));
	sprintf(ex, "  %s  %s         ", s, t);
	ex[19] = '\0';
	fputs(ex, fp);

	if(HOLD != 0)
		sprintf(s, "%s\n", LE216_MSG);
	else{
		if(priority[0] != '\0')
			sprintf(s, "%s\n", LE219_MSG);
		else
			sprintf(s, "%s\n", LE215_MSG);
	}

	fputs(s, fp);

	fclose(fp);
  }
  else {
        if(G94ACTIVE == 0){
		sprintf(s, " X-Mail via UUCP (%s) ", rec_char);
		headline(s);
		printf("\n%s", MAL35_MSG);
	}
	sprintf(s, "%s/%d.expm", TMP, getpid());
	sprintf(t, "/bin/sh ./etc/rmail.sh %s %s %s > /dev/null 2>&1", s, rec_char, username);
	system(t);
	unlink(s);
	unlink(f);
	umask(0007);
	if(G94ACTIVE == 0) printf(" %s\n", MAL36_MSG);
  }

  unlink(REP);
  if((UMLEITUNG == 0) && (WEITERLEITEN == 0)) unlink(TEP);

  sprintf(s, "%s \"%s\" %s", MAL11_MSG, rec_char, MAL37_MSG);
  control(s, 3);

  if(G94ACTIVE == 0) printf("\n");


#ifdef _PMCOPY

  IS_BUFFERED = 0;

  if(WEITERLEITEN == 0){
	  if((strcomp(POSTMASTER, LOOSER.sh_name) == 0) || (strcomp(POSTMASTER, LOOSER.nick) == 0)){
		if(bcc[0] != '\0') strcat(bcc, ", ");
		sprintf(s, "%s!root", UUCPSITE);
		strcat(bcc, (UNSIGNED char *) s);
		IS_BUFFERED = 1;
	  }
  }
#endif

  if((cc[0] != '\0') || (bcc[0] != '\0')){
	carboncopy(cc, bcc);
  }

  if((EX_PM == 0) && (KOPIE == 0)){
	sprintf(s, "%s/usr/%c/%d/.deputy", HOME, rec_char[0], receiver);
	fp = fopen( s, "r" );
	if(fp != NULL){
		ex[0] = '\0';
		while((fgets(s, STRING, fp) != 0) && (strlen(ex) < (LONGSTRING - 50))){
			strcat(ex, (UNSIGNED char *) stripped(s));
			strcat(ex, ",");	
		}
		fclose(fp);

		ex[strlen(ex)-1] = '\0';
		if(strlen(ex) > 3) carboncopy( ex, "");
	}
  }

  return 0;
}
