/* ix/MBox (lesen2.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #AZ anzeigen()         select and show an article
   #L2 lesen2()           read a couple of articles
   #I2 inhalt2()          show a few index lines
   #O2 loeschen2()        delete a group of mails
   #MS mail_status()      change the state of a mail

   Contact <volkers@unnet.wupper.de> for help! */






#include <stdio.h>
#include <sys/stat.h>

#include "mbox.h"


extern UNSIGNED char headinfo[STRING];




/* #AZ - Show an article.

   [art] is the number of the requested article. This number has to
   be in between of [von] (minimum) and [bis] (maximum).

   The return value depends on the values of the "show()" function. */


int anzeigen(art, von, bis)
int art, von, bis;
{
  UNSIGNED char entry[STRING];
  UNSIGNED char s[STRING];
  int mr;
  int ok;

 
  if (strcomp(BRETT, "PM") != 0) {
	sprintf(entry, "%s/%d", BRETT, art);
  }
  else {
	sprintf(entry, "%s/usr/%c/%d/%d", HOME, USER.name[0], USER.id, art);
  }

  mr = 0;
  if ((USER.more == 1) || (USER.more == 3)) mr = 2;

  sprintf(s, "%d", art);

  if (((art >= von) && (art <= bis)) ||
      ((art >= bis) && (art <= von))) {

	ok = pruefe(s);	

	if(ok == 0){
		if(USER.more != 0){
			sprintf(headinfo, " %s %d (%s) ", LE201_MSG, art, NG);
			headline( headinfo );
		}
		else{
			ansi2("md", 0, 0);
			printf("%s %d\n", LE202_MSG, art);
			ansi2("me", 0, 0);
		}
		show( "?", 99, 99 );
		ok = show(entry, 9999, mr);
		mail_status( art, 'L' );
		if(ok != -1){
			if(USER.more != 0) ok = more();
		}
		else{
			return ok;
		}
	}
  }
  return (int) ok;
}


int sichtbar( c, m )
char c;
int m;
{
  if (((c != '*') && (m == 0)) ||
      ((c == '*') && (m != 0))) {
		return 1;
  }
  else{
	return 0;
  }
}




/* #L2 - Selected some articles.

   [arg] gives the key used to select the articles/mails. The meaning
   of [dummy] isn't know, yet. */

void lesen2(arg, mode)
UNSIGNED char arg[];
UNSIGNED char mode;
{
  FILE *fp;
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char s[STRING];
  int a = 56, b = 63;
  int i, d, e;
  int von, bis;
  int ALLE;
  int PM = 0;
  int art[MAX_PER_NG];
  int artp;
  int k, l;
  int LR = 0;


  if(strcomp(CDROMNG, NG) == 0){
	cdromB( arg, 'L' );
	return;
  }

  i = 0;
  k = -1;
  l = -1;
  while (arg[i] != '\0') {
	if (arg[i] == '-') k = i;
	if (arg[i] == '*') l = i;
	i++;
  }

  if ((arg[0] != '\0') && (k == -1) && (l == -1)) {
	ansi2("md", 0, 0);
	if(atoi(arg) != 0)
		printf(" %s\n", LE203_MSG);
	else
		printf(" %s\n", LE203aMSG);
	ansi2("me", 0, 0);
	return;
  }

  von = 1;
  bis = 32000;

  if (l != -1) {
	ALLE = 1;
  }
  if (k != -1) {
	strcpy(s, (UNSIGNED char *) strcopy(arg, 0, (k - 1)));
	von = atoi(s);
	strcpy(s, (UNSIGNED char *) strcopy(arg, (k + 1), strlen(arg)));
	bis = atoi(s);

	if (von == 0) von = 1;
	if (bis == 0) bis = 32000;
	ALLE = 1;
  }
  if ((k == -1) && (l == -1)) {
	ALLE = 0;
  }
  if ((von == 1) && (bis == 32000)) LR++;

  if ((USER.leserichtung != 1) && (LR != 0)) {
	i = von;
	von = bis;
	bis = i;
  }
  if (strcomp(BRETT, "PM") != 0) {
	PM = 0;
  }
  else {
	PM = 1;
  }

  d = a + 10;
  e = a + 14;

  fp = fopen(INHALT, "r");
  if (fp == NULL) {
	inhalt2(arg, mode);
	return;
  }
  artp = -1;

  while (fgets(ex, LONGSTRING, fp) != NULL) {
	if (ALLE == 1) {
		artp++;
		art[artp] = atoi(ex);
	}
	else {
		strcpy(s, (UNSIGNED char *) strcopy(ex, a, b));
		if (LASTLOG < dateconv(s)) {
			artp++;
			art[artp] = atoi(ex);
		}
		if (LASTLOG == dateconv(s)) {
			strcpy(s, (UNSIGNED char *) strcopy(ex, d, e));
			if (LASTTIME <= timeconv(s)) {
				artp++;
				art[artp] = atoi(ex);
			}
		}

#ifndef _OLDSTYLE
		if (artp != -1) {	/* LESEN/READ redirected to "lesen()" */
			sprintf(s, "%d", art[artp]);
			lesen( s );
			return;
		}
#endif

	}
	if(artp >= MAX_PER_NG){
		nerror("lesen2.c", 188, "lesen2", "Too much", "articles (MAX_PER_NG)");
	}
  }
  fclose(fp);



  if (artp == -1) {
	ansi2("md", 0, 0);
	printf(" %s", LE204_MSG);
	ansi2("me", 0, 0);
	printf("\n");
	return;
  }
  ansi2("cl", 0, 0);

  if (strcomp(BRETT, "PM") != 0) {
	i = von;
	von = bis;
	bis = i;
  }

  show("?", 0, 99);

  if (von > bis) {
	for (i = artp; i >= 0; i--) {
		if (anzeigen(art[i], von, bis) == -1) return;
	}
  }
  else {
	for (i = 0; i <= artp; i++) {
		if (anzeigen(art[i], von, bis) == -1) return;
	}
  }

  return;
}





/* #I2 - Sort out some index lines and display them.
                                    
   [arg] tells which lines are meant, [dummy] doesn't tell anything. */

int inhalt2(arg, mode)
UNSIGNED char arg[];
UNSIGNED char mode;
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char s[STRING];
  UNSIGNED char tmp[STRING];
  int a = 56, b = 63;
  int e, d, i;
  int von, bis;
  int k, l;
  int plus, minus;
  int PM;
  int ALLE;
  int LR = 0;
  int ARC = 0;
  int preset = -1;

  struct stat fst;


  if(strcomp("**", arg) == 0){
	if(strcomp("PM", BRETT) == 0) ARC++;
  }

  i = 0;
  k = -1;
  l = -1;
  while (arg[i] != '\0') {
	if (arg[i] == '-') k = i;
	if (arg[i] == '*') l = i;
	i++;
  }

  von = 1;
  bis = 32000;

  if ((arg[0] != '\0') && (k == -1) && (l == -1)) {
	strcpy(s, (UNSIGNED char *) strcopy(arg, 0, strlen(arg)));
	von = atoi(s);	
	bis = von;
	ALLE = 1;
  }

  if (l != -1) {
	ALLE = 1;
  }
  if (k != -1) {
	strcpy(s, (UNSIGNED char *) strcopy(arg, 0, (k - 1)));
	von = atoi(s);
	strcpy(s, (UNSIGNED char *) strcopy(arg, (k + 1), strlen(arg)));
	bis = atoi(s);

	if (von == 0) von = 1;
	if (bis == 0) bis = 32000;
	ALLE = 1;
  }

  fp = fopen(INHALT, "r");
  if (fp == NULL) {
	brett( "~" );
	return;
  }
  sprintf(tmp, "%s/I.%d", TMP, getpid());
  ff = fopen(tmp, "w");

  sprintf(s, " %s (%s) ", LE205_MSG, NG);
  s[80] = '\0';

  fgets(ex, LONGSTRING, fp);	/* skip old headline */
  fgets(ex, LONGSTRING, fp);    /* dito */

  if((strcomp(PDNG, NG) == 0) || (strcomp(CDROMNG, NG) == 0) || (strcomp(ADULTNG, NG) == 0)){
	headblock( s, GBL08_MSG );
  }
  else{
	if(strcomp(BRETT, "PM") == 0)
		headblock( s, GBL05aMSG );
	else
		headblock( s, GBL05_MSG );
  }
  

  PM = 1;
  if (strcomp(BRETT, "PM") != 0) {
	i = von;
	von = bis;
	bis = i;
	PM = 0;
  }
  plus = 0;
  minus = 0;

  d = a + 10;
  e = a + 14;

  if (((von == 1) && (bis == 32000)) || ((von == 32000) && (bis == 1))) LR++;

  if ((USER.leserichtung != 1) && (LR != 0)) {
	i = von;
	von = bis;
	bis = i;
  }
  if (von > bis) {
	while (fgets(ex, LONGSTRING, fp) != NULL) {
		i = atoi(ex);
		if((i != 0) && (ex[5] != '*')) minus++;
		if (ALLE == 1) {
			if ((i >= bis) && (i <= von)) {
				if(sichtbar( ex[5], ARC ) == 1){
					preset = i;
					fputs(ex, ff);
					plus++;
				}
			}
		} else {
			strcpy(s, (UNSIGNED char *) strcopy(ex, a, b));
			if ((s[2] != '.') && (strlen(ex) > 50)) {
				strcpy(s, "99.99.99");
			}	
			if (LASTLOG < (long) dateconv(s)) {
				if(sichtbar( ex[5], ARC ) == 1){
					preset = i;
					fputs(ex, ff);
					plus++;
				}
			}
			if (LASTLOG == dateconv(s)) {
				strcpy(s, (UNSIGNED char *) strcopy(ex, d, e));
				if (LASTTIME <= timeconv(s)) {
					if(sichtbar( ex[5], ARC ) == 1){
						preset = i;
						fputs(ex, ff);
						plus++;
					}	
				}
			}
		}
	}
	fclose(ff);

	if (PM == 1)
		sprintf(s, "sort -nr -o %s %s", tmp, tmp);
	else
		sprintf(s, "sort -n -o %s %s", tmp, tmp);
	system(s);
  }
  else {
	while (fgets(ex, LONGSTRING, fp) != 0) {
		i = atoi(ex);
		if((i != 0) && (ex[5] != '*')) minus++;
		if (ALLE == 1) {
			if ((i >= von) && (i <= bis)) {
				if(sichtbar( ex[5], ARC ) == 1){
					preset = i;
					fputs(ex, ff);
					plus++;
				}
			}
		} 
		else {
			strcpy(s, (UNSIGNED char *) strcopy(ex, a, b));
			if ((s[2] != '.') && (strlen(ex) > 50)) {
				strcpy(s, "99.99.99");
			}
			if (LASTLOG < (long) dateconv(s)) {
				if(sichtbar( ex[5], ARC ) == 1){
					preset = i;
					fputs(ex, ff);
					plus++;
				}
			}
			if (LASTLOG == (long) dateconv(s)) {
				strcpy(s, (UNSIGNED char *) strcopy(ex, d, e));
				if (LASTTIME <= (long) timeconv(s)) {
					if(sichtbar( ex[5], ARC ) == 1){
						preset = i;
						fputs(ex, ff);
						plus++;
					}
				}
			}
		}
	}
	fclose(ff);
  }
  fclose(fp);

  if (plus != 0) show(tmp, 9999, USER.more + 100);

  unlink(tmp);

  if(CURI_SIZE != 0L){ 
	stat(INHALT, &fst);
	if(CURI_SIZE == (long) fst.st_size){
		printf("%c\n", BELL);
		ansi2( "us", 0, 0 );
		switch(CURI_NO){
			case 0 : printf("%s", LE204aMSG); break;
			case 1 : printf("%s", LE204bMSG); break;
			case 2 : printf("%s", LE204cMSG); break;
			case 3 : printf("%s", LE204dMSG); break;
			case 4 : printf("%s", LE204eMSG); break;
			case 5 : printf("%s", LE204fMSG); break;
			case 6 : printf("%s", LE204gMSG); break;
			case 7 : printf("%s", LE204hMSG); break;
			case 8 : printf("%s", LE204iMSG); break;
			default: printf("%s", LE204jMSG); break;
		}
		CURI_NO++; 
		if(CURI_NO > 8) CURI_NO = 0;
		ansi2( "me", 0, 0 );
	}	
	else{
		CURI_SIZE = 0L;
		CURI_NO = 0;
	}     
  }


  if (ARC == 1) {
	if (plus == 0) 
		printf("%s\n", LE205aMSG);
	else
		printf("\n%s\n", LE205bMSG);
	return preset;
  }

  if (plus == 0) {
	ansi2("md", 0, 0);
	printf("%s", LE206_MSG);
	ansi2("me", 0, 0);
	if ((minus - plus) > 0)
		printf("\n%s %d %s", LE207_MSG, minus, LE208_MSG);
	else
		printf("\n%s", LE209_MSG);
  }
  else if ((plus < 19) || (plus > 21)) {
	if ((minus - plus) > 0)
		printf("\n%s %d %s", LE210_MSG, (minus - plus), LE211_MSG);
	else
		printf("\n%s", LE212_MSG);
  }
  printf("\n");

  return preset;
}




/* #O2 - Delete a group of mails.

   [arg] contains the list of articles to delete, [mode] doesn't matter. 

   Actually, I can't remember what [mode] was implemented for ;-) */

void loeschen2(arg, mode)
UNSIGNED char arg[];
UNSIGNED char mode;
{
  FILE *fp;
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char s[STRING];
  UNSIGNED char tmp[STRING];
  int a, b, i;
  int von, bis;
  int k;
  int plus;
  int PM;
  int COPIES = 0;

  if((USER.level == GUEST_LEV) || (arg[0] == '\0')){
	return;
  }

  i = 0;
  k = -1;
  while (arg[i] != '\0') {
	if (arg[i] == '-') k = i;
	i++;
  }

  if ((arg[0] == '>') || (arg[0] == '<')){
	COPIES++;
	arg[0] = '\0';
	k = -1;
  }

  if(((arg[0] < '0') || (arg[0] > '9')) && (arg[0] != '\0')){
	ansi2("md", 0, 0);
	printf(" <- %s\n", LE212aMSG);
	ansi2("me", 0, 0);
	intuition( 220 );
	return;
  }

  if ((arg[0] != '\0') && (k == -1)) {
	ansi2("md", 0, 0);
	printf(" %s\n", LE213_MSG);
	ansi2("me", 0, 0);
	return;
  }
  von = 1;
  bis = 32000;

  if (k != -1) {
	strcpy(s, (UNSIGNED char *) strcopy(arg, 0, (k - 1)));
	von = atoi(s);
	strcpy(s, (UNSIGNED char *) strcopy(arg, (k + 1), strlen(arg)));
	bis = atoi(s);

	if (von == 0) von = 1;
	if (bis == 0) bis = 32000;
  }
  if (strcomp(BRETT, "PM") != 0) {
	a = 60;
	b = 69;
  } else {
	a = 58;
	b = 65;
  }

  maybe_locked(INHALT, "r");

  sprintf(tmp, "%s/%d.l2", TMP, getpid());
  sprintf(s, "cp %s %s > /dev/null", INHALT, tmp);
  system(s);

  fp = fopen(tmp, "r");
  if (fp == NULL) {
	nerror("lesen2.c", 217, "loeschen2", "Can't read", tmp);
  }
  fgets(ex, LONGSTRING, fp);
  fgets(ex, LONGSTRING, fp);

  PM = 1;
  if (strcomp(BRETT, "PM") != 0) {
	i = von;
	von = bis;
	bis = i;
	PM = 0;
  }
  plus = 0;
 
  printf("\n\n[????]");

  if (von > bis) {
	while (fgets(ex, LONGSTRING, fp) != NULL) {
		i = atoi(ex);
		if (COPIES != 0) {
			if(ex[5] != '>') i = -1;
		}
		if ((i >= bis) && (i <= von)) {
			sprintf(s, "%d-", i);
			if(ex[5] != '*'){
				printf("%c[%s%c]   ", CR, s, BS);
				loeschen(s);
			}
			plus++;
		}
	}
  }
  else {
	while (fgets(ex, LONGSTRING, fp) != NULL) {
		i = atoi(ex);
		if (COPIES != 0) {
			if(ex[5] != '>') i = -1;
		}
		if ((i >= von) && (i <= bis)) {
			sprintf(s, "%d-", i);
			if(ex[5] != '*'){
				printf("%c[%s%c]   ", CR, s, BS);
				loeschen(s);
			}
			plus++;
		}
	}
  }
  fclose(fp);

  loeschen( "100000" ); /* rebuild INDEX ... it's a trick, not a Sony! */

  if (plus == 0) {
	ansi2("md", 0, 0);
	printf(" <- %s\n", LE214_MSG);
	ansi2("me", 0, 0);
	return;
  }
 
  unlink(tmp);

  printf("\n");

  return;
}




/* #MS - Change the state of a mail.

   [number] gives the number of the mail, [status] contains the news
   state of that mail. */

mail_status( nummer, status )
int nummer;
char status;
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char tmp[STRING];
  UNSIGNED char s[LONGSTRING];
  UNSIGNED char t[STRING];

  int no;

  struct stat fst;


  if (strcomp(BRETT, "PM") != 0) return;
 
  fp = fopen(INHALT, "r");
  if (fp == NULL) {
	return;
  }

  sprintf(tmp, "%s/I.%d", TMP, getpid());
  ff = fopen(tmp, "w");

  while(fgets(s, STRING, fp) != 0){
	no = atoi(s);
	if(no == nummer){
		if(status != '*'){
			strcpy(t, (UNSIGNED char *) strcopy(s, 73, 80));
			if((strcomp(LE216_MSG, t) != 0) && (strcomp(LE218_MSG, t) != 0)){
				s[73] = '\0';
				switch( status ){
					case 'L' : 	strcat(s, (UNSIGNED char *) LE217_MSG);
						break;
					case 'B' :	strcat(s, (UNSIGNED char *) LE218_MSG);
							break;
				}
				strcat(s, (UNSIGNED char *) "\n");
			}		
		}
		else{
			if(s[5] != '*') 
				s[5] = '*';
			else
				s[5] = ' ';
		}
	}
	fputs(s, ff);
  }
  fclose(ff);
  fclose(fp);

  ff = fopen(tmp, "r");
  if(ff == NULL){
	nerror("lesen2.c", 604, "mail_status", "Can't read", tmp);
  }

  fp = fopen(INHALT, "w");

  while(fgets(s, STRING, ff) != 0){
	fputs(s, fp);
  }
  fclose(ff);
  fclose(fp);

  unlink( tmp );

  sprintf(s, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);
  stat(s, &fst);
  IDX_SIZE = (int) fst.st_size;
}
