/* ix/MBox (lesen.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #LE lesen()             read mails and articles
   #AS ansage()            message editing
   #AD adrbook()           email addresses
   #AP approve_pd()	   approve uploaded stuff
   #US unterschrift()      signature editing
   #DE deputy()            address to forward mail to
   #PL plan()              sort of UNIX (R) "plan" file
   #GS getsite()           find the name of a site in a path
   #CD checkdomaintype()   is user trying to send international mails?

   Contact <volkers@unnet.wupper.de> for help! */


  


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <utmp.h>
#include <time.h>


#include "mbox.h"


extern UNSIGNED char headinfo[STRING];



/* #LE - Read mails or news articles.
 
   [arg] contains the number of a mail or an article. */

void lesen(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  UNSIGNED char s[LSTRING];
  UNSIGNED char t[STRING]; 
  UNSIGNED char entry[STRING];
  UNSIGNED char no[10];
  UNSIGNED char c;
  int i;
  int ok;
  int MIN, MAX;
  int pr;
  int NONSTOP = 0;

  struct stat fst;


  if(strcomp(CDROMNG, NG) == 0){
	cdromB( arg, 'L' );
	return; 
  }

  sprintf(no, "%s", arg);

  maybe_locked(INHALT, "r");
  fp = fopen(INHALT, "r");
  if (fp == NULL) {
	nerror("misc.c", 558, "lesen", "Can't read", INHALT);
  }
  while ((fgets(s, LSTRING, fp) != NULL) && (s[2] != '='));
  fgets(s, LSTRING, fp);
  MIN = atoi(s);
  MAX = atoi(s); 		/* If it's only one mail/article! */
  while (fgets(s, LSTRING, fp) != NULL) {
	MAX = atoi(s);
  }
  fclose(fp);

  if (MAX < MIN) {
	i = MIN;
	MIN = MAX;
	MAX = i;
  }


  NEXT_MSG:

  if ((no[0] < '1') || (no[0] > '9')) {
	ansi2("md", 0, 0);
	printf(" %s\n", MIS41_MSG);
	ansi2("me", 0, 0);
	return;
  }
  if (pruefe(no) != 0) goto NEXT_NEXT;

  if (strcomp(BRETT, "PM") != 0) {
        sprintf(entry, "%s/%s", BRETT, no); 
	sprintf(headinfo, " %s %s (%s) ", MIS43_MSG, no, NG);
	if(!DISKUSSION) headline( headinfo );	
	ok = show(entry, 9999, USER.more);
  }
  else {
	sprintf(entry, "%s/usr/%c/%d/%s", HOME, USER.name[0], USER.id, no);
	sprintf(headinfo, " %s (%s) ", MIS45_MSG, no);
	if(!DISKUSSION) headline( headinfo );
	ok = show(entry, 9999, USER.more);
	mail_status( (int) atoi(no), 'L' ); 
  }

  if(ok == -1) return;
  if(ok == -9){
	if(USER.leserichtung == 1){
		c = MIS52_MSG;
	}
	else{
		c = MIS51_MSG;
 	}
	goto NEXT_DIS;
  }

  c = LF;

  NEXT_NEXT:

  if (NONSTOP != 0) goto NEXT_DIS;

  printf("\n");
  ansi2("mr", 0, 0);
  printf("[Mesg. %s] %s, ? >", no, MIS46_MSG);
  ansi2("me", 0, 0);
  printf(" %c%c", MIS51_MSG, BS);

  do {
	c = getint();
	if (strcomp(BRETT, "PM") == 0) {
		if (c == MIS50_MSG) c = '*';
	}
	if (c >= 97) c -= 32;
	if (c == ENTER) c = MIS51_MSG;
	if (c == '?') {
		clearline();
		ansi2("mr", 0, 0);
		printf("%c%s >", CR, MIS53_MSG);
		ansi2("me", 0 ,0);
		printf(" ");
	}
	if (    (c != MIS47_MSG) && (c != MIS48_MSG) && (c != MIS49_MSG) && 
		(c != MIS50_MSG) && (c != MIS50aMSG) && (c != MIS50bMSG) &&
		(c != MIS51_MSG) && (c != MIS52_MSG) && (c != MIS52aMSG) && 
 		(c != '*') && (c != '.') && (c != ':') && (c != '!') && (c != '#')) {

				c = 0;
	}

  } while (c == 0);

  printf("%c", c);

  NEXT_DIS:

  if (c == MIS50_MSG) {		/* DELETE / LOESCHEN */
	clearline();
	ansi2("mr", 0, 0);
	printf("%s [%c, %c] >", MIS54_MSG, GBL06_MSG, GBL07_MSG);
	ansi2("me", 0, 0);
	printf(" ");
	if (yesno() == GBL06_MSG) {
		loeschen(no);
	}
	printf("\n");
	c = MIS51_MSG;
  }
  if (c == '*') {		/* DELETE (don't ask) / LOESCHEN (sofort) */
	loeschen(no);
	printf("\n");
	c = MIS51_MSG;
  }
  if (c == MIS50aMSG) { 	/* (undocumented) UUDECODE */
	uudecode( no );
	c = MIS51_MSG;
  }
  if (c == MIS50bMSG) {		/* (undocumented) PRINT */
	drucken( no );
	c = MIS49_MSG;
  }
  if ((c == '.') && (USER.level >= ADMIN_LEV)) {	/* (undocumented) UPDATE-RQ checking */
	update_rq( no );
	/*
	loeschen( no );
	*/
	printf("\n");
	c = MIS49_MSG;
  }
  if ((c == ':') && (USER.level >= ADMIN_LEV)) {	/* (undocumented) distributing BBS software */
	distrib_rq( no );
	/*
	loeschen( no );
	printf("\n");
	*/
	c = MIS49_MSG;
  }
  if ((c == '!') && (USER.level >= ADMIN_LEV)) {	/* (undocumented) copying to disk */
  	if (strcomp(BRETT, "PM") != 0) {
		sprintf(s, "mcopy -t %s/%s a:", BRETT, no); 
  	}
	else {
		sprintf(s, "mcopy -t %s/usr/%c/%d/%s a:", HOME, USER.name[0], USER.id, no);
	}
	system(s);
	c = MIS49_MSG;
  }
  if ((c == '#') && (USER.level >= ADMIN_LEV)) {	/* (undocumented) base64 */
  	if (strcomp(BRETT, "PM") != 0) {
		sprintf(s, "cp %s/%s %s/base64.in.%d", BRETT, no, TMP, getpid());
  	}
	else {
		sprintf(s, "cp %s/usr/%c/%d/%s %s/base64.in.%d", HOME, USER.name[0], USER.id, no, TMP, getpid());
	}
	system(s);
	sprintf(s, "%s %s/base64.in.%d", FAVORITE_EDITOR, TMP, getpid());
	system(s);
	sprintf(s, "base64 %s/base64.in.%d > %s/base64.%d", TMP, getpid(), UUINCOMING, getpid());
	system(s);
	sprintf(s, "%s/base64.in.%d", TMP, getpid());
	unlink( s );
	c = MIS49_MSG;
  }
  if ((c == MIS52aMSG) || (NONSTOP != 0)){		/* NONSTOP */
	ok = 0;
	c = MIS51_MSG;
	NONSTOP = 1;
  }
  if (c == MIS51_MSG) {		/* NEXT / NAECHSTE */
	ok = 0;
	do {
		i = atoi(no);
		i++;
		sprintf(no, "%d", i);
		pr = pruefe(no);
		if (pr == 0) ok = 1;
		if (pr == 1) goto NEXT_NEXT;
		if (i > MAX) {
			if(!DISKUSSION)
				printf("\n\n%s\n", MIS55_MSG);
			else
				printf("\n\n%s\n", MIS55aMSG);
			return;
		}
	} while (ok == 0);
	if (ok == 1) goto NEXT_MSG;
	goto NEXT_NEXT;
  }
  if (c == MIS52_MSG) {		/* PREVIOUS / VORHERIGE */
	ok = 0;
	do {
		i = atoi(no);
		i--;
		sprintf(no, "%d", i);
		pr = pruefe(no);
		if (pr == 0) ok = 1;
		if (pr == 1) goto NEXT_NEXT;
		if (i < MIN) {
			printf("\n\n%s\n", MIS56_MSG);
			return;
		}
	} while (ok == 0);
	if (ok == 1) goto NEXT_MSG;
	goto NEXT_NEXT;
  }
  if (c == MIS49_MSG) goto NEXT_MSG;	/* REPEAT / WIEDERHOLEN */


  if (c == MIS48_MSG) {			/* REPLY / BEANTWORTEN */
	headline( MIS57_MSG );
	sprintf(s, "cp %s %s/%dRep > /dev/null", entry, TMP, getpid());
	system(s);

	if (strcomp(BRETT, "PM") == 0) {
		printf("\n%s", MIS58_MSG);
		if(brief("~REPLY~") != -1){
			sprintf(s, "%s?", USER.name);
			brief(s);
			sprintf(s, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);
			mail_status( (int) atoi(no), 'B');
		}
	}
	else {
		printf("\n");
		ansi2("mr", 0, 0);
		printf("%s, ? >", MIS59_MSG);
		ansi2("me", 0, 0);
		printf(" ");

		do {
			c = getint();
			if (c >= 97) c -= 32;
			if (c == '?') {
				clearline();
				ansi2("mr", 0, 0);
				printf("%c%s >", CR, MIS60_MSG);
				ansi2("me", 0, 0);
				printf(" ");
			}
			if ((c != MIS61_MSG) && (c != MIS62_MSG)) c = 0;
		} while (c == 0);

		printf("%c", c);

		printf("\n\n%s", MIS58_MSG);

		if (c == MIS62_MSG) {
			schreiben("");
		}
		if (c == MIS61_MSG) {
			if((brief("~REPLY~") != -1) && (strcomp(GUEST, USER.name) != 0)){
				sprintf(s, "%s?", USER.name);
				brief(s);
				sprintf(s, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);
				stat(s, &fst);
			        IDX_SIZE = (long) fst.st_size;
			}
		}
	}
	goto NEXT_NEXT;
  }
  printf("\n");
  return;
}




/* #AS - If a user mails you, he is shown a messages which may be
   edited here. */

void ansage()
{
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char TEP[STRING];
  UNSIGNED char c;


  printf("\n\n%s\n\n", MAL38_MSG);

  sprintf(TEP, "%s/usr/%c/%d/.hello", HOME, USER.name[0], USER.id);
  ff = fopen(TEP, "r");
  if (ff != NULL) {
	ansi2("md", 0, 0);
	while (fgets(s, STRING, ff) != NULL) {
		printf("%s", s);
	}
	fclose(ff);
	ansi2("me", 0, 0);
	printf("\n\n");
  }
  ansi2("mr", 0, 0);
  printf("%c%s [%c, %c] >", CR, MAL39_MSG, GBL06_MSG, GBL07_MSG);
  ansi2("me", 0, 0);
  printf(" ");

  c = yesno();

  if (c == GBL06_MSG) {
	security_ed( TEP );
  }
  printf("\n");
}



/* #AD - Users personal address book ... */

void adrbook()
{
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char TEP[STRING];
  UNSIGNED char c;

  headline( MAL39aMSG );

  sprintf(TEP, "%s/usr/%c/%d/.address", HOME, USER.name[0], USER.id);
  show( TEP, 9999, USER.more );
  printf("\n");
  ansi2("mr", 0, 0);
  printf("%c%s [%c, %c] >", CR, MAL39bMSG, GBL06_MSG, GBL07_MSG);
  ansi2("me", 0, 0);
  printf(" ");

  c = yesno();

  if (c == GBL06_MSG) {
	security_ed( TEP );
  }
  printf("\n");
}



/* #AP - Approve uploaded PD/Freeware stuff ... */

void approve_pd()
{
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char TEP[STRING];
  UNSIGNED char c;

  headline( MAL39cMSG );

  sprintf(TEP, "%s/etc/list.newpd", HOME);
  show( TEP, 9999, USER.more );
  printf("\n");
  ansi2("mr", 0, 0);
  printf("%c%s [%c, %c] >", CR, MAL39dMSG, GBL06_MSG, GBL07_MSG);
  ansi2("me", 0, 0);
  printf(" ");

  c = yesno();

  if (c == GBL06_MSG) {
	security_ed( TEP );
  }
  printf("\n");
}


/* #US - Sort of signature. You may edit it here. */

void unterschrift()
{
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char TEP[STRING];
  UNSIGNED char c;


  printf("\n\n%s\n\n", MAL40_MSG);

  sprintf(TEP, "%s/usr/%c/%d/.signature", HOME, USER.name[0], USER.id);
  ff = fopen(TEP, "r");
  if (ff != NULL) {
	ansi2("md", 0, 0);
	while (fgets(s, STRING, ff) != NULL) {
		printf("%s", s);
	}
	fclose(ff);
	ansi2("me", 0, 0);
	printf("\n\n");
  }
  ansi2("mr", 0, 0);
  printf("%c%s [%c, %c] >", CR, MAL41_MSG, GBL06_MSG, GBL07_MSG);
  ansi2("me", 0, 0);
  printf(" ");

  c = yesno();

  if (c == GBL06_MSG) {
	security_ed( TEP );
  }
  printf("\n");
}


/* #DE - A list of other users (or infact of your own) to forward mails to. */

void deputy()
{
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char TEP[STRING];
  UNSIGNED char c;


  printf("\n\n%s\n\n", LE220_MSG);

  sprintf(TEP, "%s/usr/%c/%d/.deputy", HOME, USER.name[0], USER.id);
  ff = fopen(TEP, "r");
  if (ff != NULL) {
	ansi2("md", 0, 0);
	while (fgets(s, STRING, ff) != NULL) {
		printf("%s", s);
	}
	fclose(ff);
	ansi2("me", 0, 0);
	printf("\n\n");
  }
  ansi2("mr", 0, 0);
  printf("%c%s [%c, %c] >", CR, LE221_MSG, GBL06_MSG, GBL07_MSG);
  ansi2("me", 0, 0);
  printf(" ");

  c = yesno();

  if (c == GBL06_MSG) {
	security_ed( TEP );
  }
  printf("\n");
}



/* #PL - Kind of plan. Change your own entry here. */

void plan(arg)
UNSIGNED char arg[];
{
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char TEP[STRING];
  UNSIGNED char c;

  if(arg[0] != '\0'){
	finger( arg );
	return;
  }

  printf("\n\n%s\n\n", MAL42_MSG);

  sprintf(TEP, "%s/usr/%c/%d/.plan", HOME, USER.name[0], USER.id);
  ff = fopen(TEP, "r");
  if (ff != NULL) {
	ansi2("md", 0, 0);
	while (fgets(s, STRING, ff) != NULL) {
		printf("%s", s);
	}
	fclose(ff);
	ansi2("me", 0, 0);
	printf("\n\n");
  }
  ansi2("mr", 0, 0);
  printf("%c%s [%c, %c] >", CR, MAL43_MSG, GBL06_MSG, GBL07_MSG);
  ansi2("me", 0, 0);
  printf(" ");

  c = yesno();

  if (c == GBL06_MSG) {
	security_ed( TEP );
  }
  printf("\n");
}





/* #GS - Locate the name of a site in a path [arg] and return it. */

UNSIGNED char *getsite(arg)
UNSIGNED char arg[];
{
  int i = 0, a = 0, b = 0, c = 0;
  UNSIGNED char s[STRING];

  while(arg[i] != '\0'){
	if(arg[i] == '!') a = i - 1;
	if(arg[i] == '@') b = i + 1;
	if(arg[i] == '.'){
		if((b != 0) && (c == 0)) c = i -1;
	}
	i++;
  }

  if((a == 0) && (b == 0)) strcat(s, UUCPSITE);
  if(a != 0) strcpy(s, (UNSIGNED char *) strcopy(arg, 0, a));
  if(b != 0) strcpy(s, (UNSIGNED char *) strcopy(arg, b, c));

  return (UNSIGNED char *) s;
}





/* #CD - Check whether a user is allowed to mail to the specified
   receiver [arg], or not.

   This function returns 0 is everything is ok, and -1 if the user
   level isn't high enough. */

int checkdomaintype(arg)
UNSIGNED char arg[];
{
  int i = 0, l, a, e = 0, f = 0, g = 0, international = 0;
  UNSIGNED char s[STRING];

  if(USER.level >= WRITE_INTERNAT) return (int) 0;

  while(arg[i] != '\0'){
	if(arg[i] == '!') e++;
	if(arg[i] == '@') g++;
	i++;
  }
  s[0] = '\0';

  if((e == 0) && (g == 0)) return (int) 0;

  if(e > 1) international++;

  if(e == 0){

	l = strlen( (UNSIGNED char *) arg);

	a = strlen( (UNSIGNED char *) NAT_DOMAIN1 );
	strcpy(s, (UNSIGNED char *) strcopy(arg, (l-a), l));
	if(strcomp(s, NAT_DOMAIN1) == 0) f++;

	a = strlen( (UNSIGNED char *) NAT_DOMAIN2 );
	strcpy(s, (UNSIGNED char *) strcopy(arg, (l-a), l));
	if(strcomp(s, NAT_DOMAIN2) == 0) f++;

	a = strlen( (UNSIGNED char *) NAT_DOMAIN3 );
	strcpy(s, (UNSIGNED char *) strcopy(arg, (l-a), l));
	if(strcomp(s, NAT_DOMAIN3) == 0) f++;  	

	if(f == 0) international++;
  }  

  if(international != 0){
	ansi2("md", 0, 0);
	printf("\n\n%s (%d) %s\n", MAL01_MSG, WRITE_INTERNAT, MAL02_MSG);
	ansi2("me", 0 ,0);
	return (int) -1;	
  }

  return (int) 0;
}
