/* ix/MBox (uptodate.c) by Volker Schuermann, 16.06.1994

   This C source code contains the following functions:

   #IM ip_menue()	
   #KO konto()          set/show users "bank" account (bbs, ip, outdial)

   Contact <volkers@unnet.wupper.de> for help! */









#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/wait.h>
#include <time.h>

#include "mbox.h"


#define MAX_ENTRY	9

#ifndef IPINCOMING
#define IPINCOMING	"/tmp"
#endif

#define HAPPYHOUR 	"20-22"


struct ip_struct {
	UNSIGNED char provider[STRING];
	int level;
	UNSIGNED char time[STRING];
	UNSIGNED char DTR[STRING];
	float mind;
	UNSIGNED char NTR[STRING];
	float minn;
	float rate;
	UNSIGNED char IDR[STRING];
	float IPD;
 	UNSIGNED char INR[STRING];
	float IPN;
	float RABT;
} IP[MAX_ENTRY];

int IPP;


struct account_struct {
	UNSIGNED char date[STRING];
	UNSIGNED char account[STRING];
	long kto;
	long seg_free;
	long seg_day;
	long seg_night;
	long fon_day;
	long fon_night; 
} ACCT;

float UNITtime;
float UNITprice;
long UNITdiscount;
long UNITdispo;

UNSIGNED char starttime[STRING];
UNSIGNED char stoptime[STRING];

void unsqueeze_account();



int ip_intime( s )
UNSIGNED char s[];
{
  UNSIGNED char t[STRING];
  int a, b, c, ok = 0;

  strcpy(t, (UNSIGNED char *) mytime( 0 ));
  c = atoi(t);
  a = sgrep( s, "-" );		
  b = atoi( (UNSIGNED char *) strcopy(s, a, 80));
  a = atoi( s );

  ok = 0;

  if(b < a){					/* 18-8 o'clock */
	if((c >= a) || (c <= b)) ok++;
  }
  else{
 	if((c >= a) && (c <= b)) ok++;		/* 8-18 o'clock */
  }
 
  return (int) ok;	
}


ipaudit( service, provider )
UNSIGNED char service[], provider[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char tmp[STRING];
  long ts, tn;
  float f;
  int i;

  FILE *fp;


  time(&ts);

  unsqueeze_account( USER.account );

  sprintf(tmp, "%s/rollback.%d", TMP, USER.id);
 
  while(1){

	fp = fopen( tmp, "r" );
 	if(fp == NULL){
		time(&ts);
	}
	else fclose(fp);	
 
	fp = fopen( tmp, "a" );
	if(fp == NULL){
		printf("SHIT");
		exit( 0 );
	}

	time(&tn); tn -= ts;
	fprintf(fp, "%s %s %5ld ", starttime, mytime( 0 ), tn);
	tn -= UNITdiscount;
	i = tn / (UNITtime * 60.00);
	i++;
	f = (float) (UNITprice * i);

	fprintf(fp, "%8.02f %-8.8s %-8.8s %8.02f %8.02f %ld\n", 
		f, service, provider, UNITtime, UNITprice, UNITdiscount); 

	fclose(fp); 

	f *= 100;

	if(ip_intime( HAPPYHOUR ) == 0){
		if((ACCT.kto - f) < UNITdispo){
			printf("%c%c%c%cKONTO UEBERZOGEN!!!%c%c", CR, LF, CR, LF, CR, LF);
			return;
		}
	}
	else{
		/*
		if((ACCT.kto - f) < (float) -25.00){
			printf("%c%c%c%cKONTO UEBERZOGEN!!!%c%c", CR, LF, CR, LF, CR, LF);
			return;
		}
		*/
	}
	
	sleep( 30 ); 
  }
}


void unsqueeze_account( data )
UNSIGNED char data[];
{
  UNSIGNED char s[STRING];

  strcpy(ACCT.date,    (UNSIGNED char *) strcopy(data,  0,  9));
  strcpy(ACCT.account, (UNSIGNED char *) strcopy(data, 11, 17));

  strcpy(s, (UNSIGNED char *) strcopy(data, 18, 24));
  ACCT.kto = atol( s );
  strcpy(s, (UNSIGNED char *) strcopy(data, 25, 31));
  ACCT.seg_free = atol( s );
  strcpy(s, (UNSIGNED char *) strcopy(data, 32, 38));
  ACCT.seg_day = atol( s );
  strcpy(s, (UNSIGNED char *) strcopy(data, 39, 45));
  ACCT.seg_night = atol( s );
  strcpy(s, (UNSIGNED char *) strcopy(data, 46, 52));
  ACCT.fon_day = atol( s );
  strcpy(s, (UNSIGNED char *) strcopy(data, 53, 59));
  ACCT.fon_night = atol( s );
}

UNSIGNED char *squeeze_account()
{
  UNSIGNED char data[STRING];

  sprintf(data, "%sI%s%7ld%7ld%7ld%7ld%7ld%7ld",
		ACCT.date,
		ACCT.account,
		ACCT.kto,
		ACCT.seg_free,
		ACCT.seg_day,
		ACCT.seg_night,
		ACCT.fon_day,
		ACCT.fon_night );

  return (UNSIGNED char *) data;
}



int ip_segments( provider )
UNSIGNED char provider[];
{
  UNSIGNED char s[STRING]; 
  UNSIGNED char t[STRING];

  FILE *fp;

  sprintf(t, "%s/Packets.%d", TMP, getpid());
  sprintf(s, "/bin/sh ./etc/ipscript.Packets %s > %s", provider, t ); 
  system( s );

  fp = fopen( t, "r" );
  if(fp == NULL){
	printf("Shit!");
	exit( 0 );
  }
  fgets(s, STRING, fp);
  fclose(fp);
  
  unlink( t );

  return (int) atoi( s );
}



void ip_calc( secs, segs )
long secs;
int segs;
{ 
  UNSIGNED char md[STRING];
  int std, min, sek;
  float pf, sdm;
  int i = segs;


  if((secs - IP[IPP].RABT) <= 0L){
	return;
  }

  headline( " Internet Zugang " );
  
  printf("\nAnwahl \"Rabatt\": %.02f Sekunden\n", IP[IPP].RABT);
  secs -= IP[IPP].RABT; /* Anwahl Zeit / RABATT */
  if(secs < 0) secs = 0;

  std = (int) (secs / 3600);
  min = (int) ((secs - (std * 3600)) / 60);
  sek = (int) (secs - (std * 3600) - (min * 60));

  if(USER.account[10] != 'I'){
	USER.account[10] = '\0';
	strcat(USER.account, (UNSIGNED char *) "I0000000000000000000000000000000000000000000000000000");
  }

  ansi2( "md", 0, 0 );

  unsqueeze_account( USER.account );

  pf = (float) (secs / 60);

  strcpy(md, (UNSIGNED char *) mydate( 3 ));

  if((ip_intime( IP[IPP].DTR )) && (md[0] == '\0')){ 
	printf("Telefon-Gebuehren Einheit: %.02f Minuten (Tagtarif)\n", IP[IPP].mind);
	pf = (int) ((pf / IP[IPP].mind) + 1);		
	ACCT.fon_day += (((pf * IP[IPP].rate) + 0.005) * 100); 
  }
  else{
	printf("Telefon-Gebuehren Einheit: %.02f Minuten (Billigtarif)\n", IP[IPP].minn);
	pf = (int) ((pf / IP[IPP].minn) + 1);
	ACCT.fon_night += (((pf * IP[IPP].rate) + 0.005) * 100);
  }

  pf = (float) pf * IP[IPP].rate;


  if((ip_intime( IP[IPP].IDR )) && (md[0] == '\0')){
	printf("IP Segment-Gebuehr: %.03f DM\n", IP[IPP].IPD);
	sdm = i * IP[IPP].IPD;
	ACCT.seg_day += (sdm * 100);
  }
  else{
	printf("IP Segment-Gebuehr: %.03f DM\n", IP[IPP].IPN);
	sdm = i * IP[IPP].IPN;
	ACCT.seg_night += (sdm * 100);	
  }

  ansi2( "me", 0, 0 );

  printf("\n==============================================\n");
  printf("GEBUEHREN (%ld sek.)\n", secs);
  printf("==============================================\n");
  printf("Dauer der Verbindung   I %02d:%02d:%02d I\n", std, min, sek);
  printf("----------------------------------------------\n");
  printf("Telefon-Gebuehren      I          I %7.02f DM\n", pf);
  printf("----------------------------------------------\n");
  printf("IP Segmente (kB)       I %8d I\n", i);
  printf("IP Segmente (DM)       I          I %7.02f DM\n", sdm );
  printf("----------------------------------------------\n");
  printf("Abgebucht werden       I          I %7.02f DM\n", pf + sdm);	
  printf("==============================================\n");

  ACCT.kto -= (long) ((sdm + pf + 0.005) * 100);
  pf = (float) ACCT.kto;
  pf /= 100;

  printf("Kontostand (total)     I          I ");
  ansi2( "md", 0, 0 );
  printf("%7.02f DM\n", pf);               
  ansi2( "me", 0, 0 );
  printf("==============================================\n");

  strcpy(USER.account, (UNSIGNED char *) squeeze_account()); 
}


void ip_private_log( service, provider, costs, account, usern, userid, mode )
UNSIGNED char service[], provider[];
float costs;
float account;
UNSIGNED char usern[];
int userid;
char mode;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char d[STRING];

  FILE *fp;

  int i;

  sprintf(s, "%s/usr/%c/%d/.ip", HOME, usern[0], userid);

  fp = fopen( s, "a" );
  if(fp == NULL){
	printf("\n%s (%s (%d))\n", s, usern, userid);
	return;
  }

  if(mode == 'T'){
	fprintf(fp, "%s %s          %-7.7s %-8.8s       %7.02f DM Trying to connect\n",
			mydate( 1 ), starttime,
			service, provider,
			account );
  }
  if(mode == 'D'){
	fprintf(fp, "%s %s-%s %-7.7s %-8.8s %5.02f %7.02f DM\n",
			mydate( 1 ), starttime, stoptime,
			service, provider,
			costs, account );
  }
  if(mode == 'R'){
	fprintf(fp, "%s %s-%s %-7.7s %-8.8s %5.02f %7.02f DM Account restored!\n",
			mydate( 1 ), starttime, stoptime,
			service, provider,
			costs, account );
  }
  if(mode == 'A'){
	sprintf(s, "[%s]", USER.name); s[22] = '\0';
	fprintf(fp, "%s %s          %-22.22s %7.02f DM Account updated\n",
			mydate( 1 ), mytime( 0 ),
		  	(UNSIGNED char *) s,
			account );
  }

  fclose(fp);   
}


void ip_log( service, provider, secs, segs, state )
UNSIGNED char service[], provider[];
long secs;
int segs;
UNSIGNED char state[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char d[STRING];
  UNSIGNED char u[STRING];

  FILE *fp;

  int i;
  float costs, account;

  unsqueeze_account( USER.account );
  secs -= UNITdiscount;
  i = secs / (UNITtime * 60.00);
  i++;
  costs = (float) (UNITprice * i);
  account = ((float) ACCT.kto/100) - costs;

  if(secs < 0) account = ((float) ACCT.kto/100);

  strcpy(s, (UNSIGNED char *) USER.name); s[16] = '\0';
  sprintf(u, "%-4d %s", USER.id, s);
  strcpy(d, (UNSIGNED char *) service);   d[4] = '\0';
  strcpy(t, (UNSIGNED char *) provider);  t[7] = '\0';

  fp = fopen( "./etc/log.ip", "a" );

  if(strcomp("ROL", state) == 0){
	fprintf(fp, "R %s %s-%s %-22.22s %-3.3s %-7.7s %s -%.02f %.02f\n", 
		mydate( 1 ), starttime, stoptime, u, d, t, state, costs, account); 
	ip_private_log( service, provider, costs, account, USER.name, USER.id, 'R' );
  }
  else if(strcomp("TTC", state) == 0){
	fprintf(fp, "  %s %s %s %-22.22s %-3.3s %-7.7s %s\n", 
		mydate( 1 ), starttime, "        ", u, d, t, state); 
  }
  else{
	strcpy(stoptime, (UNSIGNED char *) mytime( 0 ));
	if(secs > 0) 
		fprintf(fp, "  %s %s-%s %-22.22s %-3.3s %-7.7s %s -%.02f %.02f\n", 
			mydate( 1 ), starttime, stoptime, u, d, t, state, costs, account); 
	else
		fprintf(fp, "? %s %s-%s %-22.22s %-3.3s %-7.7s %s -%.02f %.02f\n", 
			mydate( 1 ), starttime, stoptime, u, d, t, state, (float) 0.0, account); 

	if(secs > 0){
		ip_private_log( service, provider, costs, account, USER.name, USER.id, 'D' );
	} 
  }

  fclose(fp);    	 
}



void ip_menue( arg )
UNSIGNED char arg[];
{
  FILE *fp, *ff;
  int i, c, lev;
  int ok;
  int fpid;

  long tn, ts;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char v[STRING];
  UNSIGNED char ENTRY[MAX_ENTRY][STRING];
  UNSIGNED char SERVICE[MAX_ENTRY][STRING];
  UNSIGNED char provider[STRING];
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char xx[LONGSTRING];
  UNSIGNED char md[STRING];

  int segs, start_segs;

    
  REDO:

  if(ip_intime( HAPPYHOUR) == 0)
	headblock( " Internet Zugang ", "      Anbieter     Zeit     Gebuehren/Einheit    Status" );
  else
	headblock( " Internet \"HAPPY HOUR\" ", "      Anbieter     Zeit     Gebuehren/Einheit    Status" );
  printf("\n");

  fp = fopen("./etc/list.providers", "r");
  if (fp == NULL) {
	nerror("ip.c", 41, "ip_menue", "Can't read", "./etc/list.providers" );
  }

  i = 0;
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));
  while((i < MAX_ENTRY) && 
	(fscanf(fp, "%s %d %s %s %f %s %f %f %s %f %s %f %f", 
		IP[i].provider, 
		&IP[i].level,
		IP[i].time,
		IP[i].DTR,
		&IP[i].mind,
		IP[i].NTR,
		&IP[i].minn,
		&IP[i].rate,
		IP[i].IDR,
		&IP[i].IPD,
		IP[i].INR,
		&IP[i].IPN,
		&IP[i].RABT ) > 0)){
	
        ok = ip_intime( IP[i].time );	
        
  	strcpy(s, (UNSIGNED char *) mydate( 3 ));
	if(s[0] != '\0') ok = 1;			/* Sunday | Saturday */ 
 
	if((IP[i].level <= USER.level) && (ok == 1)) {
		printf("  %d - %-10.10s  %5.5sh   %5.02f DM  (%.0f/%.0f Min.)\n\n", i+1, 
			IP[i].provider, IP[i].time, 
			IP[i].rate, IP[i].mind, IP[i].minn); 
		i++;
	}
	else{
	 	 printf("  ? - %-10.10s  %5.5sh   %5.02f DM  (%.0f/%.0f Min.) (gesperrt) \n\n", 
			IP[i].provider, IP[i].time,
			IP[i].rate, IP[i].mind, IP[i].minn);
	}
  }
  fclose(fp);

  printf("\n"); 
  ansi2( "md", 0, 0 );
  printf("  0 - Informationen zum Thema \"INTERNET in Wuppertal und Umgebung\"\n\n"); 
  ansi2( "me", 0, 0 );
  printf("  X - ENDE (Internet Gateway verlassen)\n");

  if(USER.terminal != ISO6429)
	ansi2("md", 0, 0);
  else
	ansi2("X9", 0, 0);
  printf("\n%s >", "Welcher Anbieter soll's denn sein?");
  ansi2("me", 0, 0);
  printf(" ");

  if(arg[0] == '\0')
	c = getint();
  else
	c = atoi(arg) + 48;
  if(c > 32) printf("%c", c);
  c -= 49;

  if(c == -1){
	headline( " Internet Zugang " );
	printf("\n");

	show( "./etc/info.4", 9999, USER.more + 100 );

	more();
	goto REDO;
  }
 
  if((c > (i - 1)) || (c < 0)){
	printf(" <- Na dann nicht ...\n\n");
	return;
  }
  IPP = c;
  strcpy(provider, (UNSIGNED char *) IP[IPP].provider);


/*
  sprintf(s, " Internet Verbindung zu [%s] ", provider );
  headline( s );
  printf("\n");

  fp = fopen("./etc/list.internet", "r");
  if (fp == NULL) {
	nerror("ip.c", 41, "ip_menue", "Can't read", "./etc/list.internet" );
  }
  i = 0;
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));
  while((i < MAX_ENTRY) && (fgets(t, STRING, fp) != 0)){
	strcpy(s, (UNSIGNED char *) strcopy(t, 24, 80));
	strcpy(ENTRY[i], (UNSIGNED char *) stripped(s));
	sscanf(t, "%s %d", s, &lev);
	if(lev <= USER.level){
		strcpy(SERVICE[i], (UNSIGNED char *) stripped( s ));
		printf("  %d - %s\n\n", i + 1, SERVICE[i]); 
		i++;
	}
  }
  fclose(fp);

  ansi2("md", 0, 0);
  printf("\n%s > ", "Welcher Service?");
  ansi2("me", 0, 0);

  c = getint();
  if(c > 32) printf("%c", c);
  c -= 49;

  if((c > (i - 1)) || (c < 0)){
	printf(" <- Na dann nicht ...\n\n");
	return;
  }
*/
  c = 0;
  strcpy(SERVICE[c], (UNSIGNED char *) "DIP");


  strcpy(md, (UNSIGNED char *) mydate( 3 ));

  if((ip_intime( IP[IPP].DTR )) && (md[0] == '\0')){ 
        UNITtime = IP[IPP].mind;
	UNITprice = IP[IPP].rate;
  }
  else{
	UNITtime = IP[IPP].minn;
	UNITprice = IP[IPP].rate;
  }

  UNITdiscount = ((long) IP[IPP].RABT);
  UNITdispo = ACCT.seg_free;

  unsqueeze_account( USER.account );

  
  if(ip_intime( HAPPYHOUR ) == 0){
  	if((ACCT.kto - (long) (UNITprice * 100)) < UNITdispo){
		ansi2( "md", 0, 0 );
		printf("\n\nIhr Konto ist absolut leer (%.02f DM)! Setzen Sie sich mit dem Sysop in\n", ((float) ACCT.kto/100));
		printf("Verbindung und fuellen Sie das Konto auf ...\n\n");
		ansi2( "me", 0, 0 );
		return;
  	}
  }	

  sprintf(s, " Internet Zugang [%s %s] ", SERVICE[c], provider );
  headline( s );
  printf("\n");

  printf("ACHTUNG: Das LOKALE Verzeichnis darf NICHT verlassen werden!\n");
  printf("         D.h. der FTP-Befehl \"lcd\" darf nicht verwendet werden!\n");
  printf("         Nach \"lcd\" koennen per FTP uebertragene Dateien nicht\n");
  printf("         mehr zum Download angeboten werden!!!\n\n");

  strcpy(starttime, (UNSIGNED char *) mytime( 0 ));
  start_segs = ip_segments( provider );
  ip_log( SERVICE[c], provider, 0L, 0, "TTC" );

  switch( (fpid = fork()) ){
	case -1 : 	break;

	case  0 :
			time(&ts);
			ipaudit( SERVICE[c], provider );			
			time(&tn);
			chdir( HOME );
			segs = (ip_segments( provider )) - start_segs;
			segs = (segs * 512) / 1024;
			kill( 0, SIGHUP );	
			break;
  }

  IP_CAUSED_HUP = getpid();

  sprintf(s, "%s/ip_incoming.%d", IPINCOMING, getpid());
  umask(0000);
  mkdir( s, 0777 );
  chdir( s );
  umask(0007);

  time(&ts);

  noctrlx();

  /*
  sprintf(ex, "/bin/sh %s/etc/ipscript.%s \"%s\" %s %d", 
	HOME, provider, ENTRY[c], provider, getpid());
  system( ex );
  */
  
  sprintf(ex, "/bin/sh %s/etc/ipscript.%s \"%s\" %s %d", 
	HOME, provider, "Dummy", provider, getpid());
  sprintf(xx, "%s/%s %s %d %d", HOME, RSH, ex, OLDUID, OLDGID);
  system(xx);
  
  ctrlx();

  
  time(&tn);

  kill(fpid, SIGKILL);
  (void) wait( &fpid );

  IP_CAUSED_HUP = 0;
 
 
  chdir( HOME ); 

  segs = (ip_segments( provider )) - start_segs;
  segs = (segs * 512) / 1024;
  
  system( "/bin/sh ./etc/ipscript.Cleanup" );


  ip_log( SERVICE[c], provider, (tn - ts), segs, "DIS" );

  sprintf(v, "/tmp/%d.dirlist", getpid());
#ifndef _SCO
  sprintf(s, "ls -w1 %s/ip_incoming.%d > %s", IPINCOMING, getpid(), v);
#else
  sprintf(s, "ls -1 %s/ip_incoming.%d > %s", IPINCOMING, getpid(), v);
#endif
  system( s );

  ok = 0;

  ff = fopen( v, "r" );
  if(ff != 0){
	while(fgets(t, STRING, ff) != 0){
		
		ok++;	

 		sprintf(s, "%s/usr/%c/%d/.lastletter", HOME, USER.name[0], USER.id);
 		fp = fopen(s, "w");
 		fprintf(fp, "BINFILE\n");
 		fprintf(fp, "%s/ip_incoming.%d/%s\n", IPINCOMING, getpid(), t);
 		fclose(fp);

 		sprintf(s, "%s/usr/%c/%d/.lastsubject", HOME, USER.name[0], USER.id);
 		fp = fopen( s, "w" );
 		fprintf(fp, "FTP %s", (UNSIGNED char *) stripped(t));
 		fclose(fp);

 		IS_BUFFERED = 1;

 		sprintf(s, "%s$", USER.name);
 		brief( s );
	
 		IS_BUFFERED = 0;
	}
	fclose(ff);

	unlink( v );
  }
 
  if(ok == 0){
	sprintf(s, "%s/ip_incoming.%d", IPINCOMING, getpid());
	rmdir( s );
  }

  ip_calc( (tn - ts), segs );

  sprintf(s, "%s/rollback.%d", TMP, USER.id);
  unlink( s );

  printf("\n");
}




long handle_kto( text, data, mode) 
UNSIGNED char text[];
long data;
char mode;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int i, l;
  float pf;


  sprintf(t, "%s ", (UNSIGNED char *) text);
  l = strlen( t );

  for(i = l; i < 31; i++) strcat(t, ".");

  pf = (float) data;
  pf /= 100;

  sprintf(s, "%8.02f", (float) pf);
  printf("%s %s DM", t, s);

  if(mode == 'C'){ 
	printf("%c%s ", CR, t);
        strcpy(t, (UNSIGNED char *) getline( 8, 1101, ' ', s ));
	data = (long) aftol( t );
  }

  printf("\n");

  return (long) data;
}



void show_ip_log();


/* #KO - set/show users "bank" account (bbs, ip, outial, etc.)  */

void konto( arg )
UNSIGNED char arg[];
{
  int fd;
  struct userdaten DUMMY, LOOSER;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char ex[LONGSTRING];

  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  int uid = -1;
  char mode = 'A';
  int changed = 0; 
  int i = 0;
 
  FILE *fp;

  long mti = 0L, mto = 0L, mf = 0L, dl = 0L, nt = 0L, dc = 0L;

 
  sprintf(s, " Kontoauszug [%s] ", arg);
  headline( s );

  printf("\n  1 - IP-Logfile ausgeben\n");
  printf("\n  2 - Kontostand anzeigen\n"); 

  if(USER.level >= ADMIN_LEV)
	printf("\n  3 - Kontostand aendern\n");

  ansi2( "md", 0, 0 );  
  printf("\n[Konto] Nun? > ");
  ansi2( "me", 0, 0 );

  if(USER.level >= ADMIN_LEV){
	do{
		mode = getch();
	}while((mode < '1') || (mode > '3')); 

	if(mode == '2') mode = 'A';
	if(mode == '3'){
		mode = 'C';
		changed++;
	}
  }
  else{
	do{
		mode = getch();
	}while((mode < '1') || (mode > '2')); 

	if(mode == '2') mode = 'A';
  }

  fd = open(UDBASE, O_RDONLY);
  if(fd == -1){
	nerror("admin.c", 324, "aendern", "Can't read", UDBASE);
  }
  while(read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy){
	if(uid == DUMMY.id){
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	}
	else{
		if((strcomp(arg, DUMMY.name) == 0) ||
		   (strcomp(arg, DUMMY.nick) == 0) ||
		   (strcomp(arg, DUMMY.sh_name) == 0)){
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
		}
	}
  }
  lseek(fd, ll, SEEK_SET);
  read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if(ll == -1L) return;

  if(USER.id == LOOSER.id) LOOSER = USER; /* User himself ... */

  if(mode == '1'){
	show_ip_log( LOOSER.name, LOOSER.id );
	return;
  }


  unsqueeze_account( LOOSER.account );

  RESHOW: 

  sprintf(s, " Kontoauszug [%s] ", LOOSER.name);
  headline( s );
  printf("\n");

  ACCT.kto         = handle_kto( "Kontostand", ACCT.kto, mode);
  if(USER.level >= ADMIN_LEV)
	ACCT.seg_free    = handle_kto( "Dispo (Kredit/negative Zahl)", ACCT.seg_free, mode);
  ACCT.seg_day     = handle_kto( "IP Segmente (Tag)", ACCT.seg_day, mode);
  ACCT.seg_night   = handle_kto( "IP Segmente (Nacht)", ACCT.seg_night, mode);
  printf("===========================================\n");
  ACCT.fon_day     = handle_kto( "Telefon (Normaltarif)", ACCT.fon_day, mode);
  ACCT.fon_night   = handle_kto( "Telefon (Billigtarif)", ACCT.fon_night, mode);


  strcpy(LOOSER.account, (UNSIGNED char *) squeeze_account()); 

  if(mode == 'C'){
	mode = 'A';
	goto RESHOW;
  }

  if(LOOSER.id != USER.id){
	maybe_locked(UDBASE, "r"); mblock(UDBASE);
	fd = open(UDBASE, O_WRONLY);
	if (fd == -1) {
		nerror("ip.c", 428, "konto", "Can't write to", UDBASE);
	}
	if (lseek(fd, ll, SEEK_SET) == -1) {
	nerror("ip.c", 431, "konto", "Position not found in", UDBASE);
	}
	write(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER));
	close(fd);
	mbunlock(UDBASE);
	if(changed != 0)
		ip_private_log( "", "", (float) 0, ((float) ACCT.kto/100), LOOSER.name, LOOSER.id, 'A' );
	adm_updated( LOOSER.id );
  }
  else{
	strcpy(USER.account, (UNSIGNED char *) LOOSER.account);
	if(changed != 0)
		ip_private_log( "", "", (float) 0, ((float) ACCT.kto/100), USER.name, USER.id, 'A' );
  }

  strcpy(t, (UNSIGNED char *) strcopy( mydate( 1 ), 3, 7) );
 
  fp = fopen( "./etc/log.charge", "r" );
  if(fp == NULL){
	nerror("ip.c", 431, "konto", "Can't open", "./etc/log.charge");
  }
  while(fgets(ex, LONGSTRING, fp) != 0){
	strcpy(s, (UNSIGNED char *) strcopy( ex, 3, 7) );
	if(strcomp(s, t) == 0){
		i = atoi( strcopy( ex, 16, 21 ) );
		if(i == LOOSER.id){
			ll = atol( strcopy( ex, 22, 31 ) );
			if(sgrep(ex, "Mail To:")     != 0){
				if((isin(ex, '!') > 0) || (isin(ex, '@') > 0))
					mto += ll;
				else 
					mti += ll;
			}
			if(sgrep(ex, "Mail From:")   != 0) mf += ll;
			if(sgrep(ex, "News To:")     != 0) nt += ll;
			if(sgrep(ex, "CD-Download:") != 0){
				dc += ll;
			}
			else{
				 if(sgrep(ex, "Download:")    != 0) dl += ll;
			}
		}
	}
  }
  fclose(fp);

  printf("\n\n");
  printf("%s ...", LOP29_MSG);

  sprintf(s, "./tmp/wc.%d", getpid());
  sprintf(t, "wc -c %s/usr/%c/%d/* | tail -1 > %s", HOME, LOOSER.name[0], LOOSER.id, s); 
  system( t );
  fp = fopen( s, "r" );
  fgets(t, STRING, fp);
  fclose(fp);
  ll = atol( t );
  unlink( s ); 

  printf("%c", CR);
  printf("Mail verschickt (intern) ..... %9.2f kB\n", (float) mti/1024);
  printf("Mail verschickt (extern) ..... %9.2f kB\n", (float) mto/1024);
  printf("Mail erhalten (extern) ....... %9.2f kB\n", (float) mf/1024);
  printf("News Artikel gesendet ........ %9.2f kB\n", (float) nt/1024);
  printf("Dateien empfangen ............ %9.2f kB\n", (float) dl/1024);
  printf("Dateien von CD geholt ........ %9.2f kB\n", (float) dc/1024);
  printf("Speicherplatz genutzt ........ %9.2f kB\n", (float) ll/1024); 
  printf("\n");
}




long getacctdata( data )
UNSIGNED char data[];
{
  unsqueeze_account( data );

  return (long) ACCT.kto;
}



void rollback()
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char service[STRING];
  UNSIGNED char provider[STRING];

  long l;
  long secs;

  FILE *fp;

  sprintf(s, "%s/rollback.%d", TMP, USER.id);

  fp = fopen( s, "r" );
  if(fp != NULL){
	while(fgets(t, STRING, fp) != 0){
		strcpy(s, (UNSIGNED char *) t);
	}

	strcpy(t, (UNSIGNED char *) stripped(strcopy(s, 17, 22)));
	secs = atol( t );

	strcpy(starttime, (UNSIGNED char *) strcopy(s, 0, 7));
	strcpy(stoptime,  (UNSIGNED char *) strcopy(s, 9, 16));

	strcpy(service,   (UNSIGNED char *) strcopy(s, 33, 41));
  	strcpy(provider,  (UNSIGNED char *) strcopy(s, 42, 50));

	strcpy(t, (UNSIGNED char *) stripped(strcopy(s, 51, 58)));
	UNITtime = ((float) aftol( t ) / 100);

	strcpy(t, (UNSIGNED char *) stripped(strcopy(s, 59, 67)));
 	UNITprice = ((float) aftol( t ) / 100);

	strcpy(t, (UNSIGNED char *) stripped(strcopy(s, 68, 80)));
	UNITdiscount = atol( t );

  	ip_log( service, provider, (secs - UNITdiscount), 0, "ROL" );

	strcpy(t, (UNSIGNED char *) stripped(strcopy(s, 23, 31)));
  	l = aftol( t );
  	unsqueeze_account( USER.account );
  	if(secs > UNITdiscount) ACCT.kto -= l; 
  	strcpy(USER.account, (UNSIGNED char *) squeeze_account()); 
  	unsqueeze_account( USER.account );

	fclose(fp);
	sprintf(s, "%s/rollback.%d", TMP, USER.id);
	unlink(s);	

	ansi2( "md", 0, 0 );
	printf("\n\nACHTUNG: Gebuehren aus einer bisher nicht abgerechneten IP-Verbindung\n");
	printf("wurden entdeckt und von Ihrem Konto abgebucht!\n\n");
	printf("Ihr aktueller Kontostand: %.02f DM\n\n", ((float) ACCT.kto/100));
	ansi2( "me", 0, 0 );
  }
}


void show_ip_log( usern, userid )
UNSIGNED char usern[];
int userid;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char tmp[STRING];

  FILE *fp;
  FILE *ff;

  sprintf(tmp, "%s/show_ip.%d", TMP, getpid());

  sprintf(s, "%s/usr/%c/%d/.ip", HOME, usern[0], userid);

#ifndef _SCO
  sprintf(t, "tac %s > %s", s, tmp);
#else
  sprintf(t, "sort -dr %s > %s", s, tmp);
#endif
  system( t );

  headblock( "Kontoauszug", "Datum    Zeit(-Raum)       Service Host    Kosten   Konto    Meldungen" );

  show(tmp, 9999, USER.more); 
  unlink(tmp);
}
