/* ix/MBox (admin.c) by Volker Schuermann, 09.10.1995

   This C source code contains the following functions:

   #IN intro()             show intros, handle login
   #IU init_user()         activate users preferences

   Contact <volkers@unnet.wupper.de> for help! */









#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>

#include "mbox.h"

time_t time_start, time_now;


void init_user();


 

/* #IN - Welcome users, show intros, handle login. */

void intro( mode )
int mode;
{
  FILE *fp;
  FILE *ff;
  int fd;
  UNSIGNED char s[LSTRING];
  UNSIGNED char t[STRING];
  UNSIGNED char f[STRING];
  UNSIGNED char tmp[STRING];
  UNSIGNED char crypt_pw[STRING];
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char tmpuser[STRING];
  UNSIGNED char moreLASTLOG[STRING];
  
  UNSIGNED char *term;  
  UNSIGNED char c;  

  int i, calls;
  int ok;
  int a, b;
  long ll, lalo;
  long fsa, fsb, fs1, fs2;

  struct userdaten LOOSER, OLDIE;
  struct tm *timeptr;
  struct stat fst;


  umask(0007);

  if(mode == 0){ 	/* DO NOT EXECUTE ON RELOGIN ! */		
 	time(&time_start);
	term = (UNSIGNED char *) malloc( (size_t) STRING);
	term = (UNSIGNED char *) getenv("TERM");
	strcpy(TERMINAL, (UNSIGNED char *) term);
  }

  MENUE_USING = 0;
  MENUE_STAGE = 0;
  fido_fast = 0;

  if(ansi2("INIT", 0, 0) == -1){
	printf("\n\n%c%s [%s] %s\n\n", 7, INT40_MSG, TERMINAL, INT41_MSG);
  }
  ansi2("me", 0, 0 );


#ifdef _SIGHUPBUG
	sprintf(s, "/bin/sh %s/contrib/sighup.bug", HOME );
	system( s );
#endif

  fp = fopen( LOGO, "r" );
  if(fp != NULL){
	fclose(fp);
	printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
	ansi2("cl", 0, 0);
	ansi2("md", 0, 0);
	show( LOGO, 9999, 0 );
	ansi2("me", 0, 0);
	c = getint();	
  }

  printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
  ansi2("cl", 0, 0);

  ansi2("mr", 0, 0);
  printf("\n%s", INT01_MSG);
  ansi2("me", 0, 0);
  printf(" %s", ORGANIZATION);
	
  ansi2("mr", 0, 0);
  printf("\n%s", INT02_MSG);
  ansi2("me", 0, 0);
  printf(" %s %s %s", VERSION, PATCHLEVEL, AUTOR);

  ansi2("mr", 0, 0);
  printf("\n%s", INT03_MSG);
  ansi2("me", 0, 0);
  printf(" %s", SYSTEM);

  BAUDRATE = (int) 0;



  fp = fopen( TERMIS, "r" );
  if(fp == NULL){
	nerror("intro.c", 158, "intro", "Can't read", TERMIS);
  }
  while((fgets(s, STRING, fp) != 0) && (s[0] != '='));

  fgets(s, STRING, fp); sscanf(s, "%s", TECA[1].entry);
  strcpy(TECA[1].name, (UNSIGNED char *) upcased( TECA[1].entry));
  strcpy(TECA[1].desc, (UNSIGNED char *) stripped( strcopy( s, strlen(TECA[1].entry), STRING)));
  fgets(s, STRING, fp); sscanf(s, "%s", TECA[2].entry);
  strcpy(TECA[2].name, (UNSIGNED char *) upcased( TECA[2].entry));
  strcpy(TECA[2].desc, (UNSIGNED char *) stripped( strcopy( s, strlen(TECA[2].entry), STRING)));
  fgets(s, STRING, fp); sscanf(s, "%s", TECA[3].entry);
  strcpy(TECA[3].name, (UNSIGNED char *) upcased( TECA[3].entry));
  strcpy(TECA[3].desc, (UNSIGNED char *) stripped( strcopy( s, strlen(TECA[3].entry), STRING)));
  fclose(fp);
  
  OLDIE = USER; 
  USER.id = -1;  

  if ((OLDGID == GUEST_GID) || (mode == 1) || (strcomp(MYNAME, "Juhi Chawla") != 0)) {	/* GUESTS / GAESTE */

        TRY_AGAIN:

	if((strcomp(MYNAME, "Juhi Chawla") == 0) || (strcomp(MYNAME, GUEST) == 0)){
		printf("\n\n%s .............................. %s", GBL04_MSG, INT03aMSG);
		a = 31 + strlen(INT03aMSG);
		for (i = 0; i < a; i++) printf("%c", BS);
		strcpy(LOOSER.name, (UNSIGNED char *) getline(30, 11, '.', ""));
		if (LOOSER.name[0] == '\0') goto TRY_AGAIN;
	}
	else{
		printf("\n\n%s ....................", GBL04_MSG);
		for (i = 0; i < 20; i++) printf("%c", BS);
		printf("%s", MYNAME);
		strcpy(LOOSER.name, (UNSIGNED char *) MYNAME);
	}	

	strcpy(s, (UNSIGNED char *) upcased(LOOSER.name));

	if (strcomp(GUEST, s) != 0) {

		printf("\n%s ", GBL09_MSG);
		strcpy(LOOSER.passwort, (UNSIGNED char *) getline(10, 12, '.', ""));
		strcpy(crypt_pw, (UNSIGNED char *) crypted(LOOSER.passwort));
		
  		sprintf(s, "[LOGIN] %s (%s)", LOOSER.name, crypt_pw);
  		control(s, 3);

		maybe_locked(UDBASE, "r"); mblock(UDBASE);
		fd = open(UDBASE, O_RDONLY);
		if (fd == -1) {
			nerror("intro.c", 78, "intro", "Can't read", UDBASE);
		}
		ok = 0;
		while ((ok == 0) && (read(fd, (UNSIGNED char *) &USER, sizeof(USER)) == sizeof(USER))) {
			if ((strcomp(LOOSER.name, USER.name) == 0) ||
			    (strcomp(LOOSER.name, USER.nick) == 0)) {
				ok = -1;
				if ((strcomp(USER.passwort, (UNSIGNED char *) crypt_pw) == 0) ||
			    	    (strcomp(USER.passwort, LOOSER.passwort) == 0))
					ok = 1;
			}
		}
		close(fd);
		mbunlock(UDBASE);

		if (ok == 1) goto WELL_DONE;
		strcpy(MYNAME, (UNSIGNED char *) "Juhi Chawla");
		USER = OLDIE;
		goto TRY_AGAIN;
	}
	strcpy(LOOSER.name, (UNSIGNED char *) upcased(s));

	maybe_locked(UDBASE, "r"); mblock(UDBASE);
	fd = open(UDBASE, O_RDONLY);
	if (fd == -1) {
		nerror("intro.c", 98, "intro", "Can't read", UDBASE);
	}
	ok = 0;
	while ((ok == 0) && (read(fd, (UNSIGNED char *) &USER, sizeof(USER)) == sizeof(USER))) {
		if (strcomp(LOOSER.name, USER.name) == 0) ok = 1;
	}
	close(fd);
	mbunlock(UDBASE);

	if(ok != 1){
  		sprintf(s, "[LOGIN] FAILED! %s <> %s", LOOSER.name, USER.name);
  		control(s, 3);
		strcpy(MYNAME, (UNSIGNED char *) GUEST);
		goto TRY_AGAIN;
	}

	ansi2("md", 0, 0);
	printf("\n\n%s\n\n", INT04_MSG);
	ansi2("me", 0, 0);
	printf("%s\n\n", INT05_MSG);
	printf("%-15.15s  6 - %-12.12s  7 - %-12.12s  8 - %-12.12s\n",
 		INT05aMSG, TECA[1].name, TECA[2].name, TECA[3].name);

	ansi2("md", 0, 0);
	printf("\n%s > ", INT06_MSG);
	ansi2("me", 0, 0);
	printf("5%c", BS);

	do {
		c = getint();
		if((c == LF) || (c == CR)) c = '5';
	} while ((c < '1') || (c > '8'));
	printf("%c", c);
	USER.terminal = c - 48;

#ifdef GERMAN_VERSION
	ansi2("md", 0, 0);
	printf("\n\nWelche der folgenden Umlaut-Darstellungen ist korrekt?\n\n");
	ansi2("me", 0, 0);

	printf("1 - [%c] [%c] [%c] [%c] [%c] [%c] [%c]  ISO-8859-1 / UNIX / LINUX / AMIGA\n\n",
		196, 214, 220, 228, 246, 252, 223);
	printf("2 - [%c] [%c] [%c] [%c] [%c] [%c] [%c]  IBM / ATARI\n\n",
		142, 153, 154, 132, 148, 129, 225);

	printf("3 - [Ae] [Oe] [Ue] [ae] [oe] [ue] [ss]\n");

	ansi2("md", 0, 0);
	printf("\n%s > ", "Und?");
	ansi2("me", 0, 0);
	printf("2%c", BS);

	do {
		c = getint();
		if((c == LF) || (c == CR)) c = '2';
	} while ((c < '1') || (c > '3'));
	printf("%c", c);
	USER.schluessel[2] = c - 48;

#else
	USER.schluessel[2] = 4;
#endif

	ansi2( "md", 0, 0 );
	printf("\n\n%s\n\n", INT36_MSG);
	ansi2( "me", 0, 0 );

	printf("1 - %s\n\n", INT37_MSG);
	printf("2 - %s\n\n", INT38_MSG);

	ansi2( "md", 0, 0 );
	printf("%s > ", INT39_MSG );
	ansi2( "me", 0, 0 );

	printf("1%c", BS);

	do {
		c = getint();
		if((c == LF) || (c == CR)) c = '1';
	} while ((c < '1') || (c > '2'));
	printf("%c", c);

	if(c == '1'){
		MENUE_USING = 0;
	}
	else{
		MENUE_USING = 1;
	}

	strcpy(USER.name, (UNSIGNED char *) GUEST);
	sprintf(USER.passwort, "%s", "*****");

	USER.level	   =   0;
	USER.prompt        =   2;
	USER.bell          =   0;
	USER.intro         =   1;
	USER.more          =   3;
	USER.lastmode      =   2;
	USER.leserichtung  =   2;
	USER.tlines        =  22;
	USER.schluessel[0] =   1;
	USER.schluessel[1] =   3;
	USER.schluessel[3] = 128;
	USER.schluessel[4] = 123;

	if(USER.terminal < 2) 
			USER.editor = 1;
	else
			USER.editor = 2;

	strcpy(USER.account, "00.00.000000000000000000000000000000000000000000000000000000000000000");

	sprintf(USER.newsgrps, "%s", NEWS_MINIMUM);

	LASTLOG = (long) 19700101;
	LASTTIME = 0;
	sprintf(moreLASTLOG, "%s", "01.01.1970");
  }
  else {			/* USER */

	printf("\n\n%s ....................", GBL04_MSG);
	for (i = 0; i < 20; i++) printf("%c", BS);

	strcpy(tmpuser, (UNSIGNED char *) whoami());
	printf("%s", tmpuser);

	printf("\n%s ..........", GBL09_MSG);

	for (i = 0; i < 10; i++) printf("%c", BS);
	for (i = 0; i < 10; i++) printf("*");

	if (strcomp(tmpuser, "root") == 0) {
		strcpy(tmpuser, (UNSIGNED char *) POSTMASTER);

		strcpy(s, (UNSIGNED char *) ttyname(0));
		if((strlen(PMS_TTY) > 3) && (strcomp(PMS_TTY, s) != 0)){
			printf("\n\n");
			ansi2("mr", 0, 0);
			printf("%s \"%s\" %s", INT07_MSG, PMS_TTY, INT07aMSG);
			ansi2("me", 0, 0);
			printf("\n\n");
			exit(-1);
		}
		else {
			USER.level = 10;
		}
	}
	maybe_locked(UDBASE, "r"); mblock(UDBASE);
	fd = open(UDBASE, O_RDONLY);
	if (fd == -1) {
		nerror("intro.c", 156, "intro", "Can't read", UDBASE);
	}
	ok = 0;
	while ((ok == 0) && (read(fd, (UNSIGNED char *) &USER, sizeof(USER)) == sizeof(USER))) {
		if ((strcomp(tmpuser, USER.sh_name) == 0)) ok = 1;
	}
	close(fd);
	mbunlock(UDBASE);

	if (ok == 0) {
		USER.level = 0;
		postfach(tmpuser);
	}
  }

  WELL_DONE: avoid_struggles = USER.id;


  fp = fopen( STTOUT, "r" );
  if(fp == NULL){
	nerror("intro.c", 299, "intro", "Can't read", STTOUT);
  }
  while((fgets(s, STRING, fp) != 0) && (s[0] != '='));
  while(fgets(s, STRING, fp) != 0){
	sscanf(s, "%d %d %d", &i, &a, &b);
	if(i <= USER.level){
		TOUT_TIME = a;
		TOUT_CALLS = b;
	}
  }
  fclose(fp);

  if(TOUT_TIME < 60){
	TOUT_TIME = 3600;
	nerror("intro.c", 313, "intro", "Timeout misdefined", STTOUT);
  }
  if(TOUT_CALLS < 1){
	TOUT_CALLS = 1;  
	nerror("intro.c", 317, "intro", "Number of calls misdefined", STTOUT);
  }

  sprintf(s, "%s/timeouts.cat", "./etc");
  fp = fopen( s, "r" );
  if(fp != NULL){
	fgets(s, STRING, fp);
	strcpy(t, (UNSIGNED char *) mydate( 1 ));
	if(strcomp(t, s) != 0){
		fclose(fp);
  		sprintf(s, "%s/timeouts.cat", "./etc");
		fp = fopen( s, "w" );
		fprintf(fp, "%s\n%d\n", (UNSIGNED char *) mydate( 1 ), USER.id);
		fclose(fp);
	}
	else{
		i = 0;
		while(fgets(s, STRING, fp) != 0){
			if(atoi(s) == USER.id) i++;
		}
		fclose(fp);
  		sprintf(s, "%s/timeouts.cat", "./etc");
		fp = fopen(s, "a");
		fprintf(fp, "%d\n", USER.id);
		fclose(fp);

		if(i > TOUT_CALLS){
			printf("\n\n");
			ansi2( "md", 0, 0 );
			show(THROWN_OUT, 9999, 0);
			ansi2( "me", 0, 0 );
			logout();
			printf("\n\n");
			exit(0);
		}
	}
  }
  else{
	fp = fopen( s, "w" );
	fprintf(fp, "%s\n%d\n", (UNSIGNED char *) mydate( 1 ), USER.id);
	fclose(fp);
  }

  printf("\n\n%s ...", INT09aMSG);

  setuid( ROOT_UID );
  setgid( ROOT_GID ); 

  if(USER.name[0] > 96) USER.name[0] -= 32;

  if (strcomp(GUEST, USER.name) != 0) {
	LASTLOG = (long) dateconv(USER.lastlog);
	LASTTIME = USER.lasttime;
	sprintf(moreLASTLOG, "%s", USER.lastlog);
  }
  if (USER.lastmode == 2) LASTTIME = 0;

  sprintf(s, "%s/usr/%c/%d/.dummy", HOME, USER.name[0], USER.id); /* New User-Directory !!! */
  fp = fopen( s, "w" );
  if(fp == NULL){
	sprintf(s, "%s/usr/%c", HOME, USER.name[0]);
#ifndef _LINUX
	mkdir( s );
	chmod( s, 0777 );
#else
	mkdir( s, 0777 );
#endif
	sprintf(s, "%s/usr/%c/%d", HOME, USER.name[0], USER.id);
#ifndef _LINUX
	mkdir( s );
	chmod(s , 0777 );
#else
	mkdir(s, 0777 );
#endif
	sprintf(s, "cp %s/usr/%d/.* %s/usr/%c/%d > /dev/null 2>&1", HOME, USER.id, HOME, USER.name[0], USER.id);
	system( s );
	sprintf(s, "cp %s/usr/%d/* %s/usr/%c/%d > /dev/null 2>&1", HOME, USER.id, HOME, USER.name[0], USER.id);
	system( s );
	sprintf(s, "rm -r %s/usr/%d", HOME, USER.id);
	system( s );
  }
  else{
	unlink(s);
	fclose(fp);  
  }

  sprintf(s, "%s \"%s\" (%d) %s", INT08_MSG, USER.name, USER.id, INT09_MSG);
  control(s, 3);
  whodo( INT10_MSG );

  /* 
  if ((USER.level < 10) && (strcomp(MYNAME, USER.name) != 0)) {
  */
  if (USER.level < 10) {

	maybe_locked(SEQ, "r"); mblock(SEQ);
	fp = fopen(SEQ, "r");
	if (fp == NULL) {
		nerror("intro.c", 223, "intro", "Can't read", SEQ);
	}
	fscanf(fp, "%d", &calls);
	fclose(fp);
	calls++;

	fp = fopen(SEQ, "w");
	if (fp == NULL) {
		nerror("intro.c", 227, "intro", "Can't write to", SEQ);
	}
	fprintf(fp, "%d\n", calls);
	fclose(fp);
	mbunlock(SEQ);

	sprintf(tmp, "%s/%dT", TMP, getpid());

	fp = fopen(tmp, "w");
	if (fp == NULL) {
		nerror("intro.c", 236, "intro", "Can't write to", tmp);
	}
	maybe_locked(CALLS, "r"); mblock(CALLS);
	ff = fopen(CALLS, "r");
	if (ff == NULL) {
		nerror("intro.c", 239, "intro", "Can't read", CALLS);
	}
	sprintf(s, "%s (%s)", USER.name, USER.nick);
	strcpy(t, numstripped(USER.wohnort));
	if (t[0] == '\0') strcpy(t, (UNSIGNED char *) "   ");
	strcpy(t, (UNSIGNED char *) stripped(t));
	if (t[0] >= 97) t[0] -= 32;

	strcpy(f, (UNSIGNED char *) ttyna());

	fprintf(fp, "%5.d  %-28.28s  %-17.17s%8.8s  %s  %s\n",
		calls, s, t, f, (UNSIGNED char *) mydate(1), (UNSIGNED char *) mytime(1));

	if(PRO_ENTRIES < 10){
		nerror("intro.c", 291, "intro", "PRO_ENTRIES must be defined bigger", "mbox.h");			
	}

	i = 1;
	while ((fgets(s, STRING, ff) != NULL) && (i <= PRO_ENTRIES)) {
		fputs(s, fp);
		i++;
	}

	fclose(fp);
	fclose(ff);

#ifdef _ALLTIME
	if(i >= PRO_ENTRIES){
		fp = fopen( ALLTIME, "a" );
		if(fp == NULL){
			nerror("intro.c", 337, "intro", "Can't append to", ALLTIME);
		}
		fputs(s, fp);
		fclose(fp);
	}
#endif

        mbrename( tmp, CALLS );
	unlink(tmp);
	mbunlock(CALLS);
  }

  sprintf(s, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);  
  if(atol(USER.abused) == 0L){
	  stat(s, &fst);
	  IDX_SIZE = (long) fst.st_size;
  }
  else IDX_SIZE = atol(USER.abused);

  stat(MB_READY, &fst);
  MBD_SIZE = (int) fst.st_size;  

  printf("%c", CR);

  init_user( INT11_MSG, 1 );


  if(USER.schluessel[3] == 128){
	show_raw( ANSI_INTRO, 10 );
  }

  sprintf(UGROUPS, "%s/usr/%c/%d/.active", HOME, USER.name[0], USER.id);

  if (USER.intro < 3) {

	a = 0;
	fp = fopen(UGROUPS, "r");
	if (fp == NULL) {
		nerror("intro.c", 283, "intro", "Can't read", AGROUPS);
	}
	while (fgets(ex, LONGSTRING, fp) != NULL) a++;
	fclose(fp);

	sprintf(s, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);  
	
	fp = fopen(s, "r");
	if (fp == NULL) {
		nerror("intro.c", 291, "intro", "Can't read", s);
	}
	b = 2; 
	fgets(ex, LONGSTRING, fp);
	fgets(ex, LONGSTRING, fp);
	while (fgets(ex, LONGSTRING, fp) != NULL){
		if((strlen(ex) > 60) && (ex[5] != '*')) b++;
	}
	fclose(fp);
	b -= 2;

	ansi2("md", 0, 0);
	printf("%s %d%s %s %s.\n", 
		INT12_MSG, USER.seq, INT13_MSG, moreLASTLOG, INT14_MSG);
	printf("%s %d %s %d %s.\n", 
		INT15_MSG, a, INT16_MSG, b, INT17_MSG);
	ansi2("me", 0, 0);
	printf("\n");
  }

  if ((USER.intro != 2) && (USER.intro != 4)){
	a = MAX_SCR_LINES;
	if (USER.schluessel[3] == 128)
		MAX_SCR_LINES -= 11;
		
	if (USER.level == GUEST_LEV) {
		sprintf(s, "./etc/guests.intro.%s", (UNSIGNED char *) LANGUAGE);
		if(show(s, 9999, USER.more) == -1) show(GUESTS_INTRO, 9999, USER.more);
		printf("\n");
		if(more() == 0){
			sprintf(s, "./etc/intro.%s", (UNSIGNED char *) LANGUAGE);
			if(show(s, 9999, USER.more) == -1) show(INTRO, 9999, USER.more);
		}	
	}
	else{
		sprintf(s, "./etc/intro.%s", (UNSIGNED char *) LANGUAGE);
		if(show(s, 9999, USER.more) == -1) show(INTRO, 9999, USER.more);
	}
	MAX_SCR_LINES = a;
  }
  
  sprintf(MYNAME, "%s", USER.name);

  sprintf(s, "%s", (UNSIGNED char *) mydate(0));
  s[6] = '\0';
  if (strcomp(s, USER.geburtsdatum) == 0) {
	ansi2("md", 0, 0);
	printf("\n\n%s\n", INT18_MSG);
	printf("%s\n\n", INT19_MSG);
	ansi2("me", 0, 0);
  }
  if (strcomp("24.12.", s) == 0) {
	ansi2("md", 0, 0);
	printf("\n\n%s\n", INT20_MSG);
	printf("%s\n\n", INT21_MSG);
	ansi2("me", 0, 0);
  }
  if (strcomp("06.12.", s) == 0) {
	ansi2("md", 0, 0);
	printf("\n\n%s\n", INT22_MSG);
	printf("\n%s\n\n", INT23_MSG);
	ansi2("me", 0, 0);
  }
  if (strcomp("01.01.", s) == 0) {
	ansi2("md", 0, 0);
	printf("\n\n%s\n", INT24_MSG);
	printf("%s\n\n", INT25_MSG);
	ansi2("me", 0, 0);
  }
  if ((calls == 1000) || (calls == 10000) || (calls == 100000)) {
	ansi2("md", 0, 0);
	printf("\n\n%s %d%s\n\n", INT26_MSG, calls, INT27_MSG);
	ansi2("me", 0, 0);
  }


  /* Strict Accounting ... decrease Level if User doesn't pay */

  strcpy(s, (UNSIGNED char *) mydate( 0 ));
  lalo = dateconv(s);  
  
  strcpy(s, (UNSIGNED char *) USER.account);
  s[10] = '\0';
  ll = dateconv(s);

  if((ll <= lalo) && (ll > 19000000L)){
	ansi2( "md", 0, 0 );
	printf("\n%s %s %s\n", INT28_MSG, s, INT29_MSG);
	ansi2( "me", 0, 0 );
	printf("%s\n", INT30_MSG);

	if(lalo > (ll + 14)){
		USER.level = PD_U_LEV;
		sprintf(USER.newsgrps, "%s", NEWS_MINIMUM);		
	}
  }

  if(USER.level >= ADMIN_LEV){
	sprintf(s, "%s/core", HOME);
	fp = fopen( s, "r" );
	if(fp != NULL){
		fclose(fp);
		stat(s, &fst);
		timeptr = localtime( &fst.st_mtime );

		printf("\n%s %02.2d.%02.2d.%04.4d %s %02.2d:%02.2d %s\n",
			INT31_MSG,
			timeptr->tm_mday, timeptr->tm_mon, 1900 + timeptr->tm_year,
			INT32_MSG,
			timeptr->tm_hour, timeptr->tm_min,
			INT33_MSG );
		unlink(s);
	}
	sprintf(s, "%s/etc/fszs", HOME);
	fp = fopen( s, "r" );
	if(fp != NULL){
		stat(CPRN, &fst);
		fsa = fst.st_size;
		stat(MBD_ERROR, &fst);
		fsb = fst.st_size;

		fgets(t, STRING, fp); fs1 = (long) atol(t);
		fgets(t, STRING, fp); fs2 = (long) atol(t);

		if(fsa != fs1){
			ansi2( "mb", 0, 0 );
			printf("\n%s \"%s\" %s\n", INT34_MSG, CPRN, INT35_MSG);
			ansi2( "me", 0, 0 );
		}

		if((fsb != fs2) && (USER.level >= (ADMIN_LEV+2))){
			ansi2( "mb", 0, 0 );
			printf("\n%s \"%s\" %s\n", INT34_MSG, MBD_ERROR, INT35_MSG);
			ansi2( "me", 0, 0 );
		}
	}
	fp = fopen( s, "w" );
	if(fp != NULL){
		fprintf(fp, "%ld\n%ld\n", fsa, fsb);
		fclose(fp);
	}
	fp = fopen( "./etc/mb-daemon.lastrun", "r" );
	if(fp == NULL){
		ansi2( "mb", 0, 0 );
		printf("\n%s\n", INT35aMSG);
		ansi2( "me", 0, 0 );
		sprintf(ex, "%s", (UNSIGNED char *) INT35aMSG);
		control(ex, 99);
	}
	else fclose( fp );
  }

  THISTIME = timeconv( (UNSIGNED char *) mytime( 0 ));

  uptodate();
 
  opinion_poll();

  rollback(); /* IP stuff ... not worth investigating ... */

  printf("%cAG90m%c     %c", ESC, CR, LF); /* Wake Up G90 Terminal Proggies */
  
}



/* #IU - Reset users data for this session. 

   [info] contains a text, which is shown during the process,
   [mode] if set to 1 will start a complete rebuild. */ 

void init_user(info, mode)
UNSIGNED char info[];
int mode;
{
  FILE *fp;
  FILE *ff;
  FILE *fl;
  int fd;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int i;
  struct userdaten DUMMY;
  int dummy = sizeof(DUMMY);
  long ll, lalo;
  int lati;
  static char *env_term;
  static char *env_nickname;
  static char *env_userhome;
  static char *env_nntpserver;
  
  printf("%s ..", info);

  TERM_RETRY:

  switch (USER.terminal) {
      case 1:	sprintf(TERMINAL, "ansi");
		break;
      case 2:	sprintf(TERMINAL, "vt100");
		break;
      case 3:	sprintf(TERMINAL, "vt52");
		break;
      case 4:	sprintf(TERMINAL, "un");
		break;
      case 5:   sprintf(TERMINAL, "ansi-color");
		break;	
      case 6:	sprintf(TERMINAL, TECA[1].entry);
		break;
      case 7: 	sprintf(TERMINAL, TECA[2].entry);
		break;
      case 8:	sprintf(TERMINAL, TECA[3].entry);
  }
  printf(".");

#ifndef _SCO
  env_term = (char *) malloc( (size_t) STRING);
  sprintf(env_term, "TERM=%s", TERMINAL);
  putenv(env_term);
  env_nickname = (char *) malloc( (size_t) STRING);
  sprintf(env_nickname, "NICKNAME=%s", USER.nick);
  putenv(env_nickname);
  env_userhome = (char *) malloc( (size_t) STRING);
  sprintf(env_userhome, "USERHOME=%s/usr/%c/%d", HOME, USER.name[0], USER.id);
  putenv(env_userhome);
  env_nntpserver = (char *) malloc( (size_t) STRING);
  sprintf(env_nntpserver, "NNTPSERVER=%s", NNTPSERVER);
  putenv(env_nntpserver); 
  free( env_term );
  free( env_nickname );
  free( env_userhome );
  free( env_nntpserver);
#endif

  sprintf(s, "[TERMINAL:] %s", TERMINAL);
  control(s, 3);

  if(ansi2("INIT", 0, 0) == -1){
	USER.terminal--;
	if(USER.terminal < 1) USER.terminal = 8;
	printf("\n\n%c%s [%s] %s", 7, INT40_MSG, TERMINAL, INT41_MSG);
	(void) getch();
	printf("\n");	
	goto TERM_RETRY;	
  }

  if(USER.level < 1){
	if(USER.editor > 2) USER.editor = 1;
  }

  fp = fopen(EDITORS, "r");
  if (fp == NULL) {
	nerror("intro.c", 487, "intro", "Can't read", EDITORS);
  }
  i = 0;
  while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));

  while (fscanf(fp, "%s %s", t, s) > 0){
	if(i == (USER.editor -1)) strcpy(EDDY, (UNSIGNED char *) s);
	i++;
  }
  fclose(fp);

  OFFERED_EDITORS = i;

  printf(".");

  if (USER.leserichtung == 0) USER.leserichtung = 2;

  USER.seq++;

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  ll = (long) -1;
  fd = open(UDBASE, O_RDWR);
  if (fd == -1) {
	nerror("intro.c", 395, "init_user", "Can't open", UDBASE);
  }
  while ((read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) && (ll == (long) -1)) {
	if (USER.id == DUMMY.id) {
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	}
  }
  if(avoid_struggles != USER.id){
	sprintf(s, "(%d %d %d)", avoid_struggles, USER.id, DUMMY.id); 
	nerror("intro.c", 829, "init_user", "Struggling with user id", s);
  }
  /*
  if((ll != (long) -1) && (strcomp(GUEST, USER.name) != 0)){
	lseek(fd, ll, SEEK_SET);
	write(fd, (UNSIGNED char *) &USER, sizeof(USER));
  }
  */
  if((ll != (long) -1) && (USER.level != 0)){
	lseek(fd, ll, SEEK_SET);
	write(fd, (UNSIGNED char *) &USER, sizeof(USER));
  }
  close(fd);
  mbunlock(UDBASE);

  printf(".");

  if (USER.newsgrps[0] == '\0') sprintf(USER.newsgrps, "%s", NEWS_MINIMUM);

  if (strcomp("selected", USER.newsgrps) == 0){

	i = 1;
	
	fp = fopen( SELECTED, "r" );
	if(fp == NULL){
		nerror("intro.c", 675, "init_user", "Can't open", SELECTED);
	} 	
	while((fgets(s, STRING, fp) != 0) && (i < MAX_NEWSGRPS)){
		if((s[0] != '#') && (strlen(s) > 2)){
			strcpy(newsgrp[i], (UNSIGNED char *) stripped(s));
			i++;
		}
	}
	fclose(fp);	
  }
  else{
	sscanf(USER.newsgrps, "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s",
		newsgrp[1], newsgrp[2], newsgrp[3], newsgrp[4], newsgrp[5],
		newsgrp[6], newsgrp[7], newsgrp[8], newsgrp[9], newsgrp[10],
		newsgrp[11], newsgrp[12], newsgrp[13], newsgrp[14], newsgrp[15]);
  }

  if (mode == 1) { 

	sprintf(UGROUPS, "%s/usr/%c/%d/.active", HOME, USER.name[0], USER.id);
	sprintf(SGROUPS, "%s/usr/%c/%d/.active.all", HOME, USER.name[0], USER.id);
	sprintf(MAKRO, "%s/usr/%c/%d/.makro", HOME, USER.name[0], USER.id);

	maybe_locked( AGROUPS, "r" );
	fp = fopen(AGROUPS, "r");
	if (fp == NULL) {
		nerror("intro.c", 412, "intro", "Can't read", AGROUPS);
	}
	ff = fopen(UGROUPS, "w");
	if (ff == NULL) {
		nerror("intro.c", 442, "intro", "Can't write", UGROUPS);
	}
	fl = fopen(SGROUPS, "w");
	if (fl == NULL) {
		nerror("intro.c", 545, "intro", "Can't write", SGROUPS);
	}

	i = 0;

	while (fscanf(fp, "%s %ld %d", s, &lalo, &lati) > 0) {
		if ((is_subscribed(s) == 1) && (chk_newsgrp(s) == 0)) {
			sprintf(t, "%s 00000 00000 y\n", s);
			if (LASTLOG < lalo) {
				fputs(t, ff);
			}
			if (LASTLOG == lalo) {
				if (LASTTIME <= lati) fputs(t, ff);
			}
			fputs(t, fl);
		}
		i++;
		if (!(i % 30)) printf(".");
	  }
	  fclose(fl);
	  fclose(ff);
	  fclose(fp);

	  printf(".");

  }

  strcpy(BRETT, "PM");
  sprintf(NG, "%s.PM", USER.name);
  sprintf(INHALT, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);


#ifdef _BOTTOMLINE
  MAX_SCR_LINES = USER.tlines - 2;
#else  
  MAX_SCR_LINES = USER.tlines;
#endif

  if(USER.schluessel[0] == 32)
	SHORT_HEADER = 1;
  else
	SHORT_HEADER = 0;

  if(USER.schluessel[1] == 0)
	USER.schluessel[1] = 4;

  if(USER.level >= WRITE_INTERNAT){
	strcpy(UUCPID, UUCPID2);
  }
  else{
	strcpy(UUCPID, UUCPID1);
  }

  if((USER.schluessel[2] != 1) && (USER.schluessel[2] != 2) && (USER.schluessel[2] != 4))
	USER.schluessel[2] = 3;

  UMLAUT_MODUS = USER.schluessel[2];

  if(USER.account[0] == '\0') strcpy(USER.account, "00.00.000000000000000000000000000000000000000000000000000000000000000");
  if(USER.name[0] >= 'a') USER.name[0] -= 32;

  if((USER.schluessel[3] != 128) && (USER.schluessel[3] != 96)){
	if(USER.schluessel[2] == INTEL_INSIDE)
		USER.schluessel[3] = 128;
	else
		USER.schluessel[3] = 96;
  }

  if(UMLAUT_MODUS != INTEL_INSIDE){
	USER.schluessel[3] = 96;
  }

  if(USER.schluessel[3] == 128)
	sprintf(s, "[GRAPHICS:] %s", "yes");
  else
	sprintf(s, "[GRAPHICS:] %s", "no");
  control(s, 3);


  if(MENUE_USING == 0)
	sprintf(s, "[FIDOMENU:] %s", "nope");
  else
	sprintf(s, "[FIDOMENU:] %s", "yep");
  control(s, 3);

  USE_AREAS = 0; if(USER.schluessel[4] != 123) USE_AREAS = 1;

  if(USE_AREAS == 0)
	sprintf(s, "[AREA_USE:] %s", "never");
  else
	sprintf(s, "[AREA_USE:] %s", "sure");
  control(s, 3);


  printf("%c", CR);
  sprintf(s, "%s/usr/%c/%d/.download", HOME, USER.name[0], USER.id);
  fp = fopen(s, "r");
  if(fp == NULL){
	DOWN_PROT = 0;
	DOWN_PACK = 0;
  }
  else{
	fgets(s, STRING, fp); DOWN_PROT = atoi(s);
	fgets(s, STRING, fp); DOWN_PACK = atoi(s);
	
	fclose(fp);
  }

  if(USER.level <= GUEST_LEV){
	DOWN_PROT = 0;
	DOWN_PACK = 0;
  }

  if(USER.more < 0) USER.more = 0;

  printf("%c", CR);
}

