/* ix/MBox (help.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #HE help()           display help texts
   #IT intuition()	help on problems on a command line
   #FF filofax()	maintain an address book

   Contact <volkers@unnet.wupper.de> for help! */








#include <stdio.h>

#include "mbox.h"



/* #HE - Give help.

   [cmd]   ->  '*'        = Display the entire helpfile
               '='        = Show the short version of the helpfile

               '#Command' = find the entry for 'Command' and show
                            the belonging helptext

   This functions returns 0 on any errors or the number of found entries
   otherwise. */

int help(cmd)
UNSIGNED char cmd[];
{
  FILE *fp;
  UNSIGNED char s[LONGSTRING];
  int ok = 0, found = 0, toggle = 0, lines = 0, new = 0;

  show(KURZHILFE, 99, 99); /* RESET */
  
  if(cmd[0] == '='){
	if(USER.schluessel[3] != 128){
		headline( HLP01_MSG );
		show(KURZHILFE, 9999, USER.more);
	}
	else{
		show_raw( ANSI_HELP, 10 );
		show(KURZHILFE, 9999, USER.more + 1000);
	}

	return 9999;
  }

  maybe_locked(HILFE, "r");
  fp = fopen(HILFE, "r");
  if (fp == NULL) {
	nerror("help.c", 14, "help", "Can't read", HILFE);
  }
  if (cmd[0] != '#') {
	ok = 2;
	found++;
  }
  headline( HLP01_MSG );
  lines = 0;

  while(fgets(s, STRING, fp) != NULL){

	if(UMLAUT_MODUS != 4) 
		strcpy(s, (UNSIGNED char *) iso_line(s));
	
	strcpy(s, (UNSIGNED char *) richtext(s));

	if (USER.more > 0) {
		if (lines >= MAX_SCR_LINES) {
			lines = 0;
			if (more() != 0){
				fclose(fp);
				return 1;
			}
		}
	}
	if (ok == 2) {
		if (s[0] != '#') {
			printf("%s", s);
			lines++;
			if (toggle > 0) {
				ansi2("me", 0, 0);
				toggle = 0;
			}
		}
		else {
			printf("\n");
			lines++;
			ansi2("md", 0, 0);
			toggle++;
		}
	}
	else {
		if ((ok == 1) && (s[0] == '#')) {
			if(new != 0){
				ok = 0;
				/*
				printf("\n");
				*/
				lines++;
				new = 0;
			}
		}
		if ((ok == 1) && (s[0] != '#')) {
			printf("%s", s);
			new++;
			lines++;
			if (toggle > 0) {
				ansi2("me", 0, 0);
				toggle = 0;
			}
		}
		if ((ok == 0) && (s[0] == '#')) {
			if (strcomp(cmd, s) == 0) {
				ok = 1;
				found++;
				ansi2("md", 0, 0);
				toggle++;
			}
		}
	}
  }
  fclose(fp);

  return found;
}


/* #IT - Help quickly. */

intuition( be )
int be;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char x[STRING];
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char xx[LONGSTRING];

  FILE *fp;

  int i, ok = 0;

  
  if(do_assist != 0) return;

  s[0] = '\0'; i = 0;
  while((s[0] == '\0') && (BEF[i].id != -1)){
	if(BEF[i].id == be) strcpy(s, BEF[i].befehl);
	i++;
  }
  
  sprintf(t, "%s/src/languages/%s.shh", HOME, LANGUAGE);
  fp = fopen(t, "r");
  if(fp == NULL){
	nerror("help.c", 155, "intuition", "Can't read", t);
	return;
  }

  ansi2( "us", 0, 0 );
  printf("\n-------------------------------------------------------------------------------\n");
  ansi2( "me", 0, 0 );

  while(fgets(ex, LONGSTRING, fp) != 0){
	if(strlen(ex) < 40) ok = 0;
	strcpy(t, (UNSIGNED char *) strcopy(ex, 0, 40));
	if((sgrep(t, s) != 0) || (ok > 0)){
		strcpy(xx, (UNSIGNED char *) richtext( ex ));
		strcpy(ex, (UNSIGNED char *) iso_line( xx ));
		printf("%s", ex );
		ok++;
	}
  } 
 
  fclose(fp); 

  ansi2( "us", 0, 0 );
  printf("-------------------------------------------------------------------------------\n");
  ansi2( "me", 0, 0 );
}


/* #FF - Addresses ... [mode == 0] -> add a new on, [mode == 1] -> search */

UNSIGNED char *filofax( address, mode )
UNSIGNED char address[];
int mode;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char v[STRING];
  UNSIGNED char a[STRING];

  FILE *fp;
 
  int ok = 0, x, y, i, c;

  strcpy(a, (UNSIGNED char *) stripped(address));
  sprintf(t, "%s/usr/%c/%d/.address", HOME, USER.name[0], USER.id);

  if(mode == 0){
	sprintf(t, "%s/usr/%c/%d/.address", HOME, USER.name[0], USER.id);

	fp = fopen( t, "r" );
	if(fp != NULL){
		while(fgets(s, STRING, fp) != 0){
			if(strcomp(a, s) == 0){
				ok++;
			}
		}
		fclose(fp);
	}
	if(ok == 0){
		fp = fopen(t, "a" );
		fprintf(fp, "%s, NICKNAME\n", (UNSIGNED char *) a);
		fclose(fp);
	}

	strcpy(s, (UNSIGNED char *) "OK" );
  }
	
  if(mode == 1){
	strcpy(s, (UNSIGNED char *) a);

	fp = fopen( t, "r" );
	if(fp != NULL){
		while((fgets(v, STRING, fp) != 0) && (ok == 0)){
			x = isin(v, ',');
			if(x != 0){
				strcpy(s, (UNSIGNED char *) stripped(strcopy(v, x, strlen(v))));
				if(strcomp(a, s) == 0){
					ok++;
					strcpy(a, (UNSIGNED char *) stripped(strcopy(v, 0, x-2)));
					i = 0; x = -1; y = -1; c = 0;
					while(a[i] != '\0'){
						if(a[i] == '('){
							x = i+1; c = 1;
						}
						if((a[i] == ')') && (y == -1)){
							y = i-1;
						}
						if(a[i] == '<'){
							x = i+1; c = 2;
						}
						if((a[i] == '>') && (y == -1)){
							y = i-1;
						}
						i++;
					}
					if(c == 0) strcpy(s, (UNSIGNED char *) a);
					if(c == 1){
						strcpy(s, (UNSIGNED char *) stripped(strcopy(a, 0, x-2)));
					}
					if(c == 2){
						strcpy(s, (UNSIGNED char *) stripped(strcopy(a, x, y)));
					}
				}
			}
		}
		fclose(fp);
		if(ok == 0) strcpy(s, (UNSIGNED char *) a);
	}
  }

  return (UNSIGNED char *) s;
}
