/* ix/MBox (control.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #CT control()          detailed log of users activities
   #WD whodo()            builds a file for the "who" commands 
   #PF profile()          debugging only - I need it, you don't!

   Contact <volkers@unnet.wupper.de> for help! */


#include <stdio.h>

#include "mbox.h"


/* #CT - Creating a log output.

   The [text] is shown together with terminal port and other data.

   If [mode] is < '99', the output is shown on CONSOLE, otherwise
   it's send to CPRN. See "mbox.h" for further information. */  

FILE *contfp = NULL;

void control(text, mode)
UNSIGNED char text[];
int mode;
{
  if (mode < 99) {

	if(USER.level < 10){
		contfp = fopen(CONSOLE_REDIRECT, "a");
		if (contfp == NULL) {
			printf("\n\n%s [%s]\n\n", CTL01_MSG, CONSOLE_REDIRECT);
			exit(-1);
		}
#ifdef _DATESTAMP
		fprintf(contfp, "%s %s <%s>  %s\n", mydate(1), mytime(1), ttyna(), text);
#else
		fprintf(contfp, "(%s:) %s\n", ttyna(), text);
#endif
		fflush(contfp);
		fclose(contfp);
	}

  }
  if (mode == 99) {
	contfp = fopen(CPRN, "a");
	if (contfp == NULL) {
		printf("\n\n%s [%s]\n\n", CTL01_MSG, CPRN);
		exit(-1);
	}
	fprintf(contfp, "\n%s  -  %s\n", mydate(1), mytime(1));
	fprintf(contfp, "(%s:) %s\n", ttyna(), text);
	fflush(contfp);
	fclose(contfp);
  }
}





/* #WD - Building up a file for later user by "portinfo()".

   The argument [text] contains users latest activity. */

void whodo(text)
UNSIGNED char text[];
{
  FILE *fp;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];


  sprintf(s, "%s/etc/whatdoes.%s", HOME, (UNSIGNED char *) ttyna());
  strcpy(t, (UNSIGNED char *) timereconv( THISTIME ));
  t[5] = '\0';

  fp = fopen(s, "w");
  if (fp == NULL) {
	nerror("control.c", 44, "whodo", "Can't write to", s);
  }
  sprintf(s, "%s (%s)", USER.name, USER.nick);
  fprintf(fp, "%-32.32s %8.8s   %-5.5s   %s\n", s, 
  		ttyna(), t, text ); 
  fclose(fp);
}




/* #PF - Profiling the performance of the C code.

   The call of [function] (contains the name of a C function inside the
   BBS) is dumped. */

FILE *profile_file = NULL;

void profile( function )
UNSIGNED char function[];
{
  if(function[0] == '+'){
	profile_file = fopen( "/tmp/profile", "w" );
	if(profile_file == NULL){
		printf("SHIT");
		exit(0);
	}
	return;
  }

  if(function[0] == '-'){
	fclose( profile_file );
	return;
  }

  fprintf(profile_file, "%s\n", function);  
}
