/* ix/MBox (admin.c) by Volker Schuermann, 16.06.1994

   This C source code contains the following functions:

   #UA user_aendern()           change user data in the BBS database
   #UZ user_anzeigen()          show user data
   #UL user_loeschen()          delete user (data) from the database
   #SG setup_get()              read a number
   #WU wait_until_keypressed()  guess what ;-)
   #AD admin()                  sysop changing user data (interactive)
   #SU setup()                  user changing user data (interactive)

   Contact <volkers@unnet.wupper.de> for help! */





#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>

#include "mbox.h"

void wait_until_keypressed();




/* #UA - Change users data. */

void user_aendern()
{
  int fd;
  struct userdaten DUMMY, LOOSER;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char oldname[STRING];

  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  int uid = -1;

  headline( ADM01_MSG );

  printf("%s ", ADM02_MSG);
  strcpy(s, (UNSIGNED char *) getline(30, 11, '.', ""));
  if ((s[0] > 47) && (s[0] < 58)) uid = atoi(s);

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if(fd == -1){
	nerror("admin.c", 324, "aendern", "Can't read", UDBASE);
  }
  while(read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy){
	if(uid == DUMMY.id){
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	}
	else{
		if((strcomp(s, DUMMY.name) == 0) ||
		   (strcomp(s, DUMMY.nick) == 0) ||
		   (strcomp(s, DUMMY.sh_name) == 0)){
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
		}
	}
  }
  lseek(fd, ll, SEEK_SET);
  read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if(ll == -1L) return;

  printf("%c%s %d                                               ", CR, ADM03_MSG, LOOSER.id);

  strcpy(oldname, (UNSIGNED char *) LOOSER.name);

  printf("\n%s ", ADM04_MSG);
  strcpy(s, (UNSIGNED char *) getline(30, 1011, '.', LOOSER.name));
  if (s[0] > 32) sprintf(LOOSER.name, s);
  if (s[0] == 32) LOOSER.name[0] = '\0';

  printf("\n%s ", ADM05_MSG);
  strcpy(s, (UNSIGNED char *) getline(10, 1011, '.', LOOSER.passwort));
  if (s[0] > 32) sprintf(LOOSER.passwort, s);
  if (s[0] == 32) LOOSER.passwort[0] = '\0';

  printf("\n%s ", ADM06_MSG);
  strcpy(s, (UNSIGNED char *) getline(14, 1011, '.', LOOSER.sh_name));
  if (s[0] > 32) sprintf(LOOSER.sh_name, s);
  if (s[0] == 32) LOOSER.sh_name[0] = '\0';

  printf("\n%s ", ADM07_MSG);
  strcpy(s, (UNSIGNED char *) getline(30, 1011, '.', LOOSER.nick));
  if (s[0] > 32) sprintf(LOOSER.nick, s);
  if (s[0] == 32) LOOSER.nick[0] = '\0';

  printf("\n%s ", ADM08_MSG);
  strcpy(s, (UNSIGNED char *) getline(30, 1011, '.', LOOSER.wohnort));
  if (s[0] > 31) sprintf(LOOSER.wohnort, s);

  printf("\n%s ", ADM09_MSG);
  strcpy(s, (UNSIGNED char *) getline(30, 1011, '.', LOOSER.strasse));
  if (s[0] > 31) sprintf(LOOSER.strasse, s);

  printf("\n%s ", ADM10_MSG);
  strcpy(s, (UNSIGNED char *) getline(20, 1011, '.', LOOSER.telefon1));
  if (s[0] > 31) sprintf(LOOSER.telefon1, s);

  printf("\n%s ", ADM11_MSG);
  strcpy(s, (UNSIGNED char *) getline(20, 1011, '.', LOOSER.telefon2));
  if (s[0] > 31) sprintf(LOOSER.telefon2, s);

  printf("\n%s ", ADM12_MSG);
  strcpy(s, (UNSIGNED char *) getline(10, 1114, '?', LOOSER.geburtsdatum));
  if (s[0] > 31) sprintf(LOOSER.geburtsdatum, s);

  printf("\n%s ", ADM13_MSG);
  sprintf(t, "%d", LOOSER.terminal);
  strcpy(s, (UNSIGNED char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.terminal = atoi(s);
  if ((LOOSER.terminal < 1) || (LOOSER.terminal > 8)) LOOSER.terminal = 1;

  printf("\n%s ", ADM14_MSG);
  sprintf(t, "%d", LOOSER.editor);
  strcpy(s, (UNSIGNED char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.editor = atoi(s);
  if ((LOOSER.editor < 1) || (LOOSER.editor > OFFERED_EDITORS)) LOOSER.editor = 1;

  printf("\n%s ", ADM15_MSG);
  sprintf(t, "%d", LOOSER.level);
  strcpy(s, (UNSIGNED char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.level = atoi(s);

  printf("\n%s ", ADM16_MSG);
  sprintf(t, "%d", LOOSER.more);
  strcpy(s, (UNSIGNED char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.more = atoi(s);
  if ((LOOSER.more < 0) || (LOOSER.more > 3)) LOOSER.more = 1;

  printf("\n%s ", ADM17_MSG);
  sprintf(t, "%d", LOOSER.bell);
  strcpy(s, (UNSIGNED char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.bell = atoi(s);
  if ((LOOSER.bell < -1) || (LOOSER.bell > 1)) LOOSER.bell = 0;

  printf("\n%s ", ADM18_MSG);
  sprintf(t, "%d", LOOSER.prompt);
  strcpy(s, (UNSIGNED char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.prompt = atoi(s);
  if ((LOOSER.prompt < 1) || (LOOSER.prompt > 3)) LOOSER.prompt = 2;

  printf("\n%s ", ADM19_MSG);
  LOOSER.tlines += 2;
  sprintf(t, "%d", LOOSER.tlines);
  strcpy(s, (UNSIGNED char *) getline(5, 1111, '.', t));
  if (s[0] > 31) LOOSER.tlines = atoi(s);
  LOOSER.tlines -= 2;
  if ((LOOSER.tlines < 22) || (LOOSER.tlines > 23)) LOOSER.tlines = DEF_MAX_SCR_LINES;
  
  printf("\n%s ", ADM20_MSG);
  strcpy(s, (UNSIGNED char *) getline(10, 1114, '?', LOOSER.lastlog));
  if (s[0] > 31) sprintf(LOOSER.lastlog, s);

  printf("\n%s ", ADM21_MSG);
  strcpy(t, (UNSIGNED char *) timereconv((long) LOOSER.lasttime));
  t[5] = '\0';
  strcpy(s, (UNSIGNED char *) getline(5, 1113, '?', t));
  LOOSER.lasttime = timeconv(s);

  printf("\n%s ", ADM21aMSG);
  strcpy(s, (UNSIGNED char *) ttyname(0));
  strcpy(t, (UNSIGNED char *) LOOSER.account); 
  LOOSER.account[10] = '\0';
  if(strcomp(PMS_TTY, s) == 0){
	strcpy(s, (UNSIGNED char *) getline(10, 1011, '.', LOOSER.account));
	if (s[0] > 31) {
		strcpy(LOOSER.account, (UNSIGNED char *) s);
		LOOSER.account[10] = '\0';
		strcat(LOOSER.account, (UNSIGNED char *) strcopy(t, 10, 80));
	}
  }
  else{
	printf("%s", LOOSER.account);
	strcpy(LOOSER.account, (UNSIGNED char *) t);
  }

  printf("\n%s ", ADM22_MSG);
  strcpy(s, (UNSIGNED char *) getline(58, 1011, '.', LOOSER.newsgrps));
  if (s[0] > 31) sprintf(LOOSER.newsgrps, s);

  printf("\n%s ", ADM23_MSG);
  sprintf(t, "%d", LOOSER.seq);
  strcpy(s, (UNSIGNED char *) getline(10, 1111, '.', t));
  if (s[0] > 31) LOOSER.seq = atoi(s);

  wait_until_keypressed();

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_WRONLY);
  if (fd == -1) {
	nerror("admin.c", 428, "aendern", "Can't write to", UDBASE);
  }
  if (lseek(fd, ll, SEEK_SET) == -1) {
	nerror("admin.c", 431, "aendern", "Position not found in", UDBASE);
  }
  write(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if (LOOSER.id == USER.id) {	/* Ich bin's !!! */

	maybe_locked(UDBASE, "r");
	mblock(UDBASE);
	fd = open(UDBASE, O_RDONLY);
	if (fd == -1) {
		nerror("admin.c", 324, "aendern", "Can't read", UDBASE);
	}
	lseek(fd, ll, SEEK_SET);
	read(fd, (UNSIGNED char *) &USER, sizeof(USER));
	close(fd);
	mbunlock(UDBASE);
  }
  else{
	adm_updated( LOOSER.id );
  }

  if(LOOSER.name[0] != oldname[0]){
	moving( oldname, LOOSER.name, LOOSER.id );
  }
}




/* #UZ - Show users data. */

void user_anzeigen()
{
  int fd;
  struct userdaten DUMMY, LOOSER;
  UNSIGNED char s[STRING];
  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  int uid = -1;


  headline( ADM01_MSG );

  printf("%s ", ADM02_MSG);
  strcpy(s, (UNSIGNED char *) getline(30, 11, '.', ""));
  if ((s[0] > 47) && (s[0] < 58)) uid = atoi(s);

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 324, "aendern", "Can't read", UDBASE);
  }
  while (read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) {
	if (uid == DUMMY.id) {
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	} 
	else{
		if ((strcomp(s, DUMMY.name) == 0) ||
		    (strcomp(s, DUMMY.nick) == 0) ||
		    (strcomp(s, DUMMY.sh_name) == 0)) {
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
		}
	}
  }
  lseek(fd, ll, SEEK_SET);
  read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if (ll == -1L) return;

  printf("%c  %s %d                                               ", CR, ADM03_MSG, LOOSER.id);
  printf("\n  %s %s",   ADM04_MSG, LOOSER.name);
  printf("\n  %s %s",   ADM05_MSG, LOOSER.passwort);
  printf("\n  %s %s",   ADM06_MSG, LOOSER.sh_name);
  printf("\n  %s %s",   ADM07_MSG, LOOSER.nick);
  printf("\n  %s %s",   ADM08_MSG, LOOSER.wohnort);
  printf("\n  %s %s",   ADM09_MSG, LOOSER.strasse);
  printf("\n  %s %s",   ADM10_MSG, LOOSER.telefon1);
  printf("\n  %s %s",   ADM11_MSG, LOOSER.telefon2);
  printf("\n  %s %s",   ADM12_MSG, LOOSER.geburtsdatum);
  printf("\n  %s %d",   ADM13_MSG, LOOSER.terminal);
  printf("\n  %s %d",   ADM14_MSG, LOOSER.editor);
  printf("\n  %s %d",   ADM15_MSG, LOOSER.level);
  printf("\n  %s %d",   ADM16_MSG, LOOSER.more);
  printf("\n  %s %d",   ADM17_MSG, LOOSER.bell);
  printf("\n  %s %d",   ADM18_MSG, LOOSER.prompt);
  printf("\n  %s %d",   ADM19_MSG, LOOSER.tlines += 2);
  printf("\n  %s %s",   ADM20_MSG, LOOSER.lastlog);
  printf("\n  %s %.5s", ADM21_MSG, (UNSIGNED char *) timereconv((long) LOOSER.lasttime));
  LOOSER.account[10] = '\0';
  printf("\n  %s %s",   ADM21aMSG, LOOSER.account);
  printf("\n  %s %s",   ADM22_MSG, LOOSER.newsgrps);
  printf("\n  %s %d",   ADM23_MSG, LOOSER.seq);

  wait_until_keypressed();
}


/* #UL - Delete BBS user account including all directories and files. */

void user_loeschen()
{
  int fd;
  int gd;
  struct userdaten DUMMY, LOOSER;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  UNSIGNED char c;
  int uid = -1;


  headline( ADM25_MSG );
	
  printf("\n%s ", ADM02_MSG);
  strcpy(s, (UNSIGNED char *) getline(30, 11, '.', ""));
  if ((s[0] > 47) && (s[0] < 58)) uid = atoi(s);

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 459, "loeschen", "Can't read", UDBASE);
  }
  while (read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) {
	if (uid == DUMMY.id) {
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	}
	else{
		if ((strcomp(s, DUMMY.name) == 0) ||
		    (strcomp(s, DUMMY.nick) == 0) ||
		    (strcomp(s, DUMMY.sh_name) == 0)) {
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
		}
	}
  }
  lseek(fd, ll, SEEK_SET);
  read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if (ll == -1L) return;

  printf("%c%s (%d)                                     ", CR, ADM26_MSG, LOOSER.id);
  printf("\n%s (%s) ", ADM27_MSG, LOOSER.name);

  ansi2("md", 0, 0);
  printf("\n\n%s [%c, %c] ? > ", ADM28_MSG, GBL06_MSG, GBL07_MSG);
  ansi2("me", 0, 0);

  c = yesno();

  if (c != GBL06_MSG) return;

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 490, "loeschen", "Can't read", UDBASE);
  }
  sprintf(s, "%s/%dbase", TMP, getpid());

  gd = open(s, O_WRONLY | O_CREAT);
  if (gd == -1) {
	nerror("admin.c", 497, "loeschen", "Can't create", s);
  }
  while (read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) {
	if (DUMMY.id != LOOSER.id) {
		write(gd, (UNSIGNED char *) &DUMMY, dummy);
	}
  }
  close(gd);
  close(fd);
  mbunlock(UDBASE);

  sprintf(t, "cp %s %s", s, UDBASE);
  system(t);

  unlink(s);

  sprintf(s, "rm -r %s/usr/%c/%d", HOME, LOOSER.name[0], LOOSER.id);
  system(s);
}



/* #SG - Read a number. Only accept numbers between 1 and 'max'. */

int setup_get(max)
UNSIGNED char max;
{
  UNSIGNED char c;


  if(USER.terminal != ISO6429)
	ansi2("md", 0, 0);
  else
	ansi2("X9", 0, 0);
  printf("[1-%c] %s >", max, ADM29_MSG);
  ansi2("me", 0, 0);

  printf(" ");

  do {
	c = getint();
	if ((c < '0') || (c > max)) c = 0;
  } while (c == 0);
  printf("%c", c);

  return c;
}



/* #WU - Wait until keypressed ... what a surprise! */

void wait_until_keypressed()
{
  UNSIGNED char c;

  ansi2("md", 0, 0);
  printf("\n\n%s > ", ADM30_MSG);
  ansi2("me", 0, 0);
 
  c = getint();
}



/* #AD - Sysop maintaining users database. */

void admin()
{
  UNSIGNED char c;

AGAIN:

  headline( ADM31_MSG );

  printf(  "\n  1 - %s", ADM32_MSG);
  printf("\n\n  2 - %s", ADM33_MSG);
  printf("\n\n  3 - %s", ADM34_MSG);
  printf("\n\n  4 - %s", ADM35_MSG);
  printf("\n\n  5 - %s", ADM36_MSG);

  printf("\n");
  printf("\n\n  9 - %s", ADM37_MSG);

  printf("\n\n");

  c = setup_get('9');

  switch (c) {
      case '1':	
		postfach("*");
		logout();
		intro( 1 );
		printf("\n");
		return;
		break;

      case '2':	
		user_aendern();
		break;

      case '3':	
		user_loeschen();
		break;

      case '4':	
		user_anzeigen();
		break;

      case '5':
		userliste("");
		wait_until_keypressed();
		break;

       default:
		printf("\n");
		return;
  }
  goto AGAIN;

}



/* #SU - User maintaining his/her data. */

void setup()
{
  FILE *fp;
  int fd;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char c;
  int i, j;
  int ok = 0;
  struct userdaten DUMMY;
  UNSIGNED char oldname[STRING];
  int upmode = 0;

  AGAIN:

  headline( ADM38_MSG );
  printf("\n");

  printf("  1 - %s\n\n", ADM39_MSG);
  printf("  2 - %s\n\n", ADM40_MSG);
  printf("  3 - %s\n\n", ADM41_MSG);
  printf("  4 - %s\n\n", ADM42_MSG);
  printf("  5 - %s\n\n", ADM43_MSG);
  printf("  6 - %s\n\n", ADM44_MSG);
  printf("  7 - %s\n\n", ADM45_MSG);
  printf("  8 - %s\n\n", ADM46_MSG);
  printf("\n");
  printf("  9 - %s\n\n", ADM47_MSG);

  c = setup_get('9');

  switch (c) {
      case '1':
		headline( ADM48_MSG );
		printf("\n");
		if (USER.terminal == 1)
			printf("*");
		else
			printf(" ");
		printf(" 1 - ANSI (X3.64 ... PC-BBS-ANSI)\n\n");
		if (USER.terminal == 2)
			printf("*");
		else
			printf(" ");
		printf(" 2 - VT100 (Digital Equipment VT100)\n\n");
		if (USER.terminal == 3)
			printf("*");
		else
			printf(" ");
		printf(" 3 - VT52 (Digital Equipment VT52)\n\n");
		if (USER.terminal == 4)
			printf("*");
		else
			printf(" ");
		printf(" 4 - Dump (%s)\n\n", ADM49_MSG);
		if (USER.terminal == 5)
			printf("*");
		else
			printf(" ");
		printf(" 5 - COLOR-ANSI (X3.64 & ISO 6429)\n\n");
                if (USER.terminal == 6)
			printf("*");
		else
			printf(" ");
		printf(" 6 - %s (%s)\n\n", TECA[1].name, TECA[1].desc);
		if (USER.terminal == 7)
			printf("*");
		else
			printf(" ");
                printf(" 7 - %s (%s)\n\n", TECA[2].name, TECA[2].desc);
		if (USER.terminal == 8)
			printf("*");
		else
			printf(" ");
		printf(" 8 - %s (%s)\n\n", TECA[3].name, TECA[3].desc);

		USER.terminal = setup_get('8') - 48;
		
		break;

      case '2':
		headline( ADM50_MSG );
		printf("\n");
		fp = fopen(EDITORS, "r");
		if (fp == NULL) {
			nerror("admin.c", 563, "setup", "Can't read", EDITORS);
		}
		i = 0;
		while((fgets(s, STRING, fp) != NULL) && (s[0] != '='));
		while (fscanf(fp, "%s %s", s, t) > 0) {
			i++;
			if (USER.editor == i)
				printf("*");
			else
				printf(" ");
			printf(" %d - %s\n\n", i, s);
		}
		fclose(fp);
		USER.editor = setup_get((i + 48)) - 48;
	
		break;

      case '3':
		headline( ADM51_MSG );
		printf("\n");
		strcpy(s, (UNSIGNED char *) mytime(0));
		if ((USER.prompt == 1) && (USER.bell == 1))
			printf("*");
		else
			printf(" ");
		printf(" 1 - %s->     \"[%s] %s > \"\n\n", ADM52_MSG, s, LOP06_MSG);
		if ((USER.prompt == 1) && (USER.bell == 0))
			printf("*");             
		else
			printf(" ");
		printf(" 2 - %s->     \"[%s] %s > \"\n\n", ADM53_MSG, s, LOP06_MSG);
		if ((USER.prompt == 2) && (USER.bell == 1))
			printf("*");
		else
			printf(" ");
		printf(" 3 - %s->     \"[%s] %s > \"\n\n", ADM54_MSG, NG, LOP06_MSG);
		if ((USER.prompt == 2) && (USER.bell == 0))
			printf("*");
		else
			printf(" ");
		printf(" 4 - %s->     \"[%s] %s > \"\n\n", ADM55_MSG, NG, LOP06_MSG);
		if ((USER.prompt == 3) && (USER.bell == 1))
			printf("*");
		else
			printf(" ");
		printf(" 5 - %s->     \"[(Sec.) NZ, RZ, WZ] %s > \"\n\n", ADM56_MSG, LOP06_MSG);
		if ((USER.prompt == 3) && (USER.bell == 0))
			printf("*");
		else
			printf(" ");
		printf(" 6 - %s->     \"[(Sec.) NZ, RZ, WZ] %s > \"\n\n", ADM57_MSG, LOP06_MSG);
	
		c = setup_get('6');
		switch (c) {
			    case '1':
					USER.prompt = 1;
					USER.bell = 1;
					break;
			    case '2':
					USER.prompt = 1;
					USER.bell = 0;
					break;
			    case '3':
					USER.prompt = 2;
					USER.bell = 1;
					break;
			    case '4':
					USER.prompt = 2;
					USER.bell = 0;
					break;
			    case '5':
					USER.prompt = 3;
					USER.bell = 1;
					break;
			    case '6':
					USER.prompt = 3;
					USER.bell = 0;
					break;
		}
		break;

      case '4':
		headline( ADM58_MSG );
		printf("\n");
		if (USER.more == 0)
			printf("*");
		else
			printf(" ");
		printf(" 1 - %s\n\n", ADM59_MSG);
		if (USER.more == 1)
			printf("*");
		else
			printf(" ");
		printf(" 2 - %s\n\n", ADM60_MSG);
		if (USER.more == 3)
			printf("*");
		else
			printf(" ");
		printf(" 3 - %s\n\n", ADM61_MSG);
		printf("\n");
		printf("  4 - %s\n\n", ADM62_MSG);
		printf("  5 - %s\n\n", ADM63_MSG);
		printf("  6 - %s\n\n", ADM64_MSG);		
		printf("  7 - %s\n\n", ADM64aMSG);
		printf("  8 - %s\n\n", ADM64bMSG);
		printf("  9 - %s\n\n", ADM64cMSG);

		i = setup_get('9') - 49;

		if (i < 3) {
			if(i < 0) i = 0;
			USER.more = i;
			if (USER.more == 2) USER.more++;
		}
		else {
			headline( ADM58_MSG );
			printf("\n");
			
			if (i == 3) {
				if (USER.leserichtung == 1)
					printf("*");
				else
					printf(" ");
				printf(" 1 - %s\n\n", ADM65_MSG);
				if (USER.leserichtung == 2)
					printf("*");
				else
					printf(" ");
				printf(" 2 - %s\n\n", ADM66_MSG);

				printf("\n");
	
				if (USER.schluessel[4] != 123)
					printf("*");
				else
					printf(" ");
				printf(" 3 - %s\n\n", ADM66aMSG);
				if (USER.schluessel[4] == 123)
					printf("*");
				else
					printf(" ");
				printf(" 4 - %s\n\n", ADM66bMSG);

				j = setup_get('4') - 48;
		
				if(j < 3) 
					USER.leserichtung = j;
				else{
					if(j == 3) 
						USER.schluessel[4] = 1;
					else
						USER.schluessel[4] = 123;
				}
				/*	
				USER.leserichtung = setup_get('2') - 48;
				*/
			}
			if (i == 4) {
				if (USER.tlines == 22)
					printf("*");
				else
					printf(" ");
				printf(" 1 - %s\n\n", ADM67_MSG);
				if (USER.tlines == 23)
					printf("*");
				else
					printf(" ");
				printf(" 2 - %s\n\n", ADM68_MSG);
				if (USER.tlines == 43)
					printf("*");
				else
					printf(" ");
				printf(" 3 - %s\n\n", ADM68aMSG);

				USER.tlines = setup_get('3') - 48 + 21;
				if(USER.tlines == 24) USER.tlines = 43; /* 45 Zeilen !! */	
			}
			if (i == 5) {
				if (USER.schluessel[0] != 32)
					printf("*");
				else
					printf(" ");
				printf(" 1 - %s\n\n", ADM69_MSG);
				if (USER.schluessel[0] == 32)
					printf("*");
				else
					printf(" ");
				printf(" 2 - %s\n\n", ADM70_MSG);
		
				i = setup_get('2') - 48;
				if (i == 2){
					USER.schluessel[0] = 32;
				}				
				else{
					USER.schluessel[0] = 1;
				}
			}
			if (i == 6) {
				if (USER.schluessel[1] == 2)
					printf("*");
				else
					printf(" ");
				printf(" 1 - %s\n\n", ADM70aMSG);
				if (USER.schluessel[1] == 3)
					printf("*");
				else
					printf(" ");
				printf(" 2 - %s\n\n", ADM70bMSG);
		
				if (USER.schluessel[1] == 4)
					printf("*");
				else
					printf(" ");
				printf(" 3 - %s\n\n", ADM70cMSG);
	
				i = setup_get('3') - 48;
				USER.schluessel[1] = i + 1;
			}
			if (i == 7) {
				if (USER.schluessel[2] == 1)
					printf("*");
				else
					printf(" ");
				printf(" 1 - %s [%c, %c, %c, %c, %c, %c, %c]\n\n", 
					ADM70dMSG, 196, 214, 220, 228, 246, 252, 223);
				if (USER.schluessel[2] == 2)
					printf("*");
				else
					printf(" ");
				printf(" 2 - %s [%c, %c, %c, %c, %c, %c, %c]\n\n",
					 ADM70eMSG, 142, 153, 154, 132, 148, 129, 225);
				if (USER.schluessel[2] == 3)
					printf("*");
				else
					printf(" ");
				printf(" 3 - %s\n\n", ADM70fMSG);
				if (USER.schluessel[2] == 4)
					printf("*");
				else
					printf(" ");
				printf(" 4 - %s\n\n", ADM70gMSG);

				i = setup_get('4') - 48;
				USER.schluessel[2] = i;
			}
			if (i == 8) {
				download( "!" );
			}
		}
		break;

	case '5':
		if (strcomp(GUEST, USER.name) == 0) break;

		headline( ADM71_MSG );
		printf("\n");

		ansi2("md", 0, 0);
		printf("%s\n", ADM72_MSG);
		printf("%s\n", ADM73_MSG);
		printf("%s\n", ADM74_MSG);
		printf("\n");
		printf("%s\n", ADM75_MSG);
		printf("%s\n", ADM76_MSG);
		ansi2("me", 0, 0);

		maybe_locked(UDBASE, "r"); 
	        fd = open(UDBASE, O_RDONLY);
		if (fd == -1) {
			nerror("admin.c", 747, "setup", "Can't read", UDBASE);
		}	

		strcpy(oldname, (UNSIGNED char *) USER.name);

		printf("\n%s ", ADM04_MSG);
		strcpy(s, (UNSIGNED char *) getline(30, 1015, '.', USER.name));
		if(strcomp(GUEST, s) != 0){
			if (s[0] > 31){
				ok = 0;
				lseek(fd, 0L, SEEK_SET);
				while ((read(fd, (UNSIGNED char *) &DUMMY, sizeof(DUMMY)) == sizeof(DUMMY)) && (ok == 0)) {
					if (strcomp(s, DUMMY.name)    == 0) ok = 1;
					if (strcomp(s, DUMMY.nick)    == 0) ok = 1;
					if (strcomp(s, DUMMY.sh_name) == 0) ok = 1;
				}
				if(USER.level < ADMIN_LEV){
					if ((strcomp("SYSOP", s) == 0) ||
					    (strcomp("POST",  s) == 0) ||
					    (strcomp("GAST",  s) == 0) ||
					    (strcomp("ADMIN", s) == 0) ||
					    (strcomp("COSYS", s) == 0)) ok++;
				}
				if(s[0] >= 97) s[0] -= 32;

				if(ok == 0) strcpy(USER.name, (UNSIGNED char *) s);
			}
		}
		printf("\n%s ", ADM07_MSG);
		strcpy(s, (UNSIGNED char *) getline(30, 1015, '.', USER.nick));
		if (s[0] > 31){	
			ok = 0;
			lseek(fd, 0L, SEEK_SET);
			while ((read(fd, (UNSIGNED char *) &DUMMY, sizeof(DUMMY)) == sizeof(DUMMY)) && (ok == 0)) {
				if (strcomp(s, DUMMY.name)    == 0) ok = 1;
				if (strcomp(s, DUMMY.nick)    == 0) ok = 1;
				if (strcomp(s, DUMMY.sh_name) == 0) ok = 1;
			}
			if (USER.level < ADMIN_LEV){
				if ((strcomp("SYSOP", s) == 0) ||
				    (strcomp("POST",  s) == 0) ||
				    (strcomp("GAST",  s) == 0) ||
				    (strcomp("ADMIN", s) == 0) ||
				    (strcomp("COSYS", s) == 0)) ok++;
			}

			if(ok == 0) strcpy(USER.nick, (UNSIGNED char *) s);
		}

		close(fd);
		mbunlock(UDBASE);

		printf("\n%s ", ADM08_MSG);
		strcpy(s, (UNSIGNED char *) getline(30, 1011, '.', USER.wohnort));
		if (s[0] > 31) sprintf(USER.wohnort, s);

		printf("\n%s ", ADM09_MSG);
		strcpy(s, (UNSIGNED char *) getline(30, 1011, '.', USER.strasse));
		if (s[0] > 31) sprintf(USER.strasse, s);

		printf("\n%s ", ADM10_MSG);
		strcpy(s, (UNSIGNED char *) getline(20, 1011, '.', USER.telefon1));
		if (s[0] > 31) sprintf(USER.telefon1, s);

		printf("\n%s ", ADM11_MSG);
		strcpy(s, (UNSIGNED char *) getline(20, 1011, '.', USER.telefon2));
		if (s[0] > 31) sprintf(USER.telefon2, s);

		printf("\n%s ", ADM12_MSG);
		strcpy(s, (UNSIGNED char *) getline(10, 1114, '?', USER.geburtsdatum));
		if (s[0] > 31) sprintf(USER.geburtsdatum, s);

		if(USER.name[0] != oldname[0]){
			moving( oldname, USER.name, USER.id );
		}
		break;

      case '6':
		if (strcomp(GUEST, USER.name) == 0) break;

		headline( ADM77_MSG );
		
		NIX: printf("\n%s ", ADM78_MSG);
	
		strcpy(s, (UNSIGNED char *) getline(10, 12, '.', ""));
		if (s[0] != '\0') {
			strcpy(USER.passwort, (UNSIGNED char *) crypted(s));
			printf(" (%s)", USER.passwort);
		}
		if (strlen(USER.passwort) < 5) {
			ansi2("md", 0, 0);
			printf("\n\n%s\n", ADM79_MSG);
			ansi2("me", 0, 0);
			goto NIX;
		}
		printf("\n\n%s ", ADM80_MSG);
		strcpy(s, (UNSIGNED char *) getline(10, 12, '.', ""));
		strcpy(t, (UNSIGNED char *) crypted(s));
		printf(" (%s)", t);
		if ((strcomp(t, USER.passwort) != 0) || (strcomp(USER.passwort, t) != 0)) {
			ansi2("md", 0, 0);
			printf(" %s         \n", ADM81_MSG);
			ansi2("me", 0, 0);
			goto NIX;
		}
		break;

	case '7':
		headline( ADM82_MSG );
		printf("\n");
		strcpy(s, (UNSIGNED char *) mytime(0));
		if (USER.intro == 1)
			printf("*");
		else
			printf(" ");
		printf(" 1 - %s\n\n", ADM83_MSG);
		if (USER.intro == 2)
			printf("*");
		else
			printf(" ");
		printf(" 2 - %s\n\n", ADM84_MSG);
		if (USER.intro == 3)
			printf("*");
		else
			printf(" ");
		printf(" 3 - %s\n\n", ADM85_MSG);
		if (USER.intro == 4)
			printf("*");
		else
			printf(" ");
		printf(" 4 - %s\n\n", ADM86_MSG);

		USER.intro = setup_get('4') - 48;
		break;

      case '8':
		headline( ADM87_MSG );
		printf("\n");
		if (USER.lastmode == 1)
			printf("*");
		else
			printf(" ");
		printf(" 1 - %s\n\n", ADM88_MSG);
		if (USER.lastmode == 2)
			printf("*");
		else
			printf(" ");
		printf(" 2 - %s\n\n", ADM89_MSG);
		printf("\n");
		printf("  3 - %s\n\n", ADM90_MSG);
	
		i = setup_get('3') - 48;

		switch (i) {
		    case 1:
				USER.lastmode = 1;
				LASTTIME = USER.lasttime;
				break;
		    case 2:
				USER.lastmode = 2;
				LASTTIME = (int) 0;
				break;
		    case 3:
				headline( ADM87_MSG );
				ansi2("md", 0, 0);
				printf("\n%s\n", ADM91_MSG);
				printf("%s\n", ADM92_MSG);
				printf("%s\n", ADM93_MSG);
				printf("%s\n", ADM94_MSG);
				ansi2("me", 0, 0);

				printf("\n%s ", ADM95_MSG);
				strcpy(t, (UNSIGNED char *) datereconv(LASTLOG));
				strcpy(s, (UNSIGNED char *) getline(10, 1114, '?', t));
				LASTLOG = (long) dateconv(s);

				printf("\n%s ", ADM96_MSG);
				strcpy(t, (UNSIGNED char *) timereconv(LASTTIME));
				strcpy(s, (UNSIGNED char *) getline(8, 1113, '?', t));
				LASTTIME = timeconv(s);

				upmode = 1; /* COMPLETE UPDATE (user_init) */
			
				break;
		}
		break;

      case '9':	
		goto ENDE;
		break;
  }
  printf("\n\n");
  init_user( ADM97_MSG, upmode );
  goto AGAIN;

  ENDE:

  sprintf(s, "%s/surf.%d", TMP, getpid());
  unlink(s);

  printf("\n");
  return;
}
