/* ix/MBox/WENDY (wendy.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #LP loop()             main loop
   #MA main()             main function

   Contact <volkers@unnet.wupper.de> for help! */









#include "wendy.h"



void sig_catch()
{
  signal( SIGQUIT, SIG_IGN );
  ctrlx();
  echo( 1 );
  signal( SIGQUIT, sig_catch);
}

 
/* #LP - Read in a char and process it */
 
loop( f )
unsigned char f[];
{
  unsigned char s[STRING];
  int c, d;
  int oldy = -1;
 
  ansi2( "cm", x, y );
 
  do{
    c = getch();
 
    if(c == ESC){
        c = getch();
	d = 0;

        if(c == ':'){
                c = vi( f );
                goto ENDLOOP;
        }
	if((c == 'C') || (c == 'D')){
		d = c;
		c = 100 * '[';
	}
	else{
		if(c > 96){
			d = 0;
			c -= 96;
		
		}
		else{
			if(c == 'O') c = '[';

			c *= 100;

	    	        d = getch();

			if(d == '1') d = getch();
		}
	}

	c += d;
    }
  
    if (SCANTEST) { 
    	ansi2( "cm", 60, 2 );
    	ansi( "md" );
	if(c < 32){
		printf(" <CTRL-%c (%d)>    ", (c + 64), c);
	}
	if((c > 31) && (c < 128)){
		printf(" <%c (%d)>         ", c, c);
	}
	if(c > 127){
		printf(" <(%d)>            ", c);
	}
    	ansi2( "cm", x, y );
    	activate( RTF_attrib );
    }

    if(c ==  wBS) c = BS;
    if(c == wDEL) c = DELD;
    if(c == wINS) c = INS;
    if(c == wEND) c = END;
  
    switch(c){
        case ENTER      :       enter();
                                break;
        case CTRL_K     :
        case UP         :       ctrlk();
                                break;
#ifdef _SYS7
        case CTRL_J     :
#endif
        case DOWN       :       ctrlj();
                                break;
        case LEFT       :       if(x > 1){
                                        ansi( "kl" );
                                        x--;
                                }
				else{
					ctrlk();
					lines_end();
				}
                                break;
        case RIGHT      :       if(x < MAXX){
                                        ansi( "kr" );
                                        x++;
                                }
				else{
					ctrlj();
					x = 1;
					ansi2( "cm", x, y );
				}
                                break;
        case CTRL_B     :
	case PGUP_LI	:
        case PGUP       :       pgup();
                                break;
        case CTRL_F     :
	case PGDN_LI	:
        case PGDN       :       pgdn();
                                break;
        case CTRL_A     :
	case HOME_LI	:
        case HOME       :       x = 1;
				ansi2( "cm", x, y );
                                break;
	case CTRL_E	:
	case TLX_END	:
        case CTRL_Z     :
        case END        :       lines_end();
                                break;
        case BS         :       ctrlh();
                                CHANGED++;
                                break;
	case TLX_DEL	:
        case DELD       :       x++;
                                CHANGED++;
                                ctrlh();
                                break;
	case TAB	:	x = (int)((x+8)/8*8) + 1;
				if(x > MAXX) x = MAXX; 
				ansi2( "cm", x, y ); 
				break;
        case CTRL_O     :       help();
                                break;
        case CTRL_P     :       if(RULER == 0){
					strcpy(version, (unsigned char *) RULERLINE);
					RULER++;
					xruler = -1;
				}
				else{
					RULER = 0;
					strcpy(version, (unsigned char *) VERSION);
				}
				show_status( version );
				STATUSM = 0;
				ansi2( "cm", x, y );
				break;
        case CTRL_L     :       ansi( "me" );
				ansi2( "cm", 1, y );
                                show_line( SCREEN[y], ATTRIB[y], 1 );
				activate( RTF_attrib );
				ansi2( "cm", x, y );
                                break;
        case CTRL_R     :       show_status( version );
                                show_screen( START );
                                break;
	case CTRL_X	:	ctrlx( f );
				break;
	case CTRL_W	:	ctrlw( f );
				break;
	case CTRL_N	:	ctrln();
				break;
	case CTRL_U	:	ctrlu();
				break;
	case CTRL_T	:	ctrlt();
				break;
	case CTRL_S	:	ctrls();
				break;
	case CTRL_Y	:	ctrly();
				break;
	case CTRL_Q	:	block_set();
				break;
	case TLX_INS	:	
	case INS	:
	case CTRL_V	:	ctrlv();
				break;
	case NUM5	:
	case CTRL_G	:	ctrlg( f );
				break;
	default		:       if(c > 9100){
#ifdef _LOCAL
					show_status( " WENDY: Unbekannte Taste " );
#else
					show_status( " WENDY: Unknown key " );	
#endif
					ansi( "mr" );
					printf("<%d>. ", c);
					ansi( "me" );
					ansi2( "cm", x, y );

					c = 0;
				}
				if(c == '~') c = 0;  

				if((c > 31) && (c < 9100)){
					CHANGED++;
					if(INS_mode == 0){
						printf("%c", c);	
						if(c == ' ') c = BLANK;	
						SCREEN[y][(x-1)] = c;
						ATTRIB[y][(x-1)] = RTF_attrib;
						x++;
						if(x > MAXX){
							if(FORMATTER != 'b')
								x = wordwrap();
							if((y < MAXY) && (y < lastline))
								y++;
							else
								ctrlj();
							ansi2( "cm", x, y );
						}
					}
					else{
						insert( c );
					}
					if(FORMATTER == 'c'){
						center();
					}
					if((ypos + y) > lastline)
					lastline = ypos + y;
				}
    }




    ENDLOOP:

    if(oldy != y){
	if((FLAG[(ypos + y - 1)] & is_richtext) == is_richtext){
#ifdef _LOCAL
		show_status( "Der folgende Text ist klassifiziert als 'text/richtext'." );
#else
		show_status( "The following text is classified as 'text/richtext'.");
#endif
	}
	if((FLAG[(ypos + y - 1)] & is_plain) == is_plain){
#ifdef _LOCAL
		show_status( "Der folgende Text ist klassifiziert als 'text/plain'." );
#else
		show_status( "The following text is classified as 'text/plain'.");
#endif
	}
	ansi2( "cm", x, y );
    	/*
	if(CHANGED != 0){
		fprintf(ROLLBACK, "%05.5d %s\n", oldy, (unsigned char *) make_rtf( SCREEN[oldy], ATTRIB[oldy] ));
	}
	*/
    }
    oldy = y;

    if(RULER){
	if(x != xruler){
		if(STATUSM != 0) show_status( version );
		if(xruler != -1){
			ansi( "mr" );
			ansi2( "cm", xruler, 1 );
			printf("%c", version[(xruler - 1)]);
		}
		ansi( "me" );
		xruler = x;
		ansi2( "cm", xruler, 1 );
		printf("%c", version[(xruler - 1)]);
		ansi2( "cm", x, y );
		STATUSM = 0;
		activate( RTF_attrib );
	}
    }

  }while(c != CTRL_X);
}



/* #MA - Wendy main function */

main(argc, argv)
int argc;
unsigned char *argv[];
{
  FILE *fp;

  unsigned char s[LONGSTRING];
  unsigned char *term;
  unsigned char *home;
  int i, j;
  int RTF = 0;

#if defined(_ESTDIO) || !defined(_SYS7)
  setbuf(stdout, NULL);
#endif

  RTF_attrib = '0';

  SCANTEST = 0;

  MAXX = 79;	/* Default Parameter */
  MAXY = 24;

  term = (unsigned char *) getenv("TERM");
  strcpy(terminal, (unsigned char *) term);
  strcpy(umlaut, (unsigned char *) "ibm" );

  wBS  = 8;
  wDEL = 9152; 
  wINS = 9151;
  wEND = 9189; 
 
  home = (unsigned char *) getenv( "HOME" );
  sprintf(s, "%s/.wendy", home);

  
  signal( SIGTERM, SIG_IGN );
  signal( SIGQUIT, sig_catch );
  signal( SIGINT,  SIG_IGN );

  fp = fopen( s, "r" );
  if(fp != NULL){
	fgets(s, 80, fp); MAXY = atoi(s);
	fgets(s, 80, fp); MAXX = atoi(s);
	fgets(s, 80, fp); sscanf(s, "%s", &terminal);
	fgets(s, 80, fp); sscanf(s, "%s", &umlaut);	
	fgets(s, 80, fp); wBS = atoi(s);
	fgets(s, 80, fp); wDEL = atoi(s);
	fgets(s, 80, fp); wINS = atoi(s);
	fgets(s, 80, fp); wEND = atoi(s);
	fclose(fp);
  }
  if(MAXY > 24) MAXY = 24;
  if(MAXY <  4) MAXY =  4;
  
  if(MAXX < 10) MAXX = 80;


  ansi2( terminal, -1, -1 );
  i = ansi2( "cm" );
  ansi( "cl" );
#ifdef _LOCAL
  printf("\n\nMein Name ist "); 
#else
  printf("\n\nMy name is ");
#endif
  ansi( "md" ); printf("Wendy");
  ansi( "me" ); printf("!\n\n");


  if((i == 1) || (i == -1)){
#ifdef _LOCAL
	printf("Und ich kann Dein Terminal nicht bedienen!\n\n");
#else
	printf("And I can't handle your terminal!\n\n");
#endif
	return;
  }
 
  if(argc < 2){
#ifdef _LOCAL
	printf("Und Du hast vergessen einen Dateinamen anzugeben!\n\n");
#else
	printf("And you've forgotten to mention a filename!\n\n");
#endif
	return;
  }
  /*
  sprintf(s, "/usr/tmp/WENDY.%d", getpid());
  ROLLBACK = fopen( s, "w" );
  if(ROLLBACK == NULL){
	printf("Rollback ???");
  }
  fprintf(ROLLBACK, "00000 %s, %s [%s] on %s\n\n", mydate( 0 ), mytime( 0 ), whoami(), ttyna());
  */
  lastline = 2;
  NEU = 0;
  RTF_toggle = 0;

  i = LINELENGTH -2;

  fp = fopen( argv[1], "r" );
  if(fp != NULL){
	FLAG[lastline] = 0;
	while(fgets(TEXT[lastline], i, fp) != 0){
		FLAG[lastline+1] = 0;
		if(strcomp("Content-Type: text/richtext", TEXT[lastline]) == 0){
			FLAG[lastline] |= is_richtext;
			lastline--;
		}
		if(strcomp("Content-Type: text/plain", TEXT[lastline]) == 0){
			FLAG[lastline] |= is_plain;
			lastline--;
		}
		lastline++;
		if(lastline > MAXLINES){
#ifdef _LOCAL
			printf("Und die Datei <%s> ist zu gross fuer mich!\n\n", argv[1]);
#else
			printf("And the file <%s> is much too big for me!\n\n", argv[1]);
#endif
			fclose(fp);
			return;
		}
	}
	  fclose(fp);
  }
  else{
	NEU++;
	RTF_toggle++;
	for(i = 0; i < 25; i++){
		strcpy(TEXT[i], (unsigned char *) "\n");
		FLAG[i] = 0;
	}
	lastline += 25;
  }
  strcpy(TEXT[lastline], (unsigned char *) "\n");
  strcpy(version, (unsigned char *) VERSION);
  show_status( version );
 
  INS_mode     = 0;
  CHANGED      = 0;
  REALLY       = 0;
  MARK	       = 0;
  START	       = 2;
  RULER	       = 0;
  STATUSM      = 0;
  FORMATTER    = 0;
  BLOCK.status = 0;

  x = 1; y = START; ypos = 1;
  
  prep_screen( ypos );
  show_screen( START );
 
  echo( 0 );
  loop( argv[1] );
  echo( 1 );
  /*
  fclose( ROLLBACK );
  */

  signal( SIGTERM, SIG_DFL );
  signal( SIGQUIT, SIG_DFL );
  signal( SIGINT,  SIG_DFL );
  
  ansi( "me" );
  ansi2( "cm", 1, MAXY );
  ansi( "ce" );
}
