#!/bin/ksh

PLAYERNAME=${LOGNAME}

if [ "${#}" = '1' ]
then
	PLAYERNAME=${1}
fi

pause()
{
	echo
	echo "[PAUSE]\c"
	read pause
	unset pause
}

yesno()
{
	echo " (Y/n) : \c"
	read YN
}

randomx()
{

	RXN=110
	until [ "${RXN}" -le "${1}" -a "${RXN}" -ge '1' ]
	do
		RXN=`echo ${RANDOM} | cut -c2-3`
	done
}


saveplyr()
{
	if [ -f players.tmp ]
	then
		rm players.tmp
	fi

echo "${EXP},${PLAYERNAME},${REALNAME},${LASTON},${LEVEL},${WEAPON},${ARMOR},\
${STRENGTH},${INTEL},${AGILITY},${WISDOM},${HP},${MAXHP},${POWER},${MAXPOWER},\
${JLEFT},${JWINS},${JLOSS},${FLEFT},${FWINS},${FLOSS},${GLEFT},${GWINS},\
${GLOSS},${GOLDBANK},${GOLDHAND},${CALLSLFT},${TOTCALLS},${FOOD},\
${EXPNEED},${STATUSC}" > players.tmp

	cat dhplyr.dat | grep -v ${PLAYERNAME} >> players.tmp
	rm dhplyr.dat
	sort -rd -o dhplyr.dat players.tmp 
#	cp players.tmp dhplyr.dat
}

saveothr()
{
	if [ -f players.tmp ]
	then
		rm players.tmp
	fi

echo "${O_EXP},${OTHRNAME},${O_REALNAME},${O_LASTON},${O_LEVEL},${O_WEAPON},\
${O_ARMOR},${O_STRENGTH},${O_INTEL},${O_AGILITY},${O_WISDOM},${O_HP},\
${O_MAXHP},${O_POWER},${O_MAXPOWER},${O_JLEFT},${O_JWINS},${O_JLOSS},\
${O_FLEFT},${O_FWINS},${O_FLOSS},${O_GLEFT},${O_GWINS},${O_GLOSS},\
${O_GOLDBANK},${O_GOLDHAND},${O_CALLSLFT},${O_TOTCALLS},${O_FOOD},\
${O_EXPNEED},${O_STATUSC}" > players.tmp

	cat dhplyr.dat | grep -v ${OTHRNAME} >> players.tmp
	rm dhplyr.dat
	sort -rd -o dhplyr.dat players.tmp 
#	cp players.tmp dhplyr.dat
}


readplyr()
{
	IFS=','
	exec 3< dhplyr.dat

	while read -u3 TEXT
	do
		set ${TEXT}
		if [ "${2}" = "${PLAYERNAME}" ]; then
			EXP="${1}"
			REALNAME="${3}"
			LASTON="${4}"
			LEVEL="${5}"
			WEAPON="${6}"
			ARMOR="${7}"
			STRENGTH="${8}"
			INTEL="${9}"
			AGILITY="${10}"
			WISDOM="${11}"
			HP="${12}"
			MAXHP="${13}"
			POWER="${14}"
			MAXPOWER="${15}"
			JLEFT="${16}"
			JWINS="${17}"
			JLOSS="${18}"
			FLEFT="${19}"
			FWINS="${20}"
			FLOSS="${21}"
			GLEFT="${22}"
			GWINS="${23}"
			GLOSS="${24}"
			GOLDBANK="${25}"
			GOLDHAND="${26}"
			CALLSLFT="${27}"
			TOTCALLS="${28}"
			FOOD="${29}"
			EXPNEED="${30}"
			STATUSC="${31}"
		fi
	done

	exec 3<&-
}

readothr()
{
	IFS=','
	exec 3< dhplyr.dat

	while read -u3 TEXT
	do
		set ${TEXT}
		if [ "${2}" = "${OTHRNAME}" ]; then
			O_EXP="${1}"
			O_REALNAME="${3}"
			O_LASTON="${4}"
			O_LEVEL="${5}"
			O_WEAPON="${6}"
			O_ARMOR="${7}"
			O_STRENGTH="${8}"
			O_INTEL="${9}"
			O_AGILITY="${10}"
			O_WISDOM="${11}"
			O_HP="${12}"
			O_MAXHP="${13}"
			O_POWER="${14}"
			O_MAXPOWER="${15}"
			O_JLEFT="${16}"
			O_JWINS="${17}"
			O_JLOSS="${18}"
			O_FLEFT="${19}"
			O_FWINS="${20}"
			O_FLOSS="${21}"
			O_GLEFT="${22}"
			O_GWINS="${23}"
			O_GLOSS="${24}"
			O_GOLDBANK="${25}"
			O_GOLDHAND="${26}"
			O_CALLSLFT="${27}"
			O_TOTCALLS="${28}"
			O_FOOD="${29}"
			O_EXPNEED="${30}"
			O_STATUSC="${31}"
		fi
	done

	exec 3<&-
}

listplyrs()
{
	IFS=','
	XX="${1}"

	exec 3< dhplyr.dat 

	clear
	echo
	echo "Player listing" 
	echo
	echo " Name                           Level        Exp  Status"
	echo "(-------------------------------------------------------)"
	while read -u3 TEXT 
	do
		set ${TEXT}
		if [ "${XX}" -eq 1 -a "${2}" != "${PLAYERNAME}" ]; then
			printf " %-30s %5s %10s  %s\n" ${3} ${5} ${1} ${31}
		else
			printf " %-30s %5s %10s  %s\n" ${3} ${5} ${1} ${31}
		fi
	done

	exec 3<&-
	unset TEXT
}

changename()
{
	echo
	echo "What would you be called, warrior? : \c"
	read XREALNAME
	echo
	echo "You would be called ${XREALNAME}? \c"
	yesno
	if [ "${YN}" = 'Y' -o "${YN}" = 'y' ]
	then
		REALNAME=`echo ${XREALNAME} | tr '[a-z]' '[A-Z]'`
		echo
		echo "Thy name has been noted."
		pause
	else
		REALNAME=`echo ${PLAYERNAME} | tr '[a-z]' '[A-Z]'`
	fi
	
	saveplyr
	unset XREALNAME
}

readarmor()
{
	XX=0
	IFS=','

	MAX=${1}

	exec 3< equip.dat
	while [ "${XX}" -lt "${MAX}" ]
	do
		read -u3 TEXT
		XX=`expr ${XX} + 1`
	done 
	exec 3<&-
	set ${TEXT}
	ARMORX="${2}"
	unset TEXT
}

readweapon()
{
	XX=0
	IFS=','

	MAX=${1}

	exec 3< equip.dat
	while [ "${XX}" -lt "${MAX}" ]
	do
		read -u3 TEXT
		XX=`expr ${XX} + 1`
	done 
	exec 3<&-
	set ${TEXT}
	WEAPONX="${1}"
	unset TEXT
}

readmonsters()
{
	XX=0

	MAX=${1}

	exec 3< monsters.dat
	while [ "${XX}" -lt "${MAX}" ]
	do
		read -u3 MONSX
		XX=`expr ${XX} + 1`
	done
	exec 3<&-
	unset MAX
}

checkexp()
{
	while [ "${EXPNEED}" -lt '1' ]; do
		LEVEL=`expr ${LEVEL} + 1`
		EXPNEED=`expr ${EXP} \* ${EXP} \* 100`
		echo
		echo "The King recognizes your acomplishments."
		echo "He gives you a choice: "
		echo ""
		echo "(A) Increase Strength"
		echo "(B) Increase Intelligence"
		echo "(C) Increase Agility"
		echo "(D) Increase Wisdom"
		echo
		echo "Choice -)> \c"
		read TEXT
		case ${TEXT} in
			a|A)	STRENGTH=`expr ${STRENGTH} + 5`	;;
			b|B)	INTEL=`expr ${INTEL} + 5`			;;
			c|C)	AGILITY=`expr ${AGILITY} + 5`		;;
			d|d)	WISDOM=`expr ${WISDOM} + 5`		;;
		esac
		saveplyr
	done
}

status()
{
	readweapon ${WEAPON}
	readarmor ${ARMOR}
	JSKILL=`expr ${STRENGTH} + ${AGILITY} + ${JWINS} - ${JLOSS}`
	FSKILL=`expr ${INTEL} + ${AGILITY} + ${FWINS} - ${FLOSS}`
	EXPNEED=`expr ${LEVEL} \* ${LEVEL} \* 100`
	EXPNEED=`expr ${EXPNEED} - ${EXP}`
	clear
	printf "Real Name   : %-34sLevel       : %s\n" ${REALNAME} ${LEVEL}
	printf "Calls Left  : %-34sExperience  : %s\n" ${CALLSLFT} ${EXP}
	printf "Total Calls : %-34sExp. Needed : %s\n" ${TOTCALLS} ${EXPNEED}
	echo
	echo "Strength    : ${STRENGTH}\t\t\t\tGold in Hand: ${GOLDHAND}"
	echo "Agility     : ${AGILITY}\t\t\t\tGold in Bank: ${GOLDBANK}"
	echo "Wisdom      : ${WISDOM}\t\t\t\tPower       : ${POWER}/${MAXPOWER}"
	echo "Intelligence: ${INTEL}\t\t\t\tHitpoints   : ${HP}/${MAXHP}"
	echo
	echo "Joust wins  : ${JWINS}\t\t\t\t\tFence wins  : ${FWINS}"
	echo "Joust losses: ${JLOSS}\t\t\t\t\tFence losses: ${FLOSS}"
	echo "Joust skill : ${JSKILL}\t\t\t\tFence skill : ${FSKILL}"
	echo
	echo "Fights left : ${GLEFT}\t\t\t\t\tFood        : ${FOOD}"
	echo "Jousts left : ${JLEFT}\t\t\t\t\tWeapon      : ${WEAPONX} #${WEAPON}"
	echo "Fences left : ${FLEFT}\t\t\t\t\tArmor       : ${ARMORX} #${ARMOR}" 
	echo
	pause
}


newguy()
{
	
	REALNAME=${PLAYERNAME}
	LASTON=`date +%Y%m%d`
	LEVEL=1
	WEAPON=1
	ARMOR=1
	STRENGTH=10
	INTEL=10
	AGILITY=10
	WISDOM=10
	HP=20
	MAXHP=20
	POWER=20
	MAXPOWER=20
	JLEFT=6
	JWINS=0
	JLOSS=0
	FLEFT=6
	FWINS=0
	FLOSS=0
	GLEFT=6
	GWINS=0
	GLOSS=0
	GOLDBANK=0
	GOLDHAND=200
	CALLSLFT=2
	TOTCALLS=1
	FOOD=100
	EXP=1
	EXPNEED=`expr ${EXP} \* ${EXP} \* 100`
	EXPNEED=`expr ${EXPNEED} - ${EXP}`
	STATUSC="ALIVE"
	saveplyr	
}

checkplyr()
{
	readplyr
	HP="${MAXHP}"
	POWER="${MAXPOWER}"
	STATUSC="ALIVE"
	TOTCALLS=`expr ${TOTCALLS} + 1`
	FLEFT=6
	GLEFT=6
	JLEFT=6
	if [ "${LASTON}" != "${THEDATE}" ]; then
		CALLSLFT=3
	fi
	if [ "${CALLSLFT}" -gt 0 ]; then
		CALLSLFT=`expr ${CALLSLFT} - 1`
		echo
		echo "Welcome back, ${PLAYERNAME}"
		echo
		checkexp
	else
		echo
		echo "Warrior, you must wait for another moon."
		echo
		pause
		exit 3
	fi
	LASTON=${THEDATE}
	saveplyr
}


init()
{

	THEDATE=`date +%Y%m%d`
	if [ -f dhplyr.dat -a `cat dhplyr.dat | grep -c ${PLAYERNAME}` -eq 1 ]
	then	
		checkplyr
		echo "Welcome back, ${PLAYERNAME}"
	else
		echo "Welcome, ${PLAYERNAME}"
		 newguy
	fi

	pause
}

bank()
{
	echo
	echo
	echo "TREASURY"
	echo 
	echo "(W)ithdraw, (D)eposit -)> \c"
	read WD
	if [ "${WD}" = 'W' -o "${WD}" = 'w' ]; then
		if [ "${GOLDBANK}" -ge 1 ]; then
			GOLDHAND=`expr ${GOLDHAND} + ${GOLDBANK}`
			GOLDBANK=0
			echo
			echo
			echo "You have ${GOLDHAND} gold pieces in your hand."
		else	
			echo
			echo
			echo "You don't have any gold in the bank."
		fi
	else
		if [ "${GOLDHAND}" -ge 1 ]; then
			GOLDBANK=`expr ${GOLDBANK} + ${GOLDHAND}`
			GOLDHAND=0
			echo
			echo
			echo "You have ${GOLDBANK} gold pieces in the bank."
		else
			echo
			echo
			echo "You don't have any gold in you hands."
		fi
	fi
	saveplyr
	pause
	unset WD
}

listwa()
{

	COST=0
	
	echo
	echo "Start at? : \c"
	read SA
	if [ "${SA}" -gt 0 -a "${SA}" -lt 26 ]
	then
		echo
		echo "##\tWeapon\t\t\tArmor\t\t\t   Cost"
		echo "(---------------------------------------------------------------------)"
		while [ "${COST}" -lt "${GOLDHAND}" ]
		do
			COST=`expr ${SA} \* ${SA} \* 100`
			readweapon "${SA}"
			readarmor "${SA}"
			printf "%2d      %-20s    %-20s %10s\n" ${SA} ${WEAPONX} ${ARMORX} ${COST}
			SA=`expr ${SA} + 1`
		done
	fi
		
	unset SA
}

buywa()
{
	echo
	echo "Buy [W]eapon or [A]rmor? : \c"
	read WA
	echo "Buy which Item? : \c"
	read ITEM
	COST=`expr ${ITEM} \* ${ITEM} \* 100`
	if [ "${GOLDHAND}" -ge "${COST}" ]
	then
		echo
		if [ "${WA}" = 'W' -o "${WA}" = 'w' ]
		then
			if [ "${ITEM}" -gt "0" -a "${ITEM}" -lt "101" ]
			then
				readweapon ${ITEM}
				echo "Buy ${WEAPONX}? \c"
				yesno
				if [ "${YN}" = 'Y' -o "${YN}" = 'y' ]
				then
					GOLDHAND=`expr ${GOLDHAND} - ${COST}`
					WEAPON=${ITEM}
					saveplyr
				else
					echo "Maybe later then?"
				fi
			else
				echo "Invalid item number."
			fi
		else
			if [ "${ITEM}" -gt "0" -a "${ITEM}" -lt "101" ]
			then
				readarmor ${ITEM}
				echo "Buy ${ARMORX}? \c"
				yesno
				if [ "${YN}" = 'Y' -o "${YN}" = 'y' ]
				then
					GOLDHAND=`expr ${GOLDHAND} - ${COST}`
					ARMOR=${ITEM}
					saveplyr
				else
					echo "Mabe later then?"
				fi
			else
				echo "Invalid item number."
			fi
		fi
	else
		echo
		echo "You don't have enough gold pieces!"
	fi
	unset ITEM WA
}

sellwa()
{
	echo
	echo "Sell which? [W]eapon or [A]rmor? : \c"
	read WA
	if [ "${WA}" = 'W' -o "${WA}" = 'w' ]
	then
		COST=`expr ${WEAPON} \* ${WEAPON} \* 100`
		COST=`expr ${COST} / 2`
		echo
		echo "I'll give you ${COST} gold pieces, ok? \c"
		yesno
		if [ "${YN}" = 'Y' -o "${YN}" = 'y' ]
		then
			echo
			echo "Done!"
			GOLDHAND=`expr ${GOLDHAND} + ${COST}`
			WEAPON=1
			saveplyr
		else
			echo
			echo "Maybe later then?"
		fi
	else
		COST=`expr ${ARMOR} \* ${ARMOR} \* 100`
		COST=`expr ${COST} / 2`
		echo
		echo "I'll give you ${COST} gold pieces, ok? \c"
		yesno
		if [ "${YN}" = 'Y' -o "${YN}" = 'y' ]
		then
			echo
			echo "Done!"
			GOLDHAND=`expr ${GOLDHAND} + ${COST}`
			ARMOR=1
			saveplyr
		else
			echo
			echo "Maybe later then?"
		fi
	fi

	unset WA

}

armory()
{

	while true
	do
		echo
		echo "You have ${GOLDHAND} Gold."
		echo "<B>uy,<S>ell, or <L>ist : \c"
		read BSL
		case ${BSL} in
			b|B)		buywa	;;
			s|S)		sellwa	;;
			l|L)		listwa	;;
			q|Q)		return	;;
			*)  		return	;;
		esac
	done
	unset BSL
}

clerics()
{
	COST=`expr ${LEVEL} \* ${LEVEL}	\* 10`
	NTH=`expr ${MAXHP} - ${HP}`
	AFT=`expr ${GOLDHAND} / ${COST}`

	if [ "${NTH}" -le "${AFT}" ]; then
		MCH=${NTH}
	else
		MCH=${AFT}
	fi
	echo
	echo "You enter a hut. A cleric says it will"
	echo "cost ${COST} Gold to heal 1 Hit Point."
	echo "You have ${NTH} points to heal."
	echo "You can afford to heal ${AFT} points."
	
	if [ "${HP}" -lt "${MAXHP}" ]; then
		echo
		echo "Heal how many? [${MCH}]: \c"
		read TEXT
		if [ "${TEXT}" = "" ]; then
			HP=`expr ${HP} + ${MCH}`
			GOLDHAND=`expr ${GOLDHAND} - ${COST} \* ${MCH}`
			saveplyr
		else
			echo
			if [ "${TEXT}" -le "${MCH}" -a "${TEXT}" -gt "0" ]
			then
				HP=`expr ${HP} + ${TEXT}` 
				GOLDHAND=`expr ${GOLDHAND} - ${COST} \* ${TEXT}`
				saveplyr
			else
				echo
				echo "Invalid input."
			fi
		fi
	else
		echo
		echo "You don't need any!"
	fi

	unset COST MCH AFT TEXT NTH
}

townsquare()
{
	while true
	do
		echo "Town Square"
		echo
		echo "(A) Armor"
		echo "(B) Market Square"
		echo "(C) Clerics"
		echo "(D) Spells"
		echo
		echo "Command -)> \c"
		read CH1
		case ${CH1} in
			a|A)	armory	;;
			c|C)	clerics	;;
			q|Q)	unset CH1
					return	;;
			*)		unset CH1
					return	;;
		esac
	done
}

makemons()
{

	BASE=${1}
	LEV=${1}
	BASE=`expr ${BASE} - 1`
	BASE=`expr ${BASE} \* 20`
	randomx 20
	MONS=`expr ${BASE} + ${RXN}`
	readmonsters ${MONS}
	randomx 15
	M_AGILITY=`expr ${LEV} \* ${RXN}`
	randomx 15
	M_GOLD=`expr ${LEV} \* ${LEV} \* ${RXN} \* 10`
	randomx 20
	M_HP=`expr ${LEV} \* ${RXN}` 
	M_WEAPON=`expr ${LEV} - 1`
	randomx 3
	M_WEAPON=`expr ${M_WEAPON} + ${RXN}`
	M_ARMOR=`expr ${LEV} - 1`
	randomx 3
	M_ARMOR=`expr ${M_ARMOR} + ${RXN}`
	randomx 10
	M_EXP=`expr ${LEV} \* ${LEV} \* ${RXN} + ${LEV}`
	
}

fightmons()
{
	echo
	echo "Room #${1}"
	echo
	echo "a Visious ${MONSX} attacks you!"
	echo
	if [ "${M_AGILITY}" -gt "${AGILITY}" ]
	then
		TURN=0
		echo "It gets first attack."
	else
		echo "You get first attack."
		TURN=1
	fi
	
	while [ "${HP}" -gt 0 -a "${M_HP}" -gt 0 ]; do
		if [ ${TURN} -eq 0 ]; then
			randomx 20
			DAMAGE=`expr ${M_WEAPON} \* ${LEV} - ${ARMOR} \* ${LEVEL} \* ${RXN}`
			if [ "${DAMAGE}" -lt '1' ]; then
				echo "It misses you completely"
			else

				HP=`expr ${HP} - ${DAMAGE}`
				echo "It hits you for ${DAMAGE} damage."
			fi
			if [ "${HP}" -lt '1' ]; then
				echo "It killed you!"
				echo "It takes your gold!"
				GOLDHAND=0
				STATUSC="DEAD"
				saveplyr
				exit 0
			fi
		fi
		echo
		echo "<F>ight, <C>ast, <S>tats )> \c"
		read FC
		case ${FC} in
			f|F)
				TURN=0
				randomx `expr ${LEVEL} \* ${LEVEL} \* 10`
				DAMAGE=`expr ${WEAPON} \* ${LEVEL}`
				DAMAGE=`expr ${DAMAGE} - ${M_ARMOR}`
				DAMAGE=`expr ${DAMAGE} \* ${LEV}`
				DAMAGE=`expr ${DAMAGE} + ${RXN}`
				if [ "${DAMAGE}" -lt '1' ]; then
					DAMAGE=0
					echo "You miss it completely!"
				else
					echo "You hit it for ${DAMAGE} damage."
					M_HP=`expr ${M_HP} - ${DAMAGE}`
				fi
				if [ "${M_HP}" -lt '1' ]; then
					echo "You killed it!"
					echo "You receive ${M_EXP} experience."
					EXP=`expr ${EXP} + ${M_EXP}`
					EXPNEED=`expr ${EXPNEED} - ${EXP}`
					echo "You find ${M_GOLD} gold."
					GOLDHAND=`expr ${GOLDHAND} + ${M_GOLD}`
					if [ "${M_WEAPON}" -gt "${WEAPON}" ]; then
						echo "You take it's weapon!"
						WEAPON=${M_WEAPON}
					fi
					if [ "${M_ARMOR}" -gt "${ARMOR}" ]; then
						echo "You take it's armor!"
						ARMOR=${M_ARMOR}
					fi
					saveplyr
					echo; echo; echo
				fi
				;;
			c|C)
				echo "Casting..."
				;;
			s|S) 	status	;;
		esac	
	done
} 

pground()
{
	if [ "${GLEFT}" -lt '1' ]; then
		echo
		echo "You don't have any fights left for today."
		echo
		pause
		return
	fi
	if [ "${1}" = "ALL" ]; then
		echo "This will use all your fights.\c"
		yesno
		if [ "${YN}" = 'y' -o "${YN}" = 'Y' ]
		then
			ROOM=-1
			while [ "${ROOM}" -lt '1' ]; do
				echo
				echo "Start in which room? [1-240]: \c"
				read ROOM
				if [ "${ROOM}" -lt '1' -o "${ROOM}" -gt '240' ]; then
					echo
					echo "Invalid room number."
				fi
			done
			GLEFT=0
			COUNT=20
		else
			return
		fi
	else	
		COUNT=1
		GLEFT=`expr ${GLEFT} - 1`
		echo
		echo "Enter creature level [1-12] )> \c"
		read BASE 
		if [ "${BASE}" -gt 0 -a "${BASE}" -le 12 ]; then
			BASE=`expr ${BASE} - 1`
			randomx 20
			ROOM=`expr ${BASE} + ${RXN}`
		fi
	fi
	while [ "${COUNT}" -gt 0 ]; do
		makemons ${ROOM}
		fightmons ${ROOM}
		COUNT=`expr ${COUNT} - 1`
		ROOM=`expr ${ROOM} + 1`
		if [ "${COUNT}" -eq '10' ]; then
			echo
			echo "You see an exit.  Take it? \c"
			yesno
			if [ "${YN}" = 'Y' -o "${YN}" = 'y' ]; then
				COUNT=0
			fi
		fi 
	done
	checkexp
}

fight_menu()
{
	echo
}


dungeon_menu()
{
	while true
	do
		echo "THE DUNGEONS"
		echo
		echo "(F)ight a Warrior"
		echo "(P)roving Grounds"
		echo "(D)ungeon of Doom"
		echo
		echo "The Dungeons -> \c"
		read CH1
		case ${CH1} in
			f|F)	fight_menu	;;
			P|p)	pground	;;
			d|D)	pground ALL ;;
			*)		unset CH1
					return	;;
		esac
	done
}

joustfence()
{

	if [ "${1}" = "J" ]; then
		JFTXT="joust"; 
	else
		JFTXT="Fence"
	fi
	listplyrs 1
	echo 
	echo "${JFTXT} who? : \c"
	read O_REALNAME
	O_REALNAME=`echo ${O_REALNAME} | tr '[a-z]' '[A-Z]'`
	if [ "${O_REALNAME}" != "" ]; then
		YN="Y"
		readothr
		while [ "${YN}" = 'Y' -o "${YN}" = 'y' ]; do
			if [ "${1}" = "J" ]; then
				XWINS=${JWINS}; XLOSS=${JLOSS}; XLEFT=${JLEFT}
				O_XWINS=${O_JWINS}; O_XLOSS=${O_JLOSS}; O_XLEFT=${O_JLEFT}
				JSKILL=`expr ${STRENGTH} + ${AGILITY} + ${JWINS} - ${JLOSS}`
				XSKILL=${JSKILL}
			else
				XWINS=${FWINS}; XLOSS=${FLOSS}; XLEFT=${FLEFT}
				O_XWINS=${O_FWINS}; O_XLOSS=${O_FLOSS}; O_XLEFT=${O_FLEFT}
				FSKILL=`expr ${INTEL} + ${AGILITY} + ${FWINS} - ${FLOSS}`
				XSKILL=${FSKILL}
			fi
			echo
			echo "${O_REALNAME}"
			echo "======================================================="
echo "His ${JFTXT} wins : ${O_XWINS}\t\t Your ${JFTXT} wins : ${XWINS}"
echo "His ${JFTXT} loses: ${O_XLOSS}\t\t Your ${JFTXT} loses: ${XLOSS}"
echo "His ${JFTXT} skill: ${O_XSKILL}\t\t Your ${JFTXT} skill: ${XSKILL}"
			echo "======================================================="
			echo
			echo "${JFTXT} ${O_REALNAME}? :\c"
			yesno
			
		done
	else
		echo
		echo "Unable to find ${O_REALNAME}"
		pause
	fi
	
}

mainmenu()
{
	while true
	do
		clear
		printf "Dragon's Hoard Main Menu\n"
		echo "-------------------------"
		echo
		echo "\t(A) Market Square"
		echo "\t(C) Change Name"
		echo "\t(D) Dungeon of Doom"
		echo "\t(K) Treasury"
		echo "\t(L) List Warriors"
		echo "\t(S) Status"
		echo "\t(K) Treasury"
		echo "\t----------------"
		echo "\t(Q) Quit"
		echo
		echo "TL[15] -)> \c"
		read CH
		case ${CH} in
			a|A)	townsquare	;;
			c|C)	changename	;;
			d|D)	dungeon_menu	;;
			f|F)	joustfence F	;;
			j|J)	joustfence J	;;
			k|K)	bank	;;			
			l|L)	listplyrs
					pause	;;
			q|Q)	
					echo "Exit the Dragon's Hoard? \c"
					yesno
					if [ "${YN}" = 'y' -o "${YN}" = 'Y' ]; then
						saveplyr
						exit 0
					fi
					;;
			s|S)	status	;;
		esac
	done
}

init
mainmenu
