#!/bin/bash
#
#  Script for the Utilities Menu.
#
DONE=nope
while [ $DONE = nope ]
do
	clear
if ! [ -f $MENU_PATH/utility.menu ]
then
	echo "Missing Utility Menu - contact Sysop..."
	echo "Missing Utility Menu for $LOGNAME" >> $ETC_PATH/sysop.log
	exit
fi
cat $MENU_PATH/utility.menu
DefaultColour
echo -n "Command> "
read SELECTION
echo "$USER selected '$SELECTION' from Utilities Menu" >> $ETC_PATH/sysop.log
case $SELECTION in

# ----------------------------------------------------------------
# code for Utility Menu option Q (Quit to Main)
 
Q | q | M | m ) 
	DONE=yup
	exit 
	;;

# end of code for Utility Menu option Q
# -----------------------------------------------------------------
# code for Utility Menu option F (Lookup a user)

F | f )
	echo 
	echo -n "username: "
	read NAME
	echo "$USER looked up user '$NAME' from the Utility Menu" >> $ETC_PATH/sysop.log	
	echo 
	finger $NAME
	echo
	pause
	;;

# end of code for Utility Menu option F
# -------------------------------------------------------------------
# code for Utility Menu option S (System Uptime)

S | s )
	echo 
	uptime
	echo
	pause
	;;

# end of code for Utility Menu option S
# --------------------------------------------------------------------
# code for Utility Menu option L (List of Users)

L | l )
	if [ -f $DOC_PATH/bbsusers.ans ]
	then
		more -d $DOC_PATH/bbsusers.ans
		echo
		pause
	else
		echo "The List of Users file does not exist" >> $ETC_PATH/sysop.log
	fi
	;;

# end of code for Utility Menu option U
# ---------------------------------------------------------------------
# code for Utility Menu option P (Change your Password)

P | p )
	echo 
	passwd
	echo
	pause
	;;

# end of code for Utility Menu option C
# -----------------------------------------------------------------------
# code for Utility Menu option D (Change your Default Colour)

D | d )
	if [ -f $DOC_PATH/colours.ans ]
	then
		echo
		cat $DOC_PATH/colours.ans
		echo -n "=> "
		read SELECTION
		echo "$USER selected colour number: $SELECTION" >> $ETC_PATH/sysop.log
		case $SELECTION in
		1 ) rm $HOME/*.default ; cp $LIB_PATH/1.default $HOME ;;
		2 ) rm $HOME/*.default ; cp $LIB_PATH/2.default $HOME ;;
		3 ) rm $HOME/*.default ; cp $LIB_PATH/3.default $HOME ;;
		4 ) rm $HOME/*.default ; cp $LIB_PATH/4.default $HOME ;;
		5 ) rm $HOME/*.default ; cp $LIB_PATH/5.default $HOME ;;
		6 ) rm $HOME/*.default ; cp $LIB_PATH/6.default $HOME ;;
		7 ) rm $HOME/*.default ; cp $LIB_PATH/7.default $HOME ;;
		8 ) rm $HOME/*.default ; cp $LIB_PATH/8.default $HOME ;;
		9 ) rm $HOME/*.default ; cp $LIB_PATH/9.default $HOME ;;
		10 ) rm $HOME/*.default ; cp $LIB_PATH/10.default $HOME ;;
		11 ) rm $HOME/*.default ; cp $LIB_PATH/11.default $HOME ;;
		12 ) rm $HOME/*.default ; cp $LIB_PATH/12.default $HOME ;;
		13 ) rm $HOME/*.default ; cp $LIB_PATH/13.default $HOME ;;
		14 ) rm $HOME/*.default ; cp $LIB_PATH/14.default $HOME ;;
		esac
	fi	
	;;

# end of code for Utility Menu option D
# ----------------------------------------------------------------
# code for Utility Menu option H (HIDE/UNHIDE your real name)

H | h )
	echo
	echo -n "Do you want to have your Real Name HIDDEN to other users? (Y/N) " 
	read SELECTION
	case $SELECTION in
	Y | y )  
		echo
		echo "Changing your entry to: '$USER'"
		echo
		chfn -f $USER
		echo
		pause
		;;
	
	N | n )
		echo
		echo -n "Then enter your Name here: "
		read REALNAME
		echo
		chfn -f "$REALNAME"
		echo
		pause
		;;
	esac
	;;

# end of code for Utility Menu option N
# -----------------------------------------------------------------
# code for Utility Menu option C (Change your Comment)

C | c )
	cat $LIB_PATH/14.default
	echo "Enter your New Comment. (or Hit ENTER to delete it)"  
	echo "** NOTE: backspaces may show up"
	DefaultColour
	read NEWCOMMENT
	if [ -f $HOME/.plan ] 
	then
		rm $HOME/.plan
	fi
	echo "$USER changed their comment to: $NEWCOMMENT" >> $ETC_PATH/sysop.log
	echo $NEWCOMMENT > $HOME/.plan
	if [ $? = 0 ]
	then
		cat $LIB_PATH/14.default
		echo "Your Comment has been Changed."
		pause
	fi
	;;

# end of code for Utility Menu option C
# -------------------------------------------------------------------
# code for Utility Menu option T (Toggle Page status ON/OFF)

T | t )
	DefaultColour
	echo "You current Page Status $(mesg)."
	echo
	echo -n "Change this to [y]es or [n]o? (y/n) "
	read SELECTION
	echo "$USER changed Page Status to [$SELECTION]" >> $ETC_PATH/sysop.log
	mesg $SELECTION
	;;

# End of code for Utility Menu option T
# -----------------------------------------------------------------
# code for Utility Menu option B (Bypass Initial Login Screens)

B | b )
	if [ -f $HOME/nologinscreens ]
	then
		DefaultColour
	    	echo "Display screens are Disabled for you at login"
	    	echo -n "Do you wish to Enable this? [y/n]: "
	    	read RESPONSE
	    	if [ "$RESPONSE" = "y" -o "$RESPONSE" = "Y" ]
	    	then
			echo
			rm $HOME/nologinscreens
			echo "Display screens are now Enabled for you at login"
			echo "$USER Enabled display screens at login" >> $ETC_PATH/sysop.log
			echo
			pause
	    	fi
	else
		DefaultColour
	   	echo "Display screens are Enabled for you at login"
	    	echo -n "Do you wish to Disable this? [y/n]: "
	    	read RESPONSE
	    	if [ "$RESPONSE" = "y" -o "$RESPONSE" = "Y" ]
	    	then
			echo
			touch $HOME/nologinscreens
			echo "Display screens are now Disabled for you at login"
			echo "$USER Disabled display screens at login" >> $ETC_PATH/sysop.log
			echo
			pause
	    	fi
	fi
	;;

# end of code for Utility Menu option B
# ----------------------------------------------------------------
# code for other hack attempts

??*)
	echo
	echo "NO  You can't grab a shell like that, DUMMY!"
	echo -e "\033[10;25]\033[11;1500]\007"
	pause
	;;

# end of code for other hack attempts
# -----------------------------------------------------------------

esac
done

exit
