#/bin/bash
#
#  Script for the Sysop Menu.
#
DONE=nope
while [ $DONE = nope ]
do
	clear
if ! [ -f $MENU_PATH/sysop.menu ]
then
	echo "Missing Sysop Menu - contact sysop..."
	echo "Missing Sysop Menu for $LOGNAME" >> $ETC_PATH/sysop.log
	exit
fi
cat $MENU_PATH/sysop.menu
DefaultColour
echo -n "Command> "
read SELECTION
echo "$USER selected '$SELECTION' from Sysop Menu" >> $ETC_PATH/sysop.log
case $SELECTION in 

# ----------------------------------------------------------------
#  code for Sysop Menu option Q, M (Quit to Main Menu)

Q | q | M | m ) 
	DONE=yup
	exit 
	;;

#  end of code for Sysop Menu option Q, M  
# -----------------------------------------------------------------
#  code for Sysop Menu option L (LinuxConf) 

L | l )
	linuxconf 2>/dev/null	# Your release of Linux may not have
	if ! [ $? = 0 ] 	# LinuxConfig, you may have to change this
	then
		echo 
		echo "You are not able to run LinuxConfig."
		echo "This is probably because you don't have permissions to do so."
		echo "Contact the sysop to grant you access."
		echo
		pause
	fi
	;;

# end of code for Sysop Menu option L 
# -----------------------------------------------------------------
# code for Sysop Menu option UNIX (Exit to UNIX)

UNIX | unix )
	echo 
	echo "Current directory is $(pwd)"
	echo "Type 'exit' to return ..." 
	echo
	bash -rcfile $ETC_PATH/.bashrc
	echo "*** Log of commands typed: ***" >> $ETC_PATH/sysop.log
	cat $HOME/.bash_history >> $ETC_PATH/sysop.log
	rm $HOME/.bash_history
	;;

# end of code for Sysop Menu option UNIX 
# ---------------------------------------------------------------
# code for Sysop Menu option LASTB (List Bad Logon Attempts)

LASTB | lastb )
	echo 
	echo -n "List bad attempts for current day? (Y/N) [N for all days] "
	read CHOICE
	echo "$USER selected '$CHOICE' for Current day or all days" >> $ETC_PATH/sysop.log
	case $CHOICE in
	Y | y )
		AAA=$(date +%a)
		BBB=$(date +%b)
		CCC=$(date +%d)
		lastb | grep $AAA | grep $BBB | grep $CCC | more -d
		echo
		pause
		;;

	N | n )
		echo
		lastb | more -d
		echo
		pause
		;;		
	esac
	;;	
	
# end of code for Sysop Menu option LASTB
# ------------------------------------------------------------------
# code for Sysop Menu option S (View Sysop Log)

S | s )
	echo
	nl -w1 $ETC_PATH/sysop.log | more -d
	echo
	pause
	;;

# end of code for Sysop Menu option S
# --------------------------------------------------------------------
# code for Sysop Menu option Y (View Mgetty Log)

Y | y )
	echo
	more -d /var/log/mgetty.log.tty*	# If you have more than
	echo					# 1 line, you may want to
	pause					# change things here a bit
	;;

# end of code for Sysop Menu option Y
# -------------------------------------------------------------------
# code for Sysop Menu option V (View System Log)

V | v )
	echo
	more -d /var/log/messages
	echo
	pause
	;;

# end of code for Sysop Menu option V
# --------------------------------------------------------------------
# code for Sysop Menu option U (View User Information Log)

U | u )
	echo
	more -d $INFO_PATH/user.list
	echo
	pause
	;;

# end of code for Sysop Menu option U
# ---------------------------------------------------------------------

esac
done

exit
