#!/bin/bash
#
#  Script for the Message Menu.       
#

DONE=nope
while [ $DONE = nope ] 
do
	clear
if ! [ -f $MENU_PATH/message.menu ]
then
	echo "Missing Message Menu - contact Sysop..."
	echo "Missing Message Menu for $LOGNAME" >> $ETC_PATH/sysop.log
	exit
fi
	cat $MENU_PATH/message.menu
	DefaultColour
	echo -n "Command> "
	read SELECTION
	echo "$USER selected '$SELECTION' from Message Menu" >> $ETC_PATH/sysop.log
	case $SELECTION in 

#-----------------------------------------------------------------------
# code for File Menu option Q (Quit to Main)

Q | q | M | m )
	DONE=yup
	exit 
	;;

# end of code for Message Menu option Q
#------------------------------------------------------------
# code for File Menu option D (Download attached File)

D | d )
	while [ $DONE=nope ] 		# All this subloop does is prevent
	do				# breaking out of the main loop.
		echo
		echo -n "Filename to Download from Home directory: "
		read FILE
		if echo $FILE | egrep "passwd|../" >/dev/null
		then
			cat $LIB_PATH/11.default
			echo "It doesn't work that way,  DUMMY!"
			echo -e "\033[10;25]\033[11;1500]\007"
			DefaultColour
			pause
			break
		fi
		FILE=$(echo $FILE | awk '{print $1}' | sed 's/\///g')		
		if ! [ -f $HOME/$FILE 2>/dev/null ]
		then
			cat $LIB_PATH/10.default
			echo "File $FILE not found in your Home directory" 
			echo "-File [$FILE] not found in Home directory" >> $ETC_PATH/sysop.log
			pause
			break
		fi 	
		cat $LIB_PATH/11.default
		echo
		echo "<Z>..ZMODEM		(Dialup)"
		echo "<Y>..YMODEM		(Dialup)"
		echo "<X>..XMODEM		(Dialup)"
		echo "<1>..XMODEM-1K		(Dialup)"
		echo "--------------"
		echo "<T>..Telnet Client  (you MUST have the RZ command for this)"
		DefaultColour
		echo -n "Please Choose Your Download Protocol: "
		read SELECTION
		echo "-$USER downloading file [$FILE], Selected protocol [$SELECTION]" >> $ETC_PATH/sysop.log
		case $SELECTION in
			Z | z ) PROTOCOL="sz -R" ;;
			Y | y ) PROTOCOL="sz -R --ymodem" ;;
			X | x ) PROTOCOL="sx -R" ;;
			1 ) PROTOCOL="sx -R -k" ;;
			T | t ) PROTOCOL="sz -R -vv --tcp-server" ;;
			* ) echo ; echo "Available Protocols are: 'Z, Y, X, 1, T'" ; echo ; pause ; break ;;
		esac
		echo
		cat $LIB_PATH/11.default
		echo "Press <CTRL>-X several times to Abort"
		DefaultColour
		echo
		$PROTOCOL $HOME/$FILE
		if ! [ $? = 0 ]
		then
			cat $LIB_PATH/11.default
			echo "Download was Unsucessful"
			echo "Download attempt Failed" >> $ETC_PATH/sysop.log
		fi
		pause
		break
		done
		;;

# end of code for File Menu option D
#----------------------------------------------------------------
# code for File Menu option A (Send message + attachment)

A | a )
	while [ $DONE=nope ] 		# All this subloop does is prevent
	do				# breaking out of the main loop.
		echo
		echo -n "Filename to Upload: "
		read FILE
		FILE=$(echo $FILE | sed 's/\///g')
		cat $LIB_PATH/11.default
		echo
		echo "<Z>..ZMODEM		(Dialup)"
		echo "<Y>..YMODEM		(Dialup)"
		echo "---------------------"
		echo "<T>..Telnet Client  (you MUST have the SZ command for this)"
		echo
		DefaultColour
		echo -n "Please Choose Your Upload Protocol: " 	
		read SELECTION
		echo "-$USER uploading [$FILE], Selected protocol [$SELECTION]" >> $ETC_PATH/sysop.log
		case $SELECTION in
			Z | z )  PROTOCOL="rz -y" ;;
			Y | y )  PROTOCOL="rz --ymodem -y" ; FILE=$(echo $FILE | tr [:lower:] [:upper:]) ;;
			T | t )  PROTOCOL="rz -vv --tcp-server" ;;
			* ) echo ; echo "Available Protocols are: 'Z, Y, T'" ; echo ; pause ; break ;;
		esac
		echo
		cat $LIB_PATH/11.default
		echo "Press <CTRL>-X several times to Abort"
		DefaultColour
		echo
		cd $HOME	# Just to make sure
		$PROTOCOL  	
		if [ $? = 0 ]
		then
			echo "File upload suceeded" >> $ETC_PATH/sysop.log
			DefaultColour
			pine -attach_and_delete $HOME/$FILE
		else
			cat $LIB_PATH/11.default
			echo
			echo "Upload UNSUCESSFUL!"
			echo "File upload UNSUCESSFUL" >> $ETC_PATH/sysop.log
			DefaultColour
		fi 
		break
		done
		;;

# end of code for File Menu option U
#------------------------------------------------------------------
# code for Message Menu option Y (Message to Sysop)

Y | y )
	DefaultColour
	pine $SYSOP
	;;

# end of code for Message Menu option Y
# ------------------------------------------------------------------
# code for Message Menu option S (Send/Read Messages)

S | s )
	DefaultColour
	pine -I l
	;;

# end of code for Message Menu option S
# -------------------------------------------------------------------
# code for other hack attempts

??*)
	echo
	echo "NO  You can't grab a shell like that, DUMMY!"
	echo -e "\033[10;25]\033[11;1500]\007"
	pause
	;;

# end of code for other hack attempts
# -------------------------------------------------------------------	

esac
done

exit
