#!/bin/bash
#
#  Script for the File Menu.       
#
#  You might want to change the download directories to mirror the
#  the FTP archives if you have any.
#
#***********************************************************************
# This is where you have to put the directory names of your file areas *
#***********************************************************************
FILE_AREA1="UPLOADS"		
FILE_AREA2="GAMES"		
FILE_AREA3="NETMAIL"	# Simply enter the directory names for each of
FILE_AREA4="NETWORKING"	# your file areas.  No path is necesary here since
FILE_AREA5="COMMUNICATIONS" # they already have a default, stored in DOWNLOAD_
FILE_AREA6="SYSTEM-UTILS"	# PATH below.  If you want more than 8 file areas,
FILE_AREA7="DISK-UTILITIES"		# then you need to add mode code.
FILE_AREA8="FILE-UTILITIES"
FILE_AREA9="MENU-UTILITIES"
FILE_AREA10="SCREEN-UTILITIES"
FILE_AREA11="DR-DOS"
FILE_AREA12="WIN-GAMES"
FILE_AREA13="WIN-UTILITIES"
FILE_AREA14="WIN-COMM"
FILE_AREA15="LINUX"
FILE_AREA16="IBBS"
FILE_AREA108="SPECIAL"

CURRENT_AREA=$FILE_AREA1	# This is just a default, change it if you want
DOWNLOAD_PATH=/usr/local/src
UPLOAD_PATH=/usr/local/src/UPLOADS	# You have to create this directory

if [ -f $HOME/TEMP ] 
then					# This code simply deletes the
	rm $HOME/TEMP			# flagged file list every time
fi					# the File Menu is selected.

DONE=nope
while [ $DONE = nope ]
do
	clear
if ! [ -f $MENU_PATH/file.menu ]
then
	echo "Missing File Menu - contact Sysop..."
	echo "Missing File Menu for $LOGNAME" >> $ETC_PATH/sysop.log
	exit
fi
cat $MENU_PATH/file.menu
cat $LIB_PATH/11.default
echo "Current File Area is: '$CURRENT_AREA'"
echo
DefaultColour
echo -n "Command> "
read SELECTION
echo "$USER selected '$SELECTION' from File Menu" >> $ETC_PATH/sysop.log
case $SELECTION in 

#-----------------------------------------------------------------------
# code for File Menu option Q (Quit to Main)

Q | q | M | m )
	DONE=yup
	exit 
	;;

# end of code for File Menu option Q
#------------------------------------------------------------
# code for File Menu option C (Change File Area)

C | c )
	SELECTION=$(grep $USER $ETC_PATH/seclevels | cut -f2 -d";")
	case $SELECTION in
		1 ) echo ; cat $DOC_PATH/fileareas1.ans ; echo ;;
		2 ) echo ; cat $DOC_PATH/fileareas2.ans ; echo ;;
		3 ) echo ; cat $DOC_PATH/fileareas3.ans ; echo ;;
		* ) echo ; cat $DOC_PATH/fileareas.ans ; echo ;;
	esac
	DefaultColour
	echo -n "File Area Number> "
	read SELECTION
	case $SELECTION in
		1 ) CURRENT_AREA=$FILE_AREA1 ;;
		2 ) CURRENT_AREA=$FILE_AREA2 ;;
		3 ) CURRENT_AREA=$FILE_AREA3 ;; 
		4 ) CURRENT_AREA=$FILE_AREA4 ;; 
		5 ) CURRENT_AREA=$FILE_AREA5 ;; 
		6 ) CURRENT_AREA=$FILE_AREA6 ;;
		7 ) CURRENT_AREA=$FILE_AREA7 ;;
		8 ) CURRENT_AREA=$FILE_AREA8 ;;
		9 ) CURRENT_AREA=$FILE_AREA9 ;;
		10 ) CURRENT_AREA=$FILE_AREA10 ;;
		11 ) CURRENT_AREA=$FILE_AREA11 ;;
		12 ) CURRENT_AREA=$FILE_AREA12 ;;
		13 ) CURRENT_AREA=$FILE_AREA13 ;;
		14 ) CURRENT_AREA=$FILE_AREA14 ;;
 		15 ) CURRENT_AREA=$FILE_AREA15 ;;
		16 ) CURRENT_AREA=$FILE_AREA16 ;;
		108 ) CURRENT_AREA=$FILE_AREA108 ;;
		* ) echo "Selection is out of Range" ; echo "" ; pause ;;
	esac
	echo "$USER selected File Area Number: $SELECTION ($CURRENT_AREA)" >> $ETC_PATH/sysop.log
	;;

# end of code for File Menu option C
#-------------------------------------------------------------------
# code for File Menu option L (List Files)

L | l )
	DefaultColour
	more -d $DOWNLOAD_PATH/$CURRENT_AREA/files.list
	echo
	pause
	;;

# end of code for File Menu option L
#--------------------------------------------------------------------
# code for File Menu option S (Search for Files)

S | s )
	echo
	cat $LIB_PATH/10.default
	echo -n "Search CURRENT File Area for Keyword: "
	read SELECTION
	echo "$USER searched File Area: $CURRENT_AREA for '$SELECTION'" >> $ETC_PATH/sysop.log
	DefaultColour
	cat $DOWNLOAD_PATH/$CURRENT_AREA/files.list | grep -i $SELECTION 2>/dev/null | more -d 
	echo
	pause
	;;

# end of code for File Menu option S
#---------------------------------------------------------------------
# code for File Menu option D (Download a File)

D | d )
	while [ $DONE=nope ] 	# All this subloop does is prevent
	do			# breaking out of the main loop.
	if [ -f $HOME/TEMP ]
	then 	
		echo
		echo -n "Download Flagged files using ZMODEM now? (Y/N) "
		read SELECTION
		if [ $SELECTION = Y -o $SELECTION = y ]
		then
			echo
			cat $LIB_PATH/11.default				
			echo "Press <CTRL>-X several times to Abort"
			DefaultColour
			cd $DOWNLOAD_PATH
			echo
			sz -R `cat $HOME/TEMP`	# -R for RESTRICTED mode.
			rm $HOME/TEMP
			cd
			pause
			break
		fi
	fi		
	echo
	echo -n "Filename to Download: "
	read FILE
	if echo $FILE | egrep "passwd|../" >/dev/null
	then
		cat $LIB_PATH/11.default
		echo "It doesn't work like that,  DUMMY!"
		echo -e "\033[10;25]\033[11;1500]\007"
		DefaultColour
		pause
		break
	fi
	FILE=$(echo $FILE | awk '{print $1}' | sed 's/\///g')
	if ! [ -f $DOWNLOAD_PATH/$CURRENT_AREA/$FILE 2>/dev/null ]
	then
		cat $LIB_PATH/10.default
		echo "File $FILE not found in your Current File Area"
		echo "-File [$FILE] not found in Current File Area" >>$ETC_PATH/sysop.log
		pause
		break
	fi
	echo "$USER selected FILE: [$FILE] From $CURRENT_AREA" >> $ETC_PATH/sysop.log
	cat $LIB_PATH/11.default
	echo
	echo "<Z>..ZMODEM		(Dialup)"
	echo "<Y>..YMODEM		(Dialup)"
	echo "<X>..XMODEM		(Dialup)"
	echo "<1>..XMODEM-1K		(Dialup)"
	echo "---------------"
	echo "<T>..Telnet Client  (you MUST have the RZ command for this)"
	DefaultColour
	echo -n "Please Choose Your Download Protocol: "
	read SELECTION
	echo "$USER selected protocol: '$SELECTION'" >> $ETC_PATH/sysop.log
	case $SELECTION in
		Z | z ) PROTOCOL="sz -R" ;;		# -R for RESTRICTED
		Y | y ) PROTOCOL="sz -R --ymodem" ;;	# mode.
		X | x ) PROTOCOL="sx -R" ;;
		1 ) PROTOCOL="sx -R -k" ;;
		T | t ) PROTOCOL="sz -R -vv --tcp-server" ;;
		* ) echo ; echo "Available Protocols are: 'Z, Y, X, 1, T'" ; echo ; pause ; break ;;
	esac
	echo
	cat $LIB_PATH/11.default
	echo "Press <CTRL>-X several times to Abort"
	echo
	$PROTOCOL $DOWNLOAD_PATH/$CURRENT_AREA/$FILE
	if ! [ $? = 0 ]
	then
		cat $LIB_PATH/11.default
		echo "Download was Unsucessful"
		echo "Download attempt Failed" >> $ETC_PATH/sysop.log
	fi
	pause
	break
	done
	;;

# end of code for File Menu option D
#----------------------------------------------------------------
# code for File Menu option U (Upload a File)

U | u )
	while [ $DONE=nope ] 	# All this subloop does is prevent
	do			# breaking out of the main loop.
		echo
		echo -n "Filename to Upload: "
		read FILE
		FILE=$(echo $FILE | sed 's/\///g')
		echo "$USER attempting to upload file: [$FILE]" >> $ETC_PATH/sysop.log
		echo -n "Description: "
		read DESCRIPTION
		echo "Description: $DESCRIPTION" >> $ETC_PATH/sysop.log
		cat $LIB_PATH/11.default
		echo
		echo "<Z>..ZMODEM		(Dialup)"
		echo "<Y>..YMODEM		(Dialup)"
		echo "------------------"
		echo "<T>..Telnet Client  (You MUST have the SZ command for this)"
		echo
		DefaultColour
		echo -n "Please Choose Your Upload Protocol: " 	
		read SELECTION
		echo "$USER selected upload protocol: '$SELECTION'" >> $ETC_PATH/sysop.log
		case $SELECTION in
			Z | z )  PROTOCOL="rz -y" ;;
			Y | y )  PROTOCOL="rz --ymodem -y" ; FILE=$(echo $FILE | tr [:lower:] [:upper:]) ;; 
			T | t )  PROTOCOL="rz -vv --tcp-server" ;;		
			* ) echo ; echo "Available Protocols are: 'Z, Y, T'" ; echo ; pause ; break ;;
		esac
		echo
		cat $LIB_PATH/11.default
		echo "Press <CTRL>-X several times to Abort"
		DefaultColour
		echo
		cd $UPLOAD_PATH
		$PROTOCOL
		if [ $? = 0 ]
		then
			echo "$(ls -h -s $FILE)	$DESCRIPTION" >> $UPLOAD_PATH/files.list
			echo "File upload suceeded" >> $ETC_PATH/sysop.log
			cd $HOME	
		else
			cd $HOME
			cat $LIB_PATH/11.default
			echo
			echo "Upload UNSUCESSFUL!"
			echo "File upload UNSUCESSFUL" >> $ETC_PATH/sysop.log
		fi 
		pause
		break
		done
		;;

# end of code for File Menu option U
#------------------------------------------------------------------
# code for File Menu option F (Flag Files)

F | f )
	echo
	echo -n "Filename to Flag: "
	read SELECTION
	if [ -f $DOWNLOAD_PATH/$CURRENT_AREA/$SELECTION 2>/dev/null ]
	then
		echo "$USER Flagged File: [$SELECTION] from $CURRENT_AREA" >> $ETC_PATH/sysop.log
		echo $CURRENT_AREA/$SELECTION >> $HOME/TEMP
			if [ $? = 0 ] 
			then
				cat $LIB_PATH/10.default
				echo "File has been Flagged for Download"
				pause
			else
				cat $LIB_PATH/10.default
				echo "Error creating a Flag file - Contact your Sysop"
				echo "- Error Creating flag file for: '$USER'" >> $ETC_PATH/sysop.log 
				pause
			fi
	else
		cat $LIB_PATH/11.default
		echo "File '$SELECTION' NOT found in Current File Area"
		echo "File [$SELECTION] NOT found in Current File Area" >> $ETC_PATH/sysop.log
		pause
	fi
	;;

# end of code for File Menu option F
#-----------------------------------------------------------------
# code for File Menu option E (Edit Batch Queue)

E | e )
	if [ -f $HOME/TEMP ]
	then
		DefaultColour
		pico -t -o $HOME $HOME/TEMP
	else
		cat $LIB_PATH/10.default
		echo "You haven't Flagged any files yet!"
		pause
	fi
	;;

# end of code for File Menu option E
#------------------------------------------------------------------
# code for File Menu option N (New Files)

N | n )
	cat $LIB_PATH/10.default
	echo -n "Number of Days to search back: "
	read DATE1
	echo -n "<T>his area, <A>ll areas, <ENTER> to abort: "
	read SELECTION
	echo "$USER searched [$SELECTION] area(s) for $DATE1 days back" >> $ETC_PATH/sysop.log
	DefaultColour
	case $SELECTION in
	T | t )
		#---------------------------------------------------------
		# Remember the filenames in the files.list must match
		# exactly with their actual filenames. (ie: CASE SENSATIVE)
		#---------------------------------------------------------
		for VAR in $(find $DOWNLOAD_PATH/$CURRENT_AREA -mtime -$DATE1 -type f 2>/dev/null)
		do
			TT=$(echo $VAR | cut -f 6 -d/) 
			grep $(echo $TT | tail -n 1) $DOWNLOAD_PATH/$CURRENT_AREA/files.list | cut -f 2 -d: | more -d
		done
		echo
		pause
		;;
	A | a )
		echo "This might take a moment...."
		for VAR in $(find $DOWNLOAD_PATH -mtime -$DATE1 -type f 2>/dev/null)
		do
			TT=$(echo $VAR | cut -f 6 -d/ | tail -n 1) 
			SS=$(echo $VAR | cut -f 5 -d/ | tail -n 1)
			grep $(echo $TT) $DOWNLOAD_PATH/$SS/files.list 
		done
		echo 
		pause
		;;	
	esac
	;;

# end of code for File Menu option N
#------------------------------------------------------------------
# code for File Menu option Y (Display Batch Queue)

Y | y )
	if [ -f $HOME/TEMP ]
	then
		echo
		more -d $HOME/TEMP
		echo
		pause
	else
		cat $LIB_PATH/10.default
		echo "You haven't Flagged any files yet!"
		pause
	fi
	;;

# end of code for File Menu option Y
# --------------------------------------------------------------------
# code for other hack attempts

??*)
	echo
	echo "NO  You can't grab a shell like that, DUMMY!"
	echo -e "\033[10;25]\033[11;1500]\007"
	pause
	;;

# end of code for hack attempts
# --------------------------------------------------------------------

esac
done

exit
