/* $Id: windowstuff.c,v 1.2 1997/07/06 14:34:49 eilts Exp eilts $ */
#include "bbs.h"

int windowtext(const char *text, const char *header, const int waittime,
               const confrecordtyp *confrecord)
{
  int zeilen, spalten, k, oldx, oldy;
  char str[MSG_MAX+2], *sp;
#ifdef NO_NCURSES
  char *bgbp;
#endif
  const char *conttxt;
  WINDOW *twin;

  conttxt = msg("windowtext",0,confrecord->userrecord.lang);
  strmaxcpy(str,text,STRLEN);
  k = strlen(str) - 1;
  if (str[k++] != '\n') {
    str[k++] = '\n';
    str[k] = '\0';
  }
  zeilen = 4;
  spalten = 5;
  k = 5;
  for (sp=str; *sp!='\0'; sp++) {
    if (*sp == '\n') {
      zeilen++;
      if (k > spalten) spalten = k;
      k = 5;
    }
    else {
      k++;
    }
  }
  k = strlen(conttxt) + 4;
  if (spalten < k) spalten = k;
  if (zeilen > LINES) zeilen = LINES;
  if (spalten > COLS) spalten = COLS;
  
  getyx(stdscr,oldy,oldx);
  if ((twin=newwin(zeilen,spalten,(LINES-zeilen)/2,(COLS-spalten)/2)) == NULL) {
    fprintf(stderr,"\ncannot open window\n");
    bbsgetch(FALSE);
    return(-1);
  }
#ifdef NO_NCURSES
  bgbp = savebackground(twin);
#else
  touchwin(stdscr);
#endif
  werase(twin);
  box(twin,'|','-');
  if (*header != '\0') {
    wmove(twin,0,(spalten-strlen(header))/2);
    WADDSTR(twin,header);
    k = 2;
    wmove(twin,k++,2);
    for (sp=str; *sp!='\0'; sp++) {
      if (*sp == '\n') {
        wmove(twin,k++,2);
      }
      else {
        waddch(twin,*sp);
      }
    }
  }
  if (waittime > 0) {
    wrefresh(twin);
    sleep(waittime);
  }
  else {
    wmove(twin,zeilen-1,(spalten-strlen(conttxt))/2);
    WADDSTR(twin,conttxt);
    wrefresh(twin);
    waitonkeypress(TRUE);
  }
#ifdef NO_NCURSES
  restorebackground(twin,bgbp);
#endif
  delwin(twin);
  move(oldy,oldx);
  refresh();
  return 0;
}


#ifdef NO_NCURSES
char *savebackground(WINDOW *win)
{
  int x, y;
  char *buf;
  
  if ((buf=(char *)malloc((win->_maxx*win->_maxy)*sizeof(char)))==NULL) {
    return(NULL);
  }
  for (x=0; x<win->_maxx; x++) {
    for (y=0; y<win->_maxy; y++) {
      move(win->_begy+y,win->_begx+x);
      buf[x+y*win->_maxx] = inch();
    }
  }
  return(buf);
}


int restorebackground(WINDOW *win, char *buf)
{
  int x, y;
  char c;
  
  if (buf == NULL)  return(-1);
  for (x=0; x<win->_maxx; x++) {
    for (y=0; y<win->_maxy; y++) {
      c = buf[x+y*win->_maxx];
      wmove(win,y,x);
      if (c != winch(win)) {
        waddch(win,c);
      }
    }
  }
  wrefresh(win);
  free(buf);
  return(0);
}
#endif

int window_on(struct termios *save_termios,  ttystateenum *ttystate,
              confrecordtyp *confrecord)
{
  char *sp;

  if (! confrecord->curses_on) {
#if ! defined(NO_NCURSES) || defined(__hpux) || defined(__sun)
    if (initscr() == NULL) {
#else
    if (initscr() == ERR) {
#endif
      sp = getenv("TERM");
      if (sp == NULL)  sp = "unknown";
      errormsg(E_LOGFILE|E_USER,confrecord,"bbs","window_on",
               "cannot start curses, TERM=%s",sp);
      return(-1);
    }
    if (tty_cbreak(STDIN_FILENO,save_termios,ttystate) < 0) {
      errormsg(E_LOGFILE|E_USER,confrecord,"bbs","window_on",
               "cannot set terminal to cbreak: %m");
      return(-1);
    }
    confrecord->curses_on = TRUE;
  }
  return 0;
}


int window_off(struct termios *save_termios, ttystateenum *ttystate,
               confrecordtyp *confrecord)
{
  if (confrecord->curses_on) {
    mvcur(0,COLS -1,LINES -1,0);
    clrtoeol();
    if (tty_reset(STDIN_FILENO,save_termios,ttystate) < 0) {
      errormsg(E_LOGFILE|E_USER,confrecord,"bbs","window_on",
               "cannot reset terminal from cbreak: %m");
      return(-1);
    }
    refresh();
    endwin();
    confrecord->curses_on = FALSE;
  }
  return 0;
}


boolean termexists(const char *termname)
{
  char tgetentbuf[TGETENTBUF];

  return tgetent(tgetentbuf,termname);
}


int addstr_withmargin(const char *str)
{
  int mlen, x_p, k;
  const char *sp;

  getyx(stdscr,k,x_p);
  mlen = COLS - x_p - 3;
  for (k=0,sp=str; *sp && *sp!='\n'; k++,sp++) ;
  if (k <= mlen) {
    for (k=0,sp=str; *sp && *sp!='\n'; sp++)  addch(*sp);
  }
  else {
    for (k=0,sp=str; *sp && *sp!='\n' && k<mlen; k++,sp++)  addch(*sp);
    ADDSTR("...");
  }
  return(0);
}


#ifdef NO_ADDSTR_CONST
int bbs_addstr(const char *str)
{
  int n;
  char *sp;
  
  if ((sp=malloc((strlen(str)+1)*sizeof(char))) == NULL) {
    return ERR;
  }
  strcpy(sp, str);
  n = addstr(sp);
  free(sp);
  return n;
}
#endif


#ifdef NO_WADDSTR_CONST
int bbs_waddstr(WINDOW *win, const char *str)
{
  int n;
  char *sp;
  
  if ((sp=malloc((strlen(str)+1)*sizeof(char))) == NULL) {
    return ERR;
  }
  strcpy(sp, str);
  n = waddstr(win, sp);
  free(sp);
  return n;
}
#endif


#ifdef NO_PRINTW_CONST
int bbs_printw(const char *fmt, ...)
{
  va_list ap;
  char str[STRLEN+1];
  
  va_start(ap, fmt);
  vsprintf(str, fmt, ap);
  va_end(ap);
  return addstr(str);
}
#endif
