/* $Id: sysstuff.c,v 1.2 1997/07/06 14:34:49 eilts Exp eilts $ */
#include "bbs.h"

#ifdef NO_DBOPEN
DBASE_DB *dbase_open(const char *file, int flags, int mode, DBTYPE type,
                     const void *openinfo)
{
  char path[PATH_MAX+1];
  DBASE_DB *db;

  if ((db=(DBASE_DB *)malloc(sizeof(DBASE_DB))) == NULL)  return NULL;
  if (file == NULL) {
    if (tmpnam(path) == NULL)  return NULL;
  }
  else {
    strcpy(path,file);
  }
  db->dbm = dbm_open(path,flags,mode);
  if (file == NULL) {
    unlink(path);
    *db->file = '\0';
  }
  else {
    strcpy(db->file,file);
  }
  if (db->dbm == NULL) {
    free(db);
    return NULL;
  }
  db->mode = mode;
  db->close = dbase_close;
  db->del = dbase_del;
  db->get = dbase_get;
  db->put = dbase_put;
  db->seq = dbase_seq;
  db->sync = dbase_sync;
  return db;
}


int dbase_close(DBASE_DB *db)
{
  dbm_close(db->dbm);
  free(db);
  return 0;
}


int dbase_del(const DBASE_DB *db, const datum *key, U_INT flags)
{
  return dbm_delete(db->dbm,*key);
}


int dbase_get(const DBASE_DB *db, const datum *key, datum *data, U_INT flags)
{
  *data = dbm_fetch(db->dbm,*key);
  if (data->dptr == NULL)  return 1;
  return 0;
}


int dbase_put(const DBASE_DB *db, datum *key, const datum *data, U_INT flags)
{
  return dbm_store(db->dbm,*key,*data,
                   flags == R_NOOVERWRITE ? DBM_INSERT : DBM_REPLACE);
}


int dbase_seq(const DBASE_DB *db, datum *key, datum *data, U_INT flags)
{
  int n;

  if (flags == R_FIRST) {
    *key = dbm_firstkey(db->dbm);
  }
  else {
    *key = dbm_nextkey(db->dbm);
  }
  n = key->dptr == NULL ? 1 : 0;
  if (n == 0) {
    *data = dbm_fetch(db->dbm,*key);
    if (data->dptr == NULL)  n = -1;
  }
  return n;
}


int dbase_sync(const DBASE_DB *db, U_INT flags)
{
#ifdef NO_DBOPEN_CONST
  char path[PATH_MAX+1];
#endif

  dbm_close(db->dbm);
#ifdef NO_DBOPEN_CONST
  strcpy(path, db->file);
  if (dbm_open(path,O_RDWR,db->mode) == NULL)  return -1;
#else
  if (dbm_open(db->file,O_RDWR,db->mode) == NULL)  return -1;
#endif
  return 0;
}


int dbase_unlink(const char *dbfile)
{
  char path[PATH_MAX+1];

  strcpy(path,dbfile);
  strcat(path,".pag");
  unlink(path);
  strcpy(path,dbfile);
  strcat(path,".dir");
  return unlink(path);
}
#endif


int f_close(FILE *stream)
{
  if (stream == NULL) {
    errno = EBADF;
    return -1;
  }
  return fclose(stream);
}


#if defined(BBSDNAME) || defined(BBSMAILNAME)
void bbssetproctitle(char *argv[], const SIZE_T mlen, char *fmt, ...)
{
  char *p;
  int k;
  SETPROC_STATIC char buf[PATH_MAX+1];
  va_list ap;
#if SPT_TYPE == SPT_PSTAT
  union pstun pst;
#endif

  p = buf;
  
  /* print daemon-name */
  strcpy(p, "bbsd: ");
  p += strlen(p);
  
  /* print the argument string */
  va_start(ap, fmt);
  vsprintf(p, fmt, ap);
  va_end(ap);
  
  k = strlen(buf);

#if SPT_TYPE == SPT_BUILTIN
  setproctitle(p);
#endif

#if SPT_TYPE == SPT_PSTAT
  pst.pst_command = buf;
  pstat(PSTAT_SETCMD, pst, k, 0, 0);
#endif

#if SPT_TYPE == SPT_PSSTRINGS
  PS_STRINGS->ps_nargvstr = 1;
  PS_STRINGS->ps_argvstr = buf;
#endif

#if SPT_TYPE == SPT_REUSEARGV
  strmaxcpy(argv[0], buf, mlen-2);
  if (k < mlen-2) {
    while (k < mlen-2)  argv[0][k++] = ' ';
  }
#endif

  return;
}
#endif


int getdatenum(const char *datestr)
{
  int p, n;
  char str[31], *splits[5], *sp;
  
  strmaxcpy(str,datestr,30);
  n = splitstring(splits,str,' ',4);
  if ((sp=strchr(splits[0],',')) != NULL)  *sp = '\0';
  if (getdaynum(splits[0]) > 0) {
    /* Fri, 18 Nov 1994 */
    p = 1;
  }
  else {
    /* 18 Nov 1994 */
    p = 0;
  }
  if ((n=getmonthnum(splits[p+1])) < 0)  return -1;
  return atoi(splits[p]) + 31 * (n + 12 * atoi(splits[p+2]));
}


int getdaynum(const char *day)
{
  if (strcmp(day,"Mon") == 0) {
    return 1;
  }
  else if (strcmp(day,"Tue") == 0) {
    return 2;
  }
  else if (strcmp(day,"Wed") == 0) {
    return 3;
  }
  else if (strcmp(day,"Thu") == 0) {
    return 4;
  }
  else if (strcmp(day,"Fri") == 0) {
    return 5;
  }
  else if (strcmp(day,"Sat") == 0) {
    return 6;
  }
  else if (strcmp(day,"Sun") == 0) {
    return 7;
  }
  return -1;
}


int getmonthnum(const char *month)
{
  if (strcmp(month,"Jan") == 0) {
    return 1;
  }
  else if (strcmp(month,"Feb") == 0) {
    return 2;
  }
  else if (strcmp(month,"Mar") == 0) {
    return 3;
  }
  else if (strcmp(month,"Apr") == 0) {
    return 4;
  }
  else if (strcmp(month,"May") == 0) {
    return 5;
  }
  else if (strcmp(month,"Jun") == 0) {
    return 6;
  }
  else if (strcmp(month,"Jul") == 0) {
    return 7;
  }
  else if (strcmp(month,"Aug") == 0) {
    return 8;
  }
  else if (strcmp(month,"Sep") == 0) {
    return 9;
  }
  else if (strcmp(month,"Oct") == 0) {
    return 10;
  }
  else if (strcmp(month,"Nov") == 0) {
    return 11;
  }
  else if (strcmp(month,"Dec") == 0) {
    return 12;
  }
  return -1;
}


char *gettime()
{
  TIME_T clock;
  static char str[ASCIITIMESTRLEN];
  
  clock = time((TIME_T)0);
  strcpy(str,asctime(localtime(&clock)));
  str[24] = '\0';
  return str;
}


#ifndef NO_TV_USEC
double microtime(void)
{
  struct timeval tp;
  struct timezone tzp;
  
  gettimeofday(&tp,&tzp);
  return((double)(tp.tv_sec + 0.000001*tp.tv_usec));
}
#endif


int mklockfile(const char *pathname)
  /*
  legt ein Lockfile pathname an
  */
{
  int fd;
  
  if ((fd=open(pathname,O_RDWR|O_CREAT|O_EXCL,0644))<0) {
    bgerror("mklockfile","open %s: %m",pathname);
    return -1;
  }
  writen(fd,(void *)"LOCKED",(SIZE_T)7);
  close(fd);

  return 0;
}


int fgetnln(char str[], const int maxlen, FILE *datei)
  /*
  Liest eine Zeile aus einem File und kopiert maximal maxlen Zeichen
  in str.
  Rueckgabewerte: -1 bei EOF, maxlen+1 wenn die Zeile zu lang war
  */
{
  char c;
  int k;
  boolean ret=TRUE;

  if ( datei == NULL )  return -1;
  k = 0;
  do {
    c = fgetc( datei );
    if ( c != EOF )  str[k++] = c;
  } while ( k <= maxlen && c!= '\n' && c != '\0' && c != EOF );
  if ( c == '\n' ) {
    ret = TRUE;
    str[--k] = '\0';
  }
  else if ( c == '\0' ) {
    ret = FALSE;
    --k;
  }
  else if ( k > maxlen && c != '\n' && c != '\0' ) {
    ret = FALSE;
    str[k-1] = '\0';
  }
  else if ( c == EOF ) {
    ret = TRUE;
    str[k] = '\0';
    k = -1;
  }
  if ( ! ret ) {
    do{
        c = fgetc( datei );
    } while( c != '\n' && c != EOF );
    if ( c == EOF )  k = -1;
  }
  return k;
}


SSIZE_T readn(int fd, void *vptr, SIZE_T n)
{
  SIZE_T nleft;
  SSIZE_T nread;
  void *ptr;
  
  ptr = vptr;
  nleft = n;
  while (nleft > 0) {
    if ((nread=read(fd,ptr,nleft)) < 0) {
      return(nread);
    }
    else if (nread == 0) {
      break;
    }
    nleft -= (SIZE_T)nread;
    ptr = (char *)ptr + nread*sizeof(char);
  }
  return(SSIZE_T)(n-nleft);
}


SSIZE_T writen(int fd, const void *vptr, SIZE_T n)
{
  SIZE_T nleft;
  SSIZE_T nwritten;
  const void *ptr;
  
  ptr = vptr;
  nleft = n;
  while (nleft > 0) {
    if ((nwritten=write(fd,ptr,nleft)) <= 0) {
      return(nwritten);
    }
    nleft -= (SIZE_T)nwritten;
    ptr = (char *)ptr + nwritten*sizeof(char);
  }
  return(SSIZE_T)n;
}


SSIZE_T recvn(int s, void *buf, SIZE_T len, int flags)
{
  SIZE_T bytesleft;
  SSIZE_T n;
  void *ptr;

  ptr = buf;
  bytesleft = len;
  while (bytesleft > 0) {
    if ((n=recv(s,ptr,bytesleft,flags)) < 0) {
      return(n);
    }
    bytesleft -= (SIZE_T)n;
    ptr = (char *)ptr + n*sizeof(char);
  }
  return(SSIZE_T)(len-bytesleft);
}


SSIZE_T sendn(int s, const void *buf, SIZE_T len, int flags)
{
  SIZE_T bytesleft;
  SSIZE_T n;
  const void *ptr;

  ptr = buf;
  bytesleft = len;
  while (bytesleft > 0) {
    if ((n=send(s,(const void *)ptr,bytesleft,flags)) < 0) {
      return(n);
    }
    if (n == 0) break;
    bytesleft -= (SIZE_T)n;
    ptr = (char *)ptr + n*sizeof(char);
  }
  return(SSIZE_T)len;
}


void (*setsighandler(int sig, void (*handler)(int)))(int)
{
  struct sigaction act, oact;
  
  act.sa_handler = handler;
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;
  if (sig == SIGALRM) {
#ifdef SA_INTERRUPT
    act.sa_flags |= SA_INTERRUPT;
#endif    
  }
  else {
#ifdef SA_RESTART
    act.sa_flags |= SA_RESTART;
#endif
  }
  if (sigaction(sig,&act,&oact) < 0) {
    return(SIG_ERR);
  }
  return(oact.sa_handler);
}


void (*setsighandler2(int sig, SIGSET_T sigset, void (*handler)(int)))(int)
{
  struct sigaction act, oact;
  
  act.sa_handler = handler;
  act.sa_mask = sigset;
  act.sa_flags = 0;
  if (sig == SIGALRM) {
#ifdef SA_INTERRUPT
    act.sa_flags |= SA_INTERRUPT;
#endif    
  }
  else {
#ifdef SA_RESTART
    act.sa_flags |= SA_RESTART;
#endif
  }
  if (sigaction(sig,&act,&oact) < 0) {
    return(SIG_ERR);
  }
  return(oact.sa_handler);
}


void syslogn(int priority, const char *message, ...)
{
  va_list ap;
  
  va_start(ap, message);
  vsyslogn(priority, message, ap);
  va_end(ap);
  return;
}


void vsyslogn(int priority, const char *message, va_list args)
{
  int k;
  char c, *cp1, *cp2, msg[SYSLOGBUF], buf[MSG_MAX+1], fmt_cpy[MSG_MAX+1];
  
  for (cp1=fmt_cpy; (c=*message)!='\0'; ++message) {
    if (c=='%' && message[1]=='m') {
      ++message;
      for (cp2=strerror(errno); (*cp1=*cp2++)!='\0'; ++cp1);
    }
    else {
      *cp1++ = c;
    }
  }
  *cp1 = '\0';
  vsprintf(buf, fmt_cpy, args);
  cp1 = buf;
  while (*cp1 != '\0') {
    k = 0;
    while (*cp1!='\0' && k<SYSLOGBUF-81) {
      msg[k++] = *cp1++;
    }
    msg[k] = '\0';
    syslog(priority, msg);
  }
  return;
}


#ifdef NO_USLEEP
void usleep(U_INT microseconds)
{
#ifndef NO_TV_USEC
  struct timeval tp;

  tp.tv_sec = microseconds / 1000000;
  tp.tv_usec = microseconds - tp.tv_sec;
  while (select(0,NULL,NULL,NULL,&tp) == EINTR) ;
  return;
#else
  sleep((microseconds + 999999) / 1000000);
#endif
  return;
}
#endif


extern char **environ;

SIZE_T environlen(void)
{
  char **ep;
  size_t len=1;
  
  for (ep=environ; *ep!=NULL; ep++) {
    len += strlen(*ep) + 1;
  }
  return(len);
}


int mdefenv(const char *env, const char *fmt, ...)
{
  va_list ap;
  int len;
  char *sp, str[PATH_MAX+1];
  
  va_start(ap, fmt);
  vsprintf(str, fmt, ap);
  va_end(ap);
  len = strlen(env) + strlen(str) + 2;
  if ((sp=(char *)malloc(len*sizeof(char))) == NULL) {
    bgerror("mdefenv","cannot malloc: %m");
    return(-1);
  }
  sprintf(sp,"%s=%s",env,str);
  return putenv(sp);
}


int mputenv(const char *str)
{
  char *sp;

  if ((sp=(char *)malloc((strlen(str)+1)*sizeof(char))) == NULL) {
    bgerror("mputenv","cannot malloc: %m");
    return(-1);
  }
  strcpy(sp,str);
  return putenv(sp);
}


#ifdef NO_PUTENV
/* Copyright (C) 1991 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

extern char **environ;

/* Put STRING, which is of the form "NAME=VALUE", in the environment.  */
int
putenv (string)
     const char *string;
{
  char *name_end = (char *)strchr (string, '=');
  register SIZE_T size;
  register char **ep;

  if (name_end == NULL)
    {
      /* Remove the variable from the environment.  */
      size = strlen (string);
      for (ep = environ; *ep != NULL; ++ep)
	if (!strncmp (*ep, string, size) && (*ep)[size] == '=')
	  {
	    while (ep[1] != NULL)
	      {
		ep[0] = ep[1];
		++ep;
	      }
	    *ep = NULL;
	    return 0;
	  }
    }

  size = 0;
  for (ep = environ; *ep != NULL; ++ep)
    if (!strncmp (*ep, string, name_end - string) &&
	(*ep)[name_end - string] == '=')
      break;
    else
      ++size;

  if (*ep == NULL)
    {
      static char **last_environ = NULL;
      char **new_environ = (char **) malloc ((size + 2) * sizeof (char *));
      if (new_environ == NULL)
	return -1;
      (void) bcopy ((char *) environ, (char *) new_environ, size * sizeof (char *));
      new_environ[size] = (char *) string;
      new_environ[size + 1] = NULL;
      if (last_environ != NULL)
	free ((char *) last_environ);
      last_environ = new_environ;
      environ = new_environ;
    }
  else
    *ep = (char *) string;

  return 0;
}
#endif

