/* $Id: stringstuff.c,v 1.2 1997/07/06 14:34:49 eilts Exp eilts $ */
#include "bbs.h"

void rm_ae_blanks(char *str)
{
  char *sp1, *sp2;

  for (sp1=str; *sp1 == ' '; sp1++) ;
  if (sp1 != str) {
    for (sp2=str; *sp1; sp1++,sp2++)  *sp2 = *sp1;
    *sp2 = '\0';
  }
  for (sp1=str; *sp1; sp1++) ;
  if (sp1 == str)  return;
  sp1--;
  while (*sp1 == ' ')  *sp1-- = '\0';
  return;
}


char *splittoken(char *str, const char splitchar, const int nr)
{
  int k=0;
  char *sp=NULL;

  sp = str;
  while (k < nr && *sp) {
    if (*sp == splitchar)  k++;
    sp++;
  }
  while (*sp == splitchar)  sp++;
  return sp;
}


char getarg(char arg[], const char *args)
{
  char option, *sp;
  static const char *ap;
  
  if (arg == NULL) {
    ap = args;
    return '\0';
  }
  while (*ap == ' ')  ++ap;
  if (*ap == '-') {
    ap++;
    option = *ap;
    ap++;
    while (*ap == ' ')  ++ap;
    for (sp=arg; (*ap != '-' || *(ap-1) != ' ') && *ap; *sp++ = *ap++) ;
    *sp = '\0';
    while (*--sp == ' ')  *sp = '\0';
  }
  else {
    option = '\0';
    strcpy(arg,ap);
  }
  return option;     
}


char *recode(char *rstr, const char ch, const char cascii)
{
  static int c_chfilter_iso_next[] =                       /* 000-255 */
  {
	  0,     1,     2,     3,     4,     5,     6,     7, /* 000-007 */
	  8,     9,    10,    11,    12,    13,    14,    15, /* 008-015 */
	  16,    17,    18,    19,    20,    21,    22,    23, /* 016-023 */
	  24,    25,    26,    27,    28,    29,    30,    31, /* 024-031 */
	  32,    33,    34,    35,    36,    37,    38,    39, /* 032-039 */
	  40,    41,    42,    43,    44,    45,    46,    47, /* 040-047 */
	  48,    49,    50,    51,    52,    53,    54,    55, /* 048-055 */
	  56,    57,    58,    59,    60,    61,    62,    63, /* 056-063 */
	  64,    65,    66,    67,    68,    69,    70,    71, /* 064-071 */
	  72,    73,    74,    75,    76,    77,    78,    79, /* 072-079 */
	  80,    81,    82,    83,    84,    85,    86,    87, /* 080-087 */
	  88,    89,    90,    91,    92,    93,    94,    95, /* 088-095 */
	  96,    97,    98,    99,   100,   101,   102,   103, /* 096-103 */
	104,   105,   106,   107,   108,   109,   110,   111, /* 104-111 */
	112,   113,   114,   115,   116,   117,   118,   119, /* 112-119 */
	120,   121,   122,   123,   124,   125,   126,   127, /* 120-127 */
	164,   166,   169,   170,   172,   173,   174,   175, /* 128-135 */
	178,   179,   183,   184,   185,   186,   188,   189, /* 136-143 */
	193,   195,   196,   198,   199,   205,   206,   207, /* 144-151 */
	208,   232,   234,   245,   248,   250,   254,   255, /* 152-159 */
	128,   161,   162,   163,   168,   165,   181,   167, /* 160-167 */
	200,   160,   227,   171,   190,   177,   176,   197, /* 168-175 */
	202,   209,   201,   204,   194,   157,   182,   180, /* 176-183 */
	203,   192,   235,   187,   210,   211,   212,   191, /* 184-191 */
	129,   130,   131,   132,   133,   134,   225,   135, /* 192-199 */
	136,   137,   138,   139,   140,   141,   142,   143, /* 200-207 */
	144,   145,   146,   147,   148,   149,   150,   158, /* 208-215 */
	233,   151,   152,   153,   154,   155,   156,   251, /* 216-223 */
	213,   214,   215,   216,   217,   218,   241,   219, /* 224-231 */
	220,   221,   222,   223,   224,   226,   228,   229, /* 232-239 */
	230,   231,   236,   237,   238,   239,   240,   159, /* 240-247 */
	249,   242,   243,   244,   246,   247,   252,   253  /* 248-255 */
  };

  if (cascii == 'U') {
    rstr[0] = ch;
    rstr[1] = '\0';
  }
  else if (cascii == 'N') {
    rstr[0] = c_chfilter_iso_next[(int)(U_CHAR)ch];
    rstr[1] = '\0';
fprintf(stderr,"%c %c\n",ch,rstr[0]);
  }
  else if (cascii == 'A') {
    switch ((unsigned char)ch) {
    case AE_U_L1:
    case AE_U_IBM850:
      strcpy(rstr,"Ae");
      break;
    case AE_L_L1:
    case AE_L_IBM850:
      strcpy(rstr,"ae");
      break;
    case OE_U_L1:
    case OE_U_IBM850:
      strcpy(rstr,"Oe");
      break;
    case OE_L_L1:
    case OE_L_IBM850:
      strcpy(rstr,"oe");
      break;
    case UE_U_L1:
    case UE_U_IBM850:
      strcpy(rstr,"Ue");
      break;
    case UE_L_L1:
    case UE_L_IBM850:
      strcpy(rstr,"ue");
      break;
    case SS_L1:
    case SS_IBM850:
      strcpy(rstr,"ss");
      break;
    case ACUTE_L1:
      rstr[0] = '\'';
      rstr[1] = '\0';
      break;
    default:
      rstr[0] = ch;
      rstr[1] = '\0';
    }
  }
  return rstr;
}


SSIZE_T fstrlen(const char *fmt, ...)
{
  SSIZE_T len;
  va_list ap;
  
  va_start(ap, fmt);
  len = vfstrlen(fmt, ap);
  va_end(ap);
  return(len);
}


SSIZE_T vfstrlen(const char *fmt, va_list ap)
{
  SSIZE_T len;
  int saved_errno;
  boolean notfound;
  char *hfmtp, hfmt[S_STRLEN], str[S_STRLEN];
  const char *fp;
  
  saved_errno = errno;
  len = strlen(fmt);
  fp = fmt;
  while(*fp!='\0' && len>=0) {
    if (*fp == '%') {
      hfmtp = hfmt;
      *hfmtp++ = '%';
      do {
	*hfmtp++ = *++fp;
	notfound = FALSE;
	switch (*fp) {
	case 's':
	  len += (SSIZE_T)strlen(va_arg(ap, char *)) - 2;
	  break;
	case 'c':
	case '%':
	  len++;
	  break;
	case 'm':
	  len += (SSIZE_T)strlen(strerror(saved_errno)) - 2;
	  break;
	case 'd':
	case 'i':
	case 'o':
	case 'x':
	case 'X':
	case 'u':
	case 'p':
	  *hfmtp = '\0';
	  sprintf(str,hfmt,va_arg(ap, int));
	  len += (SSIZE_T)strlen(str) - strlen(hfmt);
	  break;
	case 'f':
	case 'e':
	case 'E':
	case 'g':
	case 'G':
	  *hfmtp = '\0';
	  sprintf(str,hfmt,va_arg(ap, double));
	  len += (SSIZE_T)strlen(str) - strlen(hfmt);
	  break;
	case '\0':
	  len = -1;
	  break;
	default:
	  notfound = TRUE;
	}
      } while (notfound);
    }
    fp++;
  }
  errno = saved_errno;
  return(len);
}


void lowercases(char *str)
{
  while (*str != '\0') {
    *str = tolower(*str);
    str++;
  }
}


char *stripslashes(char *str)
{
  char *sp, *sp2, *sp3;

  sp = str;
  while(*sp != '\0') {
    while(*sp != '/' && *sp != '\0')  sp++;
    if (*sp != '\0' && *(++sp) == '/') {
      for (sp2=sp; *sp2=='/'; ++sp2) ;
      for (sp3=sp; *sp2!='\0';)  *(sp3++) = *(sp2++);
      *sp3 = '\0';
    }
  }
  if (--sp > str && *sp == '/')  *sp = '\0';
  if (*str == '\0')  strcpy(str,"/");
  return(str);
}


void strprepend(char *str, const char *ps)
{
  char *sp1, *sp2;
  const char *csp;
  
  sp1 = str + strlen(str)*sizeof(char);
  sp2 = sp1 + strlen(ps)*sizeof(char);
  *sp2 = '\0';
  while (sp1 > str) {
    *(--sp2) = *(--sp1);
  }
  csp = ps;
  while (*csp != '\0') {
    *(sp1++) = *(csp++);
  }
}


char *strmaxcpy(char *to, const char *from, const SIZE_T count)
{
  SIZE_T k;
  char *dp;
  const char *sp;
  
  for (dp=to,sp=from,k=0; *sp!='\0' && k<count; k++)  *dp++=*sp++;
  *dp = '\0';
  return(to);
}


char *strmaxcat(char *to, const char *append, const SIZE_T mlen)
{
  SIZE_T n, k;
  char *dp;
  const char *ap;

  n = strlen(to);
  for (dp=&(to[n]),ap=append,k=n; *ap!='\0' && k<mlen; k++)  *dp++=*ap++;
  *dp = '\0';
  return(to);
}


const char *basename(const char *path)
{
  const char *sp;
  
  sp = path;
  while (*sp!='\0') sp++;
  while (*sp!='/' && sp>path) sp--;
  if (*sp == '/')  sp++;
  return sp;
}


void pathnamedir(const char *path, char dir[])
{
  int k;
  
  strcpy(dir,path);
  k = strlen(dir) - 1;
  while ((dir[k]!='/') && (k>0)) {
    k--;
  }
  if (k > 0) {
    dir[k] = '\0';
  }
  else {
    strcpy(dir,"/");
  }
}


int splitstring(char *splits[], char *str, const char splitchar,
                const int maxsplits)
{
  int k;
  char *p;
  
  p = str;
  k = 0;
  while (*p!='\0' && k<maxsplits) {
    while (*p==splitchar) p++;
    splits[k++] = p;
    while (*p!=splitchar && *p!='\0') p++;
    if (*p!='\0') {
      *p = '\0';
      p++;
    }
  }
  splits[k] = (char *)NULL;
  return k;
}


int splitstr_wr(char *splits[], char *str, const char splitchar,
                const int maxsplits)
{
  int k;
  char *p;

  p = str;
  k = 0;
  while (*p!='\0' && k<maxsplits) {
    while (*p==splitchar) p++;
    splits[k++] = p;
    if (k == maxsplits)  break;
    while (*p!=splitchar && *p!='\0') p++;
    if (*p!='\0') {
      *p = '\0';
      p++;
    }
  }
  splits[k] = (char *)NULL;
  return k;
}



char *normalizepath(char *path)
{
  char olddir[PATH_MAX+1];

  stripslashes(path);
  getcwd(olddir,PATH_MAX);
  if (chdir(path) < 0)  return(NULL);
  getcwd(path,PATH_MAX);
  chdir(olddir);
  return(path);
}


char *buildhelppath(char *helppath, const char *fname, const char *suffix,
		    const confrecordtyp *confrecord)
{
  if (strlen(fname)+strlen(confrecord->helpdir)+strlen(suffix)+2 < PATH_MAX) {
    sprintf(helppath,"%s/%s.%s",confrecord->helpdir,fname,suffix);
    return(helppath);
  }
  return(NULL);
}


int splitparams(char *args[], char *params)
{
  int k;
  char *p;
  
  p = params;
  k = 0;
  while (*p!='\0' && k<MAXARGS-1) {
    while (*p==' ' && *p!='\0') p++;
    args[k++] = p;
    while (*p!=' ' && *p!='\0') p++;
    if (*p==' ') {
      *p = '\0';
      p++;
    }
  }
  args[k] = (char *)NULL;
  return k;
} 


int str2cmdparams(const char str[], char cmd[], char params[])
{
  int k;

  while (*str==' ' && *str!='\0')  str++;
  for (k=0; *str!=' ' && *str!='\0' && k<S_STRLEN; k++, str++) {
    cmd[k] = *str;
  }
  if (k >= S_STRLEN) {
    cmd[0] = '\0';
    return(-1);
  }
  else {
    cmd[k] = '\0';
    if (*str != '\0')  str++;
    strcpy(params, str);
  }
  return(0);
}


void split2key_arg(char *line, char **key, char **arg)
{
  char *sp3;

  *key = line;
  *arg = line;
  while (**arg!='\0' && **arg!='#')  (*arg)++;
  **arg = '\0';
  while ((**key==' ' || **key=='\t') && **key!='\0')  (*key)++;
  *arg = *key;
  while (**arg!=' ' && **arg!='\t' && **arg!='\0')  (*arg)++;
  if (**arg != '\0') {
    **arg = '\0';
    (*arg)++;
    while ((**arg==' ' || **arg=='\t') && **arg!='\0')  (*arg)++;
    sp3 = *arg;
    if (**arg != '"') {
      while (*sp3!=' ' && *sp3!='\t' && *sp3!='\n' && *sp3!='\0')  sp3++;
    }
    else {
      (*arg)++;
      sp3++;
      while (*sp3!='"' && *sp3!='\0')  sp3++;
    }
    if (*sp3 != '\0') {
      *sp3 = '\0';
    }
  }
}


void stringsort(char *strary[], const int anz)
{
  void string_sort(char *[], const int, const int);
  
  string_sort(strary, 0, anz-1);
  return;
}


void string_sort(char *strary[], const int k1, const int k2)
{
  int i, j;
  char *x, *y;
  
  i = k1; j = k2;
  x = strary[(k1+k2)/2];
  do {
    while (strcmp(strary[i],x) < 0 && i < k2) i++;
    while (strcmp(strary[j],x) > 0 && j > k1) j--;
    if (i <= j) {
      y = strary[i];
      strary[i] = strary[j];
      strary[j] = y;
      i++; j--;
    }
  } while (i <= j);
  if (k1 < j)  string_sort(strary,k1,j);
  if (i < k2)  string_sort(strary,i,k2);
  return;
}
