/* $Id: signal.c,v 1.2 1997/07/06 14:34:49 eilts Exp eilts $ */
#include "bbs.h"

#if 0
int sigalrqueue_in(TIME_T secs, int id, void (*handler)(int), int prio)
{
  TIME_T nextalarm;
  boolean oldentry = FALSE;
  SIGSET_T sigset;
  sigalrmqueuetyp *ptr;

  sigemptyset(&sigset);
  sigaddset(&sigset, SIGALRM);
  sigprocmask(SIG_BLOCK,&sigset,NULL);
  for (ptr=sigalrmqueueanchor; ptr!=(sigalrmqueuetyp *)NULL; ptr=ptr->next) {
    if (id == ptr->id) {
      oldentry = TRUE;
      ptr->time = time((TIME_T)0) + secs;
    }
  }
  if (! oldentry) {
    ptr = sigalrmqueueanchor;
    sigalrmqueueanchor = (sigalrmqueuetyp *)malloc(sizeof(sigalrmqueuetyp));
    sigalrmqueueanchor->next = ptr;
    sigalrmqueueanchor->id = id;
    sigalrmqueueanchor->prio = prio;
    sigalrmqueueanchor->handler = handler;
    sigalrmqueueanchor->time = time((TIME_T)0) + secs;
  }
  nextalarm = alarm(0);
  if (nextalarm == 0 || secs < nextalarm) {
    nextalarm = secs;
    alarm(nextalarm);
  }
  sigprocmask(SIG_UNBLOCK,&sigset,NULL);
  return nextalarm;
}


int sigalrmqueue_out(ind id)
{
  SIGSET_T sigset;
  boolean found = FALSE;
  sigalrmqueuetyp *ptr;

  sigemptyset(&sigset);
  sigaddset(&sigset, SIGALRM);
  sigprocmask(SIG_BLOCK,&sigset,NULL);
  preptr = NULL;
  for (ptr=sigalrmqueueanchor; ptr!=(sigalrmqueuetyp *)NULL && ! found;
       ptr=ptr->next) {
    if (id == ptr->id) {
      found = TRUE;
      if (preptr != (sigalrmqueuetyp *)NULL) {
        preptr->next = ptr->next;
      }
      else {
        sigalrmqueueanchor = ptr->next;
      }
      free(ptr);
    }
    else {
      preptr = ptr;
    }
  }   
  sigprocmask(SIG_UNBLOCK,&sigset,NULL);
  if (found) {
    return 0;
  }
  return EINVAL;
}


int sigalrmqueue_rm(void)
{
  SIGSET_T sigset;
  sigalrmqueuetyp *ptr;

  sigemptyset(&sigset);
  sigaddset(&sigset, SIGALRM);
  sigprocmask(SIG_BLOCK,&sigset,NULL);
  while (sigalrmqueueanchor != (sigalrmqueuetyp *)NULL) {
    ptr = sigalrmqueueanchor;
    sigalrmqueueanchor = ptr->next;
    free(ptr);
  }
  sigprocmask(SIG_UNBLOCK,&sigset,NULL);
  return;
}


void sigalrmqueue_handler(int sig)
{
  int mprio;
  TIME_T curtime, nexttime;
  SIGSET_T sigset;
  sigalrmqueuetyp *ptr, *preptr, malr;

  if (sigalrmqueueanchor == (sigalrmqueuetyp *)NULL)  return;
  sigemptyset(&sigset);
  sigaddset(&sigset, SIGALRM);
  sigprocmask(SIG_BLOCK,&sigset,NULL);
  mprio = -1;
  curtime = time((TIME_T)0);
  preptr = NULL;
  for (ptr=sigalrmqueueanchor; ptr!=(sigalrmqueuetyp *)NULL; ptr=ptr->next) {
    if (ptr->time <= curtime) {
      if (ptr->prio > mprio) {
        malr.id = ptr->id;
      }
      if (preptr != (sigalrmqueuetyp *)NULL) {
        preptr->next = ptr->next;
      }
      else {
        sigalrmqueueanchor = ptr->next;
      }
      free(ptr);
    }
    else {
      preptr = ptr;
    }
  }
  
  if (sigalrmqueueanchor != NULL) {
    nexttime = sigalrmqueueanchor->time;
    for (ptr=sigalrmqueueanchor; ptr!=(sigalrmqueuetyp *)NULL; ptr=ptr->next) {
      if (ptr->time < nexttime)  nexttime = ptr->time;
    }
    nexttime = nexttime - time((TIME_T)0);
    if (nexttime <= 0)  nexttime = 1;
    alarm(nexttime);
  }
  else {
    alarm(0);
  }
  sigprocmask(SIG_UNBLOCK,&sigset,NULL);
  if (malr.handler != SIG_IGN) {
    malr.handler(sig);
  }
  return;
}
#endif

void sighandler(int sig)
{
  signumber = sig;
  switch (sig) {
  case SIGTERM:
  case SIGHUP:
    if (canjump_sigenv)  siglongjmp(sigenv,1);
    break;
  case SIGALRM:
    if (canjump_sigalrm)  siglongjmp(sigalrmenv,1);
    break;
  case SIGUSR1:
    if (canjump_sigusr1)  siglongjmp(sigusr1env,1);
    break;
  case SIGUSR2:
    if (canjump_sigusr2)  siglongjmp(sigusr2env,1);
    break;
  }
  bgerror("sighandler","got signal %d but cannot jump",sig);
}


void sigtalkaccepthandler(int sig)
{
  if (canjump_talkaccept)  siglongjmp(talkacceptenv,1);
  bgerror("sigtalkaccepthandler","got signal %d but cannot jump",sig);
}
