/* $Id: msg.c,v 1.2 1997/07/06 14:34:49 eilts Exp eilts $ */
#include "bbs.h"

const char *msg(const char *upname, const int nr, const int lang)
{
int k;
static char noerrormsg[100];
static const char *bbs[] = {
  "Abbruch wegen Signals",
  "Terminated by signal",
  "Abbruch wegen SigTerm",
  "Terminated by SigTerm",
  "Abbruch wegen SigHup",
  "Terminated by SigHup",
  "Abbruch wegen unbekannten Signals",
  "Terminated by unknown signal",
  "Komandozeile zu lang",
  "command line too long",
  "interner Fehler beim Komandozeileneinlesen",
  "internal error at reading command line",
  "Autologout wegen Timeout (Kommandoeigabe)",
  "autologout by waiting for command",
  "%s %s: unbekannter Befehl",
  "%s %s: unknown command"
};
static const char *bbsinit[] = {
  "Login erfolglos",
  "Login failed"
};
static const char *windowtext[] = {
  "Druecke eine Taste",
  "Press a key to continue"
};
static const char *tlpager[] = {
  "Pager (Ende): [Backspace,Q]>",
  "Pager (end): [Backspace,Q]>",
  "Pager (Anfang): [Space,Q]>",
  "Pager (top): [Space,Q]>",
  "Pager (Zeile %d): [Space,Backspace,Q]>",
  "Pager (line %d): [Space,Backspace,Q]>",
  "Pager (Alles): [Q]>",
  "Pager (all): [Q]>",
  "Pager (leer): [Q]>",
  "Pager (empty): [Q]>"
};
static const char *usergreeting[] = {
  "\n\nTerminaltyp ist %s (druecke [Return] wenn ok, sonst gebe anderen an): ",
  "\n\nTerminaltyp is %s (press [Return] if ok, else enter another): ",
  "\n\nTerminaltyp ist %s\n[Return] wenn ok, sonst gebe anderen an ([?] fuer eine Auswahl): ",
  "\n\nTerminaltyp is %s\n[Return] if ok, else enter another ([?] for a selection): ",
  "\n Hinweis: Terminaltyp %s existiert (Kleinschreibung)",
  "\n Tip: Terminalyp %s exists (lowercases)",
  "\n Terminaltyp %s ist nicht verfuegbar, versuche einen anderen: ",
  "\n Terminaltyp %s is not available, try another one: "
};
static const char *rawshowtermtable[] = {
  "[Return] zum weiterblaettern",
  "[Return] to page"
};
static const char *do_sprache[] = {
  "Sprache: %s",
  "Language: %s"
};
static const char *do_autozmodem[] = {
  "automatische Uploads per Z-Modem: an",
  "automatic Z-Modem-Uploads: on",
  "automatische Uploads per Z-Modem: aus",
  "automatic Z-Modem-uploads: off"
};
static const char *do_fullist[] = {
  "Dateien bei Directorywechsel mit auflisten: ja",
  "list files on change directory also: yes",
  "Dateien bei Directorywechsel mit auflisten: nein",
  "list files on change directory also: no"
};
static const char *do_cd[] = {
  "Verzeichnis gesperrt",
  "directory is not accessible"
};
static const char *do_get[] = {
  "%s: existiert nicht (nicht uebertragen)",
  "%s: not existent (no transfer)",
  "%s: keine Datei (nicht uebertragen)",
  "%s: not a file (no transfer)",
  "%s: keine Leseberechtigung (nicht uebertragen)",
  "%s: no reading permittion (no transfer)"
};
static const char *do_home[] = {
  "unzulaessiges Homedirectory",
  "wrong home",
  "Sorry: Home kann auf Sicherheitslevel 0 nicht veraendert werden",
  "sorry: you cannot change home at security level 0"
};
static const char *do_protokoll[] = {
  "Sorry:\nKermit nicht erlaubt",
  "Sorry:\nKermit not allowed"
};
static const char *do_put[] = {
  "keine Schreibberechtigung zum Upload in %s, Abbruch",
  "no permittion for uploading in %s, aborted",
  "Upload in %s ok",
  "Upload in %s ok",
  "Upload in %s gescheitert",
  "Upload in %s failed"
};
static const char *do_showfile[] = {
  "%s: existiert nicht",
  "%s: not existent",
  "%s: keine Datei",
  "%s: not a file",
  "%s: keine Leseberechtigung",
  "%s: no reading permittion",
  "Pager (Ende): [Backspace,Q]>",
  "Pager (end): [Backspace,Q]>",
  "Pager (Anfang): [Space,Q]>",
  "Pager (top): [Space,Q]>",
  "Pager (Zeile %d): [Space,Backspace,Q]>",
  "Pager (line %d): [Space,Backspace,Q]>",
  "Pager (Alles): [Q]>",
  "Pager (all): [Q]>",
  "wahrscheinlich eine Binaerdatei, Aktion abbrechen? [J,N]>",
  "probably a binary file, abort action? [Y,N]>",
  "Umlaute nach ASCII konvertieren? [J,N]>",
  "convert Umlauts to ASCII? [Y,N]>"
};
static const char *do_newpasswd[] = {
  "%s: unbekannter Benutzer",
  "%s: unknown user",
  "%s: neues Password durch %s",
  "%s: new password by %s",
  "Password geaendert",
  "password changed",
  "Password nicht geaendert",
  "password not changed"
};
static const char *pathnamesexpand[] = {
  "keine Backquotes in Pfadnamen erlaubt",
  "no backquotes allowed",
  "keine Pfeile in Pfadnamen erlaubt",
  "no arrows allowed",
  "keine senkrechten Striche in Pfadnamen erlaubt",
  "no vertical bars allowed",
  "keine &-Zeichen in Pfadnamen erlaubt",
  "no amphersands allowed"
};
static const char *expandfilenames[] = {
  "Argumentzeile zu lang",
  "arguments too long",
  "Fehlerhaftes Suchmuster: %s",
  "wrong pattern: %s",
  "Filenamenexpansion ergibt zuviele Files",
  "expanding filenamens: too many names",
  "Argumentzeilenexpansion zu lang",
  "expanding filenames: too long"
};
static const char *talkscreen[] = {
  " Druecke Escape zum beenden ",
  " Press Escape to exit talk "
};
static const char *iniconnecttouser[] = {
  "Talk beendet",
  "talk finished",
  "Talk von der anderen Seite abgelehnt",
  "talk rejected by remote user",
  "warte auf Antwort (druecke 'Q' zum Abbrechen) [Q]> ",
  "waiting for response (press 'Q' to abort) [Q]> ",
  "Talk abgebrochen",
  "talk aborted",
  "andere Seite ist belegt",
  "other party is busy"
};
static const char *remconnecttouser[] = {
  "Talk beendet",
  "talk finished",
  "Talk abgebrochen",
  "talk aborted",
  "User %s wuenscht Talk: 'A' nimmt an, 'Q' lehnt ab [A,Q]> ",
  "User %s wants to talk: A accepts, Q rejects [A,Q]> "
};
static const char *getkeyonprompt[] = {
  "Druecke 'Escape' zum Abbrechen",
  "press 'Escape' to abort",
  "Druecke '?' fuer Kurzhilfe oder 'Escape' zum Abbrechen",
  "press '?' for help or 'Escape' to abort"
};
static const char *mail[] = {
  "Antwort auch an Co-Empfaenger (Cc-Feld) senden [J,N] ?",
  "Send answer to co-recipients (Cc-field) too [Y,N] ?",
  "Antwort per Nachricht [N] oder per E-Mail [E] versenden ?",
  "Send answer by message [M] or by e-mail [E] ?"
};
static const char *getcmdline_c[] = {
  "*** Programm BBS ***",
  "*** Program BBS ***",
  "*** Programm BBS: Systemparameter ***",
  "*** Program BBS: System Configuration ***",
  "*** Programm BBS: BBS-System ***",
  "*** Program BBS: BBS-System ***",
  "Arbeitsdirectory: %s",
  "working directory: %s"
};
static const char *selectmenue_c[] = {
  "Druecken Sie eine der in '[]' angegebenen Tasten:",
  "Press a key from '[]':"
};
static const char *menueselect_c[] = {
  "Pager (Ende): [Backspace,Return], ",
  "Pager (end): [Backspace,Return], ",
  "Pager (Anfang): [Space,Return], ",
  "Pager (top): [Space,Return], ",
  "Pager (Zeile %d): [Space,Backspace,Return], ",
  "Pager (line %d): [Space,Backspace,Return], ",
  "Pager (Alles): [Return], ",
  "Pager (all): [Return], ",
  "Pager (leer): [Return], KEINE WAHL>",
  "Pager (empty): [Return], NO SELECT>",
  "waehle: [A-",
  "select: [A-",
  "keine Wahl>",
  "no select>"
};
#ifdef NNTPNEWS
static const char *newsbrowser_c[] = {
  "Sie duerfen keine News lesen",
  "Sorry, you cannot read News",
  "kontaktiere Newsserver %s ...",
  "connecting newsserver %s ...",
  "abbonierte Newsgruppen (%d):",
  "subscribed newsgroups (%d):",
  "[A]lle oder nur [U]ngelesene Artikel auflisten ?",
  "list [A]ll or only [U]nread articles ?",
  "abbonniere Newgruppe [J,N] ?",
  "subscribe newsgroup [Y,N] ?",
};
static const char *postarticle_c[] = {
  "sende Artikel:",
  "post article",
  "Sie duerfen keine Artikel senden",
  "Sorry, You are not allowed to post",
  "Newsgruppe: ",
  "Newsgroup: ",
  "Warnung: Newsgruppe %s ist unbekannt",
  "Warning: Group %s is unknown",
  "[W]eiter  [N]ochmal  [A]bbrechen ?",
  "[P]roceed  [R]etry  [A]bort ?",
  "Thema: ",
  "Subject: ",
  "sende Artikel ...",
  "posting article ...",
  "Gebe Newsgruppen und Thema ein, es wird dann der Editor aufgerufen, in\n\
dem der Artikel erstellt wird. Editor mit 'S' (im Koammandozeilenmodus der\n\
durch CTRL-X erreicht wird) verlassen.\n\n\
Abbruch ist durch Druecken von Escape moeglich",
  "Enter newsgroups and subject, then the editor will be called for your\n\
articel.\n\
Quit editor by 'S' (in command-mode, which can be entered by CTRL-X).\n\n\
Abort by pressing Escape"
};
static const char *subscribenewsgroups_c[] = {
  "abboniere Newsgruppen",
  "subscribe newsgroups",
  "Sie duerfen keine Newsgruppen abbonieren",
  "Sorry, you are not allowed to subscribe newsgroups",
  "lese Liste aller Newsgruppen ...",
  "reading list of all newsgroups ..."
};
static const char *newspager_c[] = {
  "",
  ""
};
static const char *newsdateselect_c[] = {
  "Gebe Datumsbereich ein (? fuer Kurzhilfe)",
  "Enter time range (? for help):",
  "TT.MM.JJ fuer alle juengeren Artikel oder\n\
TT.MM.JJ-TT.MM.JJ fuer alle Artikel im angegebenen Zeitraum\n\
Wird das Jahr nicht angegeben, wird das momentane angenommen.",
  "DD.MM.YY for all article more recent or\n\
DD.MM.YY-DD.MM.YY for all article in this space of time\n\
If year is omitted, current year will be assumed.",
  "falsches 'von' Datumsformat",
  "wrong 'from' date format",
  "falsches 'bis' Datenformat",
  "wrong 'to' date format"
};
#endif
static const char *msgbrowser_c[] = {
  "keine Nachricht vorhanden",
  "no messages",
  "waehle Nachricht:",
  "select message:",
  "Nachricht lesen [R],  loeschen [D],  beantworten [A],  downladen [G] ?",
  "[R]ead, [D]elete, [A]nswer, [G]et (download) message ?"
};
static const char *sendmessage_c[] = {
  "sende Nachricht an:",
  "send message to:",
  "\n\nThema: ",
  "\n\nsubject: "
};
static const char *sendmail_c[] = {
  "sende E-Mail an:\n\n",
  "send e-mail to:\n\n",
  "\n\nAddresse: ",
  "\n\naddress: ",
  "\n\nThema: ",
  "\n\nsubject: ",
  "Sie duerfen keine E-Mail an diese Addresse senden",
  "You are not allowed to send e-mail to this address",
  "Gebe Addressaten und Thema ein, es wird dann der Editor aufgerufen, in\n\
dem die Mail erstellt wird. Editor mit 'S' (im Koammandozeilenmodus der\n\
durch CTRL-X erreicht wird) verlassen.\n\n\
Abbruch ist durch Druecken von Escape moeglich",
  "Enter address and subject, then the editor will be called for your mail.\n\
Quit editor by 'S' (in command-mode, which can be entered by CTRL-X).\n\n\
Abort by pressing Escape"
};
static const char *put_c[] = {
  "Uploads per Z-Modem werden automatisch erkannt.\nBei Problemen kann im 'Systemparameter'-Menue die Automatik\ndesaktiviert werden",
  "Uploads by Z-Modem will be recognized automatically.\nOn problems, deactivate it (menu 'System Configuration')"
};
static const char *sprache_c[] = {
  "waehle Sprache:",
  "select language:",
  "momentane Sprache ist: ",
  "current language is: ",
  "Quit (ohne Aenderung)",
  "Quit (without change)",
  "Druecken Sie eine der in '[]' angegebenen Tasten:",
  "Press a key from '[]':"
};
static const char *autozmodem_c[] = {
  "waehle automatische Uploads per Z-Modem:",
  "select automatic Z-Modem-uploads:",
  "Automatik ist an",
  "automatic is on",
  "Automatik ist aus",
  "automatic is off",
  "Aendern",
  "toggle",
  "Quit (ohne Aenderung)",
  "Quit (without change)",
  "Druecken Sie eine der in '[]' angegebenen Tasten:",
  "Press a key from '[]':"
};
static const char *fullist_c[] = {
  "Dateien bei Directorywechsel mit anzeigen:",
  "List files on change directory also:",
  "Ja",
  "Yes",
  "Nein",
  "No",
  "Aendern",
  "toggle",
  "Quit (ohne Aenderung)",
  "Quit (without change)",
  "Druecken Sie eine der in '[]' angegebenen Tasten:",
  "Press a key from '[]':"
};
static const char *protokoll_c[] = {
  "waehle Uebertragungsprotokoll:",
  "select transfer protocol:",
  "momentanes Protokoll ist: ",
  "current protocol is: ",
  "Quit (ohne Aenderung)",
  "Quit (without change)",
  "Druecken Sie eine der in '[]' angegebenen Tasten:",
  "Press a key from '[]':"
};
static const char *talk_c[] = {
  "BELEGT",
  "BUSY",
  "GESCHAEFTIG",
  "WORKING",
  "FREI",
  "FREE",
  "waehle Gespraechspartner:",
  "select other party:",
  "kein Gespraechspartner vorhanden",
  "no other party available"
};
static const char *term_c[] = {
  "Terminaltyp: momentan: %s, neu: ",
  "Term: currently: %s new: ",
  "\nTerminaltyp %s ist unbekannt, neu: ",
  "\nunknown term %s, new: ",
  "\nZeilenanzahl: momentan: %d, neu: ",
  "\nLines: currently: %d, new: ",
  "\nSpaltenanzahl: momentan: %d, neu: ",
  "\nColumns: currently %d, new: ",
  "Terminaltyp einstellen:\n\n",
  "change terminal:\n\n",
  "Gebe neuen Terminaltyp und dessen Zeilen-/Spaltenanzahl ein\n\
Bei leerer Eingabe wird der alte Wert beibehalten\n\n\n",
  "Enter new terminal type and its rows/columns\n\
Empty input save old values\n\n\n",
  "Zeichensatz waehlen:",
  "select charset:"
};
static const char *newpasswd_c[] = {
  "waehle neues Password (maximal %d Zeichen): ",
  "select new password (%d chars maximum): ",
  "Sie duerfen Ihr Password nicht veraendern",
  "You are not allowed to change password",
  "Name des Benutzers: ",
  "Username to change: ",
  "neues Password: ",
  "new password: ",
  "bitte neues Password wiederholen: ",
  "please repeat new password: ",
  "ungleiche Eingabe, Aktion abgebrochen",
  "different passwords, action terminated",
  "Gebe das neue Password ein und bestaetige es anschliessend\n\
Abbruch der Aktion ist durch ESCAPE moeglich\n\n\n",
  "Enter new password and confirm it\nAbort by ESCAPE"
};
static const char *selectterm_c[] = {
  "waehle Terminaltyp:",
  "select terminal type:"
};
static const char *selectdir_c[] = {
  "waehle das neue Directory:",
  "select new directory:",
  "Arbeitsverzeichnis",
  "working directory",
  "Datei",
  "File"
};
static const char *selectfiles_c[] = {
  "waehle das File:",
  "select file",
  "markiere das gewuenschte File:",
  "select file",
  "markiere die gewuenschten Files:",
  "select files",
  "Abbruch wegen zu vieler Files\n(Sie koennen sie auf mehrere Downloads verteilen)",
  "aborted: too many files\n(you may split they over multiple downloads)"
};
static const char *wildcardselect_c[] = {
  "Fehlerhaftes Suchmuster: %s",
  "wrong pattern: %s",
  "Gebe regulaeren Ausdruck ein (? fuer Kurzhilfe):",
  "Enter regular expression (? for help):",
  "* steht fuer einen beliebigen Teilstring,\n? fuer ein oder null beliebiges Zeichen,\n[x-y] steht fuer jedes Zeichen im Bereich x-y",
  "* matches an arbitray part,\n? matches one or zero chars,\n[x-y] matches every character in x-y once",
  "* steht fuer einen beliebigen Teilstring",
  "* matches an arbitray part"
};
static const char *bbsquit_c[] = {
  "BBS wirklich beenden? [J,N]",
  "really quit BBS? [Y,N]"
};
static const char *browsegroup[] = {
  "lese Gruppenuebersicht ...",
  "reading news overview ...",
  "keine ungelesenen Artikel, alle auflisten [J,N] ?",
  "no unread article, list all available [Y,N] ?",
  "keine Artikel in Newgruppe %s",
  "no article in newsgroup %s",
  "%s (%d Artikel):",
  "%s (%d article):",
  "[L]ese  [A]ntworte/folge  [G]download  Artikel ?",
  "[R]ead  [A]nswer/follow up  [G]download  article ?",
  "lese Artikel: %s ...",
  "reading article: %s ...",
  "zurueck zur Artikelauswahl [J,N] ?",
  "back to article select [Y,N] ?",
  "Antworte Artikel: %s: %s:",
  "answer article: %s: %s"
};
static const char *newsreply[] = {
  "[E]-Mail,  [A]rtikel  oder [B]eides ?",
  "[E]-mail,  [A]rticle  or [B]oth ?"
};
static const char *writehelptouser[] = {
  "keine Hilfe verfuegbar",
  "no help available",
  "* keine Hilfe verfuegbar *",
  "* no help available *",
  "Angezeigt werden die Dateien (mit Erstellungsdatum und Groesse)\n\
und Verzeichnisse (Directory) des Arbeitsverzeichnisses\n\n\
Vorblaettern mit SPACE\nZurueckblaettern mit BACKSPACE oder DELETE\n\
zum Hauptmenue zurueck mit 'Q'",
  "Listed are all files (with date and size)\n\
and directories (Directory) of working directory\n\n\
page by SPACE\npage back by BACKSPACE or DELETE\nback to main menu by 'Q'",
  "Druecken einer Buchstabentaste wechselt das Arbeitsverzeichnis\n\
entsprechend, wobei '..' fuer das Elterverzeichnis und 'HOME'\n\
fuer das Startverzeichnis stehen\n\nVorblaettern mit SPACE\n\
Zurueckblaettern mit BACKSPACE oder DELETE\nzum Hauptmenue zurueck mit RETURN",
  "Pressing an alpha-key changes the working directory accordingly,\n\
'..' means parent directory and 'HOME' HOME-directory\n\npage by SPACE\n\
page back by BACKSPACE or DELETE\nback to main menu by RETURN",
  "Druecken einer Buchstabentaste zeigt den Inhalt\nder entsprechenden Datei an\n\n\
Vorblaettern mit SPACE\nZurueckblaettern mit BACKSPACE oder DELETE\n\
zurueck zum Hauptmenue (ohne Anzeigen) mit ESCAPE",
  "Pressing an alpha-key lists content of according file\n\n\
page by SPACE\npage back by BACKSPACE or DELETE\n\
back to main menu (without any listing) by ESCAPE",
  "Zunaechst muessen die zu uebertragenden Dateien markiert werden,\n\
durch Druecken der entsprechenden Tasten oder, nach Druecken von\n\
'*', durch anschliessende Eingabe einer Maske\n\
Markierte Dateien werden bei nochmaliger Anwahl wieder demarkiert\n\n\
Vorblaettern mit SPACE\nZurueckblaettern mit BACKSPACE oder DELETE\n\n\
Start der Uebertragung mit RETURN\nAbbruch der Auswahl und zurueck zum Hauptmenue mit ESCAPE",
  "First, mark desired files by pressing according alpha-keys or,\n\
after pressing '*', by entering a mask\n\
Selecting an already marked file deselects it\n\n\
page by SPACE\npage back by BACKSPACE or DELETE\nstart transmit by RETURN\n\
abort and back to main menu by ESCAPE",
  "Die Sprache von BBS kann durch Druecken der entsprechenden\n\
Taste gewaehlt werden\n\nDruecken von 'Q' behaelt die alte Sprache bei",
  "The language of BBS may be changed by pressing an according key\n\n\
Pressing 'Q' saves old language",
  "Das Uebertragungsprotokoll zum Senden und Empfangen von Dateien kann\n\
durch Druecken der entsprechenden Taste gewaehlt werden\n\n\
Druecken von 'Q' behaelt das alte Protokoll bei",
  "Select transfer protocol for files by pressing an according key\n\
pressing 'Q' saves old transfer protocol",
  "Die automatische Erkennung von Uploads per Z-Modem kann durch\n\
Druecken von 'A' umgeschaltet werden,\n\
Druecken von 'Q' behaelt die alte Einstellung bei",
  "Automatic Z-modem upload detection can by switched on/off\n\
by pressing 'A'\npressing 'Q' saves old state",
  "Beim Wechsel des Arbeitsverzeichnisses werden wahlweise auch die\n\
enthaltenen Dateien mit angezeigt,\nDruecken von 'A' aendert das,\n\
Druecken von 'Q' behaelt die alte Einstellung bei",
  "Files are listed by changing working directory may be\n\
switched on/off by pressing 'A',\npressing 'Q' saves old state",
  "Druecken einer Buchstabentaste initiiert einen Dialog mit dem\n\
ausgewaelten User\n\n\
Angezeigt werden neben dem Usernamen mit Tty und Pid seiner\n\
Sitzung der Zustand des Users:\n\nFREI: User ist frei\n\
GESCHAEFTIG: User ist frei, kann aber nicht sofort antworten\n\
BELEGT: User fuert bereits einen Dialog\n\n\
Zurueck zum Hauptmenue (ohne einen Dialog zu initiieren) mit ESCAPE",
  "A dialog to another user is started by pressing its according key\n\
Shown are users and besides ttys and session-pids its state:\n\n\
FREE: user is free\n: user is free but cannot answer at once\n\
BUSY: user is already talking\n\n\
back to main menu (without starting any dialog) by ESCAPE",
  "Druecken einer Buchstabentaste waehlt den entsprechenden\n\
Terminaltyp aus, anschliessend werden noch die Zeilen- und\nSpaltenanzahl\n\
des Terminals erfragt\n\n\
Druecken von RETURN behaelt den alten Terminaltyp bei\n\
(gilt entsprechend auch bei Zeilen- und Spaltenanzahl)\n\n\
Druecken von ESCAPE wechselt zur direkten Terminaltypeingabe",
  "Select a new terminal type by pressing its according key,\n\
in sequel its columns/rows will be asked, too\n\n\
pressing RETURN saves old terminal type\n\
(this is also the case on columns/rows)\n\n\
pressing ESCAPE switches to entering terminaltype directly",
  "Zunaechst muessen alle Addressaten markiert werden, durch Druecken\n\
der entsprechenden Tasten oder, nach Druecken von '*', durch\n\
anschliessende Eingabe einer Maske.\n\
Markierte Addressaten werden bei nochmaliger Anwahl wieder demarkiert\n\
\nVorblaettern mit SPACE\nZurueckblaettern mit BACKSPACE oder DELETE\n\
Weiter (die Nachricht editieren) mit RETURN\n\
Abbruch der Auswahl und zurueck zum BBS-Menue mit ESCAPE",
  "First, mark recipients by pressing according alpha-keys, or,\n\
after pressing '*', by entering a mask.\n\
Selecting an already marked recipient deselects him.\n\
\npage by SPACE\npage back by BACKSPACE or DELETE\n\
\ngo on (to edit message) by RETURN\nabort and back to BBS menu by ESCAPE",
  "Angegeben sind jeweilts der Absender, der Typ der Nachricht (in Klammern)\n\
und das Thema.\n\nNachrichtentypen:\nS: Nachricht/E-Mail vom Sysop\n\
M: lokale (d.h. innerhalb von BBS versendete) Nachricht\n\
L: lokale E-Mail\n R: E-Mail von ausserhalb.\n\n\
Waehle die gewuenschte Nachricht durch Druecken der\nentsprechenden in\
'[]' stehenden Taste aus",
  "Listed are sender, type (in braces), and subject of each message.\n\n\
Messagetypes are:\nS: message/e-mail from system operator,\n\
M: local (i.e. internal to BBS delivered) message\n\
L: local e-mail\nR: e-mail from remote sender.\n\n\
Select desired message by pressing its according key",
  "Druecke\n'R' zum Lesen der Nachricht\n'D' zum Loeschen der Nachricht\
\n'A' zum Beantworten der Nachricht\n\n\
Druecke Escape zum Abbrechen",
  "Press\n'R' to read message\n'D' to delete message\n'A' to answer message\n'G' to download message\n\n\
Pressing Escape aborts",
  "Aufgelistet sind alle abbonierten Newsgruppen, waehle die gewuenschte\n\
durch ihre Taste aus.\n\
Durch Druecken der Return-Taste koennen auch nichtabbonierte Newsgruppen\n\
ausgewaehlt werden.\n\
Gelesene Gruppen werden durch ein '!' gekennzeichnet\n\n\
Durch Escape kann man zum BBS-Menue zurueckkehren.",
  "Listed are all subscribed newsgroups, select desired by pressing its key.\n\
By pressing Return, you can select unsubscribed newsgroups\n\
Read newsgroups are shown by '!'.\n\n\
Quit newsreading by pressing Escape.",
  "Aufgelistet sind alle (ungelesenen) Artikel der Newsgruppe.\n\
Markiere alle gewuenschten Artikel und bestaetige durch Return.\n\
Wird '*' gedrueckt, koennen alle Artikel eines anzugebenden Zeitraums\n\
markiert werden.\n\n\
Anschliessend koennen die markierten Artikel gelesen, beantwortet\n\
oder downgeladen werden, wobei beim Lesen/Beantworten mit 'Q' zum jeweils\n\
naechsten Artikel gesprungen wird.\n\
Gelesene Artikel werden durch ein '!' gekennzeichnet\n\n\
Durch Escape kann man zur Newsgruppenauswahl zurueckkehren.",
  "Listed are all (unread) articles.\n\
Mark all desired articles and confirm by pressing Return.\n\
By pressing '*', a space of time can be entered to mark every\n\
fitting aricle.\n\n\
All marked articles can be read, answerd, or downladed, 'Q' jumps\n\
on reading/answering to next article.\n\
Read articles are shown by '!'.\n\n\
Go back to newsgroup menu by pressing Escape.",
  "Die Artikel koennen gelesen, beantwortet oder downgeladen werden,\n\
wobei Antworten per E-Mail an den Absender oder per Artikel in\n\
Newsgruppen oeffentlich erfolgen koennen.",
  "Articles can be read, answered, or downloaded\n\
and answers can be given by e-mail to author or by posting\n\
to the public newsgroup.",
  "Die betreffende Newsgruppe ist momentan nicht abboniert\n\
und kann durch 'J' abonniert werden.",
  "This newsgroup is not subscribed jet\n\
and can be subscribed by 'Y'.",
  "Es werden alle bekannten Newsgruppen aufgelistet, wobei die bereits\n\
abbonierten markiert sind. Durch Druecken der entsprechenden Tasten\n\
koennen Newsgruppen abboniert/deabboniert werden.\n\n\
Bestaetigen der Wahl mit Return, abbrechen mit Escape.",
  "There are listed all known newsgroups with already subscribed marked.\n\
By pressing according keys newsgroups can be subscribed/unsubscribed.\n\n\
Confirm selection by Return, abort by Escape.",
  "original -> Text unveraendert anzeigen\n\
ASCII    -> Text ASCII-konvertiert anzeigen\n\
NeXT     -> Text fuer NeXT konvertiert anzeigen\n\
?        -> bei Bedarf fragen",
  "original -> show text unchanged\n\
ASCII    -> show text converted to ASCII\n\
NeXT     -> show text converted for NeXT\n\
?        -> ask if necessary"
};

  k = 2*nr + lang;
  if (strcmp(upname,"bbs")==0) {
    return bbs[k];
  }
  else if (strcmp(upname,"bbsinit")==0) {
    return bbsinit[k];
  }
  else if (strcmp(upname,"windowtext")==0) {
    return windowtext[k];
  }
  else if (strcmp(upname,"tlpager")==0) {
    return tlpager[k];
  }
  else if (strcmp(upname,"usergreeting")==0) {
    return usergreeting[k];
  }
  else if (strcmp(upname,"rawshowtermtable")==0) {
    return rawshowtermtable[k];
  }
  else if (strcmp(upname,"do_sprache")==0) {
    return do_sprache[k];
  }
  else if (strcmp(upname,"do_autozmodem")==0) {
    return do_autozmodem[k];
  }
  else if (strcmp(upname,"do_fullist")==0) {
    return do_fullist[k];
  }
  else if (strcmp(upname,"do_cd")==0) {
    return do_cd[k];
  }
  else if (strcmp(upname,"do_get")==0) {
    return do_get[k];
  }
  else if (strcmp(upname,"do_home")==0) {
    return do_home[k];
  }
  else if (strcmp(upname,"do_protokoll")==0) {
    return do_protokoll[k];
  }
  else if (strcmp(upname,"do_put")==0) {
    return do_put[k];
  }
  else if (strcmp(upname,"do_showfile")==0) {
    return do_showfile[k];
  }
  else if (strcmp(upname,"do_newpasswd")==0) {
    return do_newpasswd[k];
  }
  else if (strcmp(upname,"pathnamesexpand")==0) {
    return pathnamesexpand[k];
  }
  else if (strcmp(upname,"expandfilenames")==0) {
    return expandfilenames[k];
  }
  else if (strcmp(upname,"iniconnecttouser")==0) {
    return iniconnecttouser[k];
  }
  else if (strcmp(upname,"talkscreen")==0) {
    return talkscreen[k];
  }
  else if (strcmp(upname,"remconnecttouser")==0) {
    return remconnecttouser[k];
  }
  else if (strcmp(upname,"getkeyonprompt")==0) {
    return getkeyonprompt[k];
  }
  else if (strcmp(upname,"mail")==0) {
    return mail[k];
  }
  else if (strcmp(upname,"getcmdline_c")==0) {
    return getcmdline_c[k];
  }
  else if (strcmp(upname,"selectmenue_c")==0) {
    return selectmenue_c[k];
  }
  else if (strcmp(upname,"menueselect_c")==0) {
    return menueselect_c[k];
  }
#ifdef NNTPNEWS
  else if (strcmp(upname,"newsbrowser_c")==0) {
    return newsbrowser_c[k];
  }
  else if (strcmp(upname,"postarticle_c")==0) {
    return postarticle_c[k];
  }
  else if (strcmp(upname,"subscribenewsgroups_c")==0) {
    return subscribenewsgroups_c[k];
  }
  else if (strcmp(upname,"newspager_c")==0) {
    return newspager_c[k];
  }
  else if (strcmp(upname,"newsdateselect_c")==0) {
    return newsdateselect_c[k];
  }
#endif
  else if (strcmp(upname,"msgbrowser_c")==0) {
    return msgbrowser_c[k];
  }
  else if (strcmp(upname,"sendmessage_c")==0) {
    return sendmessage_c[k];
  }
  else if (strcmp(upname,"sendmail_c")==0) {
    return sendmail_c[k];
  }
  else if (strcmp(upname,"put_c")==0) {
    return put_c[k];
  }
  else if (strcmp(upname,"sprache_c")==0) {
    return sprache_c[k];
  }
  else if (strcmp(upname,"autozmodem_c")==0) {
    return autozmodem_c[k];
  }
  else if (strcmp(upname,"fullist_c")==0) {
    return fullist_c[k];
  }
  else if (strcmp(upname,"talk_c")==0) {
    return talk_c[k];
  }
  else if (strcmp(upname,"protokoll_c")==0) {
    return protokoll_c[k];
  }
  else if (strcmp(upname,"term_c")==0) {
    return term_c[k];
  }
  else if (strcmp(upname,"newpasswd_c")==0) {
    return newpasswd_c[k];
  }
  else if (strcmp(upname,"selectterm_c")==0) {
    return selectterm_c[k];
  }
  else if (strcmp(upname,"selectdir_c")==0) {
    return selectdir_c[k];
  }
  else if (strcmp(upname,"selectfiles_c")==0) {
    return selectfiles_c[k];
  }
  else if (strcmp(upname,"wildcardselect_c")==0) {
    return wildcardselect_c[k];
  }
  else if (strcmp(upname,"bbsquit_c")==0) {
    return bbsquit_c[k];
  }
  else if (strcmp(upname,"browsegroup")==0) {
    return browsegroup[k];
  }
  else if (strcmp(upname,"newsreply")==0) {
    return newsreply[k];
  }
  else if (strcmp(upname,"writehelptouser")==0) {
    return writehelptouser[k];
  }

  sprintf(noerrormsg,"msg: no string found for %s, %i",upname,nr);
  return  noerrormsg;
}
