/* $Id: mailstuff.c,v 1.1 1997/07/06 14:34:49 eilts Exp eilts $ */
#include "bbs.h"

int parseaddrline(char *addr, char *realname, const char *zeile)
{
  char *ap, *rp;
  const char *zp;

  *addr = '\0';
  *realname = '\0';
  if (zeile == NULL)  return -1;
  for (zp=zeile; *zp && *zp!='<' && *zp!='('; zp++) ;
  if (*zp == '<') {
    for (rp=realname,zp=zeile; *zp!='<'; zp++,rp++)  *rp = *zp;
    *rp = '\0';
    for (ap=addr,zp++; *zp && *zp!='>'; zp++,ap++)  *ap = *zp;
    *ap = '\0';
  }
  else if (*zp == '(') {
    for (ap=addr,zp=zeile; *zp!='('; zp++,ap++)  *ap = *zp;
    *ap = '\0';
    for (rp=realname,zp++; *zp && *zp!=')'; zp++,rp++)  *rp = *zp;
    *rp = '\0';
  }
  else {
    strcpy(addr,zeile);
  }
  rm_ae_blanks(addr);
  rm_ae_blanks(realname);
  if (*addr != '\0')  return 0;
  return -1;
}


boolean testmailbegin(const char *str)
{
  return (strncmp(str,"From ",5) == 0);
}


char from_quotestream(const boolean bodyonly, FILE *infp, FILE *outfp)
{
  int n, k;
  char *pattern, c, c1, buf[5];
  
  if (! bodyonly) {
    c1 = ' ';
    while ((c=getc(infp)) != EOF) {
      putc(c,outfp);
      if (c == '\n' && c1 == '\n')  break;
      c1 = c;
    }
    if (c == EOF)  return c;
  }
  do {
    pattern = "From ";
    n = 0;
    while ((c=getc(infp)) == *pattern && *pattern) {
      buf[n++] = c;
      pattern++;
    }
    if (! *pattern)  putc('>',outfp);
    for (k=0; k<n; k++)  putc(buf[k],outfp);
    if (c == EOF)  break;
    putc(c,outfp);
  } while (c != EOF);
  return c;
}


int fprint_mailheaderline(char *hdrln, const char *key, FILE *fp)
{
  int k, n, anz;
  SIZE_T keylen;
  char *splits[MAXARGS+1];
  
  anz = splitstring(splits,hdrln,',',MAXARGS);
  if (splits[0] == NULL) {
    fprintf(fp,"%s:\n",key);
  }
  else {
    keylen = strlen(key);
    for (k=0; splits[k] != NULL; k++)  rm_ae_blanks(splits[k]);
    fprintf(fp,"%s: %s",key,splits[0]);
    for (k=1; splits[k] != NULL; k++) {
      fprintf(fp,",\n  ");
      for (n=0; n<keylen; n++)  putc(' ',fp);
      fputs(splits[k],fp);
    }
    putc('\n',fp);
  }
  return anz;
}


char *parsemailheader(mailheadertyp *mailhdr, FILE *fp,
                      const confrecordtyp *confrecord)
{
  int n, k;
  char c, c2, *sp, *buf, *key, *txt, *headers[101];
  static char *nullchar = "";

  mailhdr->from = nullchar;
  mailhdr->reply_to = nullchar;
  mailhdr->to = nullchar;
  mailhdr->cc = nullchar;
  mailhdr->subject = nullchar;
  mailhdr->date = nullchar;
  mailhdr->msg_id = nullchar;
  mailhdr->mime_encoding = nullchar;
  if ((buf=(char *)malloc(BUFSIZE)) == NULL) {
    errormsg(E_LOGFILE|E_USER,confrecord,"bbs","parsemailheader","malloc: %m");
    return NULL;
  }
  c = ' ';
  k = 0;
  n = 1;
  do {
    c2 = c;
    c = fgetc(fp);
    if (k >= n*BUFSIZE) {
      n++;
      if ((buf=(char *)realloc((void *)buf,n*BUFSIZE)) == NULL) {
        errormsg(E_LOGFILE|E_USER,confrecord,"bbs","parsemailheader",
	         "realloc: %m");
        free(buf);
	return NULL;
      }
    }
    if (c2 == '\n' && (c == ' ' || c == '\t')) {
      k--;
    }
    buf[k++] = c;
  } while (c != EOF && (c2 != '\n' || c != '\n'));
  buf[k-1] = '\0';
  splitstring(headers,buf,'\n',100);    
  for (k=0; headers[k] != NULL; k++) {
    if ((sp=strchr(headers[k],':')) != NULL) {
      *sp = '\0';
      key = headers[k];
      sp++;
      while (*sp == ' ' && *sp)  sp++;
      txt = sp;
      while (*sp)  sp++;
      if (sp > txt)  sp--;
      while (*sp == ' ' && sp > txt)  *sp-- = '\0';
      lowercases(key);
      if (strcmp(key,"from") == 0) {
        mailhdr->from = txt;
      }
      else if (strcmp(key,"reply-to") == 0) {
        mailhdr->reply_to = txt;
      }
      else if (strcmp(key,"to") == 0) {
        mailhdr->to = txt;
      }
      else if (strcmp(key,"cc") == 0) {
        mailhdr->cc = txt;
      }
      else if (strcmp(key,"subject") == 0) {
        mailhdr->subject = txt;
      }
      else if (strcmp(key,"date") == 0) {
        mailhdr->date = txt;
      }
      else if (strcmp(key,"message-id") == 0) {
        mailhdr->msg_id = txt;
      }
      else if (strcmp(key,"content-transfer-encoding") == 0) {
        mailhdr->mime_encoding = txt;
      }
    }
  }

  return buf;
}
