/* $Id: edit.h,v 1.1 1997/07/06 14:34:49 eilts Exp eilts $ */
#ifdef EDIT_MAIN
# include "edit_main.h"
#else
# include "bbs.h"
#endif

#ifndef _EDIT_INCLUDED
#define _EDIT_INCLUDED

#ifdef NeXT
extern char *tgetstr(const char *, char **);
extern int winsertln(WINDOW *);
extern int wdeleteln(WINDOW *);
extern int wclrtoeol(WINDOW *);
extern int scroll(WINDOW *);
extern int winsch(WINDOW *, int);
#endif

typedef enum {InsChar, ReturnChar, DelChar, KillLine, CurUp, CurDown, CurLeft,
              CurRight, PageUp, PageDown, LineStart, LineEnd, RedrawEdWin,
	      CmdLine, QuitEdit, SaveFile, AbortEdit, NoCmd, ErrCmd} keyboardcmd;
typedef struct {
  const char *id;
  char *sequenz;
  keyboardcmd cmd;
} termkeystruct;
#define LINE_START       1      /* ^A */
#define LINE_END       	 5      /* ^E */
#define REDRAW_ED_WIN	18	/* ^R */
#define KILL_LINE	11	/* ^K */
#define PAGE_UP		22	/* ^V */
#define PAGE_DOWN	23	/* ^W */
#define CMDLINE		24	/* ^X */

typedef struct {
  int t_x;
  int t_y;
  int a_x;
  int a_y;
  int a_t;
  int a_zeilen;
  char *a_zeile;
  int a_offset;
  int vscroll_a_x;
  boolean unsaved;
  boolean writeable;
} posstruct;

typedef struct {
  int cols;
  int lines;
  int curlines;
  boolean showcmdline;
} screenstruct;

#define INBUFLEN 128
#define KEYBOARDIN_R_TIME 0.02
#define KEYBOARDIN_SEQ_DELAY 4

typedef enum {TTY_EDIT_RESET, TTY_EDIT_SET} tty_editstateenum;

extern int edit(const char *, const MODE_T, const boolean, const U_INT,
                const confrecordtyp *);
extern int gettermkeys(termkeystruct [], const confrecordtyp *);
extern keyboardcmd keyboardin(char *, const termkeystruct [],
                              const confrecordtyp *);
extern keyboardcmd cmdline(posstruct *txt, screenstruct*, tlistetyp **tliste,
                           const confrecordtyp *);
extern void cur_right(posstruct*, const screenstruct*, tlistetyp**,
                      const confrecordtyp*);
extern void cur_left(posstruct*, const screenstruct*, tlistetyp**,
                     const confrecordtyp*);
extern void cur_down(posstruct*, const screenstruct*, tlistetyp**,
                     const confrecordtyp*);
extern void cur_up(posstruct*, const screenstruct*, tlistetyp**,
                   const confrecordtyp*);
extern void line_start(posstruct*, const confrecordtyp*);
extern void line_end(posstruct*, const confrecordtyp*);
extern void text_jump(const int, posstruct*, const screenstruct*, tlistetyp**,
                      const confrecordtyp*);
extern void page_screen(posstruct*, const screenstruct*, tlistetyp**,
                        const int, const confrecordtyp *);
extern int ins_char(const char, posstruct*, const screenstruct*,
                    tlistetyp**, const confrecordtyp*);
extern int return_char(posstruct*, const screenstruct*, tlistetyp**,
                       const confrecordtyp*);
extern void del_char(posstruct*, const screenstruct*, tlistetyp**,
                     const confrecordtyp*);
extern int join_lines(posstruct*, const int, const int, const screenstruct*,
                      tlistetyp**, const confrecordtyp*);
extern void kill_line(posstruct*, const screenstruct*, tlistetyp**,
                      const confrecordtyp*);
extern int insert_empty_line(posstruct*, const int, const int,
                       const screenstruct*, tlistetyp**, const confrecordtyp*);
extern int delete_line(posstruct*, const int, const int, const screenstruct*,
                       tlistetyp**, const confrecordtyp*);
extern char *rebreak_t_line(posstruct*, const int, const int,
                     const screenstruct*, tlistetyp **, const confrecordtyp *);
extern char *strinsert_char(char *, const char, const SIZE_T, char *,
                            const SIZE_T, const confrecordtyp *);
extern char *strdel_char(char *, const SIZE_T, char *);
extern void redraw_screen(posstruct*, const screenstruct*, tlistetyp**,
                          const confrecordtyp*);
extern void printline(const char*);
extern void ringbell(void);
extern boolean getcmd_on_prompt(char *, const SIZE_T, const char *,
                             const char *, const boolean, const screenstruct*);
extern int readcommand(char [], const int);
extern int save_file(const char *, const MODE_T, posstruct *, const boolean,
                     const screenstruct*, tlistetyp **, const U_INT,
		     const confrecordtyp *);
extern int copyfile(const char *, const char *, const boolean,
		    const confrecordtyp *);
extern void showcmdlmsg(const char *, const U_INT, const screenstruct *);
extern int tty_editset(int, struct termios *, tty_editstateenum *);
extern int tty_editreset(int, struct termios *, tty_editstateenum *);
extern int waitread(const int, char *, const SIZE_T, const int);
extern void showhelp(const screenstruct *, const confrecordtyp *);
#endif
