/* $Id: local-in.h,v 1.1 1997/07/06 14:34:49 eilts Exp eilts $ */
#ifndef _LOCAL_INCLUDED
#define _LOCAL_INCLUDED

#include "conf/X_SYSHEADER"

/* look in bbskeys */
#include "bbskeys.h"

/* location of configfile, can be overwritten by '-c' at startup */
/* some of the following defs may be overwritten in configfile (marked */
/* with (c), look at 'bbs.conf') or overwritten in usersfile (marked */
/* with (u), look at 'users' */
#define CONFFILE "X_INSTALLDIR/bbs.conf"

/* keys (fix and var (c)) for a simple authentication bbs <-> bbsd */
#define BBS_AUTHKEY_FIX "X_BBS_AUTHKEY_FIX"
#define BBS_AUTHKEY_VAR "X_BBS_AUTHKEY_VAR"

/* use 'edit' functions for BBS for some 'curses' functions */
#define USE_EDIT

/* maximum number of args to a command */
#define MAXARGS 256

/* for syslog, may be changed to LOCAL_1 e.g. */
#define LOG_BBS LOG_DAEMON

/* this files will be shown automatically on cd's, may be undef */
#define AUTOLISTFILE ".bbsindex"

/* compile code vor daemonenkiller into bbsd */
#define DAEMONENKILLER 1

/* define, if users shall not be able to send messages to thereself */
/* #define NO_MESSAGES_TO_YOURSELF */

/* if you want a different name for bbsd by 'ps' */
/* if this is a problem, undef it */
#define BBSDNAME

/* if you want a different name for bbsmail by 'ps' */
/* if this is a problem, undef it */
#define BBSMAILNAME

/* keystrokes faster than will be ignored (for autozmodem) */
#define KEYTIME 0.1

/* name of sysop (c) */
#define SYSOP "X_SYSOP"

/* maximum number of logintries (c) */
#define MAXTRIES 3

/* timeout for a succesful login (c) */
#define LOGINTIMEOUT 60

/* autologout for user (time between end of last command and next */
/* commandinput) (c) */
#define IDLETIMEOUT 360

/* time between two looks about bbsd should exit, 0 means no lookups (c) */
#define BBSDWATCHTIME 0

/* communication-timeout bbs to bbsd, after that bbsd closes connection to */
/* bbs it is connected to, 0 means no timeout (c) */
#define BBSDTIMEOUT 300

/* name of NNTP server (c) */
#define NNTPSERVER "X_NNTPSERVER"

/* method to post: True -> direct by NNTP, False -> indirect by inews (c) */
#define NNTPPOST "X_NNTPPOST"

/* timeout for connecting NNTP server (3 tries each) */
#define NNTP_CONNECT_TIMEOUT 15

/* time between geting list of newsgroups from NNTP server */
#define NEWSGROUP_UPDATE_INTERVALL 3600

/* changeroot-directory, it appears for user as '/' (c) */
/* may be like primary_root:root_2:...:root_n, look at DOC for further */
/* details */
#define ROOT "X_CHROOTDIR"

/* the daemon should run on another uid as his clients, so install it suid */
/* to this uid, BBSDUID can be undefined */
/* if you want the euid to select in configfile, define BBSUID to */
/* any username (c) an set bbsd suid-root */
/* #define BBSDUID "X_BBSD_SUID" */

/* set to 1 if tty-mode shall be changed, 0 else (c) (unused at time) */
#define TTY_CHMOD 0

/* timeout for closing talk-connections */
#define TALKQUITTIMEOUT 30

/* directory for bbsd status dumps (by SIGINT) */
#define DUMPDIR "/var/tmp"

/* only usefull if HOME is not ok in environment at client-startup */
/* #define PGHOME "X_CHROOTDIR" */

/* location of 'bbsd' (daemon) (c) */
#define BBSDPATH "X_INSTALLDIR/bbsd"

/* some temorary files are put in this directory by bbsd, must be writeable */
/* for the daemon and not for the clients (c) */
#define VARDIR "X_INSTALLDIR/etc"

/* location of all user-maildirs (c) */
#define MAILDIR "X_INSTALLDIR/mail"

/* location of all helpfiles (c) */
#define HELPDIR "X_INSTALLDIR/help"

/* directory in which all bbs users may read/write */
#define SCRATCHDIR "X_INSTALLDIR/scratch"

/* location of the logfile (c) */
#define LOGFILENAME "X_INSTALLDIR/etc/bbslog"

/* location of the termtable (c) */
/* change termtable to 'none' if you want no table */
#define TERMTABLE "X_TERMTABPATH"

/* location of the usersfile (c) */
#define USERRECFILE "X_INSTALLDIR/etc/users"

/* default-password for users */
#define NOPASSWORD ""

/* Loglevel (not very meanigfull at time) (u) */
#define DEFLOGLEVEL 0

/* define to 1 if users may use kermit, else define to 0 (u) */
#define DEFKERMITOK 0

/* homedir (relative to chroot) (u) */
#define DEFHOME "/"

/* uploaddir (relative to chroot (u) */
#define DEFUPLOADDIR "X_CHROOTDIR/incoming"

/* set to 1 if auto-Z-Modem shall be active at default, else 0 (u) */
#define DEFAUTOZMODEM 1

/* list files on cd also (u) */
#define DEFFULLIST 1

/* language (c) (u) */
#define DEFLANGUAGE 1

/* defaults for terminal (u) */
#define DEFTERM "vt100"
#define DEFLINES 24
#define DEFCOLUMNS 80
#define DEFCHARSET "original"  /* look at online doc for others */

/* if changing termtype by menu, bbs checks if all entries are valid */
/* usefull for installation of new tables, but slows down */
/* #define CHECKTERMTABLE */

/* locations of gunzip, kermit, sz, rz, sendmail, inews */
#define GUNZIP "X_GUNZIP"
#define KERMIT "X_KERMIT"
#define SZ "X_SZ"
#define RZ "X_RZ"
#define SENDMAIL "X_SENDMAIL"
#define INEWS "X_INEWS"

/* console-device (for messages to sysop) */
#define DEV_CONSOLE "/dev/console"

/* will be assigned to environment SHELL to disable shell */
#define NOSHELL "/bin/false"

/* will be assigned to environment PATH to disable it */
#define NOPATH ""

/* for restricted shell-accounts (unused at time) */
#define RESHELL "/bin/sh -r"

#endif
