/* $Id: bbsdstuff.c,v 1.2 1997/07/06 14:34:49 eilts Exp eilts $ */
#include "bbs.h"

#ifndef NO_BBS_TIMEOUT
  sigjmp_buf connecttimeoutenv;
#endif

#ifdef NNTPNEWS
int getnewsrc(tlistetyp **tliste, const confrecordtyp *confrecord)
{
  int sockd, n, anz=0;
  SIZE_T len;
  char bstr[BEFSTRLEN+1], str[NNTP_STRLEN+1];
  const char *name;
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getnewsrc",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_GETNEWSRC);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    name = confrecord->userrecord.name;
    len = strlen(name) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)name,len,0);
    recvn(sockd,(void *)&len,sizeof(SIZE_T),0);
    while (len > 0) {
      recvn(sockd,(void *)str,len,0);
      addstrtoliste(tliste,TRUE,anz++,TL_BLOCKLEN,str,confrecord);
      recvn(sockd,(void *)&len,sizeof(SIZE_T),0);
    }
    recvn(sockd,(void *)&n,sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getnewsrc",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n >= 0)  n = anz;
  return(n);
}


int savenewsrc(tlistetyp *tliste, const int anz,
               const confrecordtyp *confrecord)
{
  int sockd, n;
  SIZE_T len;
  char bstr[BEFSTRLEN+1], *sp;
  const char *name;
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","savenewsrc",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_SAVENEWSRC);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    name = confrecord->userrecord.name;
    len = strlen(name) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)name,len,0);
    for (n=0; n < anz; n++) {
      readliste(&tliste,FALSE,n,TL_BLOCKLEN,&sp,confrecord);
      len = strlen(sp) + 1;
      sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
      sendn(sockd,(void *)sp,len,0);
    }
    len = 0;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    recvn(sockd,(void *)&n,sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","savenewsrc",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  return(n);
}


int getallnewsgroups(tlistetyp **tliste, const int mask,
                     const confrecordtyp *confrecord)
{
  int n, anz, sockd;
  SIZE_T len;
  char bstr[BEFSTRLEN+1], entry[NNTP_STRLEN+S_STRLEN+4];
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getallnewsgroups",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_GETALLNEWSGROUPS);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    sendn(sockd,(void *)&mask,sizeof(int),0);
    anz = 0;
    recvn(sockd,(void *)&len,sizeof(SIZE_T),0);
    while (len > 0) {
      recvn(sockd,(void *)entry,len,0);
      addstrtoliste(tliste,TRUE,anz++,TL_BLOCKLEN,entry,confrecord);
      recvn(sockd,(void *)&len,sizeof(SIZE_T),0);
    }
    recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getallnewsgroups",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n >= 0)  n = anz;
  return(n);
}


int checkgroup(const char *group, const confrecordtyp *confrecord)
{
  int n, sockd;
  SIZE_T len;
  char bstr[BEFSTRLEN+1];
  boolean grp_exists = FALSE;
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","checkgroup",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_CHECKGROUP);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    len = strlen(group) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)group,len,0);
    recvn(sockd,(void *)&grp_exists,(SIZE_T)sizeof(boolean),0);
    recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","checkgroup",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n == 0 && grp_exists)  n = 1;
  return n;
}
#endif


int listmessages(tlistetyp **tliste, const confrecordtyp *confrecord)
{
  int sockd, n, anz=0;
  SIZE_T len;
  char bstr[BEFSTRLEN+1], hdrlines[3*STRLEN+4];
  const char *name;
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","listmessages",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_LISTMESSAGES);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    name = confrecord->userrecord.name;
    len = strlen(name) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)name,len,0);
    recvn(sockd,(void *)&len,sizeof(SIZE_T),0);
    while (len > 0) {
      recvn(sockd,(void *)hdrlines,len,0);
      addstrtoliste(tliste,TRUE,anz++,TL_BLOCKLEN,hdrlines,confrecord);
      recvn(sockd,(void *)&len,sizeof(SIZE_T),0);
    }
    recvn(sockd,(void *)&n,sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","listmessages",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n >= 0)  n = anz;
  return(n);
}


int removemessage(const int nr, const char *mesg_id,
                  const confrecordtyp *confrecord)
{
  int sockd, n;
  SIZE_T len;
  char bstr[BEFSTRLEN+1];
  const char *name;
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","removemessage",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_REMOVEMESSAGE);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    name = confrecord->userrecord.name;
    len = strlen(name) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)name,len,0);
    sendn(sockd,(void *)&nr,sizeof(int),0);
    len = strlen(mesg_id) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)mesg_id,len,0);
    recvn(sockd,(void *)&n,sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","removemessage",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  return(n);
}


int getmessage(char mpath[], const int nr, const char *mesg_id,
               const confrecordtyp *confrecord)
{
  int sockd, n;
  SIZE_T len;
  char bstr[BEFSTRLEN+1];
  const char *name;
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getmessage",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_GETMESSAGE);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    name = confrecord->userrecord.name;
    len = strlen(name) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)name,len,0);
    sendn(sockd,(void *)&nr,sizeof(int),0);
    len = strlen(mesg_id) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)mesg_id,len,0);
    recvn(sockd,(void *)&len,sizeof(SIZE_T),0);
    if (len > 0) {
      recvn(sockd,(void *)mpath,len,0);
    }
    else {
      mpath[0] = '\0';
    }
    recvn(sockd,(void *)&n,sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getmessage",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n >= 0)  n = len - 1;
  return(n);
}


int sendmessage(const char *from, const char *addr, const char *subject,
                const char *letter, const confrecordtyp *confrecord)
{
  int sockd, letterfd, n, rw=0;
  SIZE_T len;
  SSIZE_T bytes;
  char bstr[BEFSTRLEN+1], buf[BUFSIZE];
  struct stat stats;
  
  if (stat(letter,&stats) < 0) {
    errormsg(E_LOGFILE|E_USER,confrecord,"bbs","sendmessage",
             "stat %d: %m", letter);
    return -1;
  }
  if ((letterfd=open(letter,O_RDONLY)) < 0) {
    errormsg(E_LOGFILE|E_USER,confrecord,"bbs","sendmessage",
	     "open letter %s: %m", letter);
    return -1;
  }
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","sendmessage",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_SENDMESSAGE);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    len = strlen(from) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)from,len,0);
    len = strlen(addr) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)addr,len,0);
    len = strlen(subject) + 1;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    sendn(sockd,(void *)subject,len,0);
    len = (SIZE_T)stats.st_size;
    sendn(sockd,(void *)&len,sizeof(SIZE_T),0);
    bytes = 0;
    while (len > 0 && bytes >= 0 &&
	    (bytes=read(letterfd,(void *)buf,(SIZE_T)BUFSIZE)) > 0) {
      bytes = sendn(sockd,(void *)buf,bytes,0);
      len -= (SIZE_T)bytes;
    }
    close(letterfd);
    do {
      recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
      if (n > 1) {
	recvn(sockd,(void *)addr,(SIZE_T)n,0);
	errormsg(E_USER,confrecord,"bbs","sendmessage",addr);
      }
    } while (n > 0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","sendmessage",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (bytes < 0 || n < 0) {
    rw = -1;
  }
  else {
    unlink(letter);
  }

  return(rw);
}


int getallusernames(tlistetyp **tliste, const int mask,
                    const confrecordtyp *confrecord)
{
  int n, anz, sockd;
  SIZE_T len;
  char bstr[BEFSTRLEN+1], user[2*S_STRLEN+4];
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getallusernames",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_GETALLUSERNAMES);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    sendn(sockd,(void *)&mask,sizeof(int),0);
    anz = 0;
    recvn(sockd,(void *)&len,sizeof(SIZE_T),0);
    while (len > 0) {
      recvn(sockd,(void *)user,len,0);
      addstrtoliste(tliste,TRUE,anz++,TL_BLOCKLEN,user,confrecord);
      recvn(sockd,(void *)&len,sizeof(SIZE_T),0);
    }
    recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getallusernames",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n >= 0)  n = anz;
  return(n);
}


int iniconnecttouserd(const PID_T inipid, const PID_T remotepid,
                      char *sockname, const confrecordtyp *confrecord)
{
  int n, sockd;
  char bstr[BEFSTRLEN+1];
    
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","iniconnecttouserd",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_TALKINIT);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    sendn(sockd,(void *)&inipid,(SIZE_T)sizeof(PID_T),0);
    sendn(sockd,(void *)&remotepid,(SIZE_T)sizeof(PID_T),0);
    recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    if (n == 0) {
      recvn(sockd,(void *)sockname,(SIZE_T)TALKSOCKNAMELEN,0);
      recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    }
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","iniconnecttouserd",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  return(n);
}


int remconnecttouserd(sessionrecordtyp *sr, char *sockname, const PID_T mypid,
                      const confrecordtyp *confrecord)
{
  int n, sockd;
  char bstr[BEFSTRLEN+1];

#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","remconnecttouserd",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_TALKREMOTE);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    sendn(sockd,(void *)&mypid,(SIZE_T)sizeof(PID_T),0);
    recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    if (n == 0) {
      recvn(sockd,(void *)sockname,(SIZE_T)TALKSOCKNAMELEN,0);
      recvn(sockd,(void *)sr,(SIZE_T)sizeof(sessionrecordtyp),0);
      recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    }
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","remconnecttouserd",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  return(n);
}


int sendstatustodaemon(const int status, const confrecordtyp *confrecord)
{
  int sockd, n;
  PID_T pid;
  char bstr[BEFSTRLEN+1];
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","sendstatustodaemon",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_SENDSTATUS);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    pid = getpid();
    sendn(sockd,(void *)&pid,(SIZE_T)sizeof(PID_T),0);
    sendn(sockd,(void *)&status,(SIZE_T)sizeof(int),0);
    recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","sendstatustodaemon",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n<0) {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","sendstatustodaemon",
             "command endstatustodaemon wrongly executed by bbsd");
    return -1;
  }
  return n;
}


int addsession(const sessionrecordtyp *sessionrecord,
               const confrecordtyp *confrecord)
  /*
  Sendet sessionrecord zum Eintragen zum Daemon
  */
{
  int n, sockd;
  char bstr[BEFSTRLEN+1];
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","addsession",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_ADDSESSION);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    sendn(sockd,(void *)sessionrecord,(SIZE_T)sizeof(sessionrecordtyp),0);
    recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","addsession",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n<0) {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","addsession",
             "command addsession wrongly executed by bbsd");
    return -1;
  }
  return 0;
}


int removesession(const PID_T pid, const confrecordtyp *confrecord)
  /*
  Sendet pid zum Loeschen der zugehoerigen session zum Daemon
  */
{
  int n, sockd;
  char bstr[BEFSTRLEN+1];
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","removebbspid",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_REMOVESESSION);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    sendn(sockd,(void *)&pid,(SIZE_T)sizeof(PID_T),0);
    recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","removebbsdpid",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n<0) {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","removebbspid",
             "command removesession wrongly executed by bbsd");
    return -1;
  }
  return 0;
}


boolean getuserrecord(userrecordtyp *userrecord, const char *username,
                      const confrecordtyp *confrecord)
  /*
  Erfragt den Userrecord des Users username vom Daemon
  Der Rueckgabewert von getuserrecord ist FALSE, wenn der User nicht existiert
  */
{
  int n, sockd;
  char bstr[BEFSTRLEN+1];
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getuserrecord",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_GETUSERRECORD);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    sendn(sockd,(void *)username,(SIZE_T)S_STRLEN,0);
    n = (int)recvn(sockd,(void *)userrecord,(SIZE_T)sizeof(userrecordtyp),0);
    recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getuserrecord",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n<0) {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","getuserrecord",
             "command getuserrecord wrongly executed by bbsd");
    return FALSE;
  }
  return (n==0);
}


int saveuserrecord(const userrecordtyp *userrecord,
                   const confrecordtyp *confrecord)
  /*
  Sendet den Userrecord userrecord zum Daemon, der ihn dann im Userfile
  permanent speichern soll
  */
{
  int n, sockd;
  char bstr[BEFSTRLEN+1];
  
#ifndef NO_BBS_TIMEOUT
  if (sigsetjmp(connecttimeoutenv,(int)TRUE) == 0) {
    setsighandler(SIGALRM,connecttimeouthandler);
    alarm(confrecord->bbsdtimeout);
#endif
    if ((sockd=connect2bbsd(confrecord))<0) {
      errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","saveuserrecord",
		"connection to daemon failed");
      exit(1);
    }
    sprintf(bstr,"#%2d\n",DO_SAVEUSERRECORD);
    sendn(sockd,(void *)bstr,(SIZE_T)BEFSTRLEN,0);
    sendn(sockd,(void *)userrecord,(SIZE_T)sizeof(userrecordtyp),0);
    recvn(sockd,(void *)&n,(SIZE_T)sizeof(int),0);
    unconnect2bbsd(sockd,confrecord);
#ifndef NO_BBS_TIMEOUT
  }
  else {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","saveuserrecord",
             "communication timeout to daemon");
    n = -1;
  }
  alarm(0);
#endif
  if (n<0) {
    errormsg(E_SYSLOG|E_USER|E_CONSOLE,confrecord,"bbs","saveuserrecord",
             "command saveuserrecord wrongly executed by bbsd");
    return FALSE;
  }
  return (n==0);
}
