/* $Id: bbs_types.h,v 1.2 1997/07/06 14:34:49 eilts Exp eilts $ */
#ifndef _BBS_TYPESH_INCLUDED
#define _BBS_TYPESH_INCLUDED

#ifndef PID_T
#define PID_T pid_t		/* process id */
#endif

#ifndef UID_T
#define UID_T uid_t		/* user id */
#endif

#ifndef GID_T
#define GID_T gid_t		/* group id */
#endif

#ifndef MODE_T
#define MODE_T mode_t		/* file type */
#endif

#ifndef TIME_T
#define TIME_T time_t		/* counter of secounts */
#endif

#ifndef OFF_T
#define OFF_T off_t		/* file offset */
#endif

#ifndef MODE_T
#define MODE_T mode_t		/* mode bits for open */
#endif

#ifndef SIZE_T
#define SIZE_T size_t		/* size of objects (unsigned) */
#endif

#ifndef SSIZE_T
#define SSIZE_T ssize_t		/* signed size of objects */
#endif

#ifndef U_CHAR
#define U_CHAR u_char           /* unsigned char */
#endif

#ifndef U_INT
#define U_INT u_int            /* unsigned int */
#endif

#ifndef FD_SET_T
#define FD_SET_T fd_set		/* file descriptor set */
#endif

#ifndef FD_SETPTR_CAST          /* cast for ptr to fd_set */
#define FD_SETPTR_CAST (FD_SET_T *)
#endif

#ifndef CADDR_T
#define CADDR_T caddr_t		/* core address */
#endif

#ifndef SIG_ATOMIC_T
#define SIG_ATOMIC_T sig_atomic_t	/* atomically accessed type */
#endif

#ifndef SIGSET_T
#define SIGSET_T sigset_t	/* signal set */
#endif

#ifndef WRONG_SCM_RIGHTS
#  ifdef SCM_RIGHTS
#    define HAS_SCM_RIGHTS
#  endif
#endif
#ifndef SUN_LEN
# ifdef HAS_SCM_RIGHTS
#  define SUN_LEN(unp) sizeof((unp)->sun_len)+sizeof((unp)->sun_family)+strlen((unp)->sun_path)+1
# else
#  define SUN_LEN(unp) sizeof((unp)->sun_family) + strlen((unp)->sun_path)
# endif
#endif

#ifndef ARG_MAX
# ifdef _POSIX_ARG_MAX
#  define ARG_MAX _POSIX_ARG_MAX
# endif
#endif

#ifndef PATH_MAX
# ifdef MAXPATHLEN
#  define PATH_MAX MAXPATHLEN
# endif
#endif

#ifndef NAME_MAX
# ifdef _MAXNAMLEN
#  define NAME_MAX _MAXNAMLEN
# endif
#endif

#ifndef SYSLOGBUF
# define SYSLOGBUF 1024
#endif

#ifndef MSG_MAX
# define MSG_MAX PATH_MAX+SYSLOGBUF
#endif

#ifndef TGETENTBUF
#define TGETENTBUF 8192
#endif

#ifndef PASS_MAX
# ifdef _PASSWORD_LEN
#  define PASS_MAX _PASSWORD_LEN
# else
#  define PASS_MAX 8
# endif
#endif

#ifndef PASSCRYPTED_LEN
# define PASSCRYPTED_LEN 20
#endif

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif
typedef int boolean;

#define STRLEN 1024
#define S_STRLEN 80
#define TTYNAMELEN 20
#define TALKSOCKNAMELEN 40
#define BUFSIZE 1024
#define ALLOCSTEPSIZE 8192
#define ASCIITIMESTRLEN 26
#define LOG_NEVER -1
#define LOG_FILE 0
#define LOG_CONSOLE 1
#define SOCKCONTRIES 3
#define MAXSESSIONS 100

#define BEFSTRLEN 4
#define DO_LOG 1
#define DO_GETSESSIONS 2
#define DO_ADDSESSION 3
#define DO_REMOVESESSION 4
#define DO_GETUSERRECORD 5
#define DO_SAVEUSERRECORD 6
#define DO_TALKINIT 7
#define DO_TALKABORT 8
#define DO_TALKREMOTE 9
#define DO_SENDSTATUS 10
#define DO_GETALLUSERNAMES 11
#define DO_SENDMESSAGE 12
#define DO_GETMESSAGE 13
#define DO_REMOVEMESSAGE 14
#define DO_LISTMESSAGES 15
#define DO_RECEIVEMAIL 16
#define DO_GETALLNEWSGROUPS 17
#define DO_GETNEWSRC 18
#define DO_SAVENEWSRC 19
#define DO_CHECKGROUP 20

#define BBS_IDLE 0
#define BBS_BUSY 1

#define E_SYSLOG 1
#define E_LOGFILE 2
#define E_CONSOLE 4
#define E_USER 8

#define USERNAME_MASK 1
#define REALNAME_MASK 2

#define GROUPNAME_MASK 1
#define GROUPCOUNT_MASK 2

#define USERNAME_DB 1
#define NEWSGROUPS_DB 2

#define PERM_R 1
#define PERM_W 2
#define PERM_X 4

typedef struct {
  char name[S_STRLEN+1];
  char passwd[PASSCRYPTED_LEN+1];
  char realname[S_STRLEN+1];
  int loglevel;
  int seclevel;
  char permittions[S_STRLEN+1];
  int kermitok;
  int protokoll;
  boolean autozmodem;
  boolean fullist_on_cd;
  char home[PATH_MAX+1];
  char uploaddir[PATH_MAX+1];
  char shell[PATH_MAX+1];
  char path[PATH_MAX+1];
  int lang;
  char term[S_STRLEN+1];
  int lines;
  int columns;
  char charset[S_STRLEN+1];
} userrecordtyp;

#define KERMITPROTO 0
#define ZMODEMPROTO 1
#define HIGHSECURITY 0
#define MEDIUMSECURITY 1
#define LOWSECURITY 2
#define NOUSER "nouser"

#define GERMAN 0
#define ENGLISH 1

typedef struct {
  userrecordtyp userrecord;
  int idletimeout;
  int logintimeout;
  int maxtries;
  char bbsdpath[PATH_MAX+1];
  int bbsdwatchtime;
  char bbsduid[STRLEN+1];
  char usersfile[PATH_MAX+1];
  char logfile[PATH_MAX+1];
  char termtable[PATH_MAX+1];
  char vardir[PATH_MAX+1];
  char maildir[PATH_MAX+1];
  char helpdir[PATH_MAX+1];
  char scratchdir[PATH_MAX+1];
  char sysop[STRLEN+1];
  char hostname[STRLEN+1];
  int lang;
  char authkey[STRLEN+1];
  boolean curses_on;
  char rootdir[PATH_MAX+1];
  char sockpath[PATH_MAX+1];
  char lockpath[PATH_MAX+1];
  int bbsdtimeout;
  char bbsdpidpath[PATH_MAX+1];
  char bbsdkpidpath[PATH_MAX+1];
  char kermrcpath[PATH_MAX+1];
  char nntpserver[STRLEN+1];
  char nntppost[S_STRLEN+1];
} confrecordtyp;

typedef struct {
  char cwd[PATH_MAX+1];
  char cwdname[PATH_MAX+1];
  char primaryroot[PATH_MAX+1];
  char root[PATH_MAX+1];
  char rootname[PATH_MAX+1];
} chrootrecordtyp;

typedef struct {
  PID_T pid;
  int status;
  char tty[TTYNAMELEN+1];
  char user[S_STRLEN+1];
  PID_T talking_to;
} sessionrecordtyp;

typedef struct {
  char key;
  char *dec[2];
  char *cmd;
} menuetyp;

typedef struct {
  char *from;
  char *reply_to;
  char *to;
  char *cc;
  char *subject;
  char *date;
  char *msg_id;
  char *mime_encoding;
} mailheadertyp;

typedef struct tlistetyp {
  char **tp;
  int nr;
  struct tlistetyp *prec;
  struct tlistetyp *next;
} tlistetyp;

#define TL_BLOCKLEN 8

#define MAXMEN 26

#define BINARYFACTOR 10

typedef enum {Curleft, Curright, Nocmd} keybcmd;

typedef struct {
  const char *id;
  char *sequenz;
  keybcmd cmd;
} termks;

typedef enum {TTY_RESET, TTY_RAW, TTY_CBREAK} ttystateenum;
typedef enum {SIGMASK_SET, SIGMASK_UNSET} sigmaskstatusenum;

#ifndef NO_DBOPEN
# define DBASE_DB DB
# define DBASE_DBT DBT
# define DBASE_DATA(a) (a).data
# define DBASE_SIZE(a) (a).size
# define DBASE_UNLINK(a) unlink(a)
#else
typedef enum { DB_BTREE, DB_HASH, DB_RECNO } DBTYPE;
typedef struct __db {
  char file[PATH_MAX+1];
  int mode;
  int (*close) (struct __db *);
  int (*del) (const struct __db *, const datum *, U_INT);
  int (*get) (const struct __db *, const datum *, datum *, U_INT);
  int (*put) (const struct __db *, datum *, const datum *, U_INT);
  int (*seq) (const struct __db *, datum *, datum *, U_INT);
  int (*sync) (const struct __db *, U_INT);
  DBM *dbm;
} DBASE_DB;
typedef struct {
  U_INT bsize;          /* bucket size */
  U_INT ffactor;        /* fill factor */
  U_INT nelem;          /* number of elements */
  U_INT cachesize;      /* bytes to cache */
  U_INT (*hash) (const void *, SIZE_T);
  int   lorder;         /* byte order */
} HASHINFO;
# define DBASE_DBT datum
# define DBASE_DATA(a) (a).dptr
# define DBASE_SIZE(a) (a).dsize
# define DBASE_UNLINK(a) dbase_unlink(a)
# define R_NOOVERWRITE 8
# define R_FIRST 0
# define R_NEXT 1
#endif

typedef struct {
  DBASE_DB *u_db;
  DBASE_DB *newsgrp_db;
} bbsddbtyp;

#ifndef  NNTP_STRLEN
# define NNTP_STRLEN     512
#endif

typedef struct {
  char server[STRLEN+1];
  int sock;
  boolean is_connected;
  boolean can_post;
  boolean nntp_failed;
  char lastretstr[NNTP_STRLEN+1];
  boolean group_is_set;
  int subscribed_anz;
  DBASE_DB *newsrcdb;
} newsstattyp;

#ifdef NNTPNEWS
typedef struct {
  char groupname[NNTP_STRLEN+1];
  int first_article;
  int last_article;
  int anz_article;
  SIZE_T ov_anz;
  tlistetyp *ov_liste;
} grouptyp;

typedef struct {
  int nr;
  char subject[STRLEN+1];
  char from[STRLEN+1];
  char date[31];
  char msg_id[S_STRLEN+1];
  char references[STRLEN+1];
  int bytes;
  int lines;
  int reflevel;
  char read;
} articletyp;

typedef struct {
  char *from;
  char *newsgroups;
  char *reply_to;
  char *followup_to;
  char *subject;
  char *date;
  char *references;
  char *msg_id;
  char *mime_encoding;
} newsheadertyp;
#endif
# if 0
typedef struct sigalrmqueuetyp {
  TIME_T time;
  int id;
  int prio;
  void (*handler)(int);
  struct sigalrmqueuetyp *next;
} sigalrmqueuetyp;
#endif
#endif
