/* $Id: bbs_decl.h,v 1.2 1997/07/06 14:34:49 eilts Exp eilts $ */
#ifndef _BBS_SUBR_INCLUDED
#define _BBS_SUBR_INCLUDED

#ifndef WCOREDUMP
#define WCOREDUMP(x) 0
#endif

#ifndef NO_CRYPT
# define CRYPTFUNC(a,b) crypt(a,b)
#else
# define CRYPTFUNC(a,b) a
#endif

#ifndef NO_RANDOM
# define SRANDOM(a) srandom(a)
# define RANDOM  random
#else
# ifndef NO_LRAND48
#  define SRANDOM(a) srand48(a)
#  define RANDOM  lrand48
# else
#  define SRANDOM(a) srand(a)
#  define RANDOM  rand
# endif
#endif

#ifndef NO_MEMSET
# define BZERO(a,b) memset(a,0,b)
#else
# define BZERO(a,b) bzero(a,b)
#endif

#ifdef NO_ADDSTR_CONST
# define ADDSTR(a) bbs_addstr(a)
#else
# define ADDSTR(a) addstr(a)
#endif

#ifdef NO_WADDSTR_CONST
# define WADDSTR(a,b) bbs_waddstr(a,b)
#else
# define WADDSTR(a,b) waddstr(a,b)
#endif

#ifdef NO_PRINTW_CONST
# define PRINTW bbs_printw
#else
# define PRINTW printw
#endif

/* bbs */
/* main */
extern PID_T bbsinit(chrootrecordtyp *, confrecordtyp *, const char *);
extern void bbsexit(const int, confrecordtyp *);

/* bbsdstuff */
#ifdef NNTPNEWS
extern int getnewsrc(tlistetyp **, const confrecordtyp *);
extern int savenewsrc(tlistetyp *, const int, const confrecordtyp *);
extern int getallnewsgroups(tlistetyp **, const int, const confrecordtyp *);
extern int checkgroup(const char *, const confrecordtyp *);
#endif
extern int listmessages(tlistetyp **, const confrecordtyp *);
extern int removemessage(const int, const char *, const confrecordtyp *);
extern int getmessage(char [], const int, const char *, const confrecordtyp *);
extern int sendmessage(const char *, const char *, const char *, const char *,
                       const confrecordtyp *);
extern int getallusernames(tlistetyp **, const int, const confrecordtyp *);
extern int iniconnecttouserd(const PID_T, const PID_T, char *,
 			     const confrecordtyp *);
extern int remconnecttouserd(sessionrecordtyp *, char *, const PID_T,
			     const confrecordtyp *);
extern int bbslog(const int, const confrecordtyp *, const char *, ...);
extern int bbslogn(const int, const confrecordtyp *, const char *, ...);
extern int sendstatustodaemon(const int, const confrecordtyp *);
extern int getsessions(sessionrecordtyp [], const int, const confrecordtyp *);
extern int addsession(const sessionrecordtyp *, const confrecordtyp *);
extern int removesession(const PID_T, const confrecordtyp *);
extern boolean getuserrecord(userrecordtyp *, const char *,
                             const confrecordtyp *);
extern boolean saveuserrecord(const userrecordtyp *, const confrecordtyp *);
extern int connect2bbsd(const confrecordtyp *);
extern int unconnect2bbsd(const int, const confrecordtyp *);
extern PID_T testdaemon(const char *, const confrecordtyp *);
extern void connecttimeouthandler(int);

/* do */
#ifdef NNTPNEWS
extern int do_postart_nntp(const char *, const char *, const char *,
                           const char *, newsstattyp *, const confrecordtyp *);
extern int do_postart_inews(const char *, const char *, const char *,
                            const char *, const confrecordtyp *);
#endif
extern void do_msgbrowser(const char [], const confrecordtyp *);
extern void do_sendmessage(const char [], const char *, const char *,
                           const confrecordtyp *);
extern void do_shownewsheader(const char *, const confrecordtyp *);
extern int do_sendmail(const char [], char *, const char *, const char *,
                       const confrecordtyp *);
extern void do_talk(const char [], const confrecordtyp *);
extern void do_sprache(const char [], const char *[], confrecordtyp *);
extern void do_autozmodem(const char [], confrecordtyp *);
extern void do_fullist(const char [], confrecordtyp *);
extern char do_showfile(const char *, const char *, const char *, const char *,
                        const confrecordtyp *);
extern void do_ls(const char [], const chrootrecordtyp *,
                  const confrecordtyp *);
extern void do_cd(const char [], chrootrecordtyp *, const confrecordtyp *);
extern void do_pwd(const char *, const confrecordtyp *);
extern void do_showenv(const userrecordtyp *, const confrecordtyp *);
extern void do_protokoll(const char [], const char *[], int *,
                         confrecordtyp *);
extern void do_get(const char [], const chrootrecordtyp *, const char *[],
                   const int, const confrecordtyp *);
extern void do_put(const char [], const chrootrecordtyp *, const int,
                   confrecordtyp *);
extern void do_home(const char [], const chrootrecordtyp *, userrecordtyp *,
                    const confrecordtyp *);
extern int do_term(const char [], userrecordtyp *, confrecordtyp *confrecord);
extern int do_newpasswd(const char [], userrecordtyp *, const confrecordtyp *);

/* errorstuff */
extern void errormsg(const int, const confrecordtyp *, const char *,
                     const char *, const char *, ...);
extern void bgerror(const char *, const char *, ...);

/* execute */
extern int execute(const char *, char *const [], const int,
                   const confrecordtyp *);
extern void executesighandler(int);

/* filesys */
extern char *scratchfilename(char *, const char *, const char *, const char *);
extern int checkfileperms(const char *, const UID_T, const GID_T);
extern int getperms(const struct stat *, const UID_T, const GID_T);
extern char *chrootpath(char [], const char *, const char *);
extern char *getchrootcwd(chrootrecordtyp *);
extern char *getchrootpath(char [], const char *);
extern char *getrealdir(char [], const confrecordtyp *);
extern int readconffile(confrecordtyp *, const char *);
#if 0
extern int expandfilenames(const char *, char [], const int,
                           const confrecordtyp *);
#endif

/* menue */
extern int getcmdline_c(char [], const menuetyp [], const menuetyp [],
                        const menuetyp [], const chrootrecordtyp *,
			confrecordtyp *);
extern char selectmenue_c(char [], const menuetyp [], const char *, const char,
                          const char *, const confrecordtyp *);
#ifdef NNTPNEWS
extern int newsbrowser_c(const confrecordtyp *);
extern int postarticle_c(const char *, const char *, const char *,
                         const char *, newsstattyp *, const confrecordtyp *);
extern int subscribenewsgroups_c(const confrecordtyp *);
extern char newspager_c(tlistetyp *, const int, const char *, const char *,
                        const boolean, const char *, const confrecordtyp *);
extern int newsdateselect_c(tlistetyp *, const int, const confrecordtyp *);
#endif
extern int msgbrowser_c(char [], const menuetyp [], const chrootrecordtyp *,
                        const confrecordtyp *);
extern int sendmessage_c(char [], const char *, const char *, const char *,
                         const chrootrecordtyp *, const confrecordtyp *);
extern int sendmail_c(char [], const char *, const char *, const char *,
                const boolean, const chrootrecordtyp *, const confrecordtyp *);
extern int put_c(char [], const confrecordtyp *);
extern int talk_c(char [], const confrecordtyp *);
extern int sprache_c(char [], const confrecordtyp *);
extern int autozmodem_c(char [], const confrecordtyp *);
extern int fullist_c(char [], const confrecordtyp *);
extern int protokoll_c(char [], const confrecordtyp *);
extern int term_c(char [], confrecordtyp *);
extern int newpasswd_c(char [], const confrecordtyp *);
extern char *selectterm_c(const char *, const confrecordtyp *);
extern int selectfiles_c(char [], const int, const char *,
                         const confrecordtyp *);
extern int selectdir_c(char [], const chrootrecordtyp *, const char *,
                       const confrecordtyp *);
extern char selectpager_c(tlistetyp *, const int, const char *, const char *,
                          const boolean, const char *, const confrecordtyp *);
extern char menueselect_c(char *[], const int, const int, const int,
                          const boolean, const char *, const confrecordtyp *);
extern int wildcardselect_c(const char, tlistetyp *, const int,
                          const confrecordtyp *);
extern int selectpagerquit_c(const char);
extern int alphastep_c(const char);
extern int wildcardchar_c(const char);
extern int bbsquit_c(char [], const confrecordtyp *);

/* msg */
extern const char *msg(const char *, const int, const int);

/* signal */
extern int sigalrminqueue(TIME_T, int, void (*)(int), int);
extern void sigalrmoutqueue(int);
extern void sighandler(int);
extern void sigtalkaccepthandler(int);

/* stringstuff */
extern void rm_ae_blanks(char *);
extern char *splittoken(char *, const char, const int);
extern char getarg(char [], const char *);
extern char *recode(char *, const char, const char);
extern SSIZE_T vfstrlen(const char *, va_list);
extern SSIZE_T fstrlen(const char *, ...);
extern void lowercases(char *);
extern char *stripslashes(char *);
extern void strprepend(char *, const char *);
extern char *strmaxcpy(char *, const char *, const SIZE_T);
extern char *strmaxcat(char *, const char *, const SIZE_T);
extern const char *basename(const char *);
extern void pathnamedir(const char *, char []);
extern int splitstring(char *[], char *, const char, const int);
extern int splitstr_wr(char *[], char *, const char, const int);
extern char *normalizepath(char *);
extern char *buildhelppath(char *, const char *, const char *,
                           const confrecordtyp *);
extern int splitparams(char *[], char *);
extern int str2cmdparams(const char [], char [], char []);
extern void split2key_arg(char *, char **, char **);
extern void stringsort(char *[], const int);

/* sysstuff */
extern int f_close(FILE *);
#ifdef BBSDNAME
extern void bbssetproctitle(char *[], const SIZE_T, char *, ...);
#endif
extern int getdatenum(const char *);
extern int getdaynum(const char *);
extern int getmonthnum(const char *);
extern char *gettime(void);
#ifndef NO_TV_USEC
extern double microtime(void);
#endif
extern int mklockfile(const char []);
extern int fgetnln(char [], const int, FILE *);
extern SSIZE_T recvn(int, void *, SIZE_T, int);
extern SSIZE_T sendn(int, const void *, SIZE_T, int);
extern SSIZE_T readn(int, void *, SIZE_T);
extern SSIZE_T writen(int, const void *, SIZE_T);
extern void (*setsighandler(int, void (*)(int)))(int);
extern void (*setsighandler2(int, SIGSET_T, void (*)(int)))(int);
extern void syslogn(int, const char *, ...);
extern void vsyslogn(int, const char *, va_list);
#ifdef NO_USLEEP
extern void usleep(U_INT);
#endif
extern SIZE_T environlen(void);
extern int mdefenv(const char *, const char *, ...);
extern int mputenv(const char *);
#ifdef NO_PUTENV
extern int putenv(const char *);
#endif

/* talk */
extern int talkscreen(const int, const confrecordtyp *);
extern char inserttalktext(char *, const int, WINDOW *);
extern int iniconnecttouser(const PID_T, const confrecordtyp *);
extern void praeleaveiniconnecttouser(void);
extern int abortconnecttouser(const PID_T, const PID_T, const int,
			      const char *, const confrecordtyp *);
extern int remconnecttouser(const confrecordtyp *);
extern void praeleaveremconnecttouser(const int);

/* tliste */
extern int addstrtoliste(tlistetyp **, const boolean, const int, const int,
                         char *, const confrecordtyp *);
extern int readliste(tlistetyp **, const boolean, const int, const int,
                     char **, const confrecordtyp *);
extern int removeliste(tlistetyp **, const boolean, const int);
extern int inserttoliste(tlistetyp **, const boolean, const int, int *,
                         const int, char *, const confrecordtyp *);
extern int delfromliste(tlistetyp **, const boolean, const int, int *,
                        const int, const confrecordtyp *);
extern void sortliste(tlistetyp *, const int, const int,
                      const confrecordtyp *);
extern void sort_liste(tlistetyp *, const int, const int, const int,
                  int (*cmpfkt)(const char *, const char *),
                  const confrecordtyp *);
extern char tlpager(tlistetyp *, const int, const char *,
                    const char *, const confrecordtyp *);

/* mail */
extern int mimerecode(const char *, const char *, const confrecordtyp *);
extern int addresstyp(const char *, const confrecordtyp *);
extern int mailreply(char [], const int, const char *, const menuetyp [],
                     const chrootrecordtyp *, const confrecordtyp *);
extern int makereplytext(char [], mailheadertyp *, const int, const char *,
                         char *, const confrecordtyp *);
extern int checkmailperms(const char *, const confrecordtyp *);

/* mailstuff */
extern int parseaddrline(char *, char *, const char *);
extern boolean testmailbegin(const char *);
extern char from_quotestream(const boolean, FILE *, FILE *);
extern int fprint_mailheaderline(char *, const char *, FILE *);
extern char *parsemailheader(mailheadertyp *, FILE *, const confrecordtyp *);

/* userrw */
extern boolean userlogin(confrecordtyp *, const char *);
extern int usergreeting(confrecordtyp *);
extern int rawshowtermtable(const char *, const confrecordtyp *);
extern char *showmsgline(const char *, ...);
extern void removemsgline(const char *);
extern int writetouser(const confrecordtyp *, const char *, ...);
extern int readfromuser(char [], const char *, const int, const boolean,
                        const confrecordtyp *);
extern char bbsgetch(const boolean);
extern char waitonkeypress(const boolean);
extern char getkeyonprompt(const char *, const char *, const boolean,
                           const boolean, const char *, const confrecordtyp *);
#ifndef NO_TV_USEC
extern char autoz_getch_c(boolean *, const boolean);
#endif
extern void invertpromptkeys(const char *);
extern int tty_cbreak(int, struct termios *, ttystateenum *);
extern int tty_raw(int, struct termios *, ttystateenum *);
extern int tty_reset(int, struct termios *, ttystateenum *);
extern int pagerstep(const char);
extern int pagerquit(const char);
extern void linerecodeout(const char *, const char *, OFF_T, const char,
                          const SIZE_T);
extern void writehelptouser(const char *, const confrecordtyp *);

/* windowstuff */
extern int windowtext(const char *, const char *, const int,
                      const confrecordtyp *);
extern char *savebackground(WINDOW *);
extern int restorebackground(WINDOW *, char *);
extern int window_on(struct termios *, ttystateenum *, confrecordtyp *);
extern int window_off(struct termios *, ttystateenum *, confrecordtyp *);
extern boolean termexists(const char *);
extern int addstr_withmargin(const char *);
#ifdef NO_ADDSTR_CONST
int bbs_addstr(const char *);
#endif
#ifdef NO_ADDSTR_CONST
int bbs_waddstr(WINDOW *, const char *);
#endif
#ifdef NO_PRINTW_CONST
int bbs_printw(const char *, ...);
#endif

/* dbase */
#ifdef NNTPNEWS
extern int updatenewsgroupsdb(bbsddbtyp *, newsstattyp *,
                              const confrecordtyp *);
#endif
extern int updatebbsddb(bbsddbtyp *, const confrecordtyp *);
extern int lookupbbsddb(const bbsddbtyp *, const void *, const SIZE_T,
                        const int, void *, SIZE_T *, const confrecordtyp *);
extern int closebbsddb(const bbsddbtyp *);
extern int getkeysbbsddb(const bbsddbtyp *, const int, void *, SIZE_T *,
                         void *, SIZE_T *, const confrecordtyp *);

/* nntp */
#ifdef NNTPNEWS
extern int nntp_postarticle(const char *, const char *, newsstattyp *,
                            const confrecordtyp *);
extern int nntp_getarticle(char **, char *, const int, const boolean,
                           newsstattyp *, const confrecordtyp *);
extern int nntp_getoverview(grouptyp *, const boolean, newsstattyp *,
                            const confrecordtyp *);
#endif

/* nntp-com */
#ifdef NNTPNEWS
extern int browsegroup(grouptyp *, newsstattyp *, const confrecordtyp *);
extern int nntp_connect(newsstattyp *, const confrecordtyp *);
extern int nntp_socket(newsstattyp *, const confrecordtyp *);
extern void nntp_close(newsstattyp *);
extern int nntp_ask(char *, newsstattyp *, const char *, ...);
extern char *nntp_copytext(SIZE_T *, newsstattyp *);
extern int nntp_getline(char *string, SIZE_T, newsstattyp *);
extern int nntp_getresponse(char *, SIZE_T,  newsstattyp *);
extern int nntp_putline(const char *, const newsstattyp *);
#endif

/* news */
#ifdef NNTPNEWS
extern int newsreply(newsheadertyp *, const char *, newsstattyp *,
                     const confrecordtyp *);
extern int getnewsgrpname(char *, const confrecordtyp *);
extern int checknewsperms(const confrecordtyp *);
extern int parsenewsheader(newsheadertyp *, char *);
extern int updatenewsrc(DBASE_DB *, grouptyp *, const boolean,
                        const confrecordtyp *);
extern int syncnewsrcdb(DBASE_DB *, const confrecordtyp *);
extern DBASE_DB *createnewsrcdb(newsstattyp *, const confrecordtyp *);
extern int lookupnewsrcdb(const DBASE_DB *, const void *, const SIZE_T, void *,
                          SIZE_T *, const confrecordtyp *);
extern int newsrcdbtolist(tlistetyp **, const DBASE_DB *,
                          const confrecordtyp *);
extern int overviewtolist(tlistetyp **, const grouptyp *,
                            const confrecordtyp *);
extern int parseoverviewline(articletyp *, char *);
#endif

/* bbsd */
/* main */
extern PID_T disconnect(const confrecordtyp *);
extern int rmdeadsessions(sessionrecordtyp []);
extern void cpysr(sessionrecordtyp *, const sessionrecordtyp *);
extern int dumpbbsdstatus(const char *,const sessionrecordtyp [],
                         const confrecordtyp *, const char *);
extern int changeuid(const char *);
extern PID_T daemonenkiller(const boolean, char *[], const SIZE_T,
			    const PID_T, const confrecordtyp *);
extern void dsighandler(int);
extern void kdsighandler(int);
extern int doaction(const int, const int, const int, char *[], const SIZE_T,
                    sessionrecordtyp [], bbsddbtyp *, newsstattyp *,
                    const char *[], const confrecordtyp *);
extern int writepidsfile(const confrecordtyp *, const PID_T, const PID_T);
extern int removepidsfile(const confrecordtyp *);

/* daction */
#ifdef NNTPNEWS
extern int dgetnewsrc(const int, const confrecordtyp *);
extern int dsavenewsrc(const int, const confrecordtyp *);
extern int dgetallnewsgroups(const int, const bbsddbtyp *,
                             const confrecordtyp *);
extern int dcheckgroup(const int, const bbsddbtyp *, const confrecordtyp *);
#endif
extern int dputinlog(const int, const int);
extern int dlistmessages(const int, const confrecordtyp *);
extern int dremovemessage(const int, const confrecordtyp *);
extern int dgetmessage(const int, const confrecordtyp *);
extern int dsendmessage(const int, const bbsddbtyp *, const confrecordtyp *);
extern int dreceivemail(const int, const bbsddbtyp *, const confrecordtyp *);
extern int dgetallusernames(const int, const bbsddbtyp *,
                            const confrecordtyp *);
extern int dsendstatustodaemon(sessionrecordtyp [], const confrecordtyp *,
			       const int);
extern int diniconnecttouser(sessionrecordtyp [], const confrecordtyp *,
                             const int);
extern int dabortconnecttouser(sessionrecordtyp [], const confrecordtyp *,
			       const int);
extern int dremconnecttouser(const sessionrecordtyp [], const confrecordtyp *,
                             const int);
extern int dgetsessions(sessionrecordtyp [], const int);
extern int daddsession(sessionrecordtyp [], const int);
extern int dremovesession(sessionrecordtyp [], const PID_T, const int);
extern int dgetuserrecord(const int, const confrecordtyp *);
extern int dsaveuserrecord(const int, const confrecordtyp *);

/* bbsmail */
extern int startbbsd(const confrecordtyp *, const char *);

#endif
