#include "daydream.h"
#include <sys/types.h>
#include <sys/stat.h>
#ifdef UNIX
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <termios.h>
#include <sys/wait.h>
#endif
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <utmp.h>
#include <ctype.h>

#ifdef USE_SGTTY
#include <sgtty.h>
#endif

#ifdef USE_SGTTY
static struct sgttyb oldtty;
static struct sgttyb sertty;
statuc struct sgttyb olsertty;
#elif defined(UNIX)
static struct termios oldtty;
static struct termios sertty;
#endif

int dsockfd;
static struct sockaddr_un ddsock;
static int idleon=1;
int fnode=0;
int bgmode=0;


void sysopsend(void);
int setlocal(void);
void showhelp(void);

extern int lmode;
extern int forcebps;

int initterm(void)
{
#ifdef USE_SGTTY
	struct sgttyb tty;
#else
	struct termios tty;
#endif
	char puskuri[512];

	umask(0);
	if (lmode==1||fnode) {
		setgid(maincfg.CFG_BBSGID);
		setegid(maincfg.CFG_BBSGID);
		setuid(maincfg.CFG_BBSUID);
		seteuid(maincfg.CFG_BBSUID);
	}
	if (getnodeinfo()==0) exit(1);

	if (!lmode && !fnode) {
		setenv("DAYDREAM",origdir,1);
	        serhandle=open(ttyname(0),O_RDWR);

		/* Create communication fifos for DDSnoop */
	
		sprintf(puskuri,"%sdaydream%dr",DDTMP,node);

		unlink(puskuri);
		if (mkfifo(puskuri,0770)!=0) {
			printf("Can't create fifo!\n");
			printf("Make sure daydream can access %s -directory!\n",DDTMP);
			exit(0);
		}
	
		conin=open(puskuri,O_RDWR);
		
		sprintf(puskuri,"%sdaydream%dw",DDTMP,node);
		unlink(puskuri);
		if (mkfifo(puskuri,0770)!=0) {
			printf("Can't create fifo!\n");
			exit(0);
		}
	
		conout=open(puskuri,O_RDWR);

	}
       	if (lmode==1||fnode) {
		conin=STDIN_FILENO;
		conout=STDOUT_FILENO;
		conon=2;
	}

	

	if ((dsockfd=socket(AF_UNIX,SOCK_DGRAM,0)) < 0) {
		printf("Can't create socket!\n");
		exit(1);
	}
	sprintf(puskuri,"%sdd_sock%d",DDTMP,node);
	unlink(puskuri);
	strcpy(ddsock.sun_path,puskuri);
	ddsock.sun_family=AF_UNIX;
	if (bind(dsockfd,(struct sockaddr *)&ddsock,sizeof(ddsock)) < 0) {
		printf("Can't bind socket...\n\n");
		close(dsockfd);
		exit(0);
	}

#if USE_SGTTY
	ioctl(0,TIOCEXCL,0);
	ioctl(0,TIOCGETP,&tty);

        oldtty=tty;
    
	tty.sg_flags &= ~ECHO;
   	tty.sg_flags |= RAW;
	ioctl(0,TIOCSETP,&tty);

#else
        tcgetattr(0,&tty); 
        oldtty=tty;
    
  	tty.c_iflag &= ~(IGNBRK | IGNCR | INLCR | ICRNL | IUCLC | 
  		IXANY | IXON | IXOFF | INPCK | ISTRIP);
  	tty.c_iflag |= (BRKINT | IGNPAR);
	tty.c_oflag &= ~OPOST;
	tty.c_lflag &= ~(XCASE|ECHONL|NOFLSH);
  	tty.c_lflag &= ~(ICANON | ISIG | ECHO);
  	tty.c_cflag |= CREAD;
  	tty.c_cc[VTIME] = 5;
  	tty.c_cc[VMIN] = 1;
   	tcsetattr(0,TCSANOW,&tty);

#endif
	
	atexit(clear);
	
	return 1;
}

void clear(void)
{
	char puskuri[512];
	
    	if (conon) tcsetattr(conin,TCSANOW,&sertty);
    	if (conout) tcsetattr(conout,TCSANOW,&sertty);
    
    	tcsetattr(0,TCSANOW,&oldtty);     
  
	if (conin) close(conin);
	if (conout) close(conout);
	sprintf(puskuri,"%sdaydream%dr",DDTMP,node);
	unlink(puskuri);
	close(dsockfd);
	sprintf(puskuri,"%sdd_sock%d",DDTMP,node);
	unlink(puskuri);
	sprintf(puskuri,"%sdaydream%dw",DDTMP,node);
	unlink(puskuri);
	sprintf(puskuri,"%snodeinfo%d.data",DDTMP,node);
	unlink(puskuri);

}

int sendtosock(int dnode, struct dd_nodemessage *dn)
{	
	int sock;
        struct sockaddr_un name;
     	
     	sprintf(name.sun_path,"%sdd_sock%d",DDTMP,dnode);
	sock = socket(AF_UNIX, SOCK_DGRAM, 0);
	if (sock < 0) 
        name.sun_family = AF_UNIX;

        sendto(sock, dn, sizeof(struct dd_nodemessage), 0, (struct sockaddr *)&name, sizeof(struct sockaddr_un));
        close(sock);
	return 1;
}

void setstderr(void)
{
	char stderrname[40];
	int newfd;
	
	sprintf(stderrname,"logfiles/stderr.%d",node);
	newfd=open(stderrname,O_RDWR|O_CREAT);
	lseek(newfd,0,SEEK_END);
	dup2(newfd,STDERR_FILENO);
}

int getnodeinfo(void)
{
	char *mytty;
	struct DayDream_Multinode *danode;
	struct utmp *ut_rec;
	char parbuf[80];
	char *s;
		
	if (lmode) return getfreelnode();
	
	mytty=ttyname(serhandle);
	
	danode=nodes;
	
	if (fnode) {
		while(danode->MULTI_NODE)
		  {
			if (danode->MULTI_NODE==fnode) {
				currnode=danode;
				node=fnode;
				bpsrate=danode->MULTI_TTYSPEED;
				return 1;
			} else {
				danode++;
			}
                  }
		return 0;
	}

	while (danode->MULTI_NODE)
	{
		if (!(strcmp(danode->MULTI_TTYNAME,mytty))) {
			node=danode->MULTI_NODE;
			currnode=danode;
			if (danode->MULTI_TTYTYPE==0) {
				setutent();
				while((ut_rec=getutent()))
				{
					if (!(strcmp(ut_rec->ut_line,&mytty[5]))) {
#ifdef USER_PROCESS
						if (ut_rec->ut_type == USER_PROCESS){
#else
						{
#endif
							bpsrate=atoi(ut_rec->ut_host);
							endutent();
							return 1;
						}
					} 
				}
				endutent();
				printf("Can't parse utmp!\n\nexiting...");
				return 0;
			} else {
				bpsrate=danode->MULTI_TTYSPEED;
				return 1;
			}
		} else {
			danode++;
		}
	}
	s=maincfg.CFG_TELNETPAT;
	while( (s=strspa(s,parbuf)) ) {
		if (wildcmp(mytty,parbuf)) {
			return getfreetnode();
		}
	}

	s=maincfg.CFG_LOCALPAT;
	while( (s=strspa(s,parbuf)) ) {
		if (wildcmp(mytty,parbuf)) {
			return getfreelnode();
		}
	}

	printf("Unknown tty: %s\n\nexiting...",mytty);
	return 0;
}

int getfreetnode(void)
{
	struct DayDream_Multinode *danode;

	danode=nodes;

	while (danode->MULTI_NODE)
	{
		if (danode->MULTI_NODE==254) {
			int i,j;
			i=maincfg.CFG_TELNETMAX;
			j=maincfg.CFG_TELNET1ST;
			while(i)
			{
				struct DayDream_NodeInfo ni;
				if (!isnode(j,&ni)) {
					currnode=malloc(sizeof(struct DayDream_Multinode));
					memcpy(currnode,danode,sizeof(struct DayDream_Multinode));
					node=j;
					sprintf(currnode->MULTI_TEMPORARY,danode->MULTI_TEMPORARY,j);
					currnode->MULTI_NODE=node;
					bpsrate=danode->MULTI_TTYSPEED;
					changenodestatus("Logging in..");
					return 1;
				}
				i--; j++;
			}
			printf("All telnet nodes in use. Call back later.\n");
			return 0;
		}
		danode++;
	}
	printf("We don't support telnet. Get out.\n");
	return 0;
}

int getfreelnode(void)
{
	struct DayDream_Multinode *danode;

	danode=nodes;

	while (danode->MULTI_NODE)
	{
		if (danode->MULTI_NODE==253) {
			int i,j;
			i=maincfg.CFG_LOCALMAX;
			j=maincfg.CFG_LOCAL1ST;
			while(i)
			{
				struct DayDream_NodeInfo ni;
				if (!isnode(j,&ni)) {
					currnode=malloc(sizeof(struct DayDream_Multinode));
					memcpy(currnode,danode,sizeof(struct DayDream_Multinode));
					node=j;
					sprintf(currnode->MULTI_TEMPORARY,danode->MULTI_TEMPORARY,j);
					currnode->MULTI_NODE=node;
					bpsrate=danode->MULTI_TTYSPEED;
					changenodestatus("Logging in..");
					return 1;
				}
				i--; j++;
			}
			printf("All local nodes in use. \n");
			return 0;
		}
		danode++;
	}
	printf("No local nodes\n");
	return 0;
}

void strupr (char *strh)
{
	while (*strh)
	{
		*strh++=toupper(*strh);
	}
}

int strlwr (char *strh)
{
	while (*strh)
	{
		*strh++=tolower(*strh);
	}
	return 1;
}

unsigned char HotKey(params)
int params;
{
	unsigned char pala=0;
	fd_set setti;
	struct timeval tv;
	int maxfd=0;
	int idlemode=0;
		     
	while ((waitpid(-1, NULL, WNOHANG)) > 0);

	if (!checkcarrier()) return 0;
	if (bgmode) return 0;
	/* Remove zombies */
	
askagain:
	FD_ZERO(&setti);
	maxfd=0;
	
	if (!lmode && userinput && (!(params & HOT_RE))) {
		maxfd=serhandle;
		FD_SET(serhandle, &setti);
	}

 	if (maxfd < conin) maxfd=conin;
    	FD_SET(conin, &setti);

	if (dsockfd) {
 		if (maxfd < dsockfd) maxfd=dsockfd;
    		FD_SET(dsockfd, &setti);
	}
	if (params & HOT_DELAY) {
		tv.tv_sec=delayt;
		tv.tv_usec=0;
		select((maxfd+1),&setti,0,0,&tv); 
	} else if ((params & HOT_QUICK) && ((params & HOT_RE)==0)) {
		tv.tv_sec=0;
		tv.tv_usec=0;
		select((maxfd+1),&setti,0,0,&tv); 
	} else {
		if (!idlemode) 
			tv.tv_sec=maincfg.CFG_IDLETIMEOUT-30;
			else tv.tv_sec=30;
			tv.tv_usec=0;
		select((maxfd+1),&setti,0,0,&tv); 
	}
	timeleft=endtime-time(0);

	if (timeleft < 0 && onlinestat) {
		char tbuf[1024];
		
		DDPut(sd[dltstr]);
		sprintf(tbuf,"Connection closed due to an expiration of daily time limit at %s\n",currt());
		dropcarrier();
		return 0;
	}

	if (!checkcarrier()) return 0;
	
	if (!lmode && FD_ISSET(serhandle, &setti)) {
		read(serhandle,&pala,1);
		if (display && display->DISPLAY_ATTRIBUTES & (1L<<1)) {
			pala=inconvtab[pala];
		}
		keysrc=1;
	} else if (FD_ISSET(dsockfd, &setti)) {
		struct dd_nodemessage ddn;
		read(dsockfd,&ddn,sizeof(struct dd_nodemessage));
		processmsg(&ddn);
		if (params & HOT_MAIN) return 0;
		return HotKey(params);
	} else if ( (conin!=serhandle || conon==2)  && FD_ISSET(conin, &setti)) {
		read(conin,&pala,1);
		keysrc=2;
	} else {
		if ((params & HOT_DELAY) || (params & HOT_QUICK) || !idleon) return 255;
		
		if (!idlemode) {
			DDPut(sd[timeoutstr]);
			idlemode=1;
			goto askagain;
			
		} else {
			char bbuf[1024];
			sprintf(bbuf,"Connection closed by idle timeout at %s\n",currt());
			writelog(bbuf);
			dropcarrier();
		}

		return 0;
	}

    	if (keysrc == 2 && pala==2) {
		return handlectrl(params);
    	}
    
	if (params & HOT_YESNO && (!(params & HOT_RE))) {
		if (pala=='Y' || pala=='y' || pala==13 || pala==10) {
			DDPut(sd[yesstr]);
			return 1;
		} else if (pala=='N' || pala=='n') {
			DDPut(sd[nostr]);
			return 2;
		} else goto askagain;
	}

	if (params & HOT_NOYES && (!(params & HOT_RE))) {
		if (pala=='N' || pala=='n' || pala==13 || pala==10) {
			DDPut(sd[nostr]);
			return 2;
		} else if (pala=='Y' || pala=='y') {
			DDPut(sd[yesstr]);
			return 1;
		} else goto askagain;
	}


    	if (pala==27 && (params & HOT_CURSOR))
    	{
      		pala=HotKey(0);
       		if (pala=='[') {
       			pala=HotKey(0); 
       			if(pala=='A') return 250;
                        if(pala=='B') return 251;
                        if(pala=='C') return 252;
                        if(pala=='D') return 253;
                        return pala;
                }   
    	}    

    	if (pala==155 && (params & HOT_CURSOR)) {
    		pala=HotKey(0); 
    		if(pala=='A') return 250;
                if(pala=='B') return 251;
                if(pala=='C') return 252;
                if(pala=='D') return 253;
                return pala;  
    	}    
   	return(pala);
}

int handlectrl(int params)
{
	int pala;
	int oldansi;
	
	pala=HotKey(params|HOT_RE);
	if (pala==2) return pala;
	else if (pala==1) {
		if (conon!=2) conon=1;
		smallstatus();
		pala=HotKey(params|HOT_RE);
		if (pala) maincfg.CFG_LOCALSCREEN=pala;
		pala=HotKey(params);
		return pala;
	}
	else if (pala==4) {
		if (conon!=2) conon=0;
		pala=HotKey(params);
		return pala;
	}
		
	else if (pala=='c'||pala=='C') {
		LineChat();
		pala=HotKey(params);
		return pala;
	} else if (pala=='1') {
		DDPut(sd[accountedstr]);
		oldansi=ansi;
		ansi=1;
		userinput=0;
		usered();
		ansi=oldansi;
		userinput=1;
		pala=HotKey(params);
		return pala;
	} else if (pala=='2') {
		usered();
		pala=HotKey(params);
		return pala;			
	} else if (pala=='h' || pala=='H') {
		oldansi=ansi;
		ansi=1;
		userinput=0;

		DDPut("[33m\nSnooping commands:\n\n");
		DDPut("[36mCtrl-b-h [34m- [0mHelp\n");
		DDPut("[36mCtrl-b-1 [34m- [0mUser editor (SysOp only)\n");
		DDPut("[36mCtrl-b-2 [34m- [0mUser editor (SysOp + user)\n");
		DDPut("[36mCtrl-b-c [34m- [0mChat\n");
		DDPut("[36mCtrl-b-s [34m- [0mWho's online\n");
		DDPut("[36mCtrl-b-u [34m- [0mSend files (free download)\n");
		DDPut("[36mCtrl-b-r [34m- [0mReceive files (-> chat download)\n");
		ansi=oldansi;
		userinput=1;
		pala=HotKey(params);
		return pala;
	} else if (pala=='s' || pala=='S') {
		smallstatus();
		pala=HotKey(params);
		return pala;
	} else if (pala=='u' || pala=='U') {
		sysopsend();
		pala=HotKey(params);
		return pala;
	} else if (pala=='r' || pala=='R') {
		recfiles(maincfg.CFG_CHATDLPATH,0);
		pala=HotKey(params);
		return pala;
	}
	else return pala;
}

void smallstatus(void)
{
	int oldansi;
	char sbu[500];	
	oldansi=ansi;
	ansi=1;
	userinput=0;

	if (onlinestat) {
		sprintf(sbu,"\n[36mUser online\n\n[0mName: %s (%s)\nFrom: %s (%s)\nUls : %Lu / %d\nDls : %Lu / %d\nCalls/Slot/Sec/Time left: %d / %d / %d /%d\n",user.user_realname,user.user_handle,user.user_zipcity,user.user_organization,user.user_ulbytes,user.user_ulfiles,user.user_dlbytes,user.user_dlfiles,user.user_connections,user.user_account_id,user.user_securitylevel,timeleft/60);
		DDPut(sbu);
	} else {
		DDPut("\nNo user online!\n");
	}
	ansi=oldansi;
	userinput=1;

}

void sysopsend(void)
{
	int oldansi;
	char sbu[500];	
	char flname[80];

	oldansi=ansi;
	ansi=1;
	userinput=0;

	DDPut("[0m\nFiles to send: [36m");
	*sbu=0;
	if (!(Prompt(sbu,500,0))) return;
	
	sprintf(flname,"%sfilelist.%d",DDTMP,node);
	if (makeflist(flname,sbu)) {
		sendfiles(flname,sbu);
	}
	ansi=oldansi;
	userinput=1;
}

int getcmdline(int args, char *argi[])
{
	char *cp;
	
	while (--args) {
	cp = *++argi;
		if (*cp == '-') {
			while( *++cp) {
				switch(*cp) {
				 case 'd':
					idleon=0;
					break;
				 case 'l':
					lmode=1;
					if (setlocal()) return 0;
					break;
				 case 'n':
					if (--args < 1) {
						showhelp();
						return 0;
					}
					fnode=atoi(*++argi);
					if (setlocal()) return 0;
					break;
				 case 's':
					if (--args < 1) {
						showhelp();
						return 0;
					}
					forcebps=atoi(*++argi);
					if (setlocal()) return 0;
					break;
				 default:
					showhelp();
					return 0;
				}
				
			}
		} else {
			showhelp();
			return 0;
		}
	}
	return 1;
}

void showhelp(void)
{
	printf("DayDream BBS " versionstring " by Antti Hyrynen\n\n"
	       "Usage: daydream [-d] [-l] [-n node] [-s bps]\n\n"
	       "      -d -> disable idle\n"
	       "      -l -> local login\n"
	       "      -n -> force node\n"
	       "      -s -> call has been answered by mailer -> enter the BBS as\n"
	       "            <bps> connection.\n");
}

int setlocal(void)
{
       	char *s;
		  
	s=getenv("DAYDREAM");
	if (!s) {
		printf("set env-variable DAYDREAM!\n");
		return 1;
	}
	strcpy(origdir,s);
	chdir(s);
	return 0;
}
	
