#include <dirent.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <daydream.h>

static int quote(char *);

int row;
char wrapbuf[80];

/* Returns the number of lines entered. */
int lineed(char *buffer, int mode, struct DayDream_Message *msg)
{
	int i, j;
	char lbuf[300];
	char *s, *t;

	*wrapbuf = 0;
	row = 1;

	DDPut(sd[leheadstr]);

	if (mode) {
		quote(buffer);
	}
	while (1) {
		ddprintf(sd[lelinestr], row);

		s = buffer;
		s = s + ((row - 1) * 80);
		*s = 0;
		if (!(Prompt(s, 75, PROMPT_WRAP)))
			return 0;

		snprintf(lbuf, sizeof(lbuf), "%c", maincfg.CFG_LINEEDCHAR);
		if (*s == 0 || (!strcasecmp(lbuf, s)) || row == 495) {
			while (1) {
				DDPut(sd[lepromptstr]);
				lbuf[0] = 0;
				if (!(Prompt(lbuf, 3, 0)))
					return 0;

				if (!strcasecmp(lbuf, "a")) {
					DDPut(sd[lesureabortstr]);
					i = HotKey(HOT_NOYES);
					if (!i || i == 1)
						return 0;
				} else if (!strcasecmp(lbuf, "c")) {
					TypeFile("lineedcommands", TYPE_WARN | TYPE_MAKE);
				} else if (!strcasecmp(lbuf, "d")) {
					DDPut(sd[ledelstr]);
					lbuf[0] = 0;
					if (!(Prompt(lbuf, 3, PROMPT_NOCRLF)))
						return 0;
					if ((i = atoi(lbuf))) {
						lbuf[0] = 0;
						DDPut(sd[ledeltostr]);
						if (!(Prompt(lbuf, 3, 0)))
							return 0;
						if ((j = atoi(lbuf))) {
							if (j < i) {
								int t;
								t = i;
								i = j;
								j = t;
							}
							if (j > 0 && i > 0 && j <= row) {
								while (i - 1 != j) {
									int k;
									for (k = (i - 1); k < row; k++) {
										s = buffer + ((k) * 80);
										t = buffer + ((k + 1) * 80);
										strcpy(s, t);
									}
									j--;
									row--;

								}
							}
						}
					}
				} else if (!strcasecmp(lbuf, "e")) {
					DDPut(sd[leedlinstr]);
					lbuf[0] = 0;
					if (!(Prompt(lbuf, 3, 0)))
						return 0;
					i = atoi(lbuf);
					if (!(i < 1 || i > (row - 1))) {
						ddprintf(sd[leedpstr], i);
						s = buffer + (i - 1) * 80;
						if (!(Prompt(s, 75, 0)))
							return 0;
					}
				} else if (!strcasecmp(lbuf, "r")) {
					break;
				} else if (!strcasecmp(lbuf, "f")) {
					if (msg && *msg->MSG_ATTACH) {
						fileattach();
					} else {
						DDPut(sd[noattachstr]);
					}
				} else if ((!strcasecmp(lbuf, "i")) && row < 495) {
					DDPut(sd[insertstr]);
					lbuf[0] = 0;
					if (!(Prompt(lbuf, 3, 0)))
						return 0;
					DDPut("\nInsert does not work yet, sorry...\n\n");
				} else if (!strcasecmp(lbuf, "l")) {
					int lcount = user.user_screenlength;
					i = row - 1;
					j = 1;
					while (i) {
						s = buffer + (j - 1) * 80;
						ddprintf(sd[lellinestr], j, s);
						lcount--;

						if (lcount == 0) {
							int hot;

							DDPut(sd[morepromptstr]);
							hot = HotKey(0);
							DDPut("\r                                                         \r");
							if (hot == 'N' || hot == 'n')
								break;
							if (hot == 'C' || hot == 'c') {
								lcount = -1;
							} else {
								lcount = user.user_screenlength;
							}
						}
						j++;
						i--;
					}

				} else if (!strcasecmp(lbuf, "s")) {
					return row - 1;
				} else if (!strcasecmp(lbuf, "q")) {
					if (!mode) {
						DDPut(sd[lereperrorstr]);
					}
					quote(s);
				}
			}
		} else {
			row++;
		}
	}
}

int fileattach(void)
{
	char olddir[1024];
	char fabuf[1024];
	FILE *falist;
	int cnt = 0;
	struct dirent *dent;
	DIR *dh;

	cleantemp();
	recfiles(currnode->MULTI_TEMPORARY, 0);

	snprintf(fabuf, sizeof(fabuf), "%s/attachs.%d", DDTMP, node);
	/* FIXME: check falist == NULL */
	falist = fopen(fabuf, "w");

	if ((dh = opendir(currnode->MULTI_TEMPORARY))) {
		getcwd(olddir, 1024);
		chdir(currnode->MULTI_TEMPORARY);
		while ((dent = readdir(dh))) {
			if (dent->d_name[0] == '.' && (dent->d_name[1] == '\0' || (dent->d_name[1] == '.' && dent->d_name[2] == '\0')))
				continue;
			if (!strcmp(".packtmp", dent->d_name))
				continue;

			deldir(".packtmp");
			ddprintf(sd[afqstr], dent->d_name);
			if (HotKey(HOT_YESNO) == 1) {
				fprintf(falist, "%s\n", dent->d_name);
				cnt++;
			} else {
				unlink(dent->d_name);
			}
			if (!checkcarrier())
				break;
		}
		chdir(olddir);
		closedir(dh);
	}
	fclose(falist);
	if (!cnt) {
		snprintf(fabuf, sizeof(fabuf), "%s/attachs.%d", DDTMP, node);
		unlink(fabuf);
	}
	return 1;
}

static int quote(char *qmem)
{
	char qbuffer[200];
	char input[100];
	int qld = 0;
	int line;
	char *s;
	FILE *qfd;

	snprintf(qbuffer, sizeof(qbuffer), "%s/daydream%d.msg", DDTMP, node);
	qfd = fopen(qbuffer, "r");
	if (!qfd) 
		return 0;
	
	line = 1;

	while (fgetsnolf(input, 78, qfd)) {
		s = qmem + qld * 80;
		strcpy(s, input);
		row++;
		qld++;
		line++;

	}
	fclose(qfd);
	return 1;
}

char *fgetsnolf(char *buf, int n, FILE * fh)
{
	char *hih;
	char *s;

	hih = fgets(buf, n, fh);
	if (!hih)
		return 0;
	s = buf;
	while (*s == 13) {
		strcpy(s, s + 1);
	}
	while (*s) {
		if (*s == 13 || *s == 10) {
			*s = 0;
			break;
		}
		s++;
	}
	return hih;
}
