#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>

#include "ddcommon.h"

#ifdef HAVE_UTMPX_H
#include <utmpx.h>
#else
#include <utmp.h>
#endif

#ifndef _PATH_WTMP
#define _PATH_WTMP WTMP_FILE
#endif
#ifndef _PATH_WTMPX
#define _PATH_WTMPX WTMPX_FILE
#endif

#ifndef HAVE_ERROR_AT_LINE
char *prog_invocation_name = NULL;
#endif

void init_common_library(int argc, char *argv[])
{
#ifndef HAVE_ERROR_AT_LINE
	prog_invocation_name = strdup(argv[0]);
#endif
}

off_t dd_lseek(int fd, off_t offset, int whence)
{
	struct stat st;
	if (whence == SEEK_END && offset < 0) {
		whence = SEEK_SET;
		if (fstat(fd, &st) == -1)
			return (off_t) -1;
		offset = st.st_size - offset;
	}
	return lseek(fd, offset, whence);
}

char *strupr(char *s)
{
	char *p;	
	for (p = s; *p; *p = toupper(*p), p++);
	return s;
}
	
char *strlwr(char *s)
{
	char *p;	
	for (p = s; *p; *p = tolower(*p), p++);
	return s;
}

#ifndef HAVE_CFMAKERAW
int cfmakeraw(struct termios *t)
{
	t->c_iflag &= ~(IGNBRK | BRKINT | PARMRK | ISTRIP | INLCR |
			IGNCR | ICRNL | IXON);
	t->c_oflag &= ~OPOST;
	t->c_lflag &= ~(ECHO | ECHONL | ICANON | ISIG | IEXTEN);
	t->c_cflag &= ~(CSIZE | PARENB);
	t->c_cflag |= CS8;
	return 0;
}
#endif
