#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include <ddcommon.h>

void error_at_line(int status, int errnum, const char *fname, 
	unsigned int lineno, const char *fmt, ...)
{
	va_list args;
	va_start(args, fmt);
	fprintf(stderr, "%s:%s:%d: ", prog_invocation_name, fname, lineno);
	vfprintf(stderr, fmt, args);
	va_end(args);
	if (errnum) 
		fprintf(stderr, ": %s", strerror(errnum));
	fputc('\n', stderr);
	exit(status);	
}
