#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include <ddcommon.h>

void err(int status, int errnum, const char *fmt, ...)
{
	va_list args;
	va_start(args, fmt);
	fprintf(stderr, "%s: ", prog_invocation_name);
	vfprintf(stderr, fmt, args);
	va_end(args);
	if (errnum) 
		fprintf(stderr, ": %s", strerror(errnum));
	fputc('\n', stderr);
	exit(status);	
}
