#ifndef _DDCOMMON_H_INCLUDED
#define _DDCOMMON_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#include "config.h"

#include <sys/types.h>
#include <string.h>
#ifdef HAVE_TERMIOS_H
#include <termios.h>
#endif
#ifdef HAVE_ERR_H
#include <err.h>
#endif

#include <ddutmpx.h>

/* libddcommon.c */
off_t dd_lseek(int fd, off_t offset, int whence);

char *strlwr(char *);
char *strupr(char *);

void init_common_library(int argc, char *argv[]);

/* strlcpy.c */
#ifndef HAVE_STRLCPY
size_t strlcpy(char *, const char *, size_t);
#endif

/* strlcat.c */
#ifndef HAVE_STRLCAT
size_t strlcat(char *, const char *, size_t);
#endif

#ifndef HAVE_SETENV
int setenv(const char *name, const char *value, int overwrite);
#endif
#ifndef HAVE_UNSETENV
void unsetenv(const char *name);
#endif

#ifndef HAVE_CFMAKERAW
int cfmakeraw(struct termios *t);
#endif

#ifndef HAVE_WARN
void warn(const char *, ...);
#endif
#ifndef HAVE_ERROR
void error(int, int, const char *, ...);
#endif
#ifndef HAVE_ERROR_AT_LINE
extern char *prog_invocation_name;

void error_at_line(int, int, const char *, unsigned int, const char *, ...);
#endif



#ifdef __cplusplus
};
#endif

#endif 
