#include <dd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

struct DayDream_Multinode *mn;
struct DayDream_MainConfig maincfg;
char *env;

const char *whlinestr = "%-2.2d %-20.20s %-25.25s %-20.20s %s\n";

int isnode(int, struct DayDream_NodeInfo *);
void shownodes(void);
void who_show(struct DayDream_Multinode *, int);


int main(int argc, char *argv[])
{
	char *env;
	char bufa[1024];
	struct stat st;
	int fd;

	env=getenv("DAYDREAM");
	
	sprintf(bufa,"%s/data/multinode.dat",env);
	if (stat(bufa,&st)<0) {
		perror("open $DAYDREAM/data/multinode.dat");
		return -1;
	}
	mn=malloc(st.st_size+2);
	memset(mn,0,st.st_size+2);
	fd=open(bufa,O_RDONLY);
	if (fd < 0) {
		perror("open $DAYDREAM/data/multinode.dat");
		return -1;
	}
	read(fd,mn,st.st_size);
	close(fd);
	
	sprintf(bufa,"%s/data/daydream.dat",env);
	fd=open(bufa,O_RDONLY);
	if (fd < 0) {
		perror("open $DAYDREAM/data/daydream.dat");
		return -1;
	}
	read(fd,&maincfg,sizeof(struct DayDream_MainConfig));
	close(fd);
	
	shownodes();
	return 0;
}

void shownodes()
{
	struct DayDream_Multinode *cn;

	cn=mn;
	
	printf("N  Account Name         Org. / Location           Activity             Bps\n-----------------------------------------------------------------------------\n");

	while(cn->MULTI_NODE)
	{
		if (cn->MULTI_NODE == 253) {
			int j;
			int i=maincfg.CFG_TELNET1ST;
			j=maincfg.CFG_TELNETMAX;
			
			while(j) {
				j--;
				who_show(cn,i);
				i++;
			}
		} else if (cn->MULTI_NODE == 254) {
			int j;
			int i=maincfg.CFG_LOCAL1ST;
			j=maincfg.CFG_LOCALMAX;
			
			while(j) {
				j--;
				who_show(cn,i);
				i++;
			}
		} else if (cn->MULTI_NODE != 252) {
			who_show(cn,cn->MULTI_NODE);
		}
		cn++;
	}
	printf("-----------------------------------------------------------------------------\n\n");
}

void who_show(struct DayDream_Multinode *cn, int num)
{
	struct DayDream_NodeInfo myn;
	const char *usern, *orgn, *activity;
	char dabps[30];
	
	int nodefd;
	struct userbase nuser;
	char blabuf[500];       
	int showent=1;
		
	memset(&myn,0,sizeof(struct DayDream_NodeInfo));
	
	if (isnode(num,&myn)) {
		if (cn->MULTI_OTHERFLAGS & (1L<<4)) {
			showent=0;
		} else {
			if (myn.ddn_userslot > -1) {
				sprintf(blabuf,"%s/data/userbase.dat",getenv("DAYDREAM"));
				nodefd=open(blabuf,O_RDONLY);
				lseek(nodefd,myn.ddn_userslot*sizeof(struct userbase),SEEK_SET);
				read(nodefd,&nuser,sizeof(struct userbase));
				close(nodefd);
				if (maincfg.CFG_FLAGS & (1L<<1)) usern=nuser.user_handle; else usern=nuser.user_realname;
				if (maincfg.CFG_FLAGS & (1L<<2)) orgn=nuser.user_organization; else orgn=nuser.user_zipcity;
				activity=myn.ddn_activity;
				sprintf(dabps,"%d",myn.ddn_bpsrate);
			} else {
				usern=" "; orgn=" ";
				activity=myn.ddn_activity;
				sprintf(dabps,"%d",myn.ddn_bpsrate);
			}
		} 
	} else {
		if (cn->MULTI_OTHERFLAGS & (1L<<3)) showent=0;
		else {
			usern=" "; orgn=" "; activity="Waiting for a call...";
			sprintf(dabps,"%d",0);
		}
	}
	if (showent) {
		switch (cn->MULTI_TTYTYPE)
		{
			case 1:
				strcpy(dabps,"LOCAL");
			break;
			case 2:
				if (myn.ddn_flags & (1L<<1)) {
					sprintf(dabps,"%d",myn.ddn_bpsrate);
				} else {
					strcpy(dabps,"TELNET");
				}
			break;
		}
		printf(whlinestr,num,usern,orgn,activity,dabps);
	}
	return;
}

int ispid(pid_t pid)
{
	char ibuf[1024];
	struct stat st;
	
	sprintf(ibuf,"/proc/%d",pid);

	if (stat(ibuf,&st)==-1) return 0; 
	return 1;
}

int isnode(int nod, struct DayDream_NodeInfo *ndnfo)
{
	char infoname[1024];
	int nodefd;
		
	sprintf(infoname,"%snodeinfo%d.data",DDTMP,nod);
	nodefd=open(infoname,O_RDONLY);
	if (nodefd!=-1) {
		read(nodefd,ndnfo,sizeof(struct DayDream_NodeInfo));
		close(nodefd);
		if(ispid(ndnfo->ddn_pid)) return 1;
	}
	return 0;
}


