#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>

#include "daydream.h"

int viewfile(const char *params) 
{
	char parbuf[1024];		
	char fname[1024];	
	char vbuf[1024];
      	const char *srcstrh;
	
	srcstrh = params;
	
	if (!params || !*params) {
		DDPut(sd[viewstr]);
		*vbuf = 0;
		
		if (!(Prompt(vbuf, 80, PROMPT_FILE)))
			return 0;
				    
		if (!*vbuf)
			return 0;
				    
		srcstrh = vbuf;
	}
	
	for (;;) {
		char *s;

		if (strtoken(parbuf, &srcstrh, sizeof(parbuf)) > sizeof(parbuf))
			continue;
		if (!*parbuf)
			break;
		
		getarchiver(parbuf);
		
		if (!arc) {
			ddprintf(sd[viewunkastr], parbuf);
			continue;
		}
		
		if (!*arc->ARC_VIEW) {
			ddprintf(sd[viewnosupstr], arc->ARC_NAME);
			continue;
		}
		
		if (arc->ARC_VIEWLEVEL > user.user_securitylevel) {
			ddprintf(sd[viewlamerstr], arc->ARC_NAME);
			continue;
		}
		
		s = find_file(parbuf, NULL);
				
		if (!s) {
			ddprintf(sd[viewnostr], parbuf);
			continue;
		}
		
		genstdiocmdline(parbuf, arc->ARC_VIEW, s, 0);
		snprintf(fname, sizeof(fname), "%sarcoutp%d", DDTMP, node);
		runstdio(parbuf, fname, 3);
				    
		DDPut("[0m");
				
		TypeFile(fname, TYPE_NOCODES);	       		
		unlink(fname);
	}	
	
	return 1;		    
}

char *find_file(char *filename, conference_t *cf)
{
	static char list_fname[PATH_MAX];
	FILE *fp;
	
	if (!cf)
		cf = conference();
	
	if (strchr(filename, '/'))
		return NULL;
	
	snprintf(list_fname, PATH_MAX, "%sdata/paths.dat", cf->conf.CONF_PATH);
	if (!(fp = fopen(list_fname, "r"))) 
		return NULL;
	
	while (fgetsnolf(list_fname, PATH_MAX, fp)) {
		struct dirent *dent;
		DIR *dir;
		
		if (!list_fname[0])
			continue;

		if (!(dir = opendir(list_fname)))
			continue;

		while ((dent = readdir(dir))) 
			if (!strcasecmp(dent->d_name, filename)) {
				strcat(list_fname, dent->d_name);
				fclose(fp);
				return list_fname;
			}

		closedir(dir);
	}
	
	fclose(fp);
	return NULL;
}
