/* utmp support functions for Berkeley Unix */

#ifndef HAVE_GETUTENT
#include <fcntl.h>
#include <sys/types.h>
#include <utmp.h>
#include <unistd.h>

static int utmp_fd;
static struct utmp utent;

void setutent(void)
{
	utmp_fd = open(_PATH_UTMP, O_RDONLY);
}

struct utmp *getutent(void)
{
	if (read(utmp_fd, &utent, sizeof(struct utmp)) != sizeof(struct utmp))
		return NULL;
	return &utent;
}

void endutent(void)
{
	close(utmp_fd);
}
#endif /* HAVE_GETUTENT */
