#include <sys/types.h>
#include <sys/stat.h>
#include <limits.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "daydream.h"
#include "symtab.h"

#define g_read(__fd__, __ptr__, __count__) \
	(read(__fd__, __ptr__, __count__) == __count__)
#define g_write(__fd__, __ptr__, __count__) \
	(write(__fd__, __ptr__, __count__) == __count__)

static int ub_open(int mode)
{
	int fd;
	char *filename = myprintf("%s/data/userbase.dat", origdir);
#ifdef HAVE_O_SYNC
	fd = open(filename, mode | O_CREAT | O_SYNC, 0644);
#else
   	fd = open(filename, mode | O_CREAT, 0644);
#endif
	g_free(filename);
	return fd;
}

static int ub_close(int fd)
{
	return close(fd);
}

struct userbase *getubentbyid(int id)
{
	struct userbase *ub;
	int fd = ub_open(O_RDONLY);
	if (fd == -1)
		return NULL;
	if (lseek(fd, sizeof(struct userbase) * id, SEEK_SET) == -1) {
		ub_close(fd);
		return NULL;
	}
	ub = g_new(struct userbase, 1);
	if (!g_read(fd, ub, sizeof(struct userbase))) {
		free(ub);
		return NULL;
	}
	if (ub_close(fd)) {
		free(ub);
		return NULL;
	}
	return ub;
}

struct userbase *getubentbyname(const char *name)
{
	struct userbase *ub = NULL;
	int id = 0;
	
	for (;; id++) {
		g_free(ub);
		ub = NULL;
		
		ub = getubentbyid(id);
		if (!ub)
			return NULL;
		if ((ub->user_toggles & UBENT_STAT_MASK) == UBENT_STAT_DELETED)
			continue;
		if (!strcasecmp(ub->user_realname, name) ||
		    !strcasecmp(ub->user_handle, name))
			break;
	}
	
	return ub;
}
	
int writeubent(const struct userbase *ub)
{
	int fd = ub_open(O_RDWR);
	
	if (lseek(fd, sizeof(struct userbase) * ub->user_account_id,
		  SEEK_SET) == -1) {
		ub_close(fd);
		return -1;
	}
	if (!g_write(fd, ub, sizeof(struct userbase))) {
		ub_close(fd);
		return -1;
	}
	return ub_close(fd);
}
	
		
