#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/time.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "daydream.h"
#include "symtab.h"

static int dotype(char *file, int flags);

static int doconv = 1;

static char ddprintf_buffer[4096];

int ddprintf(const char *fmt,...)
{
	int chars;

	va_list args;
	va_start(args, fmt);
	chars = vsnprintf(ddprintf_buffer, 4096, fmt, args);
	va_end(args);

	DDPut(ddprintf_buffer);
	return chars;
}

void DDPut(const char *typeme)
{
	unsigned char *tempmem;

	int len1;
	int i = 0;
	int k = 0;
	int s = 0;
	int t = 0;
	int u;
	int go = 1;

	if (typeme == NULL)
		return;

	if (bgmode)
		return;

	if (*typeme == 1) {
		typeme++;
		TypeFile(typeme, TYPE_MAKE | TYPE_WARN | TYPE_CONF);
		return;
	}
	       
	len1 = strlen(typeme);      
	tempmem = (void *) xmalloc(len1 * 2 + 1);

	while (typeme[i] != 0) {
		if (typeme[i] == 10) {
			tempmem[k] = 13;
			tempmem[k + 1] = 10;
			i++;
			k = k + 2;
		} else {
			tempmem[k] = typeme[i];
			k++;
			i++;
		}
	}

	tempmem[k] = 0;

	if (!ansi) {
		while (go) {
			if (tempmem[s] == 27) {
				u = s;
				s = s + 2;
			      skiploop:
				if (s)
					goto go1;
				go = 0;
				goto gooff;
			      go1:
				if (tempmem[s] >= 'A')
					goto go2;
				s++;
				goto skiploop;
			      go2:
				if (tempmem[s] == 'm')
					goto go3;
				s = u;
				tempmem[t] = tempmem[s];
				t++;
			      go3:
				s++;
			      gooff:;
			} else {
				tempmem[t] = tempmem[s];
				t++;
				s++;
				if (tempmem[s] == 0)
					go = 0;
			}
		}
		tempmem[t] = 0;
	}

	if (conon && conout)
		write(conout, tempmem, strlen(tempmem));

	if (doconv && display && display->DISPLAY_ATTRIBUTES & (1L << 2)) {
		unsigned char *s;
		s = tempmem;
		while (*s) {
			*s = outconvtab[(unsigned char) *s];
			s++;
		}
	}
	if (userinput && checkcarrier() && serhandle != conin)
		write(serhandle, tempmem, strlen(tempmem));
	free(tempmem);
}

void stripansi(char *tempmem)
{

	int go = 1;
	int s = 0;
	int t = 0;
	int u;

	while (go) {
		if (tempmem[s] == 27) {
			u = s;
			s = s + 2;
		      skiploop:
			if (s)
				goto go1;
			go = 0;
			goto gooff;
		      go1:
			if (tempmem[s] >= 'A')
				goto go2;
			s++;
			goto skiploop;
		      go2:
			if (tempmem[s] == 'm')
				goto go3;
			s = u;
			tempmem[t] = tempmem[s];
			t++;
		      go3:
			s++;
		      gooff:;
		} else {
			tempmem[t] = tempmem[s];
			t++;
			s++;
			if (tempmem[s] == 0)
				go = 0;
		}
	}
	tempmem[t] = 0;
}

enum {
	fname_sec = 0x01,
	fname_raw = 0x02,
	fname_ext_gfx = 0x04,
	fname_ext_txt = 0x08,
	fname_ext = fname_ext_gfx | fname_ext_txt,
	fname_dpath = 0x10,
	fname_cpath = 0x20,
	fname_opath = 0x40,
	fname_cnum = 0x80,
	fname_mpath = 0x100
};

struct name_component {
	int type;
	char *ptr;
};

static char *compose_name(list_t *name_comps, int omit)
{
	char tmpstr[64];
	string_t *name = strnew();

	while (name_comps) {
		struct name_component *comp =
			car(struct name_component *, name_comps);
		name_comps = cdr(name_comps);
		switch (comp->type & ~omit) {
		case 0:
			break;
		case fname_sec:
			snprintf(tmpstr, sizeof(tmpstr), 
				".%d", user.user_securitylevel);
			name = strappend(name, tmpstr);
			break;
		case fname_raw:
			name = strappend(name, comp->ptr);
			break;
		case fname_ext_gfx:
			name = strappend(name, ".gfx");
			break;
		case fname_ext_txt:
			name = strappend(name, ".txt");
			break;		     
		case fname_dpath:
			name = strappend(name, display->DISPLAY_PATH);
			break;
		case fname_cpath:
			name = strappend(name,
					 conference()->conf.CONF_PATH);
			break;
		case fname_opath:
			name = strappend(name, origdir);
			break;
		case fname_mpath:
			name = strappend(name, origdir);
			name = strappend(name, "/menu/");
			break;
		case fname_cnum:
			snprintf(tmpstr, sizeof(tmpstr), ".%d", 
				conference()->conf.CONF_NUMBER);
			break;
		default:
			strfree(name, 1);
			return NULL;
		}
	}
	
	return strfree(name, 0);
}

static int hascomp(list_t *name_comps, int type)
{
	while (name_comps) {
		if (car(struct name_component *, name_comps)->type & type)
			break;
		name_comps = cdr(name_comps);
	}
	return (int) name_comps;
}
	
static int find_and_type_file(list_t *name_comps, int flags)
{
	int i, trythese[][2] = {
		{ fname_sec | fname_ext, fname_ext_txt },
		{ fname_sec | fname_ext, fname_ext_gfx },
		{ fname_ext, fname_ext_txt | fname_sec },
		{ fname_ext, fname_ext_gfx | fname_sec },
		{ fname_sec, 0 },
		{ 0, fname_sec }
	};
	
	for (i = 0; i < 6; i++) {
		char *filename;
		
		int flag = trythese[i][0];
		
		if ((flag & fname_ext) && !hascomp(name_comps, fname_ext))
			continue;
		    
		if ((flag & fname_sec) && !hascomp(name_comps, fname_sec))
			continue;
		
		if (!ansi && (flag & fname_ext_gfx & trythese[i][1]))
			continue;
		
		if (display && display->DISPLAY_ATTRIBUTES & (1L << 5) &&
		    ansi && (flag & fname_ext_txt)) 
			continue;
		
		filename = compose_name(name_comps, trythese[i][1]);
		if (!filename)
			continue;
		
		if (dotype(filename, flags)) {
			free(filename);
			return 1;
		}
				
		free(filename);
	}
		
	return 0;
}
				
static int typefile(const char *filename, int flags)
{
	int retcode = 0;
	list_t *name_comps = NULL;
	
	while (*filename) {
		struct name_component *comp = 
			xmalloc(sizeof(struct name_component));
		const char *ptr = filename;
		
		if (*filename == '%' && filename[1] != '%') {
			switch (*++filename) {
			case 'c':
				comp->type = fname_cpath;
				break;
			case 's':
				comp->type = fname_sec;
				break;
			case 'e':
				comp->type = fname_ext;
				break;
			case 'd':
				comp->type = fname_dpath;
				break;
			case 'o':
				comp->type = fname_opath;
				break;
			case 'n':
				comp->type = fname_cnum;
				break;
			case 'm':
				comp->type = fname_mpath;
				break;
			default:
				goto bailout;
			}
			filename++;
		} else {
			while (*ptr) {
				if (*ptr == '%' && ptr[1] != '%')
					break;
				else
					ptr++;
			}
			comp->type = fname_raw;
			comp->ptr = (char *) xmalloc(ptr - filename + 1);
			comp->ptr[ptr - filename] = 0;
			strncpy(comp->ptr, filename, ptr - filename);
			filename = ptr;
		}
		cons(name_comps, comp);
	}
	
	retcode = find_and_type_file(name_comps, flags);
	
 bailout:
	while (name_comps) {
		struct name_component *comp =
			shift(struct name_component *, name_comps);
		if (comp->type == fname_raw)
			free(comp->ptr);
		free(comp);
	}

	return retcode;
}		

int TypeFile(const char *typethis, int flags)
{	
	char buffer[PATH_MAX + 1];
	const char *sec = "";
	
	if (flags & TYPE_SEC)
		sec = "%s";
	
	if (flags & TYPE_CONF) {
		snprintf(buffer, PATH_MAX + 1, "%%cdisplay/%%d%s%s%%e",
			 typethis, sec);
		if (typefile(buffer, flags))
			return 1;
	}
		
	if (flags & TYPE_MAKE) {
		snprintf(buffer, PATH_MAX + 1, "%%o/display/%%d%s%s%%e",
			 typethis, sec);
		if (typefile(buffer, flags))
			return 1;
	}

	if (!(flags & (TYPE_CONF | TYPE_MAKE)))
		if (typefile(typethis, flags))
			return 1;
	
	if (flags & TYPE_WARN) 
		ddprintf(sd[missingtextstr], typethis);

	return 0;
}

static int dotype_more_prompt(int *sl)
{
	int hot;
	
	if (--*sl)
		return 0;
	
	DDPut(sd[morepromptstr]);
	hot = HotKey(0);
	DDPut("\r                                                         \r");
	if (hot == 'N' || hot == 'n' || hot == 'q' || hot == 'Q')
		return -1;
	if (hot == 'C' || hot == 'c') 
		*sl = -1;
	else 
		*sl = user.user_screenlength;
	
	return 0;
}
	
#define conv_check_pre() if (display && !(display->DISPLAY_ATTRIBUTES & (1L << 3))) doconv = 0;

#define istoken(__x__) ({						\
	int __retcode__;						\
	if (!(__retcode__ = strncmp(ptr, __x__, strlen(__x__))))	\
		ptr += strlen(__x__);					\
	!__retcode__;							\
})

static void dump_buffer(char *s, int *screen_length)
{
	while (*s) {
		char *lf = strchr(s, 0x0a);
		if (!lf) {
			DDPut(s);
			return;
		}
		*lf++ = 0;
		ddprintf("%s\n", s);
		if (dotype_more_prompt(screen_length))
			return;
		s = lf;
	}
}

extern void parse_menu_command(char **);

int formatted_print(char *buffer, int flags)
{
	int olda;
	int nocodes = 0;
	int sl;
	char *ptr, codebuf[512];
		
	if (flags & TYPE_NOCODES)
		nocodes = 1;
	
	if (onlinestat)
		sl = user.user_screenlength;
	else
		sl = -1;
	
		olda = ansi;
	if (flags & TYPE_NOSTRIP) {
		ansi = 1;
	}
	       
	for (ptr = buffer; *ptr; doconv = 1) {
		char *cmdchar = strchr(ptr, '~');
		if (nocodes || !cmdchar) {
			conv_check_pre();
			dump_buffer(ptr, &sl);
			break;
		}
		
		*cmdchar = 0;
		conv_check_pre();
		DDPut(ptr);
		
		if (cmdchar[1] != '#') {
			conv_check_pre();
			ddprintf("~");
			ptr = cmdchar + 1;
			continue;
		}
			
		ptr = cmdchar + 2;
		if (strlen(ptr) < 2)
			break;
		
		if (istoken("PA")) {
			HotKey(0);
		} else if (istoken("RE")) {
			DDPut(sd[pausestr]);
			HotKey(0);
		} else if (istoken("RN")) {
			DDPut(user.user_realname);
		} else if (istoken("HA")) {
			DDPut(user.user_handle);
		} else if (istoken("OR")) {
			DDPut(user.user_organization);
		} else if (istoken("LO")) {
			DDPut(user.user_zipcity);			
		} else if (istoken("PH")) {
			DDPut(user.user_voicephone);
		} else if (istoken("SL")) {
			ddprintf("%d", user.user_screenlength);
		} else if (istoken("PR")) {
			if (protocol)
				DDPut(protocol->PROTOCOL_NAME);
		} else if (istoken("SI")) {
			DDPut(user.user_signature);
		} else if (istoken("CM")) {
			DDPut(user.user_computermodel);
		} else if (istoken("DA")) {
			time_t aika;
			char *aikas;
			
			aika = time(0);
			aikas = ctime(&aika);
			aikas[24] = 0;
			DDPut(aikas);
		} else if (istoken("ID")) {
			ddprintf("%d", user.user_account_id);
		} else if (istoken("DT")) {
			ddprintf("%d", user.user_dailytimelimit);
		} else if (istoken("FC")) {
			ddprintf("%24.24s", ctime(&user.user_firstcall));
		} else if (istoken("LC")) {
			ddprintf("%24.24s", ctime(&user.user_lastcall));
		} else if (istoken("OL")) {
			ddprintf("%d", bpsrate);
		} else if (istoken("SE")) {
			ddprintf("%d", user.user_securitylevel);
		} else if (istoken("UB")) {
			ddprintf("%Lu", user.user_ulbytes);
		} else if (istoken("UF")) {
			ddprintf("%d", user.user_ulfiles);
		} else if (istoken("ML")) {
			if (user.user_flines)
				ddprintf("%d", user.user_flines);
			else
				DDPut("Unlimited");
		} else if (istoken("DB")) {
			ddprintf("%Lu", user.user_dlbytes);
		} else if (istoken("DF")) {
			ddprintf("%d", user.user_dlfiles);
		} else if (istoken("BA")) {
			freebstr(codebuf);
			DDPut(codebuf);
		} else if (istoken("FA")) {
			freefstr(codebuf);
			DDPut(codebuf);
		} else if (istoken("MP")) {
			ddprintf("%d", user.user_pubmessages + user.user_pvtmessages);
		} else if (istoken("TC")) {
			ddprintf("%d", user.user_connections);
		} else if (istoken("PA")) {
			ddprintf("%d", pages);
		} else if (istoken("CN")) {
			DDPut(conference()->conf.CONF_NAME);
		} else if (istoken("CU")) {
			ddprintf("%d", conference()->conf.CONF_NUMBER);
		} else if (istoken("MC")) {			
			char *cm, *sr;
			cm = codebuf;
			sr = ptr;
			while (*sr != '|')
				*cm++ = *sr++;
			*cm = 0;
			ptr = sr + 1;
			docmd(codebuf, 0);
		} else if (istoken("TF")) {
			char *cm, *sr;
			cm = codebuf;
			sr = ptr;
			while (*sr != '|')
				*cm++ = *sr++;
			*cm = 0;
			ptr = sr + 1;
			TypeFile(codebuf, 0);
		} else if (istoken("NM")) {
			sl = -1;
		} else if (istoken("NC")) {
			nocodes = 1;
		} else if (istoken("RA")) {
			char rbuf[1024];
			char randbuf[10];
			char *cm;
			char *sr = ptr;
			int rmax;
			time_t rtime;
			
			cm = codebuf;
			while (*sr != '|')
				*cm++ = *sr++;
			*cm = 0;
			sr++;
			cm = randbuf;
			while (*sr != '|')
				*cm++ = *sr++;
			*cm = 0;
			rmax = atoi(randbuf);
			ptr = sr + 1;
			rtime = time(0);
			srand(rtime);
			snprintf(rbuf, sizeof(rbuf), codebuf, 
				(rand() % rmax) + 1);
			TypeFile(rbuf, TYPE_WARN);
		} else if (istoken("MB")) {
			parse_menu_command(&ptr);
		} else if (istoken("LF")) {
			char *sr = strchr(ptr, 0x0a);
			if (sr)
				ptr = sr + 1;
			else
				ptr = ptr + strlen(ptr);
		}
	}

	ansi = olda;
	return 1;
}
	
/* dotype() return value:
 * 
 *  0 - error
 *  1 - successful
 */
static int dotype(char *filename, int flags)
{
	int fd, retcode;
	char *buffer;
	struct stat st;

	if ((fd = open(filename, O_RDONLY)) == -1)
		return 0;
	fstat(fd, &st);		
		
	buffer = (char *) xmalloc(st.st_size + 1);
	buffer[st.st_size] = 0;
	read(fd, buffer, st.st_size);
	close(fd);

	retcode = formatted_print(buffer, flags);
	free(buffer);
	
	return retcode;
}

int processmsg(struct dd_nodemessage *ddm)
{
	struct olm *myolm;
	char buf[1024];

	switch (ddm->dn_command) {
	case 1:
		myolm = xmalloc(sizeof(struct olm));
		strcpy(myolm->olm_msg, ddm->dn_string);
		myolm->olm_number = 0;
		AddTail(olms, (struct Node *) myolm);
		break;
	case 2:
		myolm = xmalloc(sizeof(struct olm));
		strcpy(myolm->olm_msg, ddm->dn_string);
		myolm->olm_number = ddm->dn_data1;
		AddTail(olms, (struct Node *) myolm);
		break;
	case 3:
		LineChat();
		break;
	case 4:
		dropcarrier();

		snprintf(buf, sizeof(buf), 
			"User kicked out at %s\n", currt());
		writelog(buf);
		break;
	case 5:
		usered();
		break;
	case 10:
		user.user_ulfiles += ddm->dn_data1;
		break;
	case 11:
		user.user_dlfiles += ddm->dn_data1;
		break;

	case 12:
		user.user_ulbytes += ddm->dn_data1;
		break;
	case 13:
		user.user_dlbytes += ddm->dn_data1;
		break;
	}
	return 1;
}
