#include <errno.h>
#include <stdarg.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <syslog.h>

#include <daydream.h>
#include <ddcommon.h>
#include <symtab.h>

#ifndef UTMP_FILE
#define UTMP_FILE _PATH_UTMP
#endif

int node; /* FIXME! are these really to be declared here? */
int bpsrate;

static int isonck(int, int);

int runlogoffbatch(void)
{
	char buf[512];
	snprintf(buf, sizeof(buf), "batch/batch%d.logoff %d", node, node);
	runstdio(buf, 0, 3);
	return 1;
}

void removespaces(char *strh)
{
	char *s;
	s = strh;
	if (!*s)
		return;
	while (*s)
		s++;
	s--;
	while (*s == ' ')
		s--;
	*(s + 1) = 0;
}

void changenodestatus(const char *newstatus)
{
	struct DayDream_NodeInfo ddn;
	char infoname[80];
	int myfd;

	if (bgmode)
		return;

	ddn.ddn_pid = getpid();
	ddn.ddn_flags = 0;
	if (onlinestat) {
		ddn.ddn_userslot = user.user_account_id;
		if ((user.user_toggles & (1L << 9)) == 0) {
			ddn.ddn_flags |= (1L << 0);
		}
	} else
		ddn.ddn_userslot = -1;
	strcpy(ddn.ddn_activity, newstatus);
	ddn.ddn_bpsrate = bpsrate;
	strncpy(ddn.ddn_pagereason, reason, 79);
	strncpy(ddn.ddn_path, origdir, 79);
	ddn.ddn_timeleft = timeleft;

	snprintf(infoname, sizeof(infoname), "%snodeinfo%d.data",
		DDTMP, node);
	myfd = open(infoname, O_WRONLY | O_CREAT, 0644);
	if (myfd != -1) {
		write(myfd, &ddn, sizeof(struct DayDream_NodeInfo));
		close(myfd);
	}
}

char *currt(void)
{
	time_t tt;

	tt = time(0);
	return ctime(&tt);
}

void writelog(const char *strh)
{
	char buffer[80];
	int logfd;


	snprintf(buffer, sizeof(buffer), "%s/logfiles/daydream%d.log", 
		origdir, node);
	logfd = open(buffer, O_WRONLY | O_CREAT, 0660);
	if (logfd < 0)
		return;

	lseek(logfd, 0, SEEK_END);
	write(logfd, strh, strlen(strh));
	close(logfd);
}

int wildcmp(const char *nam, const char *pat)
{
	const char *p;

	for (;;) {
		if (tolower(*nam) == tolower(*pat)) {
			if (*nam++ == '\0')
				return (1);
			pat++;
		} else if (*pat == '?' && *nam != 0) {
			nam++;
			pat++;
		} else
			break;
	}

	if (*pat != '*')
		return (0);

	while (*pat == '*') {
		if (*++pat == '\0')
			return (1);
	}

	for (p = nam + strlen(nam) - 1; p >= nam; p--) {
		if (tolower(*p) == tolower(*pat))
			if (wildcmp(p, pat) == 1)
				return (1);
	}
	return (0);
}

int iswilds(const char *strh)
{
	return strchr(strh, '*') || strchr(strh, '?');
}

int findusername(const char *name)
{
	int id;
	struct userbase *ub;
	if (!strcasecmp(name, "sysop"))
		return 0;
	ub = getubentbyname(name);
	if (!ub)
		return -1;
	id = ub->user_account_id;
	g_free(ub);
	return id;
}

static int findusername_wildcard(const char *name)
{
	struct userbase *ub = NULL;
	int account_id = 0, key;

	if (!strcasecmp(name, "sysop"))
		return 0;
	
	if (!iswilds(name))
		return findusername(name);

	for (;; account_id++) {
		g_free(ub);
		ub = NULL;
		
		ub = getubentbyid(account_id);
		if (ub == NULL)
			return -1;
		if ((ub->user_toggles & UBENT_STAT_MASK) == UBENT_STAT_DELETED)
			continue;
		
		ddprintf(sd[wildverstr], ub->user_realname, 
			 ub->user_handle);
		
		key = HotKey(HOT_YESNO);
		if (key == 1) {
			account_id = ub->user_account_id;
			break;
		} else {
			account_id = -2;
			break;
		}
	}

	g_free(ub);
	return account_id;
}

int checklogon(const char *name)
{
	struct userbase *ub;
	int userpos;

	userpos = findusername_wildcard(name);
	if (userpos == -1)
		return (0);
	if (userpos == -2)
		return -1;
	if ((maincfg.CFG_FLAGS & (1L << 8)) == 0 && isonline(userpos))
		return 2;
	
	ub = getubentbyid(userpos);

	if (!ub) {
		DDPut(sd[ubrerrstr]);
		return 0;
	}

	memcpy(&user, ub, sizeof(struct userbase));
	g_free(ub);

	clog.cl_userid = user.user_account_id;
	clog.cl_firstcall = user.user_firstcall;
	clog.cl_logon = time(0);
	if (user.user_connections == 0)
		clog.cl_flags |= CL_NEWUSER;
	clog.cl_bpsrate = bpsrate;


	return 1;
}

int cmppasswds(char *passwd, unsigned char *thepw)
{
	MD_CTX context;
	unsigned char digest[16];
	char newpw[30];
	int i;

	for (i = 0; i < 16; i++) {
		if (thepw[i]) {
			i = 100;
			break;
		}
	}
	if (i != 100)
		return 1;

	strcpy(newpw, passwd);
	strupr(newpw);

	MDInit(&context);
	MDUpdate(&context, newpw, strlen(newpw));
	MDFinal(digest, &context);

	for (i = 0; i < 16; i++) {
		if (thepw[i] != digest[i])
			return (0);
	}
	return (1);
}


int isonline(int id)
{
	struct DayDream_Multinode *cn;

	cn = nodes;

	while (cn->MULTI_NODE) {
		if (cn->MULTI_NODE == 253) {
			int j;
			int i = maincfg.CFG_TELNET1ST;
			j = maincfg.CFG_TELNETMAX;

			while (j) {
				j--;
				if (isonck(i, id))
					return i + 1;
				i++;
			}
		} else if (cn->MULTI_NODE == 254) {
			int j;
			int i = maincfg.CFG_LOCAL1ST;
			j = maincfg.CFG_LOCALMAX;

			while (j) {
				j--;
				if (isonck(i, id))
					return i + 1;
				i++;
			}
		} else if (cn->MULTI_NODE != 252) {
			if (isonck(cn->MULTI_NODE, id))
				return cn->MULTI_NODE + 1;
		}
		cn++;
	}
	return 0;
}

static int isonck(int num, int id)
{
	struct DayDream_NodeInfo myn;

	if (isnode(num, &myn)) {
		if (myn.ddn_userslot == id)
			return 1;
	}
	return 0;
}

void get_user_name(const struct userbase *ub, char *name)
{
	if (ub) {
		if (maincfg.CFG_FLAGS & (1L << 1))
			strncpy(name, ub->user_handle, 26);
		else
			strncpy(name, ub->user_realname, 26);
	} else
		strcpy(name, "deleted user");
}

void get_user_location(const struct userbase *ub, char *location)
{
	if (ub) {
		if (maincfg.CFG_FLAGS & (1L << 2))
			strncpy(location, ub->user_organization, 26);
		else
			strncpy(location, ub->user_zipcity, 21);
	} else
		strcpy(location, "N/A");
}
		
static const char *panic_footer =
	"\n\nPlease write a bug report as described in \"docs/README.panic\"\n"
	"and send it to daydream@daydream.iwn.fi.\n";
	
void panic(const char *fmt, ...)
{
	va_list args;
	va_start(args, fmt);

	fprintf(stderr, "PANIC: ");
	vfprintf(stderr, fmt, args);
	fprintf(stderr, "%s", panic_footer);
	
	va_end(args);
	abort();
}

void *xmalloc(size_t size)
{
	void *ptr = malloc(size);
	if (!ptr)
		panic("xmalloc(): %s", strerror(ENOMEM));
	return ptr;
}

void *xrealloc(void *ptr, size_t size)
{
	ptr = realloc(ptr, size);
	if (!ptr)
		panic("xrealloc(): %s", strerror(ENOMEM));
	return ptr;
}

#ifndef HAVE_STRNDUP
char *strndup(const char *str, size_t size)
{
	char *n;
	int len = strlen(str);
	if (len > size)
		len = size;
	n = (char *) xmalloc(len + 1);
	memcpy(n, str, len);
	n[len] = 0;
	return n;
}
#endif /* HAVE_STRNDUP */
	
size_t strspace(char *dest, const char *src, size_t n)
{
	const char *end;
	int length;
	if (src == NULL) {
		*dest = 0;
		return 1;
	}
	while (*src && isspace(*src))
		src++;
	for (end = src; *end && !isspace(*end); end++);
	length = end - src;
	if (length >= n) {
		*dest = 0;
		return length;
	}
	strncpy(dest, src, length);
	dest[length] = 0;
	return length + 1;
}
	
size_t strtoken(char *dest, const char **srcptr, size_t n)
{
	int length;
	const char *end;
	const char *src;
	if (srcptr == NULL) {
		*dest = 0;
		return 1;
	}
	src = *srcptr;
	if (src == NULL) {
		*dest = 0;
		return 1;
	}
	while (*src && isspace(*src))
		src++;
	for (end = src; *end && !isspace(*end); end++);
	length = end - src;
	if (length >= n) {
		*dest = 0;
		*srcptr = end;
		return length;
	}
	strncpy(dest, src, length);
	dest[length] = 0;
	*srcptr = end;
	return length + 1;
}	

const char *strspa(const char *src, char *dest, size_t n)
{
	if (strtoken(dest, &src, n) > n)
		return NULL;
	if (!*dest)
		return NULL;
	return src;
}

char *myprintf(const char *fmt, ...)
{
	char *ptr;
	va_list args;
	va_start(args, fmt);
	vasprintf(&ptr, fmt, args);
	va_end(args);
	return ptr;
}

int select_with_errchk(int n, fd_set *readfds, fd_set *writefds,
		fd_set *exceptfds, struct timeval *timeout)
{
	int retcode;
	retcode = select(n, readfds, writefds, exceptfds, timeout);
	if (retcode >= 0)
		return retcode;
	if (errno != EINTR) {
		syslog(LOG_EMERG, "unknown error in select_with_errchk()");
		ddprintf("unknown error in select_with_errchk()\n");
		exit(1);
	}
	return -1;
}
