#include "daydream.h"
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "symtab.h"

char *ul_file;
int ul_user;
int ul_conf;

int handleupload(char *);

int getftpnode(void)
{
	struct DayDream_Multinode *danode;

	danode = nodes;

	while (danode->MULTI_NODE) {
		if (danode->MULTI_NODE == 252) {
			node = (ul_user + 1) * 10000;
			currnode = xmalloc(sizeof(struct DayDream_Multinode));
			memcpy(currnode, danode, sizeof(struct DayDream_Multinode));
			snprintf(currnode->MULTI_TEMPORARY, 
				sizeof(currnode->MULTI_TEMPORARY),
				danode->MULTI_TEMPORARY, ul_user);
			currnode->MULTI_NODE = node;
			bpsrate = danode->MULTI_TTYSPEED;
			return 1;
		}
		danode++;
	}
	return 0;
}

int cmdlineupload(void)
{
	struct userbase *ub;
	char buf[1024];
	carrier = 0;
	bgmode = 1;

	chdir(getenv("DAYDREAM"));
	setuid(maincfg.CFG_BBSUID);
	seteuid(maincfg.CFG_BBSUID);
	setgid(maincfg.CFG_BBSGID);
	setegid(maincfg.CFG_BBSGID);

	ub = getubentbyid(ul_user);
	if (!ub) 
		return 0;

	memcpy(&user, ub, sizeof(struct userbase));
	g_free(ub);

	if (!getftpnode())
		return 0;

	if (!getsec())
		return 0;

	getdisplaymode("1", 1);

	if (!joinconf(ul_conf, JC_SHUTUP | JC_QUICK | JC_NOUPDATE))
		return 0;

	mkdir(currnode->MULTI_TEMPORARY, 0755);
	snprintf(buf, sizeof(buf), "%s%s", currnode->MULTI_TEMPORARY, 
		filepart(ul_file));
	newrename(ul_file, buf);
	chdir(currnode->MULTI_TEMPORARY);
	handleupload(filepart(ul_file));
	chdir(getenv("DAYDREAM"));
	deldir(currnode->MULTI_TEMPORARY);
	rmdir(currnode->MULTI_TEMPORARY);
	saveuserbase();
	return 1;
}
