#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <sys/stat.h>

#include <daydream.h>
#include <ddcommon.h>
#include <symtab.h>

static int getfidounique(void);
static int str2addr(char *, unsigned short *, unsigned short *, 
		    unsigned short *, unsigned short *);

int entermsg(struct DayDream_Message *msg, int reply, char *params)
{
	char ebuf[1024];
	int hola;
	int msgfd;
	char *s;
	struct DayDream_Message header;
	char *lineedmem;

	int recoff;

	if (toupper(current_msgbase->MSGBASE_FN_FLAGS) == 'E' && ((access1 & (1L << SECB_FIDOMESSAGE)) == 0)) {
		DDPut(sd[emnofidomsgstr]);
		return 0;
	}
	if (toupper(current_msgbase->MSGBASE_FN_FLAGS) == 'N' && ((access2 & (1L << SECB_SENDNETMAIL)) == 0)) {
		DDPut(sd[emnonetmsgstr]);
		return 0;
	}
	changenodestatus("Entering a message");
	if (msg) {
		memcpy(&header, msg, sizeof(struct DayDream_Message));
	} else {
		s = (char *) &header;
		memset(&header, 0, sizeof(struct DayDream_Message));
		if (params)
			strncpy(header.MSG_RECEIVER, params, 25);
	}

	if (current_msgbase->MSGBASE_FLAGS & (1L << 0) && current_msgbase->MSGBASE_FLAGS & (1L << 1)) {
		DDPut(sd[emnomsgsstr]);
		return 0;
	}
	DDPut(sd[emhead1str]);
	DDPut(current_msgbase->MSGBASE_NAME);
	ebuf[0] = 0;
	strcat(ebuf, sd[emhead2str]);
	hola = 61 - strlen(current_msgbase->MSGBASE_NAME);
	while (hola) {
		strcat(ebuf, "-");
		hola--;
	}
	DDPut(ebuf);
	ddprintf(sd[emhead3str], highest);
	DDPut(sd[emhead4str]);

	if ((current_msgbase->MSGBASE_FLAGS & (1L << 0)) || (header.MSG_FLAGS & (1L << 0))) {
		DDPut(sd[emprvstr]);
		header.MSG_FLAGS |= (1L << 0);
	} else {
		DDPut(sd[empubstr]);
	}
	header.MSG_CREATION = time(0);
	DDPut(sd[emhead5str]);
	DDPut(ctime(&header.MSG_CREATION));

	DDPut(sd[emhead6str]);
	if (current_msgbase->MSGBASE_FLAGS & (1L << 2)) {
		strcpy(header.MSG_AUTHOR, user.user_handle);
	} else {
		strcpy(header.MSG_AUTHOR, user.user_realname);
	}
	DDPut(header.MSG_AUTHOR);
	while (1) {
	      askrec:
		DDPut(sd[emhead7str]);
		if (!(Prompt(header.MSG_RECEIVER, 25, 0)))
			return 0;
		if (header.MSG_RECEIVER[0] == 0 || (!strcasecmp(header.MSG_RECEIVER, "all")) || (!strcasecmp(header.MSG_RECEIVER, "all users"))) {
			if (current_msgbase->MSGBASE_FLAGS & (1L << 0)) {
				DDPut(sd[emhead8str]);
				HotKey(0);
				header.MSG_RECEIVER[0] = 0;
			} else {
				DDPut(sd[emhead9str]);
				header.MSG_RECEIVER[0] = 0;
				break;
			}
		} else if (!strcasecmp(header.MSG_RECEIVER, "eall")) {
			if (current_msgbase->MSGBASE_FLAGS & (1L << 0)) {
				DDPut(sd[emhead8str]);
				HotKey(0);
				header.MSG_RECEIVER[0] = 0;
			} else if (access1 & (1L << SECB_EALLMESSAGE)) {
				header.MSG_RECEIVER[0] = -1;
				DDPut(sd[emhead10str]);
				break;
			} else {
				DDPut(sd[emnopoststr]);
				HotKey(0);
				header.MSG_RECEIVER[0] = 0;
			}
		} else {
			if (toupper(current_msgbase->MSGBASE_FN_FLAGS) == 'L') {
				struct userbase *ub;
				
				if (!strcasecmp(header.MSG_RECEIVER, "sysop")) {
					recoff = 0;
				} else {
					recoff = findusername(header.MSG_RECEIVER);
				}
				if (recoff == -1) {
					DDPut(sd[emnouserstr]);
					HotKey(0);
					goto askrec;
				}
				
				ub = getubentbyid(recoff);
				if (!ub)
					panic("can't read user %d", recoff);

				if (!checkconfaccess(conference()->conf.CONF_NUMBER, ub)) {
					DDPut(sd[emnoaccessstr]);
					HotKey(0);
				}
				DDPut("[5;12H                     [5;12H");
				if (current_msgbase->MSGBASE_FLAGS & (1L << 2)) {
					strcpy(header.MSG_RECEIVER, ub->user_handle);
				} else {
					strcpy(header.MSG_RECEIVER, ub->user_realname);
				}
				DDPut(header.MSG_RECEIVER);
				g_free(ub);
				
				break;
			} else
				break;
		}
	}
	DDPut(sd[emsubjectstr]);
	if (!(Prompt(header.MSG_SUBJECT, 67, 0)))
		return 0;
	if (header.MSG_SUBJECT[0] == 0) {
		DDPut(sd[emabortedstr]);
		return 0;
	}
	DDPut("[11;1H                                                                       [11;1H");
	if (header.MSG_RECEIVER[0] == 0 || header.MSG_RECEIVER[0] == -1 || header.MSG_FLAGS & (1L << 0) || current_msgbase->MSGBASE_FLAGS & (1L << 1)) {

	} else {
		DDPut(sd[emisprivatestr]);
		hola = HotKey(HOT_NOYES);
		if (hola == 0)
			return 0;
		if (hola == 1)
			header.MSG_FLAGS |= (1L << 0);
	}

	if ((header.MSG_FLAGS & (1L << 0)) == 0 && (access1 & (1L << SECB_PUBLICMESSAGE)) == 0) {
		DDPut(sd[emnopubstr]);
		return 0;
	}
	if (toupper(current_msgbase->MSGBASE_FN_FLAGS) == 'N') {
		if (header.MSG_FN_DEST_NET) {
			snprintf(ebuf, sizeof(ebuf), "%d:%d/%d.%d", 
				header.MSG_FN_DEST_ZONE,
				header.MSG_FN_DEST_NET, 
				header.MSG_FN_DEST_NODE,
				header.MSG_FN_DEST_POINT);
		} else {
			*ebuf = 0;
		}
		DDPut(sd[emnetaddstr]);
		if (!(Prompt(ebuf, 30, 0)))
			return 0;
		if (!str2addr(ebuf, &header.MSG_FN_DEST_ZONE, &header.MSG_FN_DEST_NET,
		    &header.MSG_FN_DEST_NODE, &header.MSG_FN_DEST_POINT))
			return 0;
	}
	*header.MSG_ATTACH = 0;

	if (current_msgbase->MSGBASE_FLAGS & (1L << 5)) {
		if ((header.MSG_FLAGS & (1L << 0)) && (access2 & (1L << SECB_PVTATTACH))) {
			*header.MSG_ATTACH = 1;
		} else if (((header.MSG_FLAGS & (1L << 0)) == 0) && (access2 & (1L << SECB_PUBATTACH))) {
			*header.MSG_ATTACH = 1;
		}
	}
	if (reply) {
		if (!askqlines()) {
			snprintf(ebuf, sizeof(ebuf), "%sdaydream%d.msg", 
				DDTMP, node);
			unlink(ebuf);
		}
		DDPut("\n\n");
	}
	lineedmem = (char *) xmalloc(80 * 500);
	hola = edfile(lineedmem, reply, &header);
	if (hola == 0) {
		char fabuf[1024];

		DDPut(sd[emaborted2str]);
		free(lineedmem);
		cleantemp();
		snprintf(fabuf, sizeof(fabuf), "%sattachs.%d", DDTMP, node);
		unlink(fabuf);

		return 0;
	}
	DDPut(sd[emsavingstr]);

	getmsgptrs();
	highest++;
	header.MSG_NUMBER = highest;
	if (setmsgptrs() == 0) {
		free(lineedmem);
		return 0;
	}
	if (*header.MSG_ATTACH) {
		char fabuf[1024];
		FILE *fd;

		snprintf(fabuf, sizeof(fabuf), "%sattachs.%d", DDTMP, node);
		if ((fd = fopen(fabuf, "r"))) {
			char hoobab[1024];

			snprintf(hoobab, sizeof(hoobab), "%smessages/base%3.3d/fa%5.5d", conference()->conf.CONF_PATH, current_msgbase->MSGBASE_NUMBER, header.MSG_NUMBER);
			mkdir(hoobab, 0755);

			while (fgetsnolf(hoobab, 1024, fd)) {
				char sr[1024];
				char de[1024];
				snprintf(sr, sizeof(sr), "%s%s", currnode->MULTI_TEMPORARY, hoobab);
				snprintf(de, sizeof(de), "%smessages/base%3.3d/fa%5.5d/%s", conference()->conf.CONF_PATH, current_msgbase->MSGBASE_NUMBER, header.MSG_NUMBER, hoobab);
				newrename(sr, de);
			}
			fclose(fd);
			snprintf(hoobab, sizeof(hoobab), "%smessages/base%3.3d/msf%5.5d", conference()->conf.CONF_PATH, current_msgbase->MSGBASE_NUMBER, header.MSG_NUMBER);
			newrename(fabuf, hoobab);
		} else {
			*header.MSG_ATTACH = 0;
		}
	}
	snprintf(ebuf, sizeof(ebuf), "%smessages/base%3.3d/msgbase.dat", conference()->conf.CONF_PATH, current_msgbase->MSGBASE_NUMBER);

	if (toupper(current_msgbase->MSGBASE_FN_FLAGS) != 'L') {
		header.MSG_FN_ORIG_ZONE = current_msgbase->MSGBASE_FN_ZONE;
		header.MSG_FN_ORIG_NET = current_msgbase->MSGBASE_FN_NET;
		header.MSG_FN_ORIG_NODE = current_msgbase->MSGBASE_FN_NODE;
		header.MSG_FN_ORIG_POINT = current_msgbase->MSGBASE_FN_POINT;
		header.MSG_FLAGS |= (1L << 2);
	}
	if ((msgfd = open(ebuf, O_RDWR | O_CREAT, 0664)) < 0) {
		DDPut(sd[emwriteerrstr]);
		free(lineedmem);
		return 0;
	}
	lseek(msgfd, 0, SEEK_END);
	write(msgfd, &header, sizeof(struct DayDream_Message));
	close(msgfd);

	snprintf(ebuf, sizeof(ebuf), "%smessages/base%3.3d/msg%5.5d", conference()->conf.CONF_PATH, current_msgbase->MSGBASE_NUMBER, header.MSG_NUMBER);

	if ((msgfd = open(ebuf, O_RDWR | O_CREAT | O_TRUNC, 0664)) < 0) {
		DDPut(sd[emwriteerrstr]);
		free(lineedmem);
		return 0;
	}
	if (toupper(current_msgbase->MSGBASE_FN_FLAGS) == 'E') {
		char ub[128];
		int uq;

		strcpy(ub, current_msgbase->MSGBASE_FN_TAG);
		strupr(ub);
		snprintf(ebuf, sizeof(ebuf), "AREA:%s\n", ub);
		write(msgfd, ebuf, strlen(ebuf));
		if ((uq = getfidounique())) {
			snprintf(ebuf, sizeof(ebuf), "\001MSGID: %d:%d/%d.%d %8.8x\n", current_msgbase->MSGBASE_FN_ZONE, current_msgbase->MSGBASE_FN_NET, current_msgbase->MSGBASE_FN_NODE, current_msgbase->MSGBASE_FN_POINT, uq);
			write(msgfd, ebuf, strlen(ebuf));
			if (header.MSG_ORIGINAL) {
				if (getreplyid(header.MSG_ORIGINAL, ebuf))
					write(msgfd, ebuf, strlen(ebuf));
			}
		}
	} else if (toupper(current_msgbase->MSGBASE_FN_FLAGS) == 'N') {
		if (header.MSG_FN_DEST_POINT) {
			snprintf(ebuf, sizeof(ebuf), "\001TOPT: %d\n", header.MSG_FN_DEST_POINT);
			write(msgfd, ebuf, strlen(ebuf));
		}
		if (header.MSG_FN_ORIG_POINT) {
			snprintf(ebuf, sizeof(ebuf), "\001FMPT: %d\n", header.MSG_FN_ORIG_POINT);
			write(msgfd, ebuf, strlen(ebuf));
		}
		if (header.MSG_FN_DEST_ZONE != current_msgbase->MSGBASE_FN_ZONE) {
			snprintf(ebuf, sizeof(ebuf), "\001INTL: %d:%d/%d %d:%d/%d\n",
			 header.MSG_FN_DEST_ZONE, header.MSG_FN_DEST_NET,
			header.MSG_FN_DEST_NODE, header.MSG_FN_ORIG_ZONE,
			header.MSG_FN_ORIG_NET, header.MSG_FN_ORIG_NODE);
			write(msgfd, ebuf, strlen(ebuf));
		}
	}
	s = lineedmem;
	while (hola) {
		snprintf(ebuf, sizeof(ebuf), "%s\n", s);
		write(msgfd, ebuf, strlen(ebuf));
		hola--;
		s = &s[80];
	}

	if (toupper(current_msgbase->MSGBASE_FN_FLAGS) == 'E') {
		snprintf(ebuf, sizeof(ebuf), "\n--- DayDream/Linux %s\n * Origin: %s (%d:%d/%d)\nSEEN-BY: %d/%d\n", versionstring, current_msgbase->MSGBASE_FN_ORIGIN, current_msgbase->MSGBASE_FN_ZONE, current_msgbase->MSGBASE_FN_NET, current_msgbase->MSGBASE_FN_NODE, current_msgbase->MSGBASE_FN_NET, current_msgbase->MSGBASE_FN_NODE);
		write(msgfd, ebuf, strlen(ebuf));
	} else if (toupper(current_msgbase->MSGBASE_FN_FLAGS) != 'L') {
		snprintf(ebuf, sizeof(ebuf), "\n--- DayDream/Linux %s\n", versionstring);
		write(msgfd, ebuf, strlen(ebuf));
	}
	close(msgfd);

	DDPut(sd[emdonestr]);
	free(lineedmem);

	if (header.MSG_FLAGS & (1L << 0)) {
		user.user_pvtmessages++;
		clog.cl_pvtmessages++;
	} else {
		user.user_pubmessages++;
		clog.cl_pubmessages++;
	}
	return 1;
}

int fsed(char *buffer, int mode, struct DayDream_Message *header)
{
	char buf[200];
	FILE *myf;
	int rc = 0;
	char goo[1024];
	int head;

	if (!mode) {
		snprintf(buf, sizeof(buf), "%sdaydream%d.msg", DDTMP, node);
		unlink(buf);
	}
	if (header) {
		snprintf(goo, sizeof(buf), "%smsgheader.%d", DDTMP, node);
		head = open(goo, O_WRONLY | O_TRUNC | O_CREAT, 0644);
		if (head > -1) {
			write(head, header, sizeof(struct DayDream_Message));
			close(head);
		}
	}
	rundoor(maincfg.CFG_FSEDCOMMAND, 0);
	snprintf(buf, sizeof(buf), "%sfsed%d.txt", DDTMP, node);

	if ((myf = fopen(buf, "r"))) {
		while (fgetsnolf(buf, 79, myf)) {
			strcpy(&buffer[rc * 80], buf);
			rc++;
		}
		fclose(myf);
		snprintf(buf, sizeof(buf), "%sfsed%d.txt", DDTMP, node);
		unlink(buf);
		return rc;
	}
	return 0;
}

int comment(void)
{
	int oldb;

	if (!conference()->conf.CONF_COMMENTAREA)
		return 0;

	oldb = current_msgbase->MSGBASE_NUMBER;

	if (changemsgbase(conference()->conf.CONF_COMMENTAREA, MC_QUICK | MC_NOSTAT)) {
		entermsg(0, 0, maincfg.CFG_SYSOPNAME);
		changemsgbase(oldb, MC_QUICK | MC_NOSTAT);
		return 1;
	}
	return 0;
}


void getmsgptrs(void)
{
	int msgfd;
	struct DayDream_MsgPointers ptrs;

	char gmpbuf[1024];
	snprintf(gmpbuf, sizeof(gmpbuf), "%smessages/base%3.3d/msgbase.ptr", conference()->conf.CONF_PATH, current_msgbase->MSGBASE_NUMBER);

	if ((msgfd = open(gmpbuf, O_RDONLY)) < 0) {
		highest = 0;
		lowest = 0;
		return;
	}
	read(msgfd, &ptrs, sizeof(struct DayDream_MsgPointers));
	close(msgfd);
	highest = ptrs.msp_high;
	lowest = ptrs.msp_low;
}

int setmsgptrs(void)
{
	int msgfd;
	struct DayDream_MsgPointers ptrs;

	char gmpbuf[1024];
	snprintf(gmpbuf, sizeof(gmpbuf), "%smessages/base%3.3d/msgbase.ptr", conference()->conf.CONF_PATH, current_msgbase->MSGBASE_NUMBER);

	if ((msgfd = open(gmpbuf, O_RDWR | O_CREAT, 0664)) < 0) {
		DDPut(sd[setptrserrstr]);
		return 0;
	}
	ptrs.msp_high = highest;
	ptrs.msp_low = lowest;
	write(msgfd, &ptrs, sizeof(struct DayDream_MsgPointers));
	close(msgfd);
	return 1;
}


int edfile(char *lineedmem, int reply, struct DayDream_Message *header)
{
	int edtype = 0;
	int hola;

	edtype = 0;
	if (user.user_toggles & (1L << 11)) {
		DDPut(sd[emfsedstr]);
		hola = HotKey(HOT_YESNO);
		if (hola == 0)
			return 0;
		if (hola == 1)
			edtype = 1;
	} else if (user.user_toggles & (1L << 0)) {
		edtype = 1;
	}
	memset(lineedmem, 0, 40000);

	if (edtype) {
		return fsed(lineedmem, reply, header);
	} else {
		return lineed(lineedmem, reply, header);
	}
}

static int getfidounique(void)
{
	int fn;
	char buf[1024];
	int i = 0;

	snprintf(buf, sizeof(buf), "%s/data/fidocnt.dat", origdir);
	fn = open(buf, O_CREAT | O_RDWR, 0644);
	if (fn < 0)
		return 0;
	read(fn, &i, sizeof(int));
	i++;
	lseek(fn, 0, SEEK_SET);
	write(fn, &i, sizeof(int));
	close(fn);
	return i;
}

static int str2addr(char *s, unsigned short *zone, unsigned short *net, 
		    unsigned short *node, unsigned short *point)
{
	char cb[1024];
	char *t;
	*zone = *net = *node = *point = 0;

	if (*s == '-' || *s == 10 || *s == 13 || *s < '0' || *s > '9') {
		return 0;
	}
	t = cb;
	while (*s != ':' && *s)
		*t++ = *s++;
	*t = 0;
	*zone = atoi(cb);
	if (!*s)
		return 0;
	else
		s++;

	t = cb;
	while (*s != '/' && *s)
		*t++ = *s++;
	*t = 0;
	*net = atoi(cb);
	if (!*s)
		return 0;
	else
		s++;

	t = cb;
	while (*s != '.' && *s && *s != 13 && *s != 10)
		*t++ = *s++;
	*t = 0;
	*node = atoi(cb);
	if (!*s || *s == 13 || *s == 10)
		return 1;
	else
		s++;

	t = cb;
	while (*s && *s != 10 && *s != 13)
		*t++ = *s++;
	*t = 0;
	*point = atoi(cb);
	return 1;

}
