#include <stdlib.h>
#include <string.h>

#include <daydream.h>

static const char *default_command_bindings =
"~#MBpush_menu(\"commands\", \"Main menu\")|~#LF
~#MBbind_cmd(\"<\"); subst(\"internal\", \"%'prev_conf %S\")|~#LF
~#MBbind_cmd(\"<<\"); subst(\"internal\", \"%'prev_base %S\")|~#LF
~#MBbind_cmd(\">\"); subst(\"internal\", \"%'next_conf %S\")|~#LF
~#MBbind_cmd(\">>\"); subst(\"internal\", \"%'next_base %S\")|~#LF
~#MBbind_cmd(\"?\"); subst(\"internal\", \"%'help %S\")|~#LF
~#MBbind_cmd(\"a\"); subst(\"internal\", \"%'change_info %S\")|~#LF
~#MBbind_cmd(\"b\"); subst(\"internal\", \"%'bulletins %S\")|~#LF
~#MBbind_cmd(\"c\"); subst(\"internal\", \"%'comment %S\")|~#LF
~#MBbind_cmd(\"copy\"); subst(\"internal\", \"%'copy %S\")|~#LF
~#MBbind_cmd(\"d\"); subst(\"internal\", \"%'download %S\")|~#LF
~#MBbind_cmd(\"e\"); subst(\"internal\", \"%'enter_msg %S\")|~#LF
~#MBbind_cmd(\"f\"); subst(\"internal\", \"%'file_scan %S\")|~#LF
~#MBbind_cmd(\"g\"); subst(\"internal\", \"%'logoff %S\")|~#LF
~#MBbind_cmd(\"gr\"); subst(\"internal\", \"%'global_read %S\")|~#LF
~#MBbind_cmd(\"j\"); subst(\"internal\", \"%'join_conf %S\")|~#LF
~#MBbind_cmd(\"l\"); subst(\"internal\", \"%'time %S\")|~#LF
~#MBbind_cmd(\"link\"); subst(\"internal\", \"%'link %S\")|~#LF
~#MBbind_cmd(\"lu\"); subst(\"internal\", \"%'local_upload %S\")|~#LF
~#MBbind_cmd(\"m\"); subst(\"internal\", \"%'change_msgbase %S\")|~#LF
~#MBbind_cmd(\"mode\"); subst(\"internal\", \"%'mode %S\")|~#LF
~#MBbind_cmd(\"move\"); subst(\"internal\", \"%'move %S\")|~#LF
~#MBbind_cmd(\"ms\"); subst(\"internal\", \"%'scan_mail %S\")|~#LF
~#MBbind_cmd(\"n\"); subst(\"internal\", \"%'new_files %S\")|~#LF
~#MBbind_cmd(\"ns\"); subst(\"internal\", \"%'global_fscan %S\")|~#LF
~#MBbind_cmd(\"o\"); subst(\"internal\", \"%'page %S\")|~#LF
~#MBbind_cmd(\"olm\"); subst(\"internal\", \"%'olm %S\")|~#LF
~#MBbind_cmd(\"r\"); subst(\"internal\", \"%'read_msgs %S\")|~#LF
~#MBbind_cmd(\"rz\"); subst(\"internal\", \"%'upload_rz %S\")|~#LF
~#MBbind_cmd(\"s\"); subst(\"internal\", \"%'stats %S\")|~#LF
~#MBbind_cmd(\"sd\"); subst(\"internal\", \"%'sysop_download %S\")|~#LF
~#MBbind_cmd(\"sf\"); subst(\"internal\", \"%'tag_confs %S\")|~#LF
~#MBbind_cmd(\"sm\"); subst(\"internal\", \"%'tag_msgbases %S\")|~#LF
~#MBbind_cmd(\"t\"); subst(\"internal\", \"%'tag_editor %S\")|~#LF
~#MBbind_cmd(\"ts\"); subst(\"internal\", \"%'text_search %S\")|~#LF
~#MBbind_cmd(\"u\"); subst(\"internal\", \"%'upload %S\")|~#LF
~#MBbind_cmd(\"usered\"); subst(\"internal\", \"%'usered %S\")|~#LF
~#MBbind_cmd(\"userlist\"); subst(\"internal\", \"%'userlist %S\")|~#LF
~#MBbind_cmd(\"v\"); subst(\"internal\", \"%'view_file %S\")|~#LF
~#MBbind_cmd(\"ver\"); subst(\"internal\", \"%'ver %S\")|~#LF
~#MBbind_cmd(\"who\"); subst(\"internal\", \"%'who %S\")|~#LF
~#MBbind_cmd(\"x\"); subst(\"internal\", \"%'expert_mode %S\")|~#LF
~#MBbind_cmd(\"z\"); subst(\"internal\", \"%'zippy_search %S\")|~#LF
~#MBbind_cmd(\"$\"); subst(\"test_door\", \"%s %S\")|~#LF
~#MBbind_cmd; return(2)|~#LF
~#MBbind_cmd(\"cls\"); print(\"\e[2J\e[H\")|~#LF";

extern int formatted_print(char *buffer, int flags);

int load_default_commands(void)
{
	struct DD_ExternalCommand *ext;
	char *tmp;
	
	/* formatted_print modifies the input string temporarily; until
	 * this gets fixed, a temporary duplicate of a string stored in
	 * read-only section should be used.
	 */
	tmp = strdup(default_command_bindings);
	
	if (!formatted_print(tmp, 0)) {
		free(tmp);
		return -1;
	}
	
	free(tmp);
	
	for (ext = exts; ext->EXT_NAME[0]; ext++) {
		char buffer[1024];
		
		if (snprintf(buffer, 1024, "~#MBbind_cmd(\"%s\"); subst(\"door\", \"%%'%s %%S\")|~#LF",
			     ext->EXT_NAME, ext->EXT_NAME) == -1) 
			return -1;
			
		if (!formatted_print(buffer, 0))
			return -1;
	}
	
	return 0;
}
