#include <syslog.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <termios.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef USE_SGTTY
#include <sgtty.h>
#endif

#include "daydream.h"

#define LOGINATTEMPTS 10

int rnode = 0;
int lmode = 0;

int conin;
int conout;
int serhandle;
char serup;
char keysrc;
int ansi;
int carrier;
int conon;
int timeleft;
time_t endtime;
int lrp;
int lsp;
int oldlrp;
int oldlsp;
int highest;
int lowest;
int bytestagged, fbytestagged;
int delayt;
uint16_t filestagged, ffilestagged;

struct DayDream_MainConfig maincfg;

msgbase_t *current_msgbase;

struct DayDream_AccessPreset *presets;
struct DayDream_DisplayMode *displays;
struct DayDream_DisplayMode *display;
struct DayDream_Multinode *nodes;
struct DayDream_Multinode *currnode;
struct DayDream_Archiver *arcs;
struct DD_ExternalCommand *exts;
struct DayDream_Protocol *protocols;
struct DayDream_Protocol *protocol;
struct callerslog clog;
struct DD_Seclevel *secs;
struct DD_Seclevel sec;


struct List *olms;

uint8_t selcfg[2056];

int pages;
int access1;
int access2;
struct userbase user;
int onlinestat;
int forcebps = 0;


char puskuri[100];
char lrpdatname[80];
int userinput;
char origdir[1024];

char *sd[MAXSTRS];
unsigned char inconvtab[256];
unsigned char outconvtab[256];


/*
   char *sd[usernamestr]="\e[36mUsername: \e[0m";
   char *sd[passwordstr]="\e[36mPassword: \e[0m";
   char *sd[tryagainstr]="\e[35mTry again!\n";
   char *sd[excessivepwfailstr]="\n\e[35mExcessive password failure!\n\n";
   char *sd[unknownuserstr]="\n\e[33mNo such user. Type \e[32mNEW\e[33m if you're a new one!\n\n";
   char *sd[disconnectingstr]="\e[35mDisconnecting...\n\n\e[0m";

 */

static void carrieroff(int);
static int createflaglist(void);
static int getin(void);
static int ispw(void);
static int mktempdir(void);
static int syspw(void);
static int visit_bbs(int);

static void readdatafile(void **dest, const char *filename, int endmarker)
{
	struct stat st;
	int fd;

	if ((fd = open(filename, O_RDONLY)) < 0) {
		printf("Can't open %s.\n", filename);
		exit(1);
	}
	fstat(fd, &st);
	*dest = xmalloc(st.st_size + 2);
	read(fd, *dest, st.st_size);
	close(fd);
	*((unsigned char *) *dest + st.st_size) = endmarker;
}

int main(int argc, char *argv[])
{
	int datafd;

	openlog("daydream", LOG_PID, LOG_LOCAL2);
	
	initstringspace();

	serup = 0;
	serhandle = 0;
	conin = 0;
	protocol = 0;
	conout = 0;
	conon = 0;
	onlinestat = 0;
	userinput = 1;
	lrp = lsp = oldlrp = oldlsp = 0;
	lrpdatname[0] = 0;
	ffilestagged = filestagged = bytestagged = fbytestagged = 0;
	*reason = 0;
	memset(&clog, 0, sizeof(struct callerslog));

/* Open required datafiles */

	if (!getcmdline(argc, argv))
		return 0;

	getcwd(origdir, 1024);

	datafd = open("data/daydream.dat", O_RDONLY);
	if (datafd == -1) {
		printf("Can't open daydream.dat. Please whip the root!\n");
		exit(0);
	}
	read(datafd, &maincfg, sizeof(struct DayDream_MainConfig));
	(void) close(datafd);

	read_conference_data();
	readdatafile((void **) &nodes, "data/multinode.dat", 0);
	readdatafile((void **) &presets, "data/access.dat", 0);
	readdatafile((void **) &secs, "data/security.dat", 0);
	readdatafile((void **) &displays, "data/display.dat", 0);
	readdatafile((void **) &exts, "data/externalcommands.dat", 0);
	readdatafile((void **) &arcs, "data/archivers.dat", 255);
	readdatafile((void **) &protocols, "data/protocols.dat", 0);

	display = 0;

	/* Check if we know which TTY we're using.. */

	olms = NewList();

	if (ul_user != -1) {
		cmdlineupload();
		return 0;
	}
	initterm();
	/* Initialize carrier loss handler */

	mkdir(DDTMP, 0755);
	mktempdir();

	signal(SIGHUP, carrieroff);
	if (!fnode) {
		signal(SIGTERM, carrieroff);
		signal(SIGINT, carrieroff);
	}


	if (fnode) {
		int ir = 0;
		while (waitforcall(ir++)) {			
			visitbbs(0);
			if (forcebps)
				break;
		}
	} else 
		visitbbs(0);
		
	fini_keyboard();
	return 0;
}

int visitbbs(int m)
{
	int retcode;
	reset_history();
	init_keyboard();
	init_menu_system();
	retcode = visit_bbs(m);
	dropcarrier();
	fini_menu_system();
	fini_keyboard();
	return retcode;
}

static int visit_bbs(int m)
{
	time_t aika;
	char *aikas;
	int tmp;
	char puskur[300];
	int attempts;

	lrp = lsp = oldlrp = oldlsp = 0;
	lrpdatname[0] = 0;
	ffilestagged = filestagged = bytestagged = fbytestagged = 0;
	*reason = 0;
	memset(&clog, 0, sizeof(struct callerslog));
	memset(&user, 0, sizeof(struct userbase));
	onlinestat = 0;
	display = 0;
	clearlist(olms);
	clearlist(flaggedfiles);

	carrier = 1;
	aika = time(0);
	aikas = ctime(&aika);
	aikas[24] = 0;

	snprintf(puskur, sizeof(puskur), "===============================================[ %s ]===\n%d BPS connection on line #%d\n\n", aikas, bpsrate, node);
	writelog(puskur);

	changenodestatus("Logging in...");

	ddprintf("[0m[2J[HDayDream BBS/Unix %s\nProgramming by Antti Hyrynen 1996-1997, DayDream Development Team 1998-2001\nYou are connected to node #%d at %d BPS.\n\n", versionstring, node, bpsrate);

	rundoorbatch("data/frontends.dat", NULL);

	if (!display)
		if (getdisplaymode(0, 0) < 1) {
			DDPut("Failed to load displaymode... disconnecting!\n\n");
			return 0;
		}
	if (!syspw()) {
		DDPut(sd[disconnectingstr]);
		return 0;
	}

	TypeFile("banner", TYPE_MAKE | TYPE_WARN);

	tmp = 0;
	if (m) {
		switch (checklogon("sysop")) {
		case 1:
			sleep(2);
			getin();
			break;
		}
		return 1;
	}
	attempts = 1;
	while (!tmp) {
		if (attempts > LOGINATTEMPTS) {
			DDPut(sd[maxattemptsstr]);
			break;
		}
		attempts++;
		DDPut(sd[usernamestr]);
		puskuri[0] = 0;
		Prompt(puskuri, 25, 0);
		removespaces(puskuri);
		if (!checkcarrier())
			tmp = 1;
		if (!puskuri[0])
			DDPut("");
		else if (!strcasecmp("new", puskuri))
			CreateNewAccount();
		else if (!strcasecmp("logoff", puskuri))
			tmp = 1;
		else if (!strcasecmp("chat", puskuri))
			pagesysop(0);
		else {
			int passwdcnt;
			switch (checklogon(puskuri)) {
			case 1:
				for (passwdcnt = 0; passwdcnt < 3; passwdcnt++) {
					puskuri[0] = 0;
					if (ispw()) {
						DDPut(sd[passwordstr]);
						Prompt(puskuri, 25, PROMPT_SECRET);
					}
					if (!checkcarrier()) {
						tmp = 1;
						break;
					}
					if (!ispw() || cmppasswds(puskuri, user.user_password)) {

						tmp = 1;
						getin();
						break;
					} else {
						if (passwdcnt != 2)
							DDPut(sd[tryagainstr]);
						clog.cl_flags |= CL_PASSWDFAIL;
					}
				}
				if (!tmp) {
					TypeFile("passwordfailure", TYPE_MAKE);
					DDPut(sd[excessivepwfailstr]);
					tmp = 1;
				}
				break;
			case 0:
				if (maincfg.CFG_FLAGS & (1L << 9)) {
					DDPut(sd[newucstr]);
					switch (HotKey(HOT_NOYES)) {
					case 1:
						if (CreateNewAccount()) {
							clog.cl_userid = user.user_account_id;
							clog.cl_firstcall = user.user_firstcall;
							clog.cl_logon = time(0);
							if (user.user_connections == 0)
								clog.cl_flags |= CL_NEWUSER;
							clog.cl_bpsrate = bpsrate;

							getin();
							tmp = 1;
						}
					case 2:
						DDPut("\n");
						break;
					default:
						tmp = 1;
						break;

					}
				} else {
					DDPut(sd[unknownuserstr]);
				}
				break;
			case 2:
				DDPut(sd[alreadyonlinestr]);
				tmp = 1;
				break;
			}
		}
	}

	DDPut(sd[disconnectingstr]);
	dropcarrier();
	return 1;
}

static int ispw(void)
{
	int i;
	for (i = 0; i < 15; i++) {
		if (user.user_password[i])
			return 1;
	}
	return 0;
}

int clearlist(struct List *l)
{
	struct Node *nodeh;
	struct Node *onode;

	if (!l)
		return 0;

	nodeh = l->lh_Head;

	while (nodeh->ln_Succ) {
		Remove((struct Node *) nodeh);
		onode = nodeh;
		nodeh = nodeh->ln_Succ;
		free(onode);
	}
	return 1;
}

static int getin(void)
{
	int clfd;
	char buffer[256];
	struct gcallerslog gcl;

	onlinestat = 1;
	enterbbs();
	
	if (current_msgbase)
		changemsgbase(current_msgbase->MSGBASE_NUMBER, MC_QUICK | MC_NOSTAT);

	createflaglist();
	user.user_timeremaining = timeleft / 60;
	saveuserbase();
	clog.cl_logoff = time(0);
	snprintf(buffer, sizeof(buffer), "%s/logfiles/callerslog%d.dat", 
		origdir, node);
	clfd = open(buffer, O_WRONLY | O_CREAT, 0644);
	if (clfd != -1) {
		lseek(clfd, 0, SEEK_END);
		write(clfd, &clog, sizeof(struct callerslog));
		(void) close(clfd);
	}
	snprintf(buffer, sizeof(buffer), "%s/logfiles/callerslog.dat", 
		origdir);
	clfd = open(buffer, O_WRONLY | O_CREAT, 0644);
	if (clfd != -1) {
		gcl.cl_node = node;
		gcl.cl = clog;
		lseek(clfd, 0, SEEK_END);
		write(clfd, &gcl, sizeof(struct gcallerslog));
		(void) close(clfd);
	}
	if (currnode->MULTI_OTHERFLAGS & (1L << 1)) {
		char mesbuf[1024];
		snprintf(mesbuf, sizeof(mesbuf), 
			"\n[0m%s from %s logged off from node #%d\n",
			maincfg.CFG_FLAGS & (1L << 1) ? user.user_handle : user.user_realname,
			maincfg.CFG_FLAGS & (1L << 2) ? user.user_organization : user.user_zipcity,
			node);

		olmall(2, mesbuf);
	}
	runlogoffbatch();
	onlinestat = 0;
	return 1;
}

static int createflaglist(void)
{
	char buf[1024];

	struct savedflag sl;
	struct FFlag *myf;
	int fd;

	recountfiles();
	if (!filestagged)
		return 1;

	myf = (struct FFlag *) flaggedfiles->lh_Head;
	if (myf->fhead.ln_Succ) {
		snprintf(buf, sizeof(buf), "%s/users/%d/flaggedfiles.dat", 
				origdir, user.user_account_id);
		fd = open(buf, O_WRONLY | O_TRUNC | O_CREAT, 0644);
		if (fd < 0)
			return 0;
		while (myf->fhead.ln_Succ) {
			strcpy(sl.fname, myf->f_filename);
			sl.conf = myf->f_conf;
			write(fd, &sl, sizeof(struct savedflag));
			myf = (struct FFlag *) myf->fhead.ln_Succ;
		}
		(void) close(fd);
	}
	return 1;
}

static void carrieroff(int sig)
{
	char buf[80];

	signal(sig, carrieroff);
	if (!carrier)
		return;
	carrier = 0;

	snprintf(buf, sizeof(buf), "Carrier lost at %s\n", currt());
	writelog(buf);
	clog.cl_flags |= CL_CARRIERLOST;
}

static int syspw(void)
{
	char b[80];
	int i;

	if (*maincfg.CFG_SYSTEMPW) {
		TypeFile("systempassword", TYPE_MAKE);
		for (i = 2; i; i--) {
			*b = 0;
			DDPut(sd[syspwstr]);
			if (!(Prompt(b, 16, PROMPT_SECRET)))
				return 0;
			if (!strcasecmp(b, maincfg.CFG_SYSTEMPW))
				return 1;
		}
		return 0;
	}
	return 1;
}

int checkcarrier(void)
{
	int kelmas;
	char buf[1024];

	if (lmode)
		return 1;
	if (!carrier)
		return 0;
	if (fnode) {
		if (ioctl(serhandle, TIOCMGET, &kelmas) < 0) {
			(void) close(serhandle);
			serhandle = open(currnode->MULTI_TTYNAME, O_RDWR | O_NOCTTY);
			return 1;
		}
		if (kelmas & TIOCM_CD)
			return 1;

		snprintf(buf, sizeof(buf), "Carrier lost at %s\n", currt());
		writelog(buf);
		clog.cl_flags |= CL_CARRIERLOST;
		carrier = 0;

		return 0;
	} else 
		return ttyname(serhandle) ? 1 : 0;
}

/* FIXME: should be declared in daydream.h */
int is_telnet_connection(void);	

int dropcarrier(void)
{
	if (!checkcarrier())
		return 0;

	if (hupmode) {
		writetomodem(hangupstring);
	} else if (!lmode && !is_telnet_connection()) {
		struct termios tty;
		speed_t sp;

		tcgetattr(serhandle, &tty);
		sp = cfgetospeed(&tty);
		cfsetospeed(&tty, B0);
		tcsetattr(serhandle, TCSANOW, &tty);
//              close(serhandle);
		sleep(2);
//              serhandle=open(currnode->MULTI_TTYNAME,O_RDWR|O_NOCTTY);
		cfsetospeed(&tty, sp);
		tcsetattr(serhandle, TCSANOW, &tty);
	}
	carrier = 0;
	return 1;
}

static int mktempdir(void)
{
	return mkdir(currnode->MULTI_TEMPORARY, 0755);
}
