#include <ctype.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include "ddcommon.h"

off_t dd_lseek(int fd, off_t offset, int whence)
{
	struct stat st;
	if (whence == SEEK_END && offset < 0) {
		whence = SEEK_SET;
		if (fstat(fd, &st) == -1)
			return (off_t) -1;
		offset = st.st_size - offset;
	}
	return lseek(fd, offset, whence);
}

char *strupr(char *s)
{
	char *p;	
	for (p = s; *p; *p = toupper(*p), p++);
	return s;
}
	
char *strlwr(char *s)
{
	char *p;	
	for (p = s; *p; *p = tolower(*p), p++);
	return s;
}
