#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/un.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <grp.h>
#include <utmp.h>
#include <errno.h>
#include <signal.h>

#include "config.h"
#include "common.h"
#include "dd.h"

#define BUFF_SIZE	256

char buff[BUFF_SIZE];
int outfd;

void closeout(void);

void sighandler(int);
 
int main (int argc, char *argv[])
{
	fd_set readset;
	struct sockaddr_un sock_addr;
	int infd, fdmax, quit = 0, n;
	int datafd;
	struct DayDream_NodeInfo ddn;
	struct userbase user;
	struct winsize ws;
		
	char sockname[128];
	
	if (argc < 2) {
		errorf ("Usage: ddsnoop <node>\n");
	}
	sprintf(sockname, "%s/daydream%sr", DDTMP, argv[1]);
	outfd=open(sockname,O_WRONLY);
	if (outfd==-1) {
		errorf ("Node not running!\n");
	}
	
	sprintf(sockname,"%s/daydream%sw", DDTMP, argv[1]);
	infd=open(sockname,O_RDONLY);
	if (infd==-1) {
		errorf ("Node not running!\n");
	}
	
	puts("DDSnoop coded by Antti Hyrynen. ctrl-b-h for help!\n");
	
	stty_initstore ();
	atexit (stty_orig);
	if (isatty(STDIN_FILENO))
		stty_raw (STDIN_FILENO);

	/* calc max file descriptor for select() */
	ioctl(STDIN_FILENO,TIOCGWINSZ,&ws);

	buff[0]=2;
	buff[1]=1;
	buff[2]=ws.ws_row;
	
	write(outfd,buff,3);
	
	atexit(closeout);
	signal(SIGINT,sighandler);
	signal(SIGHUP,sighandler);
	signal(SIGTERM,sighandler);
	fdmax = max(STDIN_FILENO, infd);
	
	/* do our thing */
	
	
	while (!quit)
	{
		FD_ZERO (&readset);
		FD_SET (STDIN_FILENO, &readset);
		FD_SET (infd, &readset);
		
		select (fdmax + 1, &readset, NULL, NULL, NULL);
		
		if (FD_ISSET(STDIN_FILENO, &readset))
		{
			read(STDIN_FILENO, buff, 1);

			if (buff[0]==3) {
				exit(0);
			} else {
				if (write(outfd, buff, 1) < 0)
					quit = 1;
			}
		}
		
		if (FD_ISSET(infd, &readset))
		{
			if ((n = read(infd, buff, BUFF_SIZE)) < 1)
				quit = 1;

			if (n > 0)
				write (STDOUT_FILENO, buff, n);
		}
	}
	
}

void closeout(void)
{
	buff[0]=2;
	buff[1]=4;
	write(outfd,buff,2);
}

void sighandler(int i)
{
	closeout();
	printf ("\r\nBack at local tty.\r\n");
	exit(0);
}
