#include <sys/stat.h>
#include <dirent.h>
#include <stdio.h>
#include <string.h>
#include "listviewer.h"
#include "entrypack.h"

DirectoryList::DirectoryList(int sl, char *path, char *title) : ListViewer(sl)
{
	Title=strdup(title);
	Path=strdup(path);
	Load();
};

int DirectoryList::HandleKeyboard(int ch)
{
	if (ch>='0' && ch<='9')
		return 0;
	
	return ListViewer::HandleKeyboard(ch);
}

/****************************************************************************/

void DirectoryList::sort(int key)
{
}

/****************************************************************************/

char *DirectoryList::GetTitle(void)
{
	return Title;
};

/****************************************************************************/

char **__select_path;

int select_func(const dirent *de) 
{
	char buffer[256];
	struct stat st;
	sprintf(buffer, "%s/%s", *__select_path, de->d_name);
	stat(buffer, &st);
	if ((!S_ISDIR(st.st_mode))||(strcmp(de->d_name, ".")&&strcmp(de->d_name, "..")))
		return 1;
	else return 0;
};

/****************************************************************************/

void DirectoryList::Load(void)
{
	dirent **d;
	__select_path=&Path;
	entries=scandir(Path, &d, select_func, alphasort);
	contents=new (DirEntryPack *)[entries];
	for (int i=0; i<entries; i++) {
		contents[i]=new DirEntryPack(*d[i], Path);
		delete [] d[i];
	}
	delete [] d;
}

/****************************************************************************/

EntryPack *DirectoryList::GetEntry(int entry, int flags)
{
	DirEntryPack *e=contents[entry];
	e->Update(flags); // maybe the returned value could be used for stg...
	return e;
}
	
/****************************************************************************/
	
DirectoryList::~DirectoryList(void)
{
	for (int i=0; i<entries; i++)
		delete contents[i];
	delete [] contents;
	delete [] Path;
}
