AC_DEFUN(AC_STRUCT_MEMBER, [
dnl This macro checks whether a specific member exists in a type
dnl declaration. If the member exists, this macro defines 
dnl HAVE_{member's name}, in uppercase. The arguments of this
dnl macro are as follows:
dnl 
dnl  1. any #include statements needed
dnl  2. structure's name, e.g. 'struct utmp'
dnl  3. member's name, e.g. 'ut_id'
dnl  4. any additional stuff. For example, ut_id is of type char[4]
dnl     and a string cannot be assigned into it, so one needs to
dnl     use something like 'foo.ut_id[0] = 0;'.
AC_MSG_CHECKING([whether $2 has member $3])
AC_TRY_COMPILE($1
,changequote({, })dnl
{
	$2 foo;
	foo.$3$4 = 0;
}changequote([, ])dnl
,
AC_DEFINE(HAVE_[]translit($3, [a-z], [A-Z]))
AC_MSG_RESULT(yes)
,
AC_MSG_RESULT(no))])

AC_DEFUN(AC_STRUCT_ARRAY_MEMBER, [
dnl This macro checks whether a specific member exists in a type
dnl declaration. If the member exists, this macro defines 
dnl HAVE_{member's name}, in uppercase. The arguments of this
dnl macro are as follows:
dnl 
dnl  1. any #include statements needed
dnl  2. structure's name, e.g. 'struct utmp'
dnl  3. member's name, e.g. 'ut_id'
AC_MSG_CHECKING([whether $2 has member $3])
AC_TRY_COMPILE($1
,changequote({, })dnl
{
	$2 foo;
	foo.$3[0] = 0;
}changequote([, ])dnl
,
AC_DEFINE(HAVE_[]translit($3, [a-z], [A-Z]))
AC_MSG_RESULT(yes)
,
AC_MSG_RESULT(no))])
