#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include "bb.h"
#include "files.h"
#include "lock.h"
#include "tokens.h"
#include "varlist.h"

extern varlist list;
extern char token[1024];
extern int in_dir;

void make_email()
{
  char *email, *user, *bbs, *tmp;
   
  if(exists("email"))
    return;
   
  user = string("user");
  if(!exists("bbsdomain"))
    fatal_error("no bbsdomain");
  bbs = string("bbsdomain");
  
  email = (char *)malloc(strlen(user) + strlen(bbs) + 2);
  sprintf(email, "%s@%s", user, bbs);
   
  for(tmp = email;*tmp;tmp++) {
    if(*tmp == ' ')
      *tmp = '_';
  }
   
  list.add_sys("email", email);
  free(email);
}

int load_user(char *name, varlist *vlist)
{
  FILE *users;
  int type;
  variable *tmp;

  bb_lock("data/users");
   
  users = fopen("data/users","r");
  if(!users)
    fatal_error("error opening data/users");
   
  for(;;) {
    type = read_token(users);
     
    if(type == TOKEN_EOF || type == TOKEN_EOL) {
      fclose(users);
      bb_unlock();
      return 0;
    }
    
    if(type != TOKEN_TEXT)
      fatal_error("loaduser: username expected");
    
    if(!strcasecmp(token, name))
      break;
     
    skip_line(users);
  }
  
  vlist -> add("user", token);
   
  for(;;) {
    type = read_token(users);
     
    if(type == TOKEN_EOF || type == TOKEN_EOL) {
      fclose(users);
      bb_unlock();
      return 1;
    }
     
    if(type != TOKEN_TEXT)
      fatal_error("loaduser: variable name expected");
     
    tmp = vlist -> add(token, 0);
     
    type = read_token(users);
     
    if(type == TOKEN_TEXT)
      *tmp = token;
    else if(type == TOKEN_NUM)
      *tmp = atoi(token);
    else
      fatal_error("loaduser: value expected");
  
    tmp -> save = 1;
  }
   
  fclose(users);
  bb_unlock();
  
  if((*vlist)["lastcall"] == NULL)
    vlist -> add("lastcall", 0);
   
  return 1;
}

void save_varlist(FILE *f, variable *v)
{
  if(v -> save) { 
    fprintf(f, "%s ", v -> name);
   
    if(v -> type == STRING)
      fprintf(f, "\"%s\" ", v -> s);
    else 
      fprintf(f, "%d ", v -> i);
  }
      
  if(v -> left)
    save_varlist(f, v -> left);
  
  if(v -> right)
    save_varlist(f, v -> right);
}

void save_user()
{
  FILE *users, *newusers;
  char *linebuf, *user, *tmp;
  int length;
   
  if(number("guest"))
    return;

  if(in_dir)
    return;
   
  linebuf = (char *)malloc(16384);
  user = list["user"] -> get_s();
   
  bb_lock("data/users");
  users = fopen("data/users", "r");
  newusers = fopen("data/newusers", "w");
   
  if(!users) {
    perror("fopen");
    fatal_error("error opening user file");
  }
   
  for(;;) {
    if(!fgets(linebuf, 16384, users))
      break;
     
    tmp = strchr(linebuf + 1, '\"');
    length = tmp - (linebuf + 1);
     
    if(length != strlen(user) ||  
       strncasecmp(user, linebuf + 1, strlen(user))) 
      fprintf(newusers, "%s", linebuf);
  }
  
  fprintf(newusers, "\"%s\" ", user);   
  save_varlist(newusers, list.base);
  fprintf(newusers, "\n");
   
  rename("data/newusers", "data/users");
   
  fclose(users);
  fclose(newusers);
     
  free(linebuf);
   
  bb_unlock();
}

int check_name(char *name)
{
  int type;
  FILE *n;
  char user[40], *baduser;
  
  strcpy(user, format_user(name));
  if(!strcmp(user, "Newuser"))	
    return 1;
   
  n = fopen("data/badnames", "r");
  if(!n)
    return 0;
  
  for(;;) {
    type = read_token(n);
    if(type == TOKEN_EOF)
      break;
    if(type == TOKEN_COMMENT || type == TOKEN_EOL)
      continue;
    baduser = format_user(token);
    if(!strcmp(user, baduser)) {
      fclose(n);
      return 1;
    }
  }
   
  fclose(n);
  return 0;
}

