#include <ctype.h>
#include <fnmatch.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include "bb.h"
#include "cmdline.h"
#include "files.h"
#include "modem.h"
#include "output.h"
#include "status.h"
#include "tokens.h"
#include "varlist.h"
#include "users.h"

extern varlist list;
extern int online, ansi;
extern void expired();
extern struct option_t options[];
extern struct value_t values[];
extern vmodem *modem;
extern char token[1024], *out_buf;

char name[40], passwd[40];
int newuser, passwd_len, guest;
time_t login_time;

#define GETTY_USER    0
#define GETTY_UNIX    1
#define GETTY_CONNECT 2

struct getty_t {
  int type;
  char *pattern;
  char *command;
  struct getty_t *next;
} *getty_list = NULL, *last_getty = NULL;

// A linked list class might be a good idea...
struct getty_t *add_getty()
{
  struct getty_t *tmp;

  tmp = (struct getty_t *)malloc(sizeof(struct getty_t));
  tmp -> next = NULL;

  if(getty_list == NULL)
    getty_list = tmp;
  else 
    last_getty -> next = tmp;
  
  last_getty = tmp;

  return tmp;  
}

void init_getty()
{
  FILE *getty;
  int type, line = 1;
  struct getty_t *tmp;

  getty = fopen("data/getty", "r");
  if(getty == NULL)
    return;

  for(;;) {
    type = read_token(getty);
    if(type == TOKEN_COMMENT || type == TOKEN_EOL) {
      line++;
      continue;
    }

    if(type == TOKEN_EOF)
      break;

    if(type != TOKEN_TEXT)
      init_error("error in data/getty line %d: type expected\n", line);
    
    tmp = add_getty();
    if(!strcmp(token, "user"))
      tmp -> type = GETTY_USER;
    else if(!strcmp(token, "unix"))
      tmp -> type = GETTY_UNIX;
    else if(!strcmp(token, "connect"))
      tmp -> type = GETTY_CONNECT;
    else
      init_error("uknown type \"%s\" in data/getty line %d\n", token, line);

    type = read_token(getty);
    if(type != TOKEN_TEXT)
      init_error("pattern string expected in data/getty line %d\n", line);
    
    tmp -> pattern = (char *)malloc(strlen(token) + 1);
    strcpy(tmp -> pattern, token);

    type = read_token(getty);
    if(type != TOKEN_TEXT)
      init_error("command expected in data/getty line %d (missing quotes?)\n",
		 line);
    
    tmp -> command = (char *)malloc(strlen(token) + 1);
    strcpy(tmp -> command, token);

    // Enforce a newline! Haha! That'll teach 'em!
    skip_line(getty); 
    line++;
  }

#if 0
  {
    struct getty_t *tmp = getty_list;
    while(tmp) {
      dprintf(">%d:%s:%s:\n", tmp -> type, tmp -> pattern, tmp -> command);
      tmp = tmp -> next;
    }
  }
#endif
}

void get_days()
{
  struct tm *right_now, *last_time;
  int this_day;
  time_t today, lastcall;
  
  today = (time_t)number("today");
  lastcall = (time_t)number("lastcall");
  
  right_now = localtime(&today);
  this_day = right_now -> tm_mday;
  last_time = localtime(&lastcall);
  
  if(this_day != last_time -> tm_mday)
    list.add_sys("yesterday", 1);
    
  if(number("today") - number("lastcall") >= (24 * 60 * 60))
    list.add_sys("dayago", 1);
}

int unix_user(char *user)
{
  FILE *passwd;
  char account[10];
  int c, t;

  passwd = fopen("/etc/passwd", "rb");
  if(passwd == NULL) {
    dprintf(">can't read /etc/passwd. Hmmm.\n");
    return 0;
  }
  
  for(;;) {
    for(t = 0;t < 9;t++) {
      c = fgetc(passwd);
      if(c == EOF || c == ':') {
	account[t] = 0;
	break;
      }
      else 
	account[t] = c;
    }
    
    if(!strcmp(user, account)) {
      dprintf(">%s is a unix account\n", user);
      fclose(passwd);
      return 1;
    }

    skip_line(passwd);
    if(c == EOF)
      break;
  }

  dprintf(">%s is not a unix account\n", user);

  fclose(passwd);
  return 0;
}

void do_getty(struct getty_t *g)
{
  char *args[100];
  char *tmp;
  int n = 1;

  list.add_sys("rawuser", name);
  cook(g -> command);

  tmp = strtok(out_buf, " ");
  args[0] = tmp;

  for(;;) {
    tmp = strtok(NULL, " ");
    if(tmp == NULL || n == 99) {
      args[n] = NULL;
      break;
    }

    args[n++] = tmp;    
  }

  if(dup2(modem -> fd, 0) == -1 || dup2(modem -> fd, 1) == -1
     || dup2(modem -> fd, 2) == -1)
    init_error("couldn't redirect stdio");

  execv(args[0], args);
  init_error("couldn't exec %s", args[0]);
}

void user_getty(char *user)
{
  struct getty_t *tmp;

  if(strlen(user) == 0)
    return;

  tmp = getty_list;

  while(tmp) {
    if((tmp -> type == GETTY_UNIX || tmp -> type == GETTY_USER) 
       && !fnmatch(tmp -> pattern, user, 0)) {
      dprintf(">user match found for %s\n", tmp -> pattern);
      if(tmp -> type == GETTY_USER || unix_user(user))
	do_getty(tmp);
    }
    tmp = tmp -> next; 
  }
}

void connect_getty(char *string)
{
  struct getty_t *tmp;

  if(strlen(string) == 0)
    return;

  tmp = getty_list;
  while(tmp) {
    if(strstr(string, tmp -> pattern)) {
      dprintf(">connect match for %s\n", tmp -> pattern);
      do_getty(tmp);
    }
    tmp = tmp -> next;
  }
}

void get_name()
{
  output_cooked("$enteryourname$");
  input_alpha(name, 40, 0);
  output_cooked("\n");

  if(!values[NOGETTY].used)
    user_getty(name);
}

void get_passwd()
{
  output_cooked("$enterpasswd$");
  input_alpha(passwd, 40, 1); 
  output_cooked("\n");
}

void firstlogin()
{
  int n;

  if(!guest)
    while(passwd_len < 4) {
      get_passwd();
      passwd_len = strlen(passwd);
      strcpy(passwd, crypt(passwd, "BB"));
    }
  
  do {
    output_cooked("$numberoflines$");
    n = input_num(24);
    list.add("lines", n);
    output_cooked("\n");
  } while(n < 10 || n > 200);
   
  do {
    output_cooked("$numberofrows$");
    n = input_num(80);
    list.add("rows", n);
    output_cooked("\n");
  } while(n < 40 || n > 160);
   
  if(ansi)
    list.add("ansi", 1);
  else {
    output_cooked("$doyouhaveansi$");
    list.add("ansi", yesno());
    output_cooked("\n");
  }
}

int login()
{
  int passwd_ok, tries = 3, n;
  varlist *tmp_list = NULL;
   
  online = 1;

  list.add("exit", "flierp");
  busy(BUSY_LOGIN);
  
  dump_file("data/issue");
   
again:   
  guest = 0;
  if(tmp_list)
    delete tmp_list;
  
  tmp_list = new varlist; 
   
  if(!tries) {
    output_cooked("$notriesleft$\n");
    log("three bad logins");
    return 0;
  }
   
  do {
    if(values[USER].used) 
      strcpy(name, values[USER].s);
    else
      get_name();
  } while(strlen(name) < 4 /*|| !strcasecmp(name, "newuser")*/);

  strcpy(name, list.add_sys("user", name) -> get_s());
   
  log("login as %s", name);

  if(check_name(name)) {
    output_cooked("$badusername$\n\n");
    log("name not allowed");
    tries--;
    goto again;
  }
   
  if(load_user(name, tmp_list)) {
    newuser = 0;
    
    if(!(*tmp_list)["passwd"]) { // no password -> guest
      guest = 1;
      passwd_ok = 1;  
      newuser = 1;
      strcpy(passwd, "none");
    }
    
    if(!guest) {
      get_passwd();
      passwd_len = strlen(passwd);
      list.add("passwd", passwd);
      strcpy(passwd, crypt(passwd, "BB"));
      if(*(*tmp_list)["passwd"] == passwd)
        passwd_ok = 1;
       else
        passwd_ok = 0;
    }
  }
  else {
    output_cooked("$areyounew$");
    n = noyes();
    output_cooked("\n");
    if(!n)
      passwd_ok = 0;
    else 
      passwd_ok = 1;
    newuser = 1;
  }
   
  if(!passwd_ok) {
    log("bad login");
    output_cooked("\n");
    tries--;
    goto again;
  }
   
  if(guest)
    log("login ok, guest user");
  else if(newuser) 
    log("login ok, new user");
  else {
    log("login ok");
    load_user(string("user"), &list);
  }
   
  list.add_sys("newuser", newuser);
  list.add_sys("guest", guest);
   
  if(!list["timeleft"])
    list.add("timeleft", list["timelimit"] -> get_i());
 
  if(newuser)
    firstlogin();
  else {
    get_days();
    if(number("yesterday"))
      list.add("timeleft", number("timelimit"));
  }
  	      
  *list["passwd"] = passwd;

  make_email();
  
  delete tmp_list;

  if(!list["timeleft"] -> get_i())
    expired();

  //list.add("lastcall", time(NULL));
  login_time = time(NULL);
  return 1;
}

