#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "areas.h"
#include "bb.h"
#include "doors.h"
#include "files.h"
#include "mail.h"
#include "modem.h"
#include "news.h"
#include "output.h"
#include "status.h"
#include "tokens.h"
#include "transfer.h"
#include "varlist.h"

#define CMD_ECHO         0
#define CMD_GETKEY       1
#define CMD_VIEW         2
#define CMD_LOGOFF       3
#define CMD_MENU         4
#define CMD_YESNO        5
#define CMD_SET          6
#define CMD_GETSTRING    7
#define CMD_SAVE         8
#define CMD_INTERRUPT    9
#define CMD_PAGE        10
#define CMD_MAILBBS     11
#define CMD_READNEWMAIL 12
#define CMD_MULTICHAT   13
#define CMD_JUMP        14 
#define CMD_FILELIST    15
#define CMD_LOG         16 
#define CMD_NOYES       17
#define CMD_CHECKMAIL   18
#define CMD_READALLMAIL 19 
#define CMD_MAILSMTP    20
#define CMD_DOWNLOAD    21
#define CMD_SETENV      22
#define CMD_DOOR        23
#define CMD_MORE        24
#define CMD_ENCRYPT     25
#define CMD_GETSECRET   26
#define CMD_SEND        27
#define CMD_GETNUMBER   28
#define CMD_SELECT      29
#define CMD_SPY         30
#define CMD_CLEARMARKS  31
#define CMD_MAKEDATE    32
#define CMD_DEFAULT     33
#define CMD_ADD         34
#define CMD_SUB         35
#define CMD_GETENV      36
#define CMD_UPLOAD      37
#define CMD_NODELIST    38
#define CMD_NNTPSTART   39
#define CMD_NNTPSTOP    40
#define CMD_GETDATE     41
#define CMD_READNEWNEWS 42
#define CMD_NEWFILELIST 43
#define CMD_POST        44
#define CMD_EDITSIG     45
#define CMD_RANDOM      46
#define COMMANDS        47

#define MAXLABELS 25

#define OP_EQUAL  1
#define OP_LESS   2
#define OP_MORE   3
#define OP_NEQUAL 4

extern int page();
extern void kill_marks();
extern void nodelist();

extern char token[1024], *out_buf;
extern varlist list;
extern int spying, date_ok, ansi;
extern vmodem *spymodem;

char *parm[4] = { NULL, NULL, NULL, NULL }, ptype[4];
int num_labels = 0;
FILE *menu;

struct label_t {
  char *name;
  long offset;
  int line;
} labels[MAXLABELS];

struct cmd_t {
  char *cmd;  
  int parms;
} cmd[COMMANDS] = {
  { "echo", 1 },
  { "getkey", 1 },
  { "view", 1 },
  { "logoff", 0 },
  { "menu", 1 },
  { "yesno", 1 },
  { "set", 2 },
  { "getstring", 2 },
  { "save", 1 },
  { "interrupt", 1 },
  { "page", 0 },
  { "mailbbs", 0 },
  { "readnewmail", 0 },
  { "multichat", 0 },
  { "jump", 1 },
  { "filelist", 0 },
  { "log", 1 },
  { "noyes", 1 },
  { "checkmail", 0 },
  { "readallmail", 0 },
  { "mailsmtp", 0 },
  { "download", 0 },
  { "setenv", 2 },
  { "door", 1 },
  { "more", 1 },
  { "encrypt", 1 },
  { "getsecret", 2 },
  { "send", 1 },
  { "getnumber", 1 },
  { "select", 2 },
  { "spy", 1 },
  { "clearmarks", 0 },
  { "makedate", 2 },
  { "default", 2 },
  { "add", 2 },
  { "sub", 2 },
  { "getenv", 2 },
  { "upload", 0 },
  { "nodelist", 0 },
  { "nntpstart", 0 },
  { "nntpstop", 0 },
  { "getdate", 2 },
  { "readnewnews", 0 },
  { "newfilelist", 1 },
  { "post", 0 },
  { "editsig", 0 },
  { "random", 2 }
};

void create_var(char *var, char *txt)
{
  variable *tmp;
  tmp = list[var];
   
  if(tmp)
    *tmp = txt;
  else
    list.add_sys(var, txt);
}

void do_getkey()
{
  char buf[2];
  
  buf[0] = read_char();
  buf[1] = 0;
  create_var(parm[0], buf);
}

int get_number(int p)
{
  char *s = parm[p];
   
  if(isdigit(*s))
    return atoi(s);
  else if(list[s] && list[s] -> get_type() == NUMERIC)
    return list[s] -> get_i();
  else 
    return 0;
}

char *get_string(int p)
{
  if(ptype[p] != TOKEN_TEXT)
    return parm[p];
  else
    if(list[parm[p]] && list[parm[p]] -> get_type() == STRING)
      return list[parm[p]] -> get_s();
    else
      return parm[p];
}

void create_var(char *var, int num)
{
  variable *tmp;
  tmp = list[var];
   
  if(tmp)
    *tmp = num;
  else
    list.add_sys(var, num);   
}

void do_set()
{
  if(ptype[1] == TOKEN_NUM || (exists(parm[1]) && list[parm[1]] -> get_type() == NUMERIC))
    create_var(parm[0], get_number(1));
  else
    create_var(parm[0], get_string(1));
}

void do_setenv()
{
  char buf[10];
  variable *v;
   
  v = list[parm[1]];
   
  if(v) {
    if(v -> get_type() == NUMERIC) {
      sprintf(buf, "%d", v -> i);
      setenv(parm[0], buf, 1);
    }
    else
      setenv(parm[0], v -> s, 1);
  }
  else
    setenv(parm[0], parm[1], 1);
}

void load_labels()
{
  int t, type, line = 1;  

  for(t = 0;t < num_labels;t++)
    free(labels[t].name);
   
  num_labels = 0;
  for(;;) {
    type = read_token(menu);
    if(type == TOKEN_EOF)
      break;
     
    if(type == TOKEN_EOL)
      line++;
     
    if(type != TOKEN_LABEL)
      continue;
    
    labels[num_labels].name = (char *)malloc(strlen(token) + 1);
    strcpy(labels[num_labels].name, token);
    labels[num_labels].offset = ftell(menu);
    labels[num_labels].line = line;
    num_labels++;
  }
   
}

int condition(variable *var, int op, char *value)
{
  int i1, i2;

  if(var -> get_type() == NUMERIC) {   
    if(isdigit(*value)) 
      i1 = atoi(value);
    else { 
      if(exists(value))
        i1 = number(value);
      else
        return 0;
    }
    
    i2 = var -> get_i();
    
    if(op == OP_EQUAL)
      return i2 == i1;
    else if(op == OP_LESS)
      return i2 < i1;
    else if(op == OP_MORE)
      return i2 > i1;
    else if(op == OP_NEQUAL)
      return i2 != i1;
  }
  else { /* value is checked in do_menu() */
    if(op == OP_EQUAL)
      return strcmp(var -> s, value) == 0;
    else if(op == OP_LESS)
      return strcmp(var -> s, value) < 0;
    else if(op == OP_MORE)
      return strcmp(var -> s, value) > 0;
    else if(op == OP_NEQUAL)
      return strcmp(var -> s, value) != 0;
  }
   
  return 42;
}

void do_select()
{
  char c, buf[2];
   
  buf[1] = 0;
  cook(parm[1]);
   
  do {
    c = read_char();
    buf[0] = c;
  } while(strchr(out_buf, c) == NULL);
       
  create_var(parm[0], buf);
}

void do_menu(char *mfile)
{
  int type, result, t, p, line, op, old_busy, tmp_i;
  variable *var;
  char buf[256], *string, mname[256], *tmp;
   
  menu = fopen(mfile, "r");
  if(!menu) {
    perror(mfile);
    fatal_error("could not open menu file \"%s\"", mfile);
  }

  load_labels();
  fseek(menu, 0L, SEEK_SET);
  line = 1;
  strcpy(mname, mfile);
   
  for(;;) {
    type = read_token(menu);  
    if(type == TOKEN_EOF) {
      fseek(menu, 0L, SEEK_SET);
      line = 1;
      continue;
    }
     
    if(type == TOKEN_LABEL)
      continue;
      
    if(type == TOKEN_COMMENT || type == TOKEN_EOL) {
      line++;
      continue;
    }
     
    if(type != TOKEN_TEXT)
      fatal_error("error in %s line %d", mname, line);
     
    result = 0;
     
    if(var = list[token]) { //condition
       type = read_token(menu);
       
       if(type == TOKEN_TEXT) { //old format, string
         if(type == TOKEN_TEXT && exists(token))
	   result = condition(var, OP_EQUAL, string(token));
	 else
	   result = condition(var, OP_EQUAL, token);
       }
       else if(type == TOKEN_NUM) //old format, num
	 result = condition(var, OP_EQUAL, token);
       else if(type == TOKEN_OPERATOR) { //new format	 
         if(!strcmp(token, "="))
	   op = OP_EQUAL;
	 else if(!strcmp(token, "<"))
	   op = OP_LESS;
	 else if(!strcmp(token, ">"))
	   op = OP_MORE;
	 else if(!strcmp(token, "!="))
	   op = OP_NEQUAL;
	 else
	   fatal_error("syntax error in menu %s line %d", mname, line);

	 type = read_token(menu);
	 if(type == TOKEN_TEXT && exists(token))
	   result = condition(var, op, token);
	 else if(type != TOKEN_TEXT && type != TOKEN_NUM)
	   fatal_error("syntax error in menu %s line %d", mname, line);
	 else
           result = condition(var, op, token);
       }
       else
	 result = 0;
       
      if(result == 0) {
	line++;
	skip_line(menu);
      }
       
    }
    else { //command
      for(t = 0;t < COMMANDS;t++) {
        if(!strcmp(cmd[t].cmd, token))
	  break;
      }
      if(t == COMMANDS) { //unkown
        skip_line(menu);
	line++;
	continue;
      }
              
      for(p = 0;p < cmd[t].parms;p++) {
	type = read_token(menu);
        ptype[p] = type;
	string = token;
	if(type == TOKEN_EOF || type == TOKEN_EOL)
	  fatal_error("menu error: missing parameter(s) in %s line %d", 
		      mname, line);
	if(!parm[p])
	  parm[p] = (char *)malloc(1024);
	strcpy(parm[p], string);
      }
       
      switch(t) {
      case CMD_ECHO:
        output_cooked(get_string(0));	 
      break;
      
      case CMD_GETKEY:
        do_getkey();
      break;
	 
      case CMD_VIEW:
	list.add_sys("exitcode", dump_file(get_string(0)));
      break;
       
      case CMD_LOGOFF:
        fclose(menu);
        return;
      break;
	 
      case CMD_MENU:
	fclose(menu);
	strcpy(mname, get_string(0));
	list.add_sys("lastmenu", mname);
	menu = fopen(mname, "r");
	if(!menu) {
	  perror(mname);
	  fatal_error("cannot open menu file \"%s\"", mname);
	}
        load_labels();
	fseek(menu, 0L, SEEK_SET);
	line = 1;
      break;
	 
      case CMD_YESNO:
        create_var(parm[0], yesno());
      break;

      case CMD_NOYES:
        create_var(parm[0], noyes());
      break;
	 
      case CMD_SET:
        do_set();
      break;
	 
      case CMD_GETSTRING:
      case CMD_GETSECRET:
	if(!input_alpha(buf, get_number(1), t == CMD_GETSECRET))
	  strcpy(buf, "empty");
	create_var(parm[0], buf);
      break;
	 
      case CMD_SAVE:
	if(list[parm[0]])
	  list[parm[0]] -> save = 1;
      break;	 

      case CMD_INTERRUPT:
//        status_p -> interruptable = get_number(0);	 
        if(get_number(0))
	  status_p -> flags |= SF_INTERRUPT;
	else
	  status_p -> flags &= (~SF_INTERRUPT);
      break;

      case CMD_PAGE:
	list.add_sys("exitcode", page());
      break;
	 
      case CMD_MAILBBS:
        list.add_sys("exitcode", mail_user());
      break;

      case CMD_READNEWMAIL:
	read_mail(0);
      break;

      case CMD_MULTICHAT:
	output_cooked("\n\n**** Nothing happens ****\n\n");
	//mchat();
      break;

      case CMD_JUMP:
        for(t = 0;t < num_labels;t++) {
	  if(!strcmp(parm[0], labels[t].name))
	    break;
	}
	 
	if(t == num_labels)
	  fatal_error("error in \"%s\" line %d: undefined label \"%s\"", 
		      mname, line, parm[0]);
	
	fseek(menu, labels[t].offset, SEEK_SET);
        line = labels[t].line;
      break;

      case CMD_FILELIST:
	list.add_sys("exitcode", list_files(0));
      break; 
	 
      case CMD_LOG:
        cook(get_string(0));
	log(out_buf);
      break;
	 
       case CMD_CHECKMAIL:
         list.add_sys("exitcode", check_mail());
       break;
	 
       case CMD_READALLMAIL:
	 read_mail(1);
       break;
      
       case CMD_MAILSMTP:
	 list.add_sys("exitcode", mail_smtp());
       break;
	 
       case CMD_DOWNLOAD:
	 list.add_sys("exitcode", download());
       break;
	 
       case CMD_SETENV:
	 do_setenv();
       break;
	 
       case CMD_DOOR:
         if(exists(parm[0]))
	   cook(string(parm[0]));
	 else
	   cook(parm[0]);

	 old_busy = status_p -> busy;
	 busy(BUSY_DOOR);
	 list.add_sys("exitcode", run_door(out_buf));
         busy(old_busy);
       break;
	 
       case CMD_MORE:
	 list.add_sys("exitcode", more_file(get_string(0)));
       break;
	 
       case CMD_ENCRYPT:
         var = list[parm[0]];
	 if(!var || var -> get_type() == NUMERIC)
	   break;
         *var = crypt(var -> get_s(), "BB");
       break;
	 
       case CMD_SEND:
	 list.add_sys("exitcode", send_file(get_string(0)));
       break;
	 
       case CMD_GETNUMBER:
	 if(exists(parm[0]))
	   *list[parm[0]] = input_num(0);
	 else
	   list.add_sys(parm[0], input_num(0));
       break;
       
       case CMD_SELECT:
         do_select();
       break;
	 
       case CMD_SPY:
         if(spymodem) {
	   delete spymodem;
	   spymodem = NULL;
	   list.add_sys("spyterm", "none");
	 }
	 tmp = get_string(0);
	 if(!strcmp(tmp, "off")) {
	   delete spymodem;
	   spymodem = NULL;
         }
	 else {
	   spymodem = new localmodem(get_string(0));
           spymodem -> init();
	   list.add_sys("spyterm", spymodem -> device);
	 }
       break;
       
       case CMD_CLEARMARKS:
         kill_marks();
       break;
	 
       case CMD_MAKEDATE:
         var = list[parm[0]];
	 if(!var)
	   var = list.add_sys(parm[0], "flierp");
	 *var = format_date(get_number(1));
       break;
	 
       case CMD_DEFAULT:
	 var = list[parm[0]];
	 if(var)
	   break;
	 else
	   do_set();
       break;
	 
       case CMD_ADD:
         var = list[parm[0]];
	 if(var && var -> get_type() == NUMERIC)
	   var -> i += get_number(1);
       break;
	 
       case CMD_SUB:
         var = list[parm[0]];
	 if(var && var -> get_type() == NUMERIC)
	   var -> i -= get_number(1);
       break;
	 
       case CMD_GETENV:
	 var = list[parm[0]];
	 tmp = getenv(get_string(1));
	 if(var && tmp)
	   *var = tmp;
	 else if(tmp)
	   list.add_sys(parm[0], tmp);
       break;
	 
       case CMD_UPLOAD:
	 list.add_sys("exitcode", upload());
       break;
       
       case CMD_NODELIST:
         nodelist();
       break;
      
       case CMD_NNTPSTART:
         list.add_sys("exitcode", nntp_start());
       break;
       
       case CMD_NNTPSTOP:
         nntp_stop();
       break;
      
       case CMD_GETDATE:
         tmp_i = unformat_date(get_string(1));
         list.add_sys(parm[0], tmp_i);
         list.add_sys("exitcode", date_ok);
       break;
       
       case CMD_READNEWNEWS:
         list.add_sys("exitcode", read_new_news());
       break;
      
       case CMD_NEWFILELIST:
         list.add_sys("exitcode", list_files(get_number(0)));      
       break;
       
       case CMD_POST:
         list.add_sys("exitcode", post_article());
       break;
       
       case CMD_EDITSIG:
         if(ansi)
           edit_signature();
       break;

      case CMD_RANDOM:
	list.add_sys(parm[0], random() % get_number(1));
      break;
      }
    }
     
  }
   
  fclose(menu);
}

