#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>

int main(int argc, char *argv[])
{
  int t;
  char *from, *to, *subject, *date, *line, *id, *mail_file, *user, *tmp;
  FILE *mail, *index;
  struct tm *time_p;
  time_t caltime;

  umask(0);
   
  if(argc != 3) {
    fprintf(stderr, "usage: bbmail <bbsdir> \"username\"\n");
    return 1;
  }

  if(chdir(argv[1])) {
    fprintf(stderr, "bbmail: can't cd to %s\n", argv[1]);
    return 1;
  }
  /*
  if(chdir("mail")) {
    fprintf(stderr, "bbmail: can't cd to %s/mail\n", argv[1]);
    return 1;
  }
  */
  user = argv[2];
  
  from = (char *)malloc(1024);
  to = (char *)malloc(1024);
  subject = (char *)malloc(1024);
  date = (char *)malloc(1024);
  line = (char *)malloc(1024);
  id = (char *)malloc(1024);
  mail_file = (char *)malloc(1024);
   
  strcpy(from, "From: ?\n");
  strcpy(to, "To: You!\n");
  strcpy(subject, "Subject: None\n");
  strcpy(date, "Date: Sep 16 1978\n"); 
  strcpy(id, "Message-Id: BLACK-HOLE\n");
   
  for(;;) {
    if(!fgets(line, 1024, stdin))
      break;
    if(!strchr(line, ':'))
      break;
    if(!strncmp(line, "From: ", 6))
      strcpy(from, line);
    else if(!strncmp(line, "To: ", 4))
      strcpy(to, line);
    else if(!strncmp(line, "Subject: ", 9))
      strcpy(subject, line);
    else if(!strncmp(line, "Date: ", 6))
      strcpy(date, line);
    else if(!strncmp(line, "Message-Id: ", 12))
      strcpy(id, line);
  }
   
  /* Experience has just shown not all messages have Id's */ 
#if 0
  id += 12;
  t = 0;
   
  while(*id) {
    if(isalnum(*id)) {
      mail_file[t++] = *id;
      mail_file[t] = 0;
    }
    id++;
  }
#endif
   
   //Walter_Heukels@noxs.nl (Walter Heukels)
   //Walter Heukels <Walter_Heukels@noxs.nl>
   //Walter_Heukels@noxs.nl
  
#if 0
  if(strchr(to, '(')) {
    strcpy(user, to + 4);
    *strchr(user, ' ') = 0;
  }
  else if(strchr(to, '<')) { 
    tmp = strchr(to, '<');
    strcpy(user, tmp + 1);
    tmp = strchr(user, '>');
    *tmp = 0;
  }
  else {
    strcpy(user, to + 4); 
  }
  
   
  else {
    fprintf(stderr, "bbmail: could not translate address: %s\n", to);
    return 1;
  }

   
  for(t = 0;t < strlen(user) - 1;t++) {
    if(user[t] == '_') 
      user[t] = ' ';
    else 
      if(user[t] == '@')
	break;
  }

  user[t] = 0;
#endif
   
  caltime = time(NULL);
  time_p = localtime(&caltime);
  sprintf(mail_file, "mail/internet%02d-%02d-%4d@%02d:%02d:%02d",
	  time_p -> tm_mon + 1, time_p -> tm_mday, time_p -> tm_year + 1900,
	  time_p -> tm_hour, time_p -> tm_min, time_p -> tm_sec);
   
  mail = fopen(mail_file, "w");
  if(!mail) {
    fprintf(stderr, "error opening mail file \"%s\"\n", mail_file);
    return 1;
  }
   
  fprintf(mail, "%s", from);
  //fprintf(mail, "%s", to); 
  fprintf(mail, "To: %s\n", user); 
  fprintf(mail, "%s", subject);
  fprintf(mail, "%s", date);
   
  for(;;) {
    fprintf(mail, "%s", line);
    if(!fgets(line, 1024, stdin))
      break;
  }
   
  fclose(mail);
     
  index = fopen("mail/Index", "a");
  fprintf(index, "\"%s\" \"mail/%s\" unread\n", user, mail_file);
  fclose(index);
   
  return 0;
}
